/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.server;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.management.MCClusterMetadata;
import com.hazelcast.client.impl.protocol.codec.MCGetClusterMetadataCodec;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetBootstrap;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JobSummary;
import com.hazelcast.jet.impl.config.ConfigProvider;
import com.hazelcast.jet.picocli.CommandLine;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.jline.reader.EOFError;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

@CommandLine.Command(name="jet", description={"Utility to perform operations on a Hazelcast Jet cluster.%nBy default it uses the file config/hazelcast-client.yaml to configure the client connection.%n%nGlobal options are:%n"}, versionProvider=JetVersionProvider.class, mixinStandardHelpOptions=true, sortOptions=false, subcommands={CommandLine.HelpCommand.class})
public class JetCommandLine
implements Runnable {
    private static final int MAX_STR_LENGTH = 24;
    private static final int WAIT_INTERVAL_MILLIS = 100;
    private static final int PRIMARY_COLOR = 3;
    private static final int SECONDARY_COLOR = 12;
    private final Function<ClientConfig, JetInstance> jetClientFn;
    private final PrintStream out;
    private final PrintStream err;
    @CommandLine.Option(names={"-f", "--config"}, description={"Optional path to a client config XML/YAML file. The default is to use config/hazelcast-client.yaml."}, order=0)
    private File config;
    @CommandLine.Option(names={"-a", "--addresses"}, split=",", arity="1..*", paramLabel="<hostname>:<port>", description={"[DEPRECATED] Optional comma-separated list of Jet node addresses in the format <hostname>:<port>, if you want to connect to a cluster other than the one configured in the configuration file. Use --targets instead."}, order=1)
    private List<String> addresses;
    @CommandLine.Option(names={"-n", "--cluster-name"}, description={"[DEPRECATED] The cluster name to use when connecting to the cluster specified by the <addresses> parameter. Use --targets instead."}, defaultValue="jet", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, order=2)
    private String clusterName;
    @CommandLine.Mixin(name="targets")
    private TargetsMixin targetsMixin;
    @CommandLine.Mixin(name="verbosity")
    private Verbosity verbosity;

    public JetCommandLine(Function<ClientConfig, JetInstance> jetClientFn, PrintStream out, PrintStream err) {
        this.jetClientFn = jetClientFn;
        this.out = out;
        this.err = err;
    }

    public static void main(String[] args) {
        JetCommandLine.runCommandLine(Jet::newJetClient, System.out, System.err, true, args);
    }

    static void runCommandLine(Function<ClientConfig, JetInstance> jetClientFn, PrintStream out, PrintStream err, boolean shouldExit, String[] args) {
        CommandLine cmd = new CommandLine(new JetCommandLine(jetClientFn, out, err));
        cmd.getSubcommands().get("submit").setStopAtPositional(true);
        String jetVersion = BuildInfoProvider.getBuildInfo().getJetBuildInfo().getVersion();
        cmd.getCommandSpec().usageMessage().header("Hazelcast Jet " + jetVersion);
        if (args.length == 0) {
            cmd.usage(out);
        } else {
            List parsed;
            CommandLine.DefaultExceptionHandler excHandler = (CommandLine.DefaultExceptionHandler)((CommandLine.DefaultExceptionHandler)new ExceptionHandler().useErr(err)).useAnsi(CommandLine.Help.Ansi.AUTO);
            if (shouldExit) {
                excHandler.andExit(1);
            }
            if ((parsed = (List)cmd.parseWithHandlers((CommandLine.IParseResultHandler2)((CommandLine.AbstractParseResultHandler)new CommandLine.RunAll().useOut(out)).useAnsi(CommandLine.Help.Ansi.AUTO), excHandler, args)) != null && parsed.size() == 1) {
                cmd.usage(out);
            }
        }
    }

    @Override
    public void run() {
    }

    @CommandLine.Command(description={"Starts the SQL shell [BETA]"})
    public void sql(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets) {
        this.runWithJet(targets, verbosity, true, jet -> {
            LineReader reader = LineReaderBuilder.builder().parser(new MultilineParser()).variable("secondary-prompt-pattern", new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12)).append("%M%P > ").toAnsi()).variable("indentation", 2).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).appName("hazelcast-jet-sql").build();
            AtomicReference<SqlResult> activeSqlResult = new AtomicReference<SqlResult>();
            reader.getTerminal().handle(Terminal.Signal.INT, signal -> {
                SqlResult r = (SqlResult)activeSqlResult.get();
                if (r != null) {
                    r.close();
                }
            });
            PrintWriter writer = reader.getTerminal().writer();
            writer.println(this.sqlStartingPrompt((JetInstance)jet));
            writer.flush();
            block3: while (true) {
                String command;
                try {
                    command = reader.readLine(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(12)).append("sql> ").toAnsi()).trim();
                }
                catch (IOError | EndOfFileException e) {
                    writer.println(SQLCliConstants.EXIT_PROMPT);
                    writer.flush();
                    break;
                }
                catch (UserInterruptException e) {
                    continue;
                }
                command = command.trim();
                if (command.length() > 0 && command.charAt(command.length() - 1) == ';') {
                    command = command.substring(0, command.length() - 1).trim();
                } else if (command.lastIndexOf(";") >= 0) {
                    String errorPrompt = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append("There are non-whitespace characters after the semicolon").toAnsi();
                    writer.println(errorPrompt);
                    writer.flush();
                    continue;
                }
                if ("".equals(command)) continue;
                if ("clear".equalsIgnoreCase(command)) {
                    reader.getTerminal().puts(InfoCmp.Capability.clear_screen, new Object[0]);
                    continue;
                }
                if ("help".equalsIgnoreCase(command)) {
                    writer.println(this.helpPrompt((JetInstance)jet));
                    writer.flush();
                    continue;
                }
                if ("history".equalsIgnoreCase(command)) {
                    History hist = reader.getHistory();
                    Iterator iterator = hist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        History.Entry entry = (History.Entry)iterator.next();
                        if (iterator.hasNext()) {
                            String entryLine = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append(String.valueOf(entry.index() + 1)).append(" - ").append(entry.line()).toAnsi();
                            writer.println(entryLine);
                            writer.flush();
                            continue;
                        }
                        iterator.remove();
                        hist.resetIndex();
                    }
                }
                if ("exit".equalsIgnoreCase(command)) {
                    writer.println(SQLCliConstants.EXIT_PROMPT);
                    writer.flush();
                    break;
                }
                this.executeSqlCmd((JetInstance)jet, command, reader.getTerminal(), activeSqlResult);
            }
        });
    }

    @CommandLine.Command(description={"Submits a job to the cluster"})
    public void submit(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Option(names={"-s", "--snapshot"}, paramLabel="<snapshot name>", description={"Name of the initial snapshot to start the job from"}) String snapshotName, @CommandLine.Option(names={"-n", "--name"}, paramLabel="<name>", description={"Name of the job"}) String name, @CommandLine.Option(names={"-c", "--class"}, paramLabel="<class>", description={"Fully qualified name of the main class inside the JAR file"}) String mainClass, @CommandLine.Parameters(index="0", paramLabel="<jar file>", description={"The jar file to submit"}) File file, @CommandLine.Parameters(index="1..*", paramLabel="<arguments>", description={"Arguments to pass to the supplied jar file"}) List<String> params) throws Exception {
        if (params == null) {
            params = Collections.emptyList();
        }
        this.verbosity.merge(verbosity);
        this.configureLogging();
        if (!file.exists()) {
            throw new Exception("File " + file + " could not be found.");
        }
        this.printf("Submitting JAR '%s' with arguments %s", file, params);
        if (name != null) {
            this.printf("Using job name '%s'", name);
        }
        if (snapshotName != null) {
            this.printf("Will restore the job from the snapshot with name '%s'", snapshotName);
        }
        this.targetsMixin.replace(targets);
        JetBootstrap.executeJar(() -> this.getJetClient(false), file.getAbsolutePath(), snapshotName, name, mainClass, params);
    }

    @CommandLine.Command(description={"Suspends a running job"})
    public void suspend(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to suspend"}) String name) {
        this.runWithJet(targets, verbosity, false, jet -> {
            Job job = JetCommandLine.getJob(jet, name);
            JetCommandLine.assertJobRunning(name, job);
            this.printf("Suspending job %s...", JetCommandLine.formatJob(job));
            job.suspend();
            JetCommandLine.waitForJobStatus(job, JobStatus.SUSPENDED);
            this.println("Job suspended.");
        });
    }

    @CommandLine.Command(description={"Cancels a running job"})
    public void cancel(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to cancel"}) String name) {
        this.runWithJet(targets, verbosity, false, jet -> {
            Job job = JetCommandLine.getJob(jet, name);
            JetCommandLine.assertJobActive(name, job);
            this.printf("Cancelling job %s", JetCommandLine.formatJob(job));
            job.cancel();
            JetCommandLine.waitForJobStatus(job, JobStatus.FAILED);
            this.println("Job cancelled.");
        });
    }

    @CommandLine.Command(name="save-snapshot", description={"Exports a named snapshot from a job and optionally cancels it"})
    public void saveSnapshot(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to take the snapshot from"}) String jobName, @CommandLine.Parameters(index="1", paramLabel="<snapshot name>", description={"Name of the snapshot"}) String snapshotName, @CommandLine.Option(names={"-C", "--cancel"}, description={"Cancel the job after taking the snapshot"}) boolean isTerminal) {
        this.runWithJet(targets, verbosity, false, jet -> {
            Job job = JetCommandLine.getJob(jet, jobName);
            JetCommandLine.assertJobActive(jobName, job);
            if (isTerminal) {
                this.printf("Saving snapshot with name '%s' from job '%s' and cancelling the job...", snapshotName, JetCommandLine.formatJob(job));
                job.cancelAndExportSnapshot(snapshotName);
                JetCommandLine.waitForJobStatus(job, JobStatus.FAILED);
            } else {
                this.printf("Saving snapshot with name '%s' from job '%s'...", snapshotName, JetCommandLine.formatJob(job));
                job.exportSnapshot(snapshotName);
            }
            this.printf("Exported snapshot '%s'.", snapshotName);
        });
    }

    @CommandLine.Command(name="delete-snapshot", description={"Deletes a named snapshot"})
    public void deleteSnapshot(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Parameters(index="0", paramLabel="<snapshot name>", description={"Name of the snapshot"}) String snapshotName) {
        this.runWithJet(targets, verbosity, false, jet -> {
            JobStateSnapshot jobStateSnapshot = jet.getJobStateSnapshot(snapshotName);
            if (jobStateSnapshot == null) {
                throw new JetException(String.format("Didn't find a snapshot named '%s'", snapshotName));
            }
            jobStateSnapshot.destroy();
            this.printf("Deleted snapshot '%s'.", snapshotName);
        });
    }

    @CommandLine.Command(description={"Restarts a running job"})
    public void restart(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to restart"}) String name) {
        this.runWithJet(targets, verbosity, false, jet -> {
            Job job = JetCommandLine.getJob(jet, name);
            JetCommandLine.assertJobRunning(name, job);
            this.println("Restarting job " + JetCommandLine.formatJob(job) + "...");
            job.restart();
            JetCommandLine.waitForJobStatus(job, JobStatus.RUNNING);
            this.println("Job restarted.");
        });
    }

    @CommandLine.Command(description={"Resumes a suspended job"})
    public void resume(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Parameters(index="0", paramLabel="<job name or id>", description={"Name of the job to resume"}) String name) {
        this.runWithJet(targets, verbosity, false, jet -> {
            Job job = JetCommandLine.getJob(jet, name);
            if (job.getStatus() != JobStatus.SUSPENDED) {
                throw new RuntimeException("Job '" + name + "' is not suspended. Current state: " + (Object)((Object)job.getStatus()));
            }
            this.println("Resuming job " + JetCommandLine.formatJob(job) + "...");
            job.resume();
            JetCommandLine.waitForJobStatus(job, JobStatus.RUNNING);
            this.println("Job resumed.");
        });
    }

    @CommandLine.Command(name="list-jobs", description={"Lists running jobs on the cluster"})
    public void listJobs(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Option(names={"-a", "--all"}, description={"Lists all jobs including completed and failed ones"}) boolean listAll) {
        this.runWithJet(targets, verbosity, false, jet -> {
            JetClientInstanceImpl client = (JetClientInstanceImpl)jet;
            List<JobSummary> summaries = client.getJobSummaryList();
            String format = "%-19s %-18s %-23s %s";
            this.printf(format, "ID", "STATUS", "SUBMISSION TIME", "NAME");
            summaries.stream().filter(job -> listAll || JetCommandLine.isActive(job.getStatus())).forEach(job -> {
                String idString = Util.idToString(job.getJobId());
                String name = job.getName().equals(idString) ? "N/A" : job.getName();
                this.printf(format, new Object[]{idString, job.getStatus(), com.hazelcast.jet.impl.util.Util.toLocalDateTime(job.getSubmissionTime()), name});
            });
        });
    }

    @CommandLine.Command(name="list-snapshots", description={"Lists exported snapshots on the cluster"})
    public void listSnapshots(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets, @CommandLine.Option(names={"-F", "--full-job-name"}, description={"Don't trim job name to fit, can break layout"}) boolean fullJobName) {
        this.runWithJet(targets, verbosity, false, jet -> {
            Collection<JobStateSnapshot> snapshots = jet.getJobStateSnapshots();
            this.printf("%-23s %-15s %-24s %s", "TIME", "SIZE (bytes)", "JOB NAME", "SNAPSHOT NAME");
            snapshots.stream().sorted(Comparator.comparing(JobStateSnapshot::name)).forEach(ss -> {
                String jobName;
                LocalDateTime creationTime = com.hazelcast.jet.impl.util.Util.toLocalDateTime(ss.creationTime());
                String string = jobName = ss.jobName() == null ? Util.idToString(ss.jobId()) : ss.jobName();
                if (!fullJobName) {
                    jobName = JetCommandLine.shorten(jobName);
                }
                this.printf("%-23s %-,15d %-24s %s", creationTime, ss.payloadSize(), jobName, ss.name());
            });
        });
    }

    @CommandLine.Command(description={"Shows current cluster state and information about members"})
    public void cluster(@CommandLine.Mixin(name="verbosity") Verbosity verbosity, @CommandLine.Mixin(name="targets") TargetsMixin targets) {
        this.runWithJet(targets, verbosity, false, jet -> {
            JetClientInstanceImpl client = (JetClientInstanceImpl)jet;
            HazelcastClientInstanceImpl hazelcastClient = client.getHazelcastClient();
            ClientClusterService clientClusterService = hazelcastClient.getClientClusterService();
            MCClusterMetadata clusterMetadata = FutureUtil.getValue(this.getClusterMetadata(hazelcastClient, clientClusterService.getMasterMember()));
            Cluster cluster = client.getCluster();
            this.println("State: " + (Object)((Object)clusterMetadata.getCurrentState()));
            this.println("Version: " + clusterMetadata.getJetVersion());
            this.println("Size: " + cluster.getMembers().size());
            this.println("");
            String format = "%-24s %-19s";
            this.printf(format, "ADDRESS", "UUID");
            cluster.getMembers().forEach(member -> this.printf(format, member.getAddress(), member.getUuid()));
        });
    }

    private CompletableFuture<MCClusterMetadata> getClusterMetadata(HazelcastClientInstanceImpl client, Member member) {
        Preconditions.checkNotNull(member);
        ClientInvocation invocation = new ClientInvocation(client, MCGetClusterMetadataCodec.encodeRequest(), null, member.getUuid());
        return new ClientDelegatingFuture<MCClusterMetadata>(invocation.invoke(), client.getSerializationService(), clientMessage -> {
            MCGetClusterMetadataCodec.ResponseParameters response = MCGetClusterMetadataCodec.decodeResponse(clientMessage);
            MCClusterMetadata metadata = new MCClusterMetadata();
            metadata.setCurrentState(ClusterState.getById(response.currentState));
            metadata.setClusterTime(response.clusterTime);
            metadata.setMemberVersion(response.memberVersion);
            metadata.setJetVersion(response.jetVersion);
            return metadata;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithJet(TargetsMixin targets, Verbosity verbosity, boolean retryClusterConnectForever, ConsumerEx<JetInstance> consumer) {
        this.targetsMixin.replace(targets);
        this.verbosity.merge(verbosity);
        this.configureLogging();
        JetInstance jet = this.getJetClient(retryClusterConnectForever);
        try {
            consumer.accept(jet);
        }
        finally {
            jet.shutdown();
        }
    }

    private JetInstance getJetClient(boolean retryClusterConnectForever) {
        return com.hazelcast.jet.impl.util.Util.uncheckCall(() -> this.jetClientFn.apply(this.getClientConfig(retryClusterConnectForever)));
    }

    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="Generates false positive")
    private ClientConfig getClientConfig(boolean retryClusterConnectForever) throws IOException {
        ClientConfig config;
        if (this.isYaml()) {
            config = new YamlClientConfigBuilder(this.config).build();
        } else if (this.isConfigFileNotNull()) {
            config = new XmlClientConfigBuilder(this.config).build();
        } else {
            if (this.addresses != null) {
                ClientConfig c = new ClientConfig();
                c.getNetworkConfig().addAddress(this.addresses.toArray(new String[0]));
                c.setClusterName(this.clusterName);
                return c;
            }
            config = ConfigProvider.locateAndGetClientConfig();
        }
        if (this.targetsMixin.getTargets() != null) {
            config.getNetworkConfig().setAddresses(this.targetsMixin.getAddresses());
            config.setClusterName(this.targetsMixin.getClusterName());
        }
        if (retryClusterConnectForever) {
            double expBackoffMultiplier = 1.25;
            long clusterConnectTimeoutMillis = Long.MAX_VALUE;
            int maxBackOffMillis = (int)TimeUnit.SECONDS.toMillis(15L);
            config.getConnectionStrategyConfig().getConnectionRetryConfig().setClusterConnectTimeoutMillis(Long.MAX_VALUE).setMultiplier(1.25).setMaxBackoffMillis(maxBackOffMillis);
        }
        return config;
    }

    private boolean isYaml() {
        return this.isConfigFileNotNull() && (this.config.getPath().endsWith(".yaml") || this.config.getPath().endsWith(".yml"));
    }

    private boolean isConfigFileNotNull() {
        return this.config != null;
    }

    private void configureLogging() {
        JetBootstrap.configureLogging();
        Level logLevel = Level.WARNING;
        if (this.verbosity.isVerbose) {
            this.println("Verbose mode is on, setting logging level to INFO");
            logLevel = Level.INFO;
        }
        LogManager.getLogManager().getLogger("").setLevel(logLevel);
    }

    private static Job getJob(JetInstance jet, String nameOrId) {
        Job job = jet.getJob(nameOrId);
        if (job == null && (job = jet.getJob(Util.idFromString(nameOrId))) == null) {
            throw new JobNotFoundException("No job with name or id '" + nameOrId + "' was found");
        }
        return job;
    }

    private void printf(String format, Object ... objects) {
        this.out.printf(format + "%n", objects);
    }

    private void println(String msg) {
        this.out.println(msg);
    }

    private static String shorten(String name) {
        if (name.length() <= 24) {
            return name;
        }
        return name.substring(0, 23) + "*";
    }

    private static String formatJob(Job job) {
        return "id=" + Util.idToString(job.getId()) + ", name=" + job.getName() + ", submissionTime=" + com.hazelcast.jet.impl.util.Util.toLocalDateTime(job.getSubmissionTime());
    }

    private static void assertJobActive(String name, Job job) {
        if (!JetCommandLine.isActive(job.getStatus())) {
            throw new RuntimeException("Job '" + name + "' is not active. Current state: " + (Object)((Object)job.getStatus()));
        }
    }

    private static void assertJobRunning(String name, Job job) {
        if (job.getStatus() != JobStatus.RUNNING) {
            throw new RuntimeException("Job '" + name + "' is not running. Current state: " + (Object)((Object)job.getStatus()));
        }
    }

    private static void waitForJobStatus(Job job, JobStatus status) {
        while (job.getStatus() != status) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
    }

    private static boolean isActive(JobStatus status) {
        return status != JobStatus.FAILED && status != JobStatus.COMPLETED;
    }

    private void executeSqlCmd(JetInstance jet, String command, Terminal terminal, AtomicReference<SqlResult> activeSqlResult) {
        PrintWriter out = terminal.writer();
        try (SqlResult sqlResult = jet.getSql().execute(command, new Object[0]);){
            activeSqlResult.set(sqlResult);
            if (sqlResult.updateCount() != -1L) {
                String message = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append("OK").toAnsi();
                out.println(message);
                return;
            }
            SqlRowMetadata rowMetadata = sqlResult.getRowMetadata();
            int[] colWidths = JetCommandLine.determineColumnWidths(rowMetadata);
            Alignment[] alignments = JetCommandLine.determineAlignments(rowMetadata);
            JetCommandLine.printMetadataInfo(rowMetadata, colWidths, alignments, out);
            int rowCount = 0;
            for (SqlRow row : sqlResult) {
                ++rowCount;
                JetCommandLine.printRow(row, colWidths, alignments, out);
            }
            JetCommandLine.printSeparatorLine(sqlResult.getRowMetadata().getColumnCount(), colWidths, out);
            String message = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append(String.valueOf(rowCount)).append(" row(s) selected").toAnsi();
            out.println(message);
        }
        catch (HazelcastSqlException e) {
            String errorPrompt = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append(e.getMessage()).toAnsi();
            out.println(errorPrompt);
        }
    }

    private static int[] determineColumnWidths(SqlRowMetadata metadata) {
        int colCount = metadata.getColumnCount();
        int[] colWidths = new int[colCount];
        block16: for (int i = 0; i < colCount; ++i) {
            SqlColumnMetadata colMetadata = metadata.getColumn(i);
            SqlColumnType type = colMetadata.getType();
            String colName = colMetadata.getName();
            switch (type) {
                case BOOLEAN: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.BOOLEAN_FORMAT_LENGTH);
                    continue block16;
                }
                case DATE: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.DATE_FORMAT_LENGTH);
                    continue block16;
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.TIMESTAMP_WITH_TIME_ZONE_FORMAT_LENGTH);
                    continue block16;
                }
                case DECIMAL: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.DECIMAL_FORMAT_LENGTH);
                    continue block16;
                }
                case REAL: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.REAL_FORMAT_LENGTH);
                    continue block16;
                }
                case DOUBLE: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.DOUBLE_FORMAT_LENGTH);
                    continue block16;
                }
                case INTEGER: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.INTEGER_FORMAT_LENGTH);
                    continue block16;
                }
                case NULL: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.NULL_FORMAT_LENGTH);
                    continue block16;
                }
                case TINYINT: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.TINYINT_FORMAT_LENGTH);
                    continue block16;
                }
                case SMALLINT: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.SMALLINT_FORMAT_LENGTH);
                    continue block16;
                }
                case TIMESTAMP: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.TIMESTAMP_FORMAT_LENGTH);
                    continue block16;
                }
                case BIGINT: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.BIGINT_FORMAT_LENGTH);
                    continue block16;
                }
                case VARCHAR: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.VARCHAR_FORMAT_LENGTH);
                    continue block16;
                }
                case OBJECT: {
                    colWidths[i] = JetCommandLine.determineColumnWidth(colName, SQLCliConstants.OBJECT_FORMAT_LENGTH);
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException(type.toString());
                }
            }
        }
        return colWidths;
    }

    private static int determineColumnWidth(String header, int typeLength) {
        return Math.max(Math.min(header.length(), SQLCliConstants.VARCHAR_FORMAT_LENGTH), typeLength);
    }

    private static Alignment[] determineAlignments(SqlRowMetadata metadata) {
        int colCount = metadata.getColumnCount();
        Alignment[] alignments = new Alignment[colCount];
        block3: for (int i = 0; i < colCount; ++i) {
            SqlColumnMetadata colMetadata = metadata.getColumn(i);
            SqlColumnType type = colMetadata.getType();
            String colName = colMetadata.getName();
            switch (type) {
                case DECIMAL: 
                case REAL: 
                case DOUBLE: 
                case INTEGER: 
                case TINYINT: 
                case SMALLINT: 
                case BIGINT: {
                    alignments[i] = Alignment.RIGHT;
                    continue block3;
                }
                default: {
                    alignments[i] = Alignment.LEFT;
                }
            }
        }
        return alignments;
    }

    private static void printMetadataInfo(SqlRowMetadata metadata, int[] colWidths, Alignment[] alignments, PrintWriter out) {
        int colCount = metadata.getColumnCount();
        JetCommandLine.printSeparatorLine(colCount, colWidths, out);
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12));
        builder.append("|");
        for (int i = 0; i < colCount; ++i) {
            String colName = metadata.getColumn(i).getName();
            colName = JetCommandLine.sanitize(colName, colWidths[i]);
            builder.style(AttributedStyle.BOLD.foreground(3));
            JetCommandLine.appendAligned(colWidths[i], colName, alignments[i], builder);
            builder.style(AttributedStyle.BOLD.foreground(12));
            builder.append('|');
        }
        out.println(builder.toAnsi());
        JetCommandLine.printSeparatorLine(colCount, colWidths, out);
        out.flush();
    }

    private static void printRow(SqlRow row, int[] colWidths, Alignment[] alignments, PrintWriter out) {
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12));
        builder.append("|");
        int columnCount = row.getMetadata().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String colString = row.getObject(i) != null ? JetCommandLine.sanitize(row.getObject(i).toString(), colWidths[i]) : "NULL";
            builder.style(AttributedStyle.BOLD.foreground(3));
            JetCommandLine.appendAligned(colWidths[i], colString, alignments[i], builder);
            builder.style(AttributedStyle.BOLD.foreground(12));
            builder.append('|');
        }
        out.println(builder.toAnsi());
        out.flush();
    }

    private static String sanitize(String s, int width) {
        if ((s = s.replace("\n", "\\n")).length() > width) {
            s = s.substring(0, width - 1) + "\u2026";
        }
        return s;
    }

    private static void appendAligned(int width, String s, Alignment alignment, AttributedStringBuilder builder) {
        int padding = width - s.length();
        assert (padding >= 0);
        if (alignment == Alignment.RIGHT) {
            JetCommandLine.appendPadding(builder, padding, ' ');
        }
        builder.append(s);
        if (alignment == Alignment.LEFT) {
            JetCommandLine.appendPadding(builder, padding, ' ');
        }
    }

    private static void appendPadding(AttributedStringBuilder builder, int length, char paddingChar) {
        for (int i = 0; i < length; ++i) {
            builder.append(paddingChar);
        }
    }

    private static void printSeparatorLine(int colSize, int[] colWidths, PrintWriter out) {
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(12));
        builder.append('+');
        for (int i = 0; i < colSize; ++i) {
            JetCommandLine.appendPadding(builder, colWidths[i], '-');
            builder.append('+');
        }
        out.println(builder.toAnsi());
    }

    private String sqlStartingPrompt(JetInstance jet) {
        JetClientInstanceImpl client = (JetClientInstanceImpl)jet;
        HazelcastClientInstanceImpl hazelcastClient = client.getHazelcastClient();
        ClientClusterService clientClusterService = hazelcastClient.getClientClusterService();
        MCClusterMetadata clusterMetadata = FutureUtil.getValue(this.getClusterMetadata(hazelcastClient, clientClusterService.getMasterMember()));
        Cluster cluster = client.getCluster();
        Set<Member> members = cluster.getMembers();
        String versionString = clusterMetadata.getJetVersion() != null ? "Hazelcast Jet " + clusterMetadata.getJetVersion() : "Hazelcast IMDG " + clusterMetadata.getMemberVersion();
        return new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append("Connected to ").append(versionString).append(" at ").append(members.iterator().next().getAddress().toString()).append(" (+").append(String.valueOf(members.size() - 1)).append(" more)\n").append("Type 'help' for instructions").toAnsi();
    }

    private String helpPrompt(JetInstance jet) {
        JetClientInstanceImpl client = (JetClientInstanceImpl)jet;
        HazelcastClientInstanceImpl hazelcastClient = client.getHazelcastClient();
        ClientClusterService clientClusterService = hazelcastClient.getClientClusterService();
        MCClusterMetadata clusterMetadata = FutureUtil.getValue(this.getClusterMetadata(hazelcastClient, clientClusterService.getMasterMember()));
        String jetVersion = clusterMetadata.getJetVersion();
        AttributedStringBuilder builder = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append("Available Commands:\n").append("  clear    Clears the terminal screen\n").append("  exit     Exits from the SQL console\n").append("  help     Provides information about available commands\n").append("  history  Shows the command history of the current session\n").append("Hints:\n").append("  Semicolon completes a query\n");
        if (jetVersion != null) {
            builder.append("  Ctrl+C cancels a streaming query\n").append("  https://jet-start.sh/docs/sql/intro");
        } else {
            builder.append("  https://docs.hazelcast.org/docs/latest/manual/html-single/#sql");
        }
        return builder.toAnsi();
    }

    private static enum Alignment {
        LEFT,
        RIGHT;

    }

    private static class SQLCliConstants {
        static final Set<String> COMMAND_SET = new HashSet<String>(Arrays.asList("clear", "exit", "help", "history"));
        static final String EXIT_PROMPT = new AttributedStringBuilder().style(AttributedStyle.BOLD.foreground(3)).append("Exiting from SQL console").toAnsi();
        static final Integer BOOLEAN_FORMAT_LENGTH = 5;
        static final Integer BIGINT_FORMAT_LENGTH = 20;
        static final Integer DATE_FORMAT_LENGTH = 10;
        static final Integer DECIMAL_FORMAT_LENGTH = 25;
        static final Integer DOUBLE_FORMAT_LENGTH = 25;
        static final Integer INTEGER_FORMAT_LENGTH = 12;
        static final Integer NULL_FORMAT_LENGTH = 4;
        static final Integer REAL_FORMAT_LENGTH = 25;
        static final Integer OBJECT_FORMAT_LENGTH = 20;
        static final Integer TINYINT_FORMAT_LENGTH = 4;
        static final Integer SMALLINT_FORMAT_LENGTH = 6;
        static final Integer TIMESTAMP_FORMAT_LENGTH = 19;
        static final Integer TIMESTAMP_WITH_TIME_ZONE_FORMAT_LENGTH = 25;
        static final Integer VARCHAR_FORMAT_LENGTH = 20;

        private SQLCliConstants() {
        }
    }

    private static final class MultilineParser
    extends DefaultParser {
        private MultilineParser() {
        }

        @Override
        public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
            super.setQuoteChars(new char[]{'\'', '\"'});
            super.setEofOnUnclosedQuote(true);
            this.stateCheck(line, cursor);
            return new DefaultParser.ArgumentList(this, line, Collections.emptyList(), -1, -1, cursor, "'", -1, -1);
        }

        private void stateCheck(String line, int cursor) {
            boolean containsNonWhitespaceData = false;
            int quoteStart = -1;
            int oneLineCommentStart = -1;
            int multiLineCommentStart = -1;
            int lastSemicolonIdx = -1;
            for (int i = 0; i < line.length(); ++i) {
                if (oneLineCommentStart == -1 && multiLineCommentStart == -1 && quoteStart < 0 && this.isQuoteChar(line, i)) {
                    quoteStart = i;
                    containsNonWhitespaceData = true;
                    continue;
                }
                char currentChar = line.charAt(i);
                if (quoteStart >= 0) {
                    if (line.charAt(quoteStart) != currentChar || this.isEscaped(line, i)) continue;
                    quoteStart = -1;
                    continue;
                }
                if (oneLineCommentStart == -1 && line.regionMatches(i, "/*", 0, "/*".length())) {
                    multiLineCommentStart = i;
                    containsNonWhitespaceData = true;
                    continue;
                }
                if (multiLineCommentStart >= 0) {
                    if (i - multiLineCommentStart <= 2 || !line.regionMatches(i - 1, "*/", 0, "*/".length())) continue;
                    multiLineCommentStart = -1;
                    continue;
                }
                if (oneLineCommentStart == -1 && line.regionMatches(i, "--", 0, "--".length())) {
                    oneLineCommentStart = i;
                    containsNonWhitespaceData = true;
                    continue;
                }
                if (oneLineCommentStart >= 0) {
                    if (currentChar != '\n') continue;
                    oneLineCommentStart = -1;
                    continue;
                }
                if (currentChar == ';') {
                    lastSemicolonIdx = i;
                    continue;
                }
                if (Character.isWhitespace(currentChar)) continue;
                containsNonWhitespaceData = true;
            }
            if (SQLCliConstants.COMMAND_SET.contains(line.trim().toLowerCase(Locale.US))) {
                return;
            }
            if (this.isEofOnEscapedNewLine() && this.isEscapeChar(line, line.length() - 1)) {
                throw new EOFError(-1, cursor, "Escaped new line");
            }
            if (this.isEofOnUnclosedQuote() && quoteStart >= 0) {
                throw new EOFError(-1, quoteStart, "Missing closing quote", line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
            }
            if (oneLineCommentStart != -1) {
                throw new EOFError(-1, cursor, "One line comment");
            }
            if (multiLineCommentStart != -1) {
                throw new EOFError(-1, cursor, "Missing end of comment", "**");
            }
            if (containsNonWhitespaceData && (lastSemicolonIdx == -1 || lastSemicolonIdx >= cursor)) {
                throw new EOFError(-1, cursor, "Missing semicolon (;)");
            }
        }
    }

    static class ExceptionHandler<R>
    extends CommandLine.DefaultExceptionHandler<R> {
        ExceptionHandler() {
        }

        @Override
        public R handleExecutionException(CommandLine.ExecutionException ex, CommandLine.ParseResult parseResult) {
            CommandLine cmdLine = ex.getCommandLine();
            while (cmdLine.getParent() != null) {
                cmdLine = cmdLine.getParent();
            }
            JetCommandLine jetCmd = (JetCommandLine)cmdLine.getCommand();
            if (jetCmd.verbosity.isVerbose) {
                ex.printStackTrace(this.err());
            } else {
                this.err().println("ERROR: " + ExceptionHandler.peel(ex.getCause()).getMessage());
                this.err().println();
                this.err().println("To see the full stack trace, re-run with the -v/--verbosity option");
            }
            if (this.hasExitCode()) {
                this.exit(this.exitCode());
            }
            throw ex;
        }

        static Throwable peel(Throwable e) {
            if (e instanceof InvocationTargetException) {
                return e.getCause();
            }
            return e;
        }
    }

    public static class TargetsMixin {
        @CommandLine.Option(names={"-t", "--targets"}, description={"The cluster name and addresses to use if you want to connect to a cluster other than the one configured in the configuration file. At least one address is required. The cluster name is optional."}, paramLabel="[<cluster-name>@]<hostname>:<port>[,<hostname>:<port>]", converter={Converter.class})
        private Targets targets;

        private Targets getTargets() {
            return this.targets;
        }

        public String getClusterName() {
            return this.targets.clusterName;
        }

        public List<String> getAddresses() {
            return this.targets.addresses;
        }

        public void replace(TargetsMixin targets) {
            if (targets.getTargets() != null) {
                this.targets = targets.getTargets();
            }
        }

        public static class Converter
        implements CommandLine.ITypeConverter<Targets> {
            @Override
            public Targets convert(String value) {
                Targets targets = new Targets();
                if (value == null) {
                    return targets;
                }
                if (value.contains("@")) {
                    String[] values = value.split("@");
                    targets.clusterName = values[0];
                    targets.addresses = Arrays.asList(values[1].split(","));
                } else {
                    targets.addresses = Arrays.asList(value.split(","));
                }
                return targets;
            }
        }

        public static class Targets {
            private String clusterName = "jet";
            private List<String> addresses = Collections.emptyList();
        }
    }

    public static class Verbosity {
        @CommandLine.Option(names={"-v", "--verbosity"}, description={"Show logs from Jet client and full stack trace of errors"}, order=1)
        private boolean isVerbose;

        void merge(Verbosity other) {
            this.isVerbose |= other.isVerbose;
        }
    }

    public static class JetVersionProvider
    implements CommandLine.IVersionProvider {
        @Override
        public String[] getVersion() {
            JetBuildInfo jetBuildInfo = BuildInfoProvider.getBuildInfo().getJetBuildInfo();
            return new String[]{"Hazelcast Jet " + jetBuildInfo.getVersion(), "Revision " + jetBuildInfo.getRevision(), "Build " + jetBuildInfo.getBuild()};
        }
    }
}

