/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PlanNodeSchema
implements PlanNodeFieldTypeProvider {
    private final List<QueryDataType> types;
    private final int rowWidth;

    public PlanNodeSchema(List<QueryDataType> types) {
        assert (types != null);
        this.types = Collections.unmodifiableList(types);
        this.rowWidth = PlanNodeSchema.calculateEstimatedRowSize(types);
    }

    public static PlanNodeSchema combine(PlanNodeSchema schema1, PlanNodeSchema schema2) {
        ArrayList<QueryDataType> types = new ArrayList<QueryDataType>(schema1.types);
        types.addAll(schema2.types);
        return new PlanNodeSchema(types);
    }

    @Override
    public QueryDataType getType(int index) {
        assert (index <= this.types.size());
        return this.types.get(index);
    }

    public List<QueryDataType> getTypes() {
        return this.types;
    }

    public int getEstimatedRowSize() {
        return this.rowWidth;
    }

    private static int calculateEstimatedRowSize(List<QueryDataType> types) {
        int res = 0;
        for (QueryDataType type : types) {
            res += type.getTypeFamily().getEstimatedSize();
        }
        return res;
    }

    public int hashCode() {
        return Objects.hash(this.types, this.rowWidth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeSchema schema = (PlanNodeSchema)o;
        return this.rowWidth == schema.rowWidth && this.types.equals(schema.types);
    }

    public String toString() {
        return "PlanNodeSchema {width=" + this.rowWidth + ", types=" + this.types + '}';
    }
}

