/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

public final class LongConverter
extends Converter {
    public static final LongConverter INSTANCE = new LongConverter();

    private LongConverter() {
        super(4, QueryDataTypeFamily.BIGINT);
    }

    @Override
    public Class<?> getValueClass() {
        return Long.class;
    }

    @Override
    public byte asTinyint(Object val) {
        long casted = this.cast(val);
        byte converted = (byte)casted;
        if ((long)converted != casted) {
            throw this.numericOverflow(QueryDataTypeFamily.TINYINT, val);
        }
        return converted;
    }

    @Override
    public short asSmallint(Object val) {
        long casted = this.cast(val);
        short converted = (short)casted;
        if ((long)converted != casted) {
            throw this.numericOverflow(QueryDataTypeFamily.SMALLINT, val);
        }
        return converted;
    }

    @Override
    public int asInt(Object val) {
        long casted = this.cast(val);
        int converted = (int)casted;
        if ((long)converted != casted) {
            throw this.numericOverflow(QueryDataTypeFamily.INTEGER, val);
        }
        return converted;
    }

    @Override
    public long asBigint(Object val) {
        return this.cast(val);
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        return new BigDecimal(this.cast(val), ExpressionMath.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val);
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Long.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asBigint(val);
    }

    private long cast(Object val) {
        return (Long)val;
    }
}

