/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.state;

import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QueryState {
    private long queryCommitIndex;
    private long queryRound;
    private final List<BiTuple<Object, InternalCompletableFuture>> operations = new ArrayList<BiTuple<Object, InternalCompletableFuture>>();
    private final Set<RaftEndpoint> acks = new HashSet<RaftEndpoint>();

    public int addQuery(long commitIndex, Object operation, InternalCompletableFuture resultFuture) {
        if (commitIndex < this.queryCommitIndex) {
            throw new IllegalArgumentException("Cannot execute query: " + operation + " at commit index because of the current " + this);
        }
        if (this.queryCommitIndex < commitIndex) {
            this.queryCommitIndex = commitIndex;
        }
        this.operations.add(BiTuple.of(operation, resultFuture));
        int size = this.operations.size();
        if (size == 1) {
            ++this.queryRound;
        }
        return size;
    }

    public boolean tryAck(long queryRound, RaftEndpoint follower) {
        if (this.queryCount() == 0 || this.queryRound > queryRound) {
            return false;
        }
        Preconditions.checkTrue(queryRound == this.queryRound, this + ", acked query round: " + queryRound + ", follower: " + follower);
        return this.acks.add(follower);
    }

    public boolean removeAck(RaftEndpoint follower) {
        return this.acks.remove(follower);
    }

    public int queryCount() {
        return this.operations.size();
    }

    public long queryRound() {
        return this.queryRound;
    }

    public boolean isMajorityAcked(long commitIndex, int majority) {
        if (this.queryCommitIndex > commitIndex) {
            throw new IllegalStateException("Cannot execute: " + this + ", current commit index: " + commitIndex);
        }
        return this.queryCount() > 0 && majority <= this.ackCount();
    }

    public boolean isAckNeeded(RaftEndpoint follower, int majority) {
        return this.queryCount() > 0 && !this.acks.contains(follower) && this.ackCount() < majority;
    }

    private int ackCount() {
        return this.acks.size() + 1;
    }

    public Collection<BiTuple<Object, InternalCompletableFuture>> operations() {
        return this.operations;
    }

    public void reset() {
        this.operations.clear();
        this.acks.clear();
    }

    public String toString() {
        return "QueryState{queryCommitIndex=" + this.queryCommitIndex + ", queryRound=" + this.queryRound + ", queryCount=" + this.queryCount() + ", acks=" + this.acks + '}';
    }
}

