/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.nonapi.io.github.classgraph.classloaderhandler;

import com.hazelcast.jet.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import com.hazelcast.jet.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import com.hazelcast.jet.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import com.hazelcast.jet.nonapi.io.github.classgraph.scanspec.ScanSpec;
import com.hazelcast.jet.nonapi.io.github.classgraph.utils.LogNode;
import com.hazelcast.jet.nonapi.io.github.classgraph.utils.ReflectionUtils;
import java.nio.file.Path;
import java.util.Collection;

class QuarkusClassLoaderHandler
implements ClassLoaderHandler {
    private static final String RUNTIME_CLASSLOADER = "io.quarkus.runner.RuntimeClassLoader";
    private static final String QUARKUS_CLASSLOADER = "io.quarkus.bootstrap.classloading.QuarkusClassLoader";

    private QuarkusClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return RUNTIME_CLASSLOADER.equals(classLoaderClass.getName()) || QUARKUS_CLASSLOADER.equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        String classLoaderName = classLoader.getClass().getName();
        if (RUNTIME_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForRuntimeClassloader(classLoader, classpathOrder, scanSpec, log);
        } else if (QUARKUS_CLASSLOADER.equals(classLoaderName)) {
            QuarkusClassLoaderHandler.findClasspathOrderForQuarkusClassloader(classLoader, classpathOrder, scanSpec, log);
        }
    }

    private static void findClasspathOrderForQuarkusClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        for (Object element : (Collection)ReflectionUtils.getFieldVal(classLoader, "elements", false)) {
            String elementClassName = element.getClass().getName();
            if ("io.quarkus.bootstrap.classloading.JarClassPathElement".equals(elementClassName)) {
                classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "file", false), classLoader, scanSpec, log);
                continue;
            }
            if (!"io.quarkus.bootstrap.classloading.DirectoryClassPathElement".equals(elementClassName)) continue;
            classpathOrder.addClasspathEntry(ReflectionUtils.getFieldVal(element, "root", false), classLoader, scanSpec, log);
        }
    }

    private static void findClasspathOrderForRuntimeClassloader(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        Collection applicationClassDirectories = (Collection)ReflectionUtils.getFieldVal(classLoader, "applicationClassDirectories", false);
        if (applicationClassDirectories != null) {
            for (Path path : applicationClassDirectories) {
                classpathOrder.addClasspathEntryObject(path.toUri(), classLoader, scanSpec, log);
            }
        }
    }
}

