/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.picocli;

import com.hazelcast.jet.picocli.CommandLine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoComplete {
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_INVALID_INPUT = 1;
    public static final int EXIT_CODE_COMMAND_SCRIPT_EXISTS = 2;
    public static final int EXIT_CODE_COMPLETION_SCRIPT_EXISTS = 3;
    public static final int EXIT_CODE_EXECUTION_ERROR = 4;
    private static final String HEADER = "#!/usr/bin/env bash\n#\n# %1$s Bash Completion\n# =======================\n#\n# Bash completion support for the `%1$s` command,\n# generated by [picocli](http://picocli.info/) version %2$s.\n#\n# Installation\n# ------------\n#\n# 1. Source all completion scripts in your .bash_profile\n#\n#   cd $YOUR_APP_HOME/bin\n#   for f in $(find . -name \"*_completion\"); do line=\". $(pwd)/$f\"; grep \"$line\" ~/.bash_profile || echo \"$line\" >> ~/.bash_profile; done\n#\n# 2. Open a new bash console, and type `%1$s [TAB][TAB]`\n#\n# 1a. Alternatively, if you have [bash-completion](https://github.com/scop/bash-completion) installed:\n#     Place this file in a `bash-completion.d` folder:\n#\n#   * /etc/bash-completion.d\n#   * /usr/local/etc/bash-completion.d\n#   * ~/bash-completion.d\n#\n# Documentation\n# -------------\n# The script is called by bash whenever [TAB] or [TAB][TAB] is pressed after\n# '%1$s (..)'. By reading entered command line parameters,\n# it determines possible bash completions and writes them to the COMPREPLY variable.\n# Bash then completes the user input if only one entry is listed in the variable or\n# shows the options if more than one is listed in COMPREPLY.\n#\n# References\n# ----------\n# [1] http://stackoverflow.com/a/12495480/1440785\n# [2] http://tiswww.case.edu/php/chet/bash/FAQ\n# [3] https://www.gnu.org/software/bash/manual/html_node/The-Shopt-Builtin.html\n# [4] http://zsh.sourceforge.net/Doc/Release/Options.html#index-COMPLETE_005fALIASES\n# [5] https://stackoverflow.com/questions/17042057/bash-check-element-in-array-for-elements-in-another-array/17042655#17042655\n# [6] https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion.html#Programmable-Completion\n#\n\nif [ -n \"$BASH_VERSION\" ]; then\n  # Enable programmable completion facilities when using bash (see [3])\n  shopt -s progcomp\nelif [ -n \"$ZSH_VERSION\" ]; then\n  # Make alias a distinct command for completion purposes when using zsh (see [4])\n  setopt COMPLETE_ALIASES\n  alias compopt=complete\nfi\n\n# ArrContains takes two arguments, both of which are the name of arrays.\n# It creates a temporary hash from lArr1 and then checks if all elements of lArr2\n# are in the hashtable.\n#\n# Returns zero (no error) if all elements of the 2nd array are in the 1st array,\n# otherwise returns 1 (error).\n#\n# Modified from [5]\nfunction ArrContains() {\n  local lArr1 lArr2\n  declare -A tmp\n  eval lArr1=(\"\\\"\\${$1[@]}\\\"\")\n  eval lArr2=(\"\\\"\\${$2[@]}\\\"\")\n  for i in \"${lArr1[@]}\";{ [ -n \"$i\" ] && ((++tmp[$i]));}\n  for i in \"${lArr2[@]}\";{ [ -n \"$i\" ] && [ -z \"${tmp[$i]}\" ] && return 1;}\n  return 0\n}\n\n";
    private static final String FOOTER = "\n# Define a completion specification (a compspec) for the\n# `%1$s`, `%1$s.sh`, and `%1$s.bash` commands.\n# Uses the bash `complete` builtin (see [6]) to specify that shell function\n# `_complete_%1$s` is responsible for generating possible completions for the\n# current word on the command line.\n# The `-o default` option means that if the function generated no matches, the\n# default Bash completions and the Readline default filename completions are performed.\ncomplete -F _complete_%1$s -o default %1$s %1$s.sh %1$s.bash\n";

    private AutoComplete() {
    }

    public static void main(String ... args) {
        new CommandLine(new App()).parseWithHandlers((CommandLine.IParseResultHandler2)new CommandLine.RunLast().andExit(0), (CommandLine.IExceptionHandler2)CommandLine.defaultExceptionHandler().andExit(1), args);
    }

    private static String bashify(CharSequence value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (!Character.isSpaceChar(c)) continue;
            builder.append('_');
        }
        return builder.toString();
    }

    private static <T> Predicate<T> negate(final Predicate<T> original) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !original.test(t);
            }
        };
    }

    private static <K, T extends K> List<T> filter(List<T> list, Predicate<K> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : list) {
            if (!filter.test(t)) continue;
            result.add(t);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bash(String scriptName, File out, File command, CommandLine commandLine) throws IOException {
        String autoCompleteScript = AutoComplete.bash(scriptName, commandLine);
        FileWriter completionWriter = null;
        Writer scriptWriter = null;
        try {
            completionWriter = new FileWriter(out);
            completionWriter.write(autoCompleteScript);
            if (command != null) {
                scriptWriter = new FileWriter(command);
                scriptWriter.write("#!/usr/bin/env bash\n\nLIBS=path/to/libs\nCP=\"${LIBS}/myApp.jar\"\njava -cp \"${CP}\" '" + commandLine.getCommand().getClass().getName() + "' $@");
            }
        }
        finally {
            if (completionWriter != null) {
                ((Writer)completionWriter).close();
            }
            if (scriptWriter != null) {
                scriptWriter.close();
            }
        }
    }

    public static String bash(String scriptName, CommandLine commandLine) {
        if (scriptName == null) {
            throw new NullPointerException("scriptName");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        String result = "";
        result = result + String.format(HEADER, scriptName, "3.9.0");
        LinkedHashMap<CommandDescriptor, CommandLine> function2command = new LinkedHashMap<CommandDescriptor, CommandLine>();
        result = result + AutoComplete.generateEntryPointFunction(scriptName, commandLine, function2command);
        for (Map.Entry functionSpec : function2command.entrySet()) {
            CommandDescriptor descriptor = (CommandDescriptor)functionSpec.getKey();
            result = result + AutoComplete.generateFunctionForCommand(descriptor.functionName, descriptor.commandName, (CommandLine)functionSpec.getValue());
        }
        result = result + String.format(FOOTER, scriptName);
        return result;
    }

    private static String generateEntryPointFunction(String scriptName, CommandLine commandLine, Map<CommandDescriptor, CommandLine> function2command) {
        String HEADER = "# Bash completion entry point function.\n# _complete_%1$s finds which commands and subcommands have been specified\n# on the command line and delegates to the appropriate function\n# to generate possible options and subcommands for the last specified subcommand.\nfunction _complete_%1$s() {\n";
        String FOOTER = "\n  # No subcommands were specified; generate completions for the top-level command.\n  _picocli_%1$s; return $?;\n}\n";
        StringBuilder buff = new StringBuilder(1024);
        buff.append(String.format(HEADER, scriptName));
        ArrayList<String> predecessors = new ArrayList<String>();
        ArrayList<String> functionCallsToArrContains = new ArrayList<String>();
        function2command.put(new CommandDescriptor("_picocli_" + scriptName, scriptName), commandLine);
        AutoComplete.generateFunctionCallsToArrContains(scriptName, predecessors, commandLine, buff, functionCallsToArrContains, function2command);
        buff.append("\n");
        Collections.reverse(functionCallsToArrContains);
        for (String func : functionCallsToArrContains) {
            buff.append(func);
        }
        buff.append(String.format(FOOTER, scriptName));
        return buff.toString();
    }

    private static void generateFunctionCallsToArrContains(String scriptName, List<String> predecessors, CommandLine commandLine, StringBuilder buff, List<String> functionCalls, Map<CommandDescriptor, CommandLine> function2command) {
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            int count = functionCalls.size();
            String functionName = "_picocli_" + scriptName + "_" + AutoComplete.concat("_", predecessors, entry.getKey(), new Bashify());
            functionCalls.add(String.format("  ArrContains COMP_WORDS CMDS%2$d && { %1$s; return $?; }\n", functionName, count));
            buff.append(String.format("  CMDS%2$d=(%1$s)\n", AutoComplete.concat(" ", predecessors, entry.getKey(), new NullFunction()), count));
            function2command.put(new CommandDescriptor(functionName, entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            predecessors.add(entry.getKey());
            AutoComplete.generateFunctionCallsToArrContains(scriptName, predecessors, entry.getValue(), buff, functionCalls, function2command);
            predecessors.remove(predecessors.size() - 1);
        }
    }

    private static String concat(String infix, String ... values) {
        return AutoComplete.concat(infix, Arrays.asList(values));
    }

    private static String concat(String infix, List<String> values) {
        return AutoComplete.concat(infix, values, null, new NullFunction());
    }

    private static <V, T extends V> String concat(String infix, List<T> values, T lastValue, Function<V, String> normalize) {
        StringBuilder sb = new StringBuilder();
        for (T val : values) {
            if (sb.length() > 0) {
                sb.append(infix);
            }
            sb.append(normalize.apply(val));
        }
        if (lastValue == null) {
            return sb.toString();
        }
        if (sb.length() > 0) {
            sb.append(infix);
        }
        return sb.append(normalize.apply(lastValue)).toString();
    }

    private static String generateFunctionForCommand(String functionName, String commandName, CommandLine commandLine) {
        String HEADER = "\n# Generates completions for the options and subcommands of the `%s` %scommand.\nfunction %s() {\n  # Get completion data\n  CURR_WORD=${COMP_WORDS[COMP_CWORD]}\n  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}\n\n  COMMANDS=\"%s\"\n  FLAG_OPTS=\"%s\"\n  ARG_OPTS=\"%s\"\n";
        String FOOTER = "\n  if [[ \"${CURR_WORD}\" == -* ]]; then\n    COMPREPLY=( $(compgen -W \"${FLAG_OPTS} ${ARG_OPTS}\" -- ${CURR_WORD}) )\n  else\n    COMPREPLY=( $(compgen -W \"${COMMANDS}\" -- ${CURR_WORD}) )\n  fi\n}\n";
        CommandLine.Model.CommandSpec commandSpec = commandLine.getCommandSpec();
        String flagOptionNames = AutoComplete.optionNames(AutoComplete.filter(commandSpec.options(), new BooleanArgFilter()));
        List<CommandLine.Model.OptionSpec> argOptionFields = AutoComplete.filter(commandSpec.options(), AutoComplete.negate(new BooleanArgFilter()));
        String argOptionNames = AutoComplete.optionNames(argOptionFields);
        String commands = AutoComplete.concat(" ", new ArrayList<String>(commandLine.getSubcommands().keySet())).trim();
        StringBuilder buff = new StringBuilder(1024);
        String sub = functionName.equals("_picocli_" + commandName) ? "" : "sub";
        buff.append(String.format(HEADER, commandName, sub, functionName, commands, flagOptionNames, argOptionNames));
        for (CommandLine.Model.OptionSpec f : commandSpec.options()) {
            if (f.completionCandidates() == null) continue;
            AutoComplete.generateCompletionCandidates(buff, f);
        }
        buff.append(AutoComplete.generateOptionsSwitch(argOptionFields));
        buff.append(String.format(FOOTER, new Object[0]));
        return buff.toString();
    }

    private static void generateCompletionCandidates(StringBuilder buff, CommandLine.Model.OptionSpec f) {
        buff.append(String.format("  %s_OPTION_ARGS=\"%s\" # %s values\n", AutoComplete.bashify(f.paramLabel()), AutoComplete.concat(" ", AutoComplete.extract(f.completionCandidates())).trim(), f.longestName()));
    }

    private static List<String> extract(Iterable<String> generator) {
        ArrayList<String> result = new ArrayList<String>();
        for (String e : generator) {
            result.add(e);
        }
        return result;
    }

    private static String generateOptionsSwitch(List<CommandLine.Model.OptionSpec> argOptions) {
        String optionsCases = AutoComplete.generateOptionsCases(argOptions, "", "${CURR_WORD}");
        if (optionsCases.length() == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder(1024);
        buff.append("\n");
        buff.append("  compopt +o default\n");
        buff.append("\n");
        buff.append("  case ${PREV_WORD} in\n");
        buff.append(optionsCases);
        buff.append("  esac\n");
        return buff.toString();
    }

    private static String generateOptionsCases(List<CommandLine.Model.OptionSpec> argOptionFields, String indent, String currWord) {
        StringBuilder buff = new StringBuilder(1024);
        for (CommandLine.Model.OptionSpec option : argOptionFields) {
            if (option.completionCandidates() != null) {
                buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
                buff.append(String.format("%s      COMPREPLY=( $( compgen -W \"${%s_OPTION_ARGS}\" -- %s ) )\n", indent, AutoComplete.bashify(option.paramLabel()), currWord));
                buff.append(String.format("%s      return $?\n", indent));
                buff.append(String.format("%s      ;;\n", indent));
                continue;
            }
            if (option.type().equals(File.class) || "java.nio.file.Path".equals(option.type().getName())) {
                buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
                buff.append(String.format("%s      compopt -o filenames\n", indent));
                buff.append(String.format("%s      COMPREPLY=( $( compgen -f -- %s ) ) # files\n", indent, currWord));
                buff.append(String.format("%s      return $?\n", indent));
                buff.append(String.format("%s      ;;\n", indent));
                continue;
            }
            if (option.type().equals(InetAddress.class)) {
                buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
                buff.append(String.format("%s      compopt -o filenames\n", indent));
                buff.append(String.format("%s      COMPREPLY=( $( compgen -A hostname -- %s ) )\n", indent, currWord));
                buff.append(String.format("%s      return $?\n", indent));
                buff.append(String.format("%s      ;;\n", indent));
                continue;
            }
            buff.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", option.names())));
            buff.append(String.format("%s      return\n", indent));
            buff.append(String.format("%s      ;;\n", indent));
        }
        return buff.toString();
    }

    private static String optionNames(List<CommandLine.Model.OptionSpec> options) {
        ArrayList<String> result = new ArrayList<String>();
        for (CommandLine.Model.OptionSpec option : options) {
            result.addAll(Arrays.asList(option.names()));
        }
        return AutoComplete.concat(" ", result, "", new NullFunction()).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int complete(CommandLine.Model.CommandSpec spec, String[] args, int argIndex, int positionInArg, int cursor, List<CharSequence> candidates) {
        if (spec == null) {
            throw new NullPointerException("spec is null");
        }
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        if (candidates == null) {
            throw new NullPointerException("candidates list is null");
        }
        if (argIndex == args.length) {
            String[] copy = new String[args.length + 1];
            System.arraycopy(args, 0, copy, 0, args.length);
            args = copy;
            args[argIndex] = "";
        }
        if (argIndex < 0 || argIndex >= args.length) {
            throw new IllegalArgumentException("Invalid argIndex " + argIndex + ": args array only has " + args.length + " elements.");
        }
        if (positionInArg < 0 || positionInArg > args[argIndex].length()) {
            throw new IllegalArgumentException("Invalid positionInArg " + positionInArg + ": args[" + argIndex + "] (" + args[argIndex] + ") only has " + args[argIndex].length() + " characters.");
        }
        String currentArg = args[argIndex];
        boolean reset = spec.parser().collectErrors();
        try {
            String committedPrefix = currentArg.substring(0, positionInArg);
            spec.parser().collectErrors(true);
            CommandLine parser = new CommandLine(spec);
            CommandLine.ParseResult parseResult = parser.parseArgs(args);
            if (argIndex >= parseResult.tentativeMatch.size()) {
                Object startPoint = AutoComplete.findCompletionStartPoint(parseResult);
                AutoComplete.addCandidatesForArgsFollowing(startPoint, candidates);
            } else {
                Object obj = parseResult.tentativeMatch.get(argIndex);
                if (obj instanceof CommandLine.Model.CommandSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(((CommandLine.Model.CommandSpec)obj).parent(), candidates);
                } else if (obj instanceof CommandLine.Model.OptionSpec) {
                    int sep = currentArg.indexOf(spec.parser().separator());
                    if (sep < 0 || positionInArg < sep) {
                        AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)obj, spec), candidates);
                    } else {
                        AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)obj, candidates);
                        int sepLength = spec.parser().separator().length();
                        if (positionInArg < sep + sepLength) {
                            int posInSeparator = positionInArg - sep;
                            String prefix = spec.parser().separator().substring(posInSeparator);
                            for (int i = 0; i < candidates.size(); ++i) {
                                candidates.set(i, prefix + candidates.get(i));
                            }
                            committedPrefix = currentArg.substring(sep, positionInArg);
                        } else {
                            committedPrefix = currentArg.substring(sep + sepLength, positionInArg);
                        }
                    }
                } else if (obj instanceof CommandLine.Model.PositionalParamSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)obj, spec), candidates);
                } else {
                    int i;
                    for (i = argIndex - 1; i > 0 && !AutoComplete.isPicocliModelObject(parseResult.tentativeMatch.get(i)); --i) {
                    }
                    if (i < 0) {
                        int n = -1;
                        return n;
                    }
                    AutoComplete.addCandidatesForArgsFollowing(parseResult.tentativeMatch.get(i), candidates);
                }
            }
            AutoComplete.filterAndTrimMatchingPrefix(committedPrefix, candidates);
            int n = candidates.isEmpty() ? -1 : cursor;
            return n;
        }
        finally {
            spec.parser().collectErrors(reset);
        }
    }

    private static Object findCompletionStartPoint(CommandLine.ParseResult parseResult) {
        List<Object> tentativeMatches = parseResult.tentativeMatch;
        for (int i = 1; i <= tentativeMatches.size(); ++i) {
            Object found = tentativeMatches.get(tentativeMatches.size() - i);
            if (found instanceof CommandLine.Model.CommandSpec) {
                return found;
            }
            if (!(found instanceof CommandLine.Model.ArgSpec)) continue;
            CommandLine.Range arity = ((CommandLine.Model.ArgSpec)found).arity();
            if (i < arity.min) {
                return found;
            }
            return AutoComplete.findCommandFor((CommandLine.Model.ArgSpec)found, parseResult.commandSpec());
        }
        return parseResult.commandSpec();
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.ArgSpec arg, CommandLine.Model.CommandSpec cmd) {
        return arg instanceof CommandLine.Model.OptionSpec ? AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)arg, cmd) : AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)arg, cmd);
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.OptionSpec option, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.OptionSpec defined : commandSpec.options()) {
            if (defined != option) continue;
            return commandSpec;
        }
        for (CommandLine sub : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec result = AutoComplete.findCommandFor(option, sub.getCommandSpec());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.PositionalParamSpec positional, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.PositionalParamSpec defined : commandSpec.positionalParameters()) {
            if (defined != positional) continue;
            return commandSpec;
        }
        for (CommandLine sub : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec result = AutoComplete.findCommandFor(positional, sub.getCommandSpec());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isPicocliModelObject(Object obj) {
        return obj instanceof CommandLine.Model.CommandSpec || obj instanceof CommandLine.Model.OptionSpec || obj instanceof CommandLine.Model.PositionalParamSpec;
    }

    private static void filterAndTrimMatchingPrefix(String prefix, List<CharSequence> candidates) {
        ArrayList<CharSequence> replace = new ArrayList<CharSequence>();
        for (CharSequence seq : candidates) {
            if (!seq.toString().startsWith(prefix)) continue;
            replace.add(seq.subSequence(prefix.length(), seq.length()));
        }
        candidates.clear();
        candidates.addAll(replace);
    }

    private static void addCandidatesForArgsFollowing(Object obj, List<CharSequence> candidates) {
        if (obj == null) {
            return;
        }
        if (obj instanceof CommandLine.Model.CommandSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.CommandSpec)obj, candidates);
        } else if (obj instanceof CommandLine.Model.OptionSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)obj, candidates);
        } else if (obj instanceof CommandLine.Model.PositionalParamSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.PositionalParamSpec)obj, candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.CommandSpec commandSpec, List<CharSequence> candidates) {
        if (commandSpec == null) {
            return;
        }
        for (Map.Entry<String, CommandLine> entry : commandSpec.subcommands().entrySet()) {
            candidates.add(entry.getKey());
            candidates.addAll(Arrays.asList(entry.getValue().getCommandSpec().aliases()));
        }
        candidates.addAll(commandSpec.optionsMap().keySet());
        for (CommandLine.Model.PositionalParamSpec positional : commandSpec.positionalParameters()) {
            AutoComplete.addCandidatesForArgsFollowing(positional, candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.OptionSpec optionSpec, List<CharSequence> candidates) {
        if (optionSpec != null) {
            AutoComplete.addCompletionCandidates(optionSpec.completionCandidates(), candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.PositionalParamSpec positionalSpec, List<CharSequence> candidates) {
        if (positionalSpec != null) {
            AutoComplete.addCompletionCandidates(positionalSpec.completionCandidates(), candidates);
        }
    }

    private static void addCompletionCandidates(Iterable<String> completionCandidates, List<CharSequence> candidates) {
        if (completionCandidates != null) {
            for (String candidate : completionCandidates) {
                candidates.add(candidate);
            }
        }
    }

    static class CommandDescriptor {
        final String functionName;
        final String commandName;

        CommandDescriptor(String functionName, String commandName) {
            this.functionName = functionName;
            this.commandName = commandName;
        }

        public int hashCode() {
            return this.functionName.hashCode() * 37 + this.commandName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CommandDescriptor)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            CommandDescriptor other = (CommandDescriptor)obj;
            return other.functionName.equals(this.functionName) && other.commandName.equals(this.commandName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanArgFilter
    implements Predicate<CommandLine.Model.ArgSpec> {
        private BooleanArgFilter() {
        }

        @Override
        public boolean test(CommandLine.Model.ArgSpec f) {
            return f.type() == Boolean.TYPE || f.type() == Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Predicate<T> {
        public boolean test(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullFunction
    implements Function<CharSequence, String> {
        private NullFunction() {
        }

        @Override
        public String apply(CharSequence value) {
            return value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bashify
    implements Function<CharSequence, String> {
        private Bashify() {
        }

        @Override
        public String apply(CharSequence value) {
            return AutoComplete.bashify(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Function<T, V> {
        public V apply(T var1);
    }

    @CommandLine.Command(name="com.hazelcast.jet.picocli.AutoComplete", sortOptions=false, description={"Generates a bash completion script for the specified command class."})
    private static class App
    implements Runnable {
        @CommandLine.Parameters(arity="1", description={"Fully qualified class name of the annotated @Command class to generate a completion script for."})
        String commandLineFQCN;
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Option(names={"-n", "--name"}, description={"Optionally specify the name of the command to create a completion script for. When omitted, the annotated class @Command 'name' attribute is used. If no @Command 'name' attribute exists, '<CLASS-SIMPLE-NAME>' (in lower-case) is used."})
        String commandName;
        @CommandLine.Option(names={"-o", "--completionScript"}, description={"Optionally specify the path of the completion script file to generate. When omitted, a file named '<commandName>_completion' is generated in the current directory."})
        File autoCompleteScript;
        @CommandLine.Option(names={"-w", "--writeCommandScript"}, description={"Write a '<commandName>' sample command script to the same directory as the completion script."})
        boolean writeCommandScript;
        @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite existing script files."})
        boolean overwriteIfExists;
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display this help message and quit."})
        boolean usageHelpRequested;

        private App() {
        }

        public void run() {
            try {
                CommandLine.IFactory factory = CommandLine.defaultFactory();
                if (this.factoryClass != null) {
                    factory = (CommandLine.IFactory)factory.create(Class.forName(this.factoryClass));
                }
                Class<?> cls = Class.forName(this.commandLineFQCN);
                Object instance = factory.create(cls);
                CommandLine commandLine = new CommandLine(instance);
                if (this.commandName == null) {
                    this.commandName = commandLine.getCommandName();
                    if ("<main class>".equals(this.commandName)) {
                        this.commandName = cls.getSimpleName().toLowerCase();
                    }
                }
                if (this.autoCompleteScript == null) {
                    this.autoCompleteScript = new File(this.commandName + "_completion");
                }
                File commandScript = null;
                if (this.writeCommandScript) {
                    commandScript = new File(this.autoCompleteScript.getAbsoluteFile().getParentFile(), this.commandName);
                }
                if (commandScript != null && !this.overwriteIfExists && this.checkExists(commandScript)) {
                    this.exit(2);
                    return;
                }
                if (!this.overwriteIfExists && this.checkExists(this.autoCompleteScript)) {
                    this.exit(3);
                    return;
                }
                AutoComplete.bash(this.commandName, this.autoCompleteScript, commandScript, commandLine);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                CommandLine.usage(new App(), System.err);
                this.exit(4);
            }
        }

        private boolean checkExists(File file) {
            if (file.exists()) {
                System.err.printf("ERROR: picocli.AutoComplete: %s exists. Specify --force to overwrite.%n", file.getAbsolutePath());
                CommandLine.usage(this, System.err);
                return true;
            }
            return false;
        }

        private void exit(int exitCode) {
            System.exit(exitCode);
        }
    }
}

