/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.monitor.impl.GlobalIndexesStats;
import com.hazelcast.internal.monitor.impl.HDGlobalIndexesStats;
import com.hazelcast.internal.monitor.impl.IndexesStats;
import com.hazelcast.internal.monitor.impl.PartitionIndexesStats;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AttributeIndexRegistry;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.ConverterCache;
import com.hazelcast.query.impl.DefaultIndexProvider;
import com.hazelcast.query.impl.GlobalQueryContextProvider;
import com.hazelcast.query.impl.GlobalQueryContextProviderWithStats;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexProvider;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.PartitionQueryContextProvider;
import com.hazelcast.query.impl.PartitionQueryContextProviderWithStats;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryContextProvider;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.IndexAwarePredicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class Indexes {
    public static final int SKIP_PARTITIONS_COUNT_CHECK = -1;
    private static final InternalIndex[] EMPTY_INDEXES = new InternalIndex[0];
    private static final ThreadLocal<CachedQueryEntry[]> CACHED_ENTRIES = ThreadLocal.withInitial(() -> new CachedQueryEntry[]{new CachedQueryEntry(), new CachedQueryEntry()});
    private final boolean global;
    private final boolean usesCachedQueryableEntries;
    private final IndexesStats stats;
    private final Extractors extractors;
    private final IndexProvider indexProvider;
    private final IndexCopyBehavior indexCopyBehavior;
    private final Supplier<java.util.function.Predicate<QueryableEntry>> resultFilterFactory;
    private final QueryContextProvider queryContextProvider;
    private final InternalSerializationService serializationService;
    private final Map<String, InternalIndex> indexesByName = new ConcurrentHashMap<String, InternalIndex>(3);
    private final AttributeIndexRegistry attributeIndexRegistry = new AttributeIndexRegistry();
    private final AttributeIndexRegistry evaluateOnlyAttributeIndexRegistry = new AttributeIndexRegistry();
    private final ConverterCache converterCache = new ConverterCache(this);
    private final Map<String, IndexConfig> definitions = new ConcurrentHashMap<String, IndexConfig>();
    private final int partitionCount;
    private volatile InternalIndex[] indexes = EMPTY_INDEXES;
    private volatile InternalIndex[] compositeIndexes = EMPTY_INDEXES;

    private Indexes(InternalSerializationService serializationService, IndexCopyBehavior indexCopyBehavior, Extractors extractors, IndexProvider indexProvider, boolean usesCachedQueryableEntries, boolean statisticsEnabled, boolean global, InMemoryFormat inMemoryFormat, int partitionCount, Supplier<java.util.function.Predicate<QueryableEntry>> resultFilterFactory) {
        this.global = global;
        this.indexCopyBehavior = indexCopyBehavior;
        this.serializationService = serializationService;
        this.usesCachedQueryableEntries = usesCachedQueryableEntries;
        this.stats = Indexes.createStats(global, inMemoryFormat, statisticsEnabled);
        this.extractors = extractors == null ? Extractors.newBuilder(serializationService).build() : extractors;
        this.indexProvider = indexProvider == null ? new DefaultIndexProvider() : indexProvider;
        this.queryContextProvider = Indexes.createQueryContextProvider(this, global, statisticsEnabled);
        this.partitionCount = partitionCount;
        this.resultFilterFactory = resultFilterFactory;
    }

    public static void beginPartitionUpdate(InternalIndex[] indexes) {
        for (InternalIndex index : indexes) {
            index.beginPartitionUpdate();
        }
    }

    public static void markPartitionAsIndexed(int partitionId, InternalIndex[] indexes) {
        for (InternalIndex index : indexes) {
            index.markPartitionAsIndexed(partitionId);
        }
    }

    public static void markPartitionAsUnindexed(int partitionId, InternalIndex[] indexes) {
        for (InternalIndex index : indexes) {
            index.markPartitionAsUnindexed(partitionId);
        }
    }

    public static Builder newBuilder(SerializationService ss, IndexCopyBehavior indexCopyBehavior, InMemoryFormat inMemoryFormat) {
        return new Builder(ss, indexCopyBehavior, inMemoryFormat);
    }

    public synchronized InternalIndex addOrGetIndex(IndexConfig indexConfig) {
        String name = indexConfig.getName();
        assert (name != null);
        assert (!name.isEmpty());
        InternalIndex index = this.indexesByName.get(name);
        if (index != null) {
            return index;
        }
        index = this.indexProvider.createIndex(indexConfig, this.extractors, this.serializationService, this.indexCopyBehavior, this.stats.createPerIndexStats(indexConfig.getType() == IndexType.SORTED, this.usesCachedQueryableEntries), this.partitionCount);
        this.indexesByName.put(name, index);
        if (index.isEvaluateOnly()) {
            this.evaluateOnlyAttributeIndexRegistry.register(index);
        } else {
            this.attributeIndexRegistry.register(index);
        }
        this.converterCache.invalidate(index);
        this.indexes = this.indexesByName.values().toArray(EMPTY_INDEXES);
        if (index.getComponents().length > 1) {
            InternalIndex[] oldCompositeIndexes = this.compositeIndexes;
            InternalIndex[] newCompositeIndexes = Arrays.copyOf(oldCompositeIndexes, oldCompositeIndexes.length + 1);
            newCompositeIndexes[oldCompositeIndexes.length] = index;
            this.compositeIndexes = newCompositeIndexes;
        }
        return index;
    }

    public void recordIndexDefinition(IndexConfig config) {
        String name = config.getName();
        assert (name != null && !name.isEmpty());
        if (this.definitions.containsKey(name) || this.indexesByName.containsKey(name)) {
            return;
        }
        this.definitions.put(name, config);
    }

    public void createIndexesFromRecordedDefinitions() {
        this.definitions.forEach((name, indexConfig) -> {
            this.addOrGetIndex((IndexConfig)indexConfig);
            this.definitions.compute((String)name, (k, v) -> indexConfig == v ? null : v);
        });
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public InternalIndex[] getIndexes() {
        return this.indexes;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public InternalIndex[] getCompositeIndexes() {
        return this.compositeIndexes;
    }

    public Collection<IndexConfig> getIndexDefinitions() {
        return this.definitions.values();
    }

    public void destroyIndexes() {
        InternalIndex[] indexesSnapshot = this.getIndexes();
        this.indexes = EMPTY_INDEXES;
        this.compositeIndexes = EMPTY_INDEXES;
        this.indexesByName.clear();
        this.attributeIndexRegistry.clear();
        this.evaluateOnlyAttributeIndexRegistry.clear();
        this.converterCache.clear();
        for (InternalIndex index : indexesSnapshot) {
            index.destroy();
        }
    }

    public void clearAll() {
        InternalIndex[] indexesSnapshot;
        for (InternalIndex index : indexesSnapshot = this.getIndexes()) {
            index.clear();
        }
    }

    public boolean haveAtLeastOneIndex() {
        return this.indexes != EMPTY_INDEXES;
    }

    public boolean haveAtLeastOneIndexOrDefinition() {
        boolean haveAtLeastOneIndexOrDefinition;
        boolean bl = haveAtLeastOneIndexOrDefinition = this.haveAtLeastOneIndex() || !this.definitions.isEmpty();
        assert (this.isGlobal() || !haveAtLeastOneIndexOrDefinition || !this.haveAtLeastOneIndex() || this.definitions.isEmpty());
        return haveAtLeastOneIndexOrDefinition;
    }

    public void putEntry(QueryableEntry entryToStore, Object oldValue, Index.OperationSource operationSource) {
        CachedQueryEntry oldEntry;
        CachedQueryEntry newEntry;
        if (entryToStore instanceof CachedQueryEntry && oldValue == null) {
            this.putEntry((CachedQueryEntry)entryToStore, null, entryToStore, operationSource);
            return;
        }
        CachedQueryEntry[] cachedEntries = CACHED_ENTRIES.get();
        if (entryToStore instanceof CachedQueryEntry) {
            newEntry = (CachedQueryEntry)entryToStore;
        } else {
            newEntry = cachedEntries[0];
            newEntry.init(this.serializationService, entryToStore.getKeyData(), entryToStore.getTargetObject(false), this.extractors);
        }
        if (oldValue == null) {
            oldEntry = null;
        } else {
            oldEntry = cachedEntries[1];
            oldEntry.init(this.serializationService, entryToStore.getKeyData(), oldValue, this.extractors);
        }
        this.putEntry(newEntry, oldEntry, entryToStore, operationSource);
    }

    public void putEntry(CachedQueryEntry newEntry, CachedQueryEntry oldEntry, QueryableEntry entryToStore, Index.OperationSource operationSource) {
        InternalIndex[] indexes = this.getIndexes();
        Throwable exception = null;
        for (InternalIndex index : indexes) {
            try {
                index.putEntry(newEntry, oldEntry, entryToStore, operationSource);
            }
            catch (Throwable t) {
                if (exception != null) continue;
                exception = t;
            }
        }
        if (exception != null) {
            ExceptionUtil.rethrow(exception);
        }
    }

    public void removeEntry(Data key, Object value, Index.OperationSource operationSource) {
        CachedQueryEntry entry = CACHED_ENTRIES.get()[0];
        entry.init(this.serializationService, key, value, this.extractors);
        this.removeEntry(entry, operationSource);
    }

    public void removeEntry(CachedQueryEntry entry, Index.OperationSource operationSource) {
        InternalIndex[] indexes;
        for (InternalIndex index : indexes = this.getIndexes()) {
            index.removeEntry(entry, operationSource);
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public InternalIndex getIndex(String name) {
        return this.indexesByName.get(name);
    }

    public Iterable<QueryableEntry> query(Predicate predicate, int ownedPartitionCount) {
        this.stats.incrementQueryCount();
        if (!this.haveAtLeastOneIndex() || !(predicate instanceof IndexAwarePredicate)) {
            return null;
        }
        IndexAwarePredicate indexAwarePredicate = (IndexAwarePredicate)predicate;
        QueryContext queryContext = this.queryContextProvider.obtainContextFor(this, ownedPartitionCount);
        if (!indexAwarePredicate.isIndexed(queryContext)) {
            return null;
        }
        Set<QueryableEntry> result = indexAwarePredicate.filter(queryContext);
        if (result != null) {
            this.stats.incrementIndexedQueryCount();
            queryContext.applyPerQueryStats();
        }
        if (result != null && this.resultFilterFactory != null) {
            return IterableUtil.filter(result, this.resultFilterFactory.get());
        }
        return result;
    }

    public InternalIndex matchIndex(String pattern, QueryContext.IndexMatchHint matchHint, int ownedPartitionCount) {
        InternalIndex index = matchHint == QueryContext.IndexMatchHint.EXACT_NAME ? this.indexesByName.get(pattern) : this.attributeIndexRegistry.match(pattern, matchHint);
        if (index == null || !index.allPartitionsIndexed(ownedPartitionCount)) {
            return null;
        }
        return index;
    }

    public InternalIndex matchIndex(String pattern, Class<? extends Predicate> predicateClass, QueryContext.IndexMatchHint matchHint, int ownedPartitionCount) {
        InternalIndex index;
        if (matchHint == QueryContext.IndexMatchHint.EXACT_NAME) {
            index = this.indexesByName.get(pattern);
        } else {
            index = this.evaluateOnlyAttributeIndexRegistry.match(pattern, matchHint);
            if (index == null) {
                index = this.attributeIndexRegistry.match(pattern, matchHint);
            }
        }
        if (index == null) {
            return null;
        }
        if (!index.canEvaluate(predicateClass)) {
            return null;
        }
        if (!index.allPartitionsIndexed(ownedPartitionCount)) {
            return null;
        }
        return index;
    }

    public TypeConverter getConverter(String attribute) {
        return this.converterCache.get(attribute);
    }

    public IndexesStats getIndexesStats() {
        return this.stats;
    }

    private static QueryContextProvider createQueryContextProvider(Indexes indexes, boolean global, boolean statisticsEnabled) {
        if (statisticsEnabled) {
            return global ? new GlobalQueryContextProviderWithStats() : new PartitionQueryContextProviderWithStats(indexes);
        }
        return global ? new GlobalQueryContextProvider() : new PartitionQueryContextProvider(indexes);
    }

    private static IndexesStats createStats(boolean global, InMemoryFormat inMemoryFormat, boolean statisticsEnabled) {
        if (statisticsEnabled) {
            if (global) {
                return inMemoryFormat.equals((Object)InMemoryFormat.NATIVE) ? new HDGlobalIndexesStats() : new GlobalIndexesStats();
            }
            return new PartitionIndexesStats();
        }
        return IndexesStats.EMPTY;
    }

    public static final class Builder {
        private final IndexCopyBehavior indexCopyBehavior;
        private final InternalSerializationService serializationService;
        private boolean global = true;
        private boolean statsEnabled;
        private boolean usesCachedQueryableEntries;
        private int partitionCount;
        private Extractors extractors;
        private IndexProvider indexProvider;
        private InMemoryFormat inMemoryFormat;
        private Supplier<java.util.function.Predicate<QueryableEntry>> resultFilterFactory;

        Builder(SerializationService ss, IndexCopyBehavior indexCopyBehavior, InMemoryFormat inMemoryFormat) {
            this.serializationService = Preconditions.checkNotNull((InternalSerializationService)ss, "serializationService cannot be null");
            this.indexCopyBehavior = Preconditions.checkNotNull(indexCopyBehavior, "indexCopyBehavior cannot be null");
            this.inMemoryFormat = inMemoryFormat;
        }

        public Builder resultFilterFactory(Supplier<java.util.function.Predicate<QueryableEntry>> filterFactory) {
            this.resultFilterFactory = filterFactory;
            return this;
        }

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder indexProvider(IndexProvider indexProvider) {
            this.indexProvider = indexProvider;
            return this;
        }

        public Builder extractors(Extractors extractors) {
            this.extractors = extractors;
            return this;
        }

        public Builder usesCachedQueryableEntries(boolean usesCachedQueryableEntries) {
            this.usesCachedQueryableEntries = usesCachedQueryableEntries;
            return this;
        }

        public Builder statsEnabled(boolean statsEnabled) {
            this.statsEnabled = statsEnabled;
            return this;
        }

        public Builder partitionCount(int partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public Indexes build() {
            return new Indexes(this.serializationService, this.indexCopyBehavior, this.extractors, this.indexProvider, this.usesCachedQueryableEntries, this.statsEnabled, this.global, this.inMemoryFormat, this.partitionCount, this.resultFilterFactory);
        }
    }
}

