/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.cluster.Address;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class MetaSupplierFromProcessorSupplier
implements ProcessorMetaSupplier,
DataSerializable {
    private int preferredLocalParallelism;
    private ProcessorSupplier processorSupplier;

    public MetaSupplierFromProcessorSupplier() {
    }

    public MetaSupplierFromProcessorSupplier(int preferredLocalParallelism, ProcessorSupplier processorSupplier) {
        this.preferredLocalParallelism = preferredLocalParallelism;
        this.processorSupplier = processorSupplier;
    }

    @Override
    public int preferredLocalParallelism() {
        return this.preferredLocalParallelism;
    }

    @Override
    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        return address -> this.processorSupplier;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.preferredLocalParallelism);
        out.writeObject(this.processorSupplier);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.preferredLocalParallelism = in.readInt();
        this.processorSupplier = (ProcessorSupplier)in.readObject();
    }
}

