/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;

public class MapEntryReplacingEntryProcessor<K, V>
implements EntryProcessor<K, V, V>,
IdentifiedDataSerializable {
    BiFunction<? super K, ? super V, ? extends V> function;

    public MapEntryReplacingEntryProcessor() {
    }

    public MapEntryReplacingEntryProcessor(BiFunction<? super K, ? super V, ? extends V> function) {
        this.function = function;
    }

    @Override
    public V process(Map.Entry<K, V> entry) {
        V newValue = this.function.apply(entry.getKey(), entry.getValue());
        entry.setValue(newValue);
        return null;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 153;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.function);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.function = (BiFunction)in.readObject();
    }
}

