/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.processor.ExpectNothingP;
import com.hazelcast.jet.impl.processor.MetaSupplierFromProcessorSupplier;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface ProcessorMetaSupplier
extends Serializable {
    @Nonnull
    default public Map<String, String> getTags() {
        return Collections.emptyMap();
    }

    default public int preferredLocalParallelism() {
        return -1;
    }

    default public void init(@Nonnull Context context) throws Exception {
    }

    @Nonnull
    public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> var1);

    default public void close(@Nullable Throwable error) throws Exception {
    }

    @Nonnull
    public static ProcessorMetaSupplier of(int preferredLocalParallelism, @Nonnull ProcessorSupplier procSupplier) {
        return new MetaSupplierFromProcessorSupplier(preferredLocalParallelism, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull ProcessorSupplier procSupplier) {
        return ProcessorMetaSupplier.of(-1, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(int preferredLocalParallelism, @Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(preferredLocalParallelism, ProcessorSupplier.of(procSupplier));
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(-1, procSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier of(final int preferredLocalParallelism, final @Nonnull FunctionEx<? super Address, ? extends ProcessorSupplier> addressToSupplier) {
        Vertex.checkLocalParallelism(preferredLocalParallelism);
        return new ProcessorMetaSupplier(){

            @Override
            public int preferredLocalParallelism() {
                return preferredLocalParallelism;
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addressToSupplier;
            }
        };
    }

    @Nonnull
    public static ProcessorMetaSupplier of(@Nonnull FunctionEx<? super Address, ? extends ProcessorSupplier> addressToSupplier) {
        return ProcessorMetaSupplier.of(-1, addressToSupplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nonnull ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.of(1, supplier);
    }

    @Nonnull
    public static ProcessorMetaSupplier preferLocalParallelismOne(@Nonnull SupplierEx<? extends Processor> procSupplier) {
        return ProcessorMetaSupplier.of(1, ProcessorSupplier.of(procSupplier));
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier) {
        return ProcessorMetaSupplier.forceTotalParallelismOne(supplier, UuidUtil.newUnsecureUuidString());
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(final @Nonnull ProcessorSupplier supplier, final @Nonnull String partitionKey) {
        return new ProcessorMetaSupplier(){
            private transient Address ownerAddress;

            @Override
            public void init(@Nonnull Context context) {
                if (context.localParallelism() != 1) {
                    throw new IllegalArgumentException("Local parallelism of " + context.localParallelism() + " was requested for a vertex that supports only total parallelism of 1. Local parallelism must be 1.");
                }
                String key = StringPartitioningStrategy.getPartitionKey(partitionKey);
                this.ownerAddress = context.jetInstance().getHazelcastInstance().getPartitionService().getPartition(key).getOwner().getAddress();
            }

            @Nonnull
            public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                return addr -> addr.equals(this.ownerAddress) ? supplier : count -> Collections.singletonList(new ExpectNothingP());
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }
        };
    }

    @Nonnull
    public static ProcessorMetaSupplier forceTotalParallelismOne(@Nonnull ProcessorSupplier supplier, @Nonnull Address memberAddress) {
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="the class is never java-serialized")
        class SpecificMemberPms
        implements ProcessorMetaSupplier,
        DataSerializable {
            private ProcessorSupplier supplier;
            private Address memberAddress;

            private SpecificMemberPms() {
            }

            SpecificMemberPms(ProcessorSupplier supplier, Address memberAddress) {
                this.supplier = supplier;
                this.memberAddress = memberAddress;
            }

            @Override
            public void init(@Nonnull Context context) throws Exception {
                if (context.localParallelism() != 1) {
                    throw new IllegalArgumentException("Local parallelism of " + context.localParallelism() + " was requested for a vertex that supports only total parallelism of 1. Local parallelism must be 1.");
                }
            }

            @Override
            @Nonnull
            public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
                if (!addresses.contains(this.memberAddress)) {
                    throw new JetException("Cluster does not contain the required member: " + this.memberAddress);
                }
                return addr -> addr.equals(this.memberAddress) ? this.supplier : count -> Collections.singletonList(new ExpectNothingP());
            }

            @Override
            public int preferredLocalParallelism() {
                return 1;
            }

            @Override
            public void writeData(ObjectDataOutput out) throws IOException {
                out.writeObject(this.supplier);
                out.writeObject(this.memberAddress);
            }

            @Override
            public void readData(ObjectDataInput in) throws IOException {
                this.supplier = (ProcessorSupplier)in.readObject();
                this.memberAddress = (Address)in.readObject();
            }
        }
        return new SpecificMemberPms(supplier, memberAddress);
    }

    public static interface Context {
        @Nonnull
        public JetInstance jetInstance();

        public long jobId();

        public long executionId();

        @Nonnull
        public JobConfig jobConfig();

        public int totalParallelism();

        public int localParallelism();

        public int memberCount();

        @Nonnull
        public String vertexName();

        @Nonnull
        public ILogger logger();

        default public boolean snapshottingEnabled() {
            return this.processingGuarantee() != ProcessingGuarantee.NONE;
        }

        public ProcessingGuarantee processingGuarantee();
    }
}

