/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.scheduledexecutor.impl.CapacityPermit;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class MemberCapacityPermit
implements CapacityPermit {
    private final String name;
    private final int capacity;
    private AtomicInteger permits;

    MemberCapacityPermit(String name, int permits) {
        this.name = name;
        this.capacity = permits;
        this.permits = new AtomicInteger(permits);
    }

    @Override
    public void acquire() throws RejectedExecutionException {
        if (this.permits.getAndDecrement() <= 0) {
            this.permits.incrementAndGet();
            throw new RejectedExecutionException("Maximum capacity (" + this.capacity + ") of tasks reached for this member and scheduled executor (" + this.name + "). Reminder, that tasks must be disposed if not needed.");
        }
    }

    @Override
    public void acquireQuietly() {
        this.permits.getAndDecrement();
    }

    @Override
    public void release() {
        this.permits.incrementAndGet();
    }

    @Override
    public int totalAcquired() {
        return this.capacity - this.permits.get();
    }
}

