/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline.transform;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.jet.core.processor.DiagnosticProcessors;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.Planner;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import javax.annotation.Nonnull;

public class PeekTransform<T>
extends AbstractTransform {
    @Nonnull
    public final PredicateEx<? super T> shouldLogFn;
    @Nonnull
    public final FunctionEx<? super T, ? extends CharSequence> toStringFn;

    public PeekTransform(@Nonnull Transform upstream, @Nonnull PredicateEx<? super T> shouldLogFn, @Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn) {
        super("peek", upstream);
        this.shouldLogFn = shouldLogFn;
        this.toStringFn = toStringFn;
    }

    @Override
    public void addToDag(Planner p, PipelineImpl.Context context) {
        this.determineLocalParallelism(-1, context, p.isPreserveOrder());
        Planner.PlannerVertex peekedPv = p.xform2vertex.get(this.upstream().get(0));
        p.xform2vertex.put(this, peekedPv);
        peekedPv.v.updateMetaSupplier(sup -> DiagnosticProcessors.peekOutputP(this.toStringFn, this.shouldLogFn, sup));
    }
}

