/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.processor.SinkProcessors;
import com.hazelcast.jet.impl.connector.DataSourceFromConnectionSupplier;
import com.hazelcast.jet.pipeline.Sink;
import com.hazelcast.jet.pipeline.Sinks;
import java.sql.PreparedStatement;
import javax.annotation.Nonnull;
import javax.sql.CommonDataSource;

public class JdbcSinkBuilder<T> {
    public static final boolean DEFAULT_EXACTLY_ONCE = true;
    public static final int DEFAULT_BATCH_LIMIT = 50;
    private String updateQuery;
    private BiConsumerEx<PreparedStatement, T> bindFn;
    private SupplierEx<? extends CommonDataSource> dataSourceSupplier;
    private boolean exactlyOnce = true;
    private int batchLimit = 50;

    JdbcSinkBuilder() {
    }

    @Nonnull
    public JdbcSinkBuilder<T> updateQuery(@Nonnull String updateQuery) {
        this.updateQuery = updateQuery;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> bindFn(@Nonnull BiConsumerEx<PreparedStatement, T> bindFn) {
        this.bindFn = bindFn;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> jdbcUrl(String connectionUrl) {
        this.dataSourceSupplier = () -> new DataSourceFromConnectionSupplier(connectionUrl);
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> dataSourceSupplier(SupplierEx<? extends CommonDataSource> dataSourceSupplier) {
        this.dataSourceSupplier = dataSourceSupplier;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> exactlyOnce(boolean enabled) {
        this.exactlyOnce = enabled;
        return this;
    }

    @Nonnull
    public JdbcSinkBuilder<T> batchLimit(int batchLimit) {
        Preconditions.checkPositive(batchLimit, "batch size limit must be positive");
        this.batchLimit = batchLimit;
        return this;
    }

    @Nonnull
    public Sink<T> build() {
        if (this.dataSourceSupplier == null) {
            throw new IllegalStateException("Neither jdbcUrl() nor dataSourceSupplier() set");
        }
        return Sinks.fromProcessor("jdbcSink", SinkProcessors.writeJdbcP(this.updateQuery, this.dataSourceSupplier, this.bindFn, this.exactlyOnce, this.batchLimit));
    }
}

