/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file;

import com.hazelcast.jet.pipeline.file.FileFormat;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TextFileFormat
implements FileFormat<String> {
    public static final String FORMAT_TXT = "txt";
    private final String charset;

    TextFileFormat() {
        this(StandardCharsets.UTF_8);
    }

    TextFileFormat(@Nonnull Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset must not be null").name();
    }

    @Nonnull
    public Charset charset() {
        return Charset.forName(this.charset);
    }

    @Override
    @Nonnull
    public String format() {
        return FORMAT_TXT;
    }
}

