/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesisAsync;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClientBuilder;
import com.hazelcast.function.SupplierEx;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class AwsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private String endpoint;
    @Nullable
    private String region;
    @Nullable
    private String accessKey;
    @Nullable
    private String secretKey;
    @Nullable
    private SupplierEx<ExecutorService> executorServiceSupplier;

    public AwsConfig withEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    public AwsConfig withRegion(@Nullable String region) {
        this.region = region;
        return this;
    }

    @Nullable
    public String getRegion() {
        return this.region;
    }

    public AwsConfig withCredentials(@Nullable String accessKey, @Nullable String secretKey) {
        if (accessKey == null ^ secretKey == null) {
            throw new IllegalArgumentException("AWS access and secret keys must be specified together");
        }
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        return this;
    }

    @Nullable
    public String getAccessKey() {
        return this.accessKey;
    }

    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    public AwsConfig withExecutorServiceSupplier(SupplierEx<ExecutorService> executorServiceSupplier) {
        this.executorServiceSupplier = executorServiceSupplier;
        return this;
    }

    @Nullable
    public SupplierEx<ExecutorService> getExecutorServiceSupplier() {
        return this.executorServiceSupplier;
    }

    public AmazonKinesisAsync buildClient() {
        AmazonKinesisAsyncClientBuilder builder = AmazonKinesisAsyncClientBuilder.standard();
        if (this.endpoint == null) {
            if (this.region != null) {
                builder.setRegion(this.region);
            }
        } else {
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.region));
        }
        builder.withCredentials((AWSCredentialsProvider)(this.accessKey == null ? new DefaultAWSCredentialsProviderChain() : new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey))));
        builder.withClientConfiguration(new ClientConfiguration());
        if (this.executorServiceSupplier != null) {
            builder.withExecutorFactory(() -> (ExecutorService)this.executorServiceSupplier.get());
        }
        return (AmazonKinesisAsync)builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AwsConfig.class.getName()).append("(");
        boolean first = true;
        if (this.endpoint != null) {
            sb.append("endpoint: ").append(this.endpoint);
            sb.append(", region: ").append(this.region);
            first = false;
        }
        if (this.accessKey != null) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("access key: ").append(this.accessKey);
            sb.append(", secret key: ").append(this.secretKey);
        }
        sb.append(")");
        return sb.toString();
    }
}

