/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl;

import com.hazelcast.jet.retry.RetryStrategy;

public class RetryTracker {
    private final RetryStrategy strategy;
    private int attempt;

    public RetryTracker(RetryStrategy strategy) {
        this.strategy = strategy;
    }

    public void reset() {
        this.attempt = 0;
    }

    public void attemptFailed() {
        ++this.attempt;
    }

    public boolean shouldTryAgain() {
        int maxAttempts = this.strategy.getMaxAttempts();
        return maxAttempts < 0 || maxAttempts > 0 && this.attempt <= maxAttempts;
    }

    public long getNextWaitTimeMillis() {
        return this.strategy.getIntervalFunction().waitAfterAttempt(this.attempt);
    }
}

