/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.kinesis.impl.source;

import com.amazonaws.services.kinesis.model.Shard;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ShardQueue {
    private final Queue<Object> queue = new LinkedBlockingQueue<Object>();

    ShardQueue() {
    }

    public void addAdded(@Nonnull Shard shard) {
        this.queue.offer(shard);
    }

    public void addExpired(@Nonnull String shardId) {
        this.queue.offer(shardId);
    }

    @Nullable
    public Shard pollAdded() {
        return this.get(Shard.class);
    }

    @Nullable
    public String pollExpired() {
        return this.get(String.class);
    }

    @Nullable
    private <T> T get(Class<T> clazz) {
        return clazz.isInstance(this.queue.peek()) ? (T)clazz.cast(this.queue.poll()) : null;
    }
}

