/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class ByteUtil {
    private static final String[] HEX_CHARS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private ByteUtil() {
    }

    public static void put3ByteInt(ByteBuffer buffer, int val) {
        ByteUtil.put3ByteInt(buffer, val, buffer.order());
    }

    public static void put3ByteInt(ByteBuffer buffer, int val, ByteOrder order) {
        int pos = buffer.position();
        ByteUtil.put3ByteInt(buffer, val, pos, order);
        buffer.position(pos + 3);
    }

    public static void put3ByteInt(ByteBuffer buffer, int val, int offset, ByteOrder order) {
        int offInc = 1;
        if (order == ByteOrder.BIG_ENDIAN) {
            offInc = -1;
            offset += 2;
        }
        buffer.put(offset, (byte)(val & 0xFF));
        buffer.put(offset + 1 * offInc, (byte)(val >>> 8 & 0xFF));
        buffer.put(offset + 2 * offInc, (byte)(val >>> 16 & 0xFF));
    }

    public static int get3ByteInt(ByteBuffer buffer) {
        return ByteUtil.get3ByteInt(buffer, buffer.order());
    }

    public static int get3ByteInt(ByteBuffer buffer, ByteOrder order) {
        int pos = buffer.position();
        int rtn = ByteUtil.get3ByteInt(buffer, pos, order);
        buffer.position(pos + 3);
        return rtn;
    }

    public static int get3ByteInt(ByteBuffer buffer, int offset) {
        return ByteUtil.get3ByteInt(buffer, offset, buffer.order());
    }

    public static int get3ByteInt(ByteBuffer buffer, int offset, ByteOrder order) {
        int offInc = 1;
        if (order == ByteOrder.BIG_ENDIAN) {
            offInc = -1;
            offset += 2;
        }
        int rtn = ByteUtil.getUnsignedByte(buffer, offset);
        rtn += ByteUtil.getUnsignedByte(buffer, offset + 1 * offInc) << 8;
        return rtn += ByteUtil.getUnsignedByte(buffer, offset + 2 * offInc) << 16;
    }

    public static int getUnsignedByte(ByteBuffer buffer) {
        int pos = buffer.position();
        int rtn = ByteUtil.getUnsignedByte(buffer, pos);
        buffer.position(pos + 1);
        return rtn;
    }

    public static int getUnsignedByte(ByteBuffer buffer, int offset) {
        return ByteUtil.asUnsignedByte(buffer.get(offset));
    }

    public static int getUnsignedShort(ByteBuffer buffer) {
        int pos = buffer.position();
        int rtn = ByteUtil.getUnsignedShort(buffer, pos);
        buffer.position(pos + 2);
        return rtn;
    }

    public static int getUnsignedShort(ByteBuffer buffer, int offset) {
        return ByteUtil.asUnsignedShort(buffer.getShort(offset));
    }

    public static int getInt(ByteBuffer buffer, ByteOrder order) {
        int offset = buffer.position();
        int rtn = ByteUtil.getInt(buffer, offset, order);
        buffer.position(offset + 4);
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInt(ByteBuffer buffer, int offset, ByteOrder order) {
        ByteOrder origOrder = buffer.order();
        try {
            int n = buffer.order(order).getInt(offset);
            return n;
        }
        finally {
            buffer.order(origOrder);
        }
    }

    public static void putInt(ByteBuffer buffer, int val, ByteOrder order) {
        int offset = buffer.position();
        ByteUtil.putInt(buffer, val, offset, order);
        buffer.position(offset + 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putInt(ByteBuffer buffer, int val, int offset, ByteOrder order) {
        ByteOrder origOrder = buffer.order();
        try {
            buffer.order(order).putInt(offset, val);
        }
        finally {
            buffer.order(origOrder);
        }
    }

    public static void clearRange(ByteBuffer buffer, int start, int end) {
        ByteUtil.putRange(buffer, start, end, (byte)0);
    }

    public static void fillRange(ByteBuffer buffer, int start, int end) {
        ByteUtil.putRange(buffer, start, end, (byte)-1);
    }

    public static void putRange(ByteBuffer buffer, int start, int end, byte b) {
        for (int i = start; i < end; ++i) {
            buffer.put(i, b);
        }
    }

    public static boolean matchesRange(ByteBuffer buffer, int start, byte[] pattern) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == buffer.get(start + i)) continue;
            return false;
        }
        return true;
    }

    public static String toHexString(ByteBuffer buffer, int size) {
        return ByteUtil.toHexString(buffer, 0, size);
    }

    public static String toHexString(byte[] array) {
        return ByteUtil.toHexString(ByteBuffer.wrap(array), 0, array.length);
    }

    public static String toHexString(ByteBuffer buffer, int offset, int size) {
        return ByteUtil.toHexString(buffer, offset, size, true);
    }

    public static String toHexString(ByteBuffer buffer, int offset, int size, boolean formatted) {
        StringBuilder rtn = new StringBuilder();
        int position = buffer.position();
        buffer.position(offset);
        for (int i = 0; i < size; ++i) {
            byte b = buffer.get();
            byte h = (byte)(b & 0xF0);
            h = (byte)(h >>> 4);
            h = (byte)(h & 0xF);
            rtn.append(HEX_CHARS[h]);
            h = (byte)(b & 0xF);
            rtn.append(HEX_CHARS[h]);
            if (!formatted) continue;
            rtn.append(" ");
            if ((i + 1) % 4 == 0) {
                rtn.append(" ");
            }
            if ((i + 1) % 24 != 0) continue;
            rtn.append("\n");
        }
        buffer.position(position);
        return rtn.toString();
    }

    public static void writeHexString(ByteBuffer buffer, String hexStr) throws IOException {
        char[] hexChars = hexStr.toCharArray();
        if (hexChars.length % 2 != 0) {
            throw new IOException("Hex string length must be even");
        }
        for (int i = 0; i < hexChars.length; i += 2) {
            String tmpStr = new String(hexChars, i, 2);
            buffer.put((byte)Long.parseLong(tmpStr, 16));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toHexFile(String fileName, ByteBuffer buffer, int offset, int size) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(fileName));
        try {
            writer.println(ByteUtil.toHexString(buffer, offset, size));
        }
        finally {
            writer.close();
        }
    }

    public static int asUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int asUnsignedShort(short s) {
        return s & 0xFFFF;
    }
}

