/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import java.sql.SQLException;

public class ColumnBuilder {
    private String _name;
    private DataType _type;
    private Integer _length;
    private Integer _precision;
    private Integer _scale;
    private boolean _autoNumber;
    private Boolean _compressedUnicode;

    public ColumnBuilder(String name) {
        this(name, null);
    }

    public ColumnBuilder(String name, DataType type) {
        this._name = name;
        this._type = type;
    }

    public ColumnBuilder setType(DataType type) {
        this._type = type;
        return this;
    }

    public ColumnBuilder setSQLType(int type) throws SQLException {
        return this.setSQLType(type, 0);
    }

    public ColumnBuilder setSQLType(int type, int lengthInUnits) throws SQLException {
        return this.setType(DataType.fromSQLType(type, lengthInUnits));
    }

    public ColumnBuilder setPrecision(int newPrecision) {
        this._precision = newPrecision;
        return this;
    }

    public ColumnBuilder setScale(int newScale) {
        this._scale = newScale;
        return this;
    }

    public ColumnBuilder setLength(int length) {
        this._length = length;
        return this;
    }

    public ColumnBuilder setLengthInUnits(int unitLength) {
        return this.setLength(this._type.getUnitSize() * unitLength);
    }

    public ColumnBuilder setMaxLength() {
        return this.setLength(this._type.getMaxSize());
    }

    public ColumnBuilder setAutoNumber(boolean autoNumber) {
        this._autoNumber = autoNumber;
        return this;
    }

    public ColumnBuilder setCompressedUnicode(boolean compressedUnicode) {
        this._compressedUnicode = compressedUnicode;
        return this;
    }

    public ColumnBuilder setFromColumn(Column template) {
        DataType type = template.getType();
        this.setType(type);
        this.setLength(template.getLength());
        this.setAutoNumber(template.isAutoNumber());
        if (type.getHasScalePrecision()) {
            this.setScale(template.getScale());
            this.setPrecision(template.getPrecision());
        }
        return this;
    }

    public Column toColumn() {
        Column col = new Column();
        col.setName(this._name);
        col.setType(this._type);
        if (this._length != null) {
            col.setLength(this._length.shortValue());
        }
        if (this._precision != null) {
            col.setPrecision(this._precision.byteValue());
        }
        if (this._scale != null) {
            col.setScale(this._scale.byteValue());
        }
        if (this._autoNumber) {
            col.setAutoNumber(true);
        }
        if (this._compressedUnicode != null) {
            col.setCompressedUnicode(this._compressedUnicode);
        }
        return col;
    }
}

