/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.ErrorHandler;
import com.healthmarketscience.jackcess.ImportFilter;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.Relationship;
import com.healthmarketscience.jackcess.SimpleImportFilter;
import com.healthmarketscience.jackcess.Table;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Iterable<Table>,
Closeable,
Flushable {
    private static final Log LOG = LogFactory.getLog(Database.class);
    private static final byte[] SYS_DEFAULT_SID = new byte[2];
    public static final boolean DEFAULT_AUTO_SYNC = true;
    public static final String USE_BIG_INDEX_PROPERTY = "com.healthmarketscience.jackcess.bigIndex";
    public static final ErrorHandler DEFAULT_ERROR_HANDLER;
    private static final int COPY_TABLE_BATCH_SIZE = 200;
    private static final int PAGE_SYSTEM_CATALOG = 2;
    private static final String TABLE_SYSTEM_CATALOG = "MSysObjects";
    private static final Integer SYS_FULL_ACCESS_ACM;
    private static final String ACE_COL_ACM = "ACM";
    private static final String ACE_COL_F_INHERITABLE = "FInheritable";
    private static final String ACE_COL_OBJECT_ID = "ObjectId";
    private static final String ACE_COL_SID = "SID";
    private static final String REL_COL_COLUMN_COUNT = "ccolumn";
    private static final String REL_COL_FLAGS = "grbit";
    private static final String REL_COL_COLUMN_INDEX = "icolumn";
    private static final String REL_COL_TO_COLUMN = "szColumn";
    private static final String REL_COL_TO_TABLE = "szObject";
    private static final String REL_COL_FROM_COLUMN = "szReferencedColumn";
    private static final String REL_COL_FROM_TABLE = "szReferencedObject";
    private static final String REL_COL_NAME = "szRelationship";
    private static final String CAT_COL_ID = "Id";
    private static final String CAT_COL_NAME = "Name";
    private static final String CAT_COL_OWNER = "Owner";
    private static final String CAT_COL_PARENT_ID = "ParentId";
    private static final String CAT_COL_TYPE = "Type";
    private static final String CAT_COL_DATE_CREATE = "DateCreate";
    private static final String CAT_COL_DATE_UPDATE = "DateUpdate";
    private static final String CAT_COL_FLAGS = "Flags";
    private static final String EMPTY_MDB = "com/healthmarketscience/jackcess/empty.mdb";
    private static final String ESCAPE_PREFIX = "x";
    private static final String PREFIX_SYSTEM = "MSys";
    private static final String SYSTEM_OBJECT_NAME_TABLES = "Tables";
    private static final String TABLE_SYSTEM_ACES = "MSysACEs";
    private static final String TABLE_SYSTEM_RELATIONSHIPS = "MSysRelationships";
    private static final Short TYPE_TABLE;
    private static Collection<String> SYSTEM_CATALOG_COLUMNS;
    private static final Set<String> RESERVED_WORDS;
    private ByteBuffer _buffer;
    private Integer _tableParentId;
    private final JetFormat _format;
    private Map<String, TableInfo> _tableLookup = new HashMap<String, TableInfo>();
    private Set<String> _tableNames;
    private final PageChannel _pageChannel;
    private Table _systemCatalog;
    private Table _accessControlEntries;
    private Table _relationships;
    private final List<byte[]> _newTableSIDs = new ArrayList<byte[]>();
    private boolean _useBigIndex;
    private ErrorHandler _dbErrorHandler;

    public static Database open(File mdbFile) throws IOException {
        return Database.open(mdbFile, false);
    }

    public static Database open(File mdbFile, boolean readOnly) throws IOException {
        return Database.open(mdbFile, readOnly, true);
    }

    public static Database open(File mdbFile, boolean readOnly, boolean autoSync) throws IOException {
        if (!mdbFile.exists() || !mdbFile.canRead()) {
            throw new FileNotFoundException("given file does not exist: " + mdbFile);
        }
        return new Database(Database.openChannel(mdbFile, !mdbFile.canWrite() || readOnly), autoSync);
    }

    public static Database create(File mdbFile) throws IOException {
        return Database.create(mdbFile, true);
    }

    public static Database create(File mdbFile, boolean autoSync) throws IOException {
        FileChannel channel = Database.openChannel(mdbFile, false);
        channel.truncate(0L);
        channel.transferFrom(Channels.newChannel(Thread.currentThread().getContextClassLoader().getResourceAsStream(EMPTY_MDB)), 0L, Integer.MAX_VALUE);
        return new Database(channel, autoSync);
    }

    private static FileChannel openChannel(File mdbFile, boolean readOnly) throws FileNotFoundException {
        String mode = readOnly ? "r" : "rw";
        return new RandomAccessFile(mdbFile, mode).getChannel();
    }

    protected Database(FileChannel channel, boolean autoSync) throws IOException {
        this._format = JetFormat.getFormat(channel);
        this._pageChannel = new PageChannel(channel, this._format, autoSync);
        this._pageChannel.initialize(this);
        this._buffer = this._pageChannel.createPageBuffer();
        this.readSystemCatalog();
    }

    public PageChannel getPageChannel() {
        return this._pageChannel;
    }

    public JetFormat getFormat() {
        return this._format;
    }

    public Table getSystemCatalog() {
        return this._systemCatalog;
    }

    public Table getAccessControlEntries() {
        return this._accessControlEntries;
    }

    public boolean doUseBigIndex() {
        return this._useBigIndex;
    }

    public void setUseBigIndex(boolean useBigIndex) {
        this._useBigIndex = useBigIndex;
    }

    public ErrorHandler getErrorHandler() {
        return this._dbErrorHandler != null ? this._dbErrorHandler : DEFAULT_ERROR_HANDLER;
    }

    public void setErrorHandler(ErrorHandler newErrorHandler) {
        this._dbErrorHandler = newErrorHandler;
    }

    private void readSystemCatalog() throws IOException {
        this._systemCatalog = this.readTable(TABLE_SYSTEM_CATALOG, 2, this.defaultUseBigIndex());
        for (Map<String, Object> row : Cursor.createCursor(this._systemCatalog).iterable(SYSTEM_CATALOG_COLUMNS)) {
            String name = (String)row.get(CAT_COL_NAME);
            if (name != null && TYPE_TABLE.equals(row.get(CAT_COL_TYPE))) {
                if (!name.startsWith(PREFIX_SYSTEM)) {
                    this.addTable((String)row.get(CAT_COL_NAME), (Integer)row.get(CAT_COL_ID));
                    continue;
                }
                if (!TABLE_SYSTEM_ACES.equals(name)) continue;
                int pageNumber = (Integer)row.get(CAT_COL_ID);
                this._accessControlEntries = this.readTable(TABLE_SYSTEM_ACES, pageNumber, this.defaultUseBigIndex());
                continue;
            }
            if (!SYSTEM_OBJECT_NAME_TABLES.equals(name)) continue;
            this._tableParentId = (Integer)row.get(CAT_COL_ID);
        }
        if (this._accessControlEntries == null) {
            throw new IOException("Did not find required MSysACEs table");
        }
        if (this._tableParentId == null) {
            throw new IOException("Did not find required parent table id");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished reading system catalog.  Tables: " + this.getTableNames()));
        }
    }

    public Set<String> getTableNames() {
        if (this._tableNames == null) {
            this._tableNames = new HashSet<String>();
            for (TableInfo tableInfo : this._tableLookup.values()) {
                this._tableNames.add(tableInfo.tableName);
            }
        }
        return this._tableNames;
    }

    @Override
    public Iterator<Table> iterator() {
        return new TableIterator();
    }

    public Table getTable(String name) throws IOException {
        return this.getTable(name, this.defaultUseBigIndex());
    }

    public Table getTable(String name, boolean useBigIndex) throws IOException {
        TableInfo tableInfo = this.lookupTable(name);
        if (tableInfo == null || tableInfo.pageNumber == null) {
            return null;
        }
        return this.readTable(tableInfo.tableName, tableInfo.pageNumber, useBigIndex);
    }

    public void createTable(String name, List<Column> columns) throws IOException {
        Database.validateIdentifierName(name, this._format.MAX_TABLE_NAME_LENGTH, "table");
        if (this.getTable(name) != null) {
            throw new IllegalArgumentException("Cannot create table with name of existing table");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Cannot create table with no columns");
        }
        if (columns.size() > this._format.MAX_COLUMNS_PER_TABLE) {
            throw new IllegalArgumentException("Cannot create table with more than " + this._format.MAX_COLUMNS_PER_TABLE + " columns");
        }
        HashSet<String> colNames = new HashSet<String>();
        for (Column column : columns) {
            column.validate(this._format);
            if (colNames.add(column.getName().toUpperCase())) continue;
            throw new IllegalArgumentException("duplicate column name: " + column.getName());
        }
        if (Table.countAutoNumberColumns(columns) > 1) {
            throw new IllegalArgumentException("Can have at most one AutoNumber column per table");
        }
        int tdefPageNumber = Table.writeTableDefinition(columns, this._pageChannel, this._format);
        this.addTable(name, tdefPageNumber);
        this.addToSystemCatalog(name, tdefPageNumber);
        this.addToAccessControlEntries(tdefPageNumber);
    }

    public List<Relationship> getRelationships(Table table1, Table table2) throws IOException {
        int nameCmp;
        if (this._relationships == null) {
            this._relationships = this.getSystemTable(TABLE_SYSTEM_RELATIONSHIPS);
            if (this._relationships == null) {
                throw new IOException("Could not find system relationships table");
            }
        }
        if ((nameCmp = table1.getName().compareTo(table2.getName())) == 0) {
            throw new IllegalArgumentException("Must provide two different tables");
        }
        if (nameCmp > 0) {
            Table tmp = table1;
            table1 = table2;
            table2 = tmp;
        }
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        Cursor cursor = Database.createCursorWithOptionalIndex(this._relationships, REL_COL_FROM_TABLE, table1.getName());
        this.collectRelationships(cursor, table1, table2, relationships);
        cursor = Database.createCursorWithOptionalIndex(this._relationships, REL_COL_TO_TABLE, table1.getName());
        this.collectRelationships(cursor, table2, table1, relationships);
        return relationships;
    }

    public Table getSystemTable(String tableName) throws IOException {
        for (Map<String, Object> row : Cursor.createCursor(this._systemCatalog).iterable(SYSTEM_CATALOG_COLUMNS)) {
            Integer pageNumber;
            String name = (String)row.get(CAT_COL_NAME);
            if (!tableName.equalsIgnoreCase(name) || !TYPE_TABLE.equals(row.get(CAT_COL_TYPE)) || (pageNumber = (Integer)row.get(CAT_COL_ID)) == null) continue;
            return this.readTable(name, pageNumber, this.defaultUseBigIndex());
        }
        return null;
    }

    private void collectRelationships(Cursor cursor, Table fromTable, Table toTable, List<Relationship> relationships) {
        for (Map<String, Object> row : cursor) {
            String fromName = (String)row.get(REL_COL_FROM_TABLE);
            String toName = (String)row.get(REL_COL_TO_TABLE);
            if (!fromTable.getName().equals(fromName) || !toTable.getName().equals(toName)) continue;
            String relName = (String)row.get(REL_COL_NAME);
            Relationship rel = null;
            for (Relationship tmp : relationships) {
                if (!tmp.getName().equals(relName)) continue;
                rel = tmp;
                break;
            }
            if (rel == null) {
                int numCols = (Integer)row.get(REL_COL_COLUMN_COUNT);
                int flags = (Integer)row.get(REL_COL_FLAGS);
                rel = new Relationship(relName, fromTable, toTable, flags, numCols);
                relationships.add(rel);
            }
            int colIdx = (Integer)row.get(REL_COL_COLUMN_INDEX);
            Column fromCol = fromTable.getColumn((String)row.get(REL_COL_FROM_COLUMN));
            Column toCol = toTable.getColumn((String)row.get(REL_COL_TO_COLUMN));
            rel.getFromColumns().set(colIdx, fromCol);
            rel.getToColumns().set(colIdx, toCol);
        }
    }

    private void addToSystemCatalog(String name, int pageNumber) throws IOException {
        Object[] catalogRow = new Object[this._systemCatalog.getColumnCount()];
        int idx = 0;
        Date creationTime = new Date();
        for (Column col : this._systemCatalog.getColumns()) {
            if (CAT_COL_ID.equals(col.getName())) {
                catalogRow[idx] = pageNumber;
            } else if (CAT_COL_NAME.equals(col.getName())) {
                catalogRow[idx] = name;
            } else if (CAT_COL_TYPE.equals(col.getName())) {
                catalogRow[idx] = TYPE_TABLE;
            } else if (CAT_COL_DATE_CREATE.equals(col.getName()) || CAT_COL_DATE_UPDATE.equals(col.getName())) {
                catalogRow[idx] = creationTime;
            } else if (CAT_COL_PARENT_ID.equals(col.getName())) {
                catalogRow[idx] = this._tableParentId;
            } else if (CAT_COL_FLAGS.equals(col.getName())) {
                catalogRow[idx] = 0;
            } else if (CAT_COL_OWNER.equals(col.getName())) {
                byte[] owner = new byte[2];
                catalogRow[idx] = owner;
                owner[0] = -49;
                owner[1] = 95;
            }
            ++idx;
        }
        this._systemCatalog.addRow(catalogRow);
    }

    private void addToAccessControlEntries(int pageNumber) throws IOException {
        if (this._newTableSIDs.isEmpty()) {
            this.initNewTableSIDs();
        }
        Column acmCol = this._accessControlEntries.getColumn(ACE_COL_ACM);
        Column inheritCol = this._accessControlEntries.getColumn(ACE_COL_F_INHERITABLE);
        Column objIdCol = this._accessControlEntries.getColumn(ACE_COL_OBJECT_ID);
        Column sidCol = this._accessControlEntries.getColumn(ACE_COL_SID);
        ArrayList<Object[]> aceRows = new ArrayList<Object[]>(this._newTableSIDs.size());
        for (byte[] sid : this._newTableSIDs) {
            Object[] aceRow = new Object[this._accessControlEntries.getColumnCount()];
            aceRow[acmCol.getColumnIndex()] = SYS_FULL_ACCESS_ACM;
            aceRow[inheritCol.getColumnIndex()] = Boolean.FALSE;
            aceRow[objIdCol.getColumnIndex()] = pageNumber;
            aceRow[sidCol.getColumnIndex()] = sid;
            aceRows.add(aceRow);
        }
        this._accessControlEntries.addRows(aceRows);
    }

    private void initNewTableSIDs() throws IOException {
        Cursor cursor = Database.createCursorWithOptionalIndex(this._accessControlEntries, ACE_COL_OBJECT_ID, this._tableParentId);
        for (Map<String, Object> row : cursor) {
            Integer objId = (Integer)row.get(ACE_COL_OBJECT_ID);
            if (!this._tableParentId.equals(objId)) continue;
            this._newTableSIDs.add((byte[])row.get(ACE_COL_SID));
        }
        if (this._newTableSIDs.isEmpty()) {
            this._newTableSIDs.add(SYS_DEFAULT_SID);
        }
    }

    private Table readTable(String name, int pageNumber, boolean useBigIndex) throws IOException {
        this._pageChannel.readPage(this._buffer, pageNumber);
        byte pageType = this._buffer.get(0);
        if (pageType != 2) {
            throw new IOException("Looking for " + name + " at page " + pageNumber + ", but page type is " + pageType);
        }
        return new Table(this, this._buffer, pageNumber, name, useBigIndex);
    }

    private static Cursor createCursorWithOptionalIndex(Table table, String colName, Object colValue) throws IOException {
        try {
            return new CursorBuilder(table).setIndexByColumns(table.getColumn(colName)).setSpecificEntry(colValue).toCursor();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Object)("Could not find expected index on table " + table.getName()));
            return Cursor.createCursor(table);
        }
    }

    public void copyTable(String name, ResultSet source) throws SQLException, IOException {
        this.copyTable(name, source, SimpleImportFilter.INSTANCE);
    }

    public void copyTable(String name, ResultSet source, ImportFilter filter) throws SQLException, IOException {
        ResultSetMetaData md = source.getMetaData();
        LinkedList<Column> columns = new LinkedList<Column>();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            Column column = new Column();
            column.setName(this.escape(md.getColumnName(i)));
            int lengthInUnits = md.getColumnDisplaySize(i);
            column.setSQLType(md.getColumnType(i), lengthInUnits);
            DataType type = column.getType();
            if (type.isTrueVariableLength() && !type.isLongValue()) {
                column.setLengthInUnits((short)lengthInUnits);
            }
            if (type.getHasScalePrecision()) {
                int scale = md.getScale(i);
                int precision = md.getPrecision(i);
                if (type.isValidScale(scale)) {
                    column.setScale((byte)scale);
                }
                if (type.isValidPrecision(precision)) {
                    column.setPrecision((byte)precision);
                }
            }
            columns.add(column);
        }
        this.createTable(this.escape(name), filter.filterColumns(columns, md));
        Table table = this.getTable(this.escape(name));
        ArrayList<Object[]> rows = new ArrayList<Object[]>(200);
        while (source.next()) {
            Object[] row = new Object[md.getColumnCount()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = source.getObject(i + 1);
            }
            rows.add(filter.filterRow(row));
            if (rows.size() != 200) continue;
            table.addRows(rows);
            rows.clear();
        }
        if (rows.size() > 0) {
            table.addRows(rows);
        }
    }

    public void importFile(String name, File f, String delim) throws IOException {
        this.importFile(name, f, delim, SimpleImportFilter.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(String name, File f, String delim, ImportFilter filter) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
            this.importReader(name, in, delim, filter);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.warn((Object)("Could not close file " + f.getAbsolutePath()), (Throwable)ex);
                }
            }
        }
    }

    public void importReader(String name, BufferedReader in, String delim) throws IOException {
        this.importReader(name, in, delim, SimpleImportFilter.INSTANCE);
    }

    public void importReader(String name, BufferedReader in, String delim, ImportFilter filter) throws IOException {
        String line = in.readLine();
        if (line == null || line.trim().length() == 0) {
            return;
        }
        String tableName = this.escape(name);
        int counter = 0;
        while (this.getTable(tableName) != null) {
            tableName = this.escape(name + counter++);
        }
        LinkedList<Column> columns = new LinkedList<Column>();
        String[] columnNames = line.split(delim);
        for (int i = 0; i < columnNames.length; ++i) {
            columns.add(new ColumnBuilder(this.escape(columnNames[i]), DataType.TEXT).setLength((short)DataType.TEXT.getMaxSize()).toColumn());
        }
        try {
            this.createTable(tableName, filter.filterColumns(columns, null));
            Table table = this.getTable(tableName);
            ArrayList<Object[]> rows = new ArrayList<Object[]>(200);
            while ((line = in.readLine()) != null) {
                Object[] data = Table.dupeRow(line.split(delim), columnNames.length);
                rows.add(filter.filterRow(data));
                if (rows.size() != 200) continue;
                table.addRows(rows);
                rows.clear();
            }
            if (rows.size() > 0) {
                table.addRows(rows);
            }
        }
        catch (SQLException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this._pageChannel.flush();
    }

    @Override
    public void close() throws IOException {
        this._pageChannel.close();
    }

    private String escape(String s) {
        if (Database.isReservedWord(s)) {
            return ESCAPE_PREFIX + s;
        }
        return s;
    }

    public static boolean isReservedWord(String s) {
        return RESERVED_WORDS.contains(s.toLowerCase());
    }

    public static void validateIdentifierName(String name, int maxLength, String identifierType) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(identifierType + " must have non-empty name");
        }
        if (name.length() > maxLength) {
            throw new IllegalArgumentException(identifierType + " name is longer than max length of " + maxLength + ": " + name);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void addTable(String tableName, Integer pageNumber) {
        this._tableLookup.put(this.toLookupTableName(tableName), new TableInfo(pageNumber, tableName));
        this._tableNames = null;
    }

    private TableInfo lookupTable(String tableName) {
        return this._tableLookup.get(this.toLookupTableName(tableName));
    }

    private String toLookupTableName(String tableName) {
        return tableName != null ? tableName.toUpperCase() : null;
    }

    public boolean defaultUseBigIndex() {
        return this.doUseBigIndex() || Boolean.getBoolean(USE_BIG_INDEX_PROPERTY);
    }

    static {
        Database.SYS_DEFAULT_SID[0] = -90;
        Database.SYS_DEFAULT_SID[1] = 51;
        DEFAULT_ERROR_HANDLER = new ErrorHandler(){

            public Object handleRowError(Column column, byte[] columnData, Table.RowState rowState, Exception error) throws IOException {
                if (error instanceof IOException) {
                    throw (IOException)error;
                }
                throw (RuntimeException)error;
            }
        };
        SYS_FULL_ACCESS_ACM = 1048575;
        TYPE_TABLE = 1;
        SYSTEM_CATALOG_COLUMNS = new HashSet<String>(Arrays.asList(CAT_COL_NAME, CAT_COL_TYPE, CAT_COL_ID));
        RESERVED_WORDS = new HashSet<String>();
        RESERVED_WORDS.addAll(Arrays.asList("add", "all", "alphanumeric", "alter", "and", "any", "application", "as", "asc", "assistant", "autoincrement", "avg", "between", "binary", "bit", "boolean", "by", "byte", "char", "character", "column", "compactdatabase", "constraint", "container", "count", "counter", "create", "createdatabase", "createfield", "creategroup", "createindex", "createobject", "createproperty", "createrelation", "createtabledef", "createuser", "createworkspace", "currency", "currentuser", "database", "date", "datetime", "delete", "desc", "description", "disallow", "distinct", "distinctrow", "document", "double", "drop", "echo", "else", "end", "eqv", "error", "exists", "exit", "false", "field", "fields", "fillcache", "float", "float4", "float8", "foreign", "form", "forms", "from", "full", "function", "general", "getobject", "getoption", "gotopage", "group", "group by", "guid", "having", "idle", "ieeedouble", "ieeesingle", "if", "ignore", "imp", "in", "index", "indexes", "inner", "insert", "inserttext", "int", "integer", "integer1", "integer2", "integer4", "into", "is", "join", "key", "lastmodified", "left", "level", "like", "logical", "logical1", "long", "longbinary", "longtext", "macro", "match", "max", "min", "mod", "memo", "module", "money", "move", "name", "newpassword", "no", "not", "null", "number", "numeric", "object", "oleobject", "off", "on", "openrecordset", "option", "or", "order", "outer", "owneraccess", "parameter", "parameters", "partial", "percent", "pivot", "primary", "procedure", "property", "queries", "query", "quit", "real", "recalc", "recordset", "references", "refresh", "refreshlink", "registerdatabase", "relation", "repaint", "repairdatabase", "report", "reports", "requery", "right", "screen", "section", "select", "set", "setfocus", "setoption", "short", "single", "smallint", "some", "sql", "stdev", "stdevp", "string", "sum", "table", "tabledef", "tabledefs", "tableid", "text", "time", "timestamp", "top", "transform", "true", "type", "union", "unique", "update", "user", "value", "values", "var", "varp", "varbinary", "varchar", "where", "with", "workspace", "xor", "year", "yes", "yesno"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableIterator
    implements Iterator<Table> {
        private Iterator<String> _tableNameIter;

        private TableIterator() {
            this._tableNameIter = Database.this.getTableNames().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._tableNameIter.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Table next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return Database.this.getTable(this._tableNameIter.next());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class TableInfo {
        public final Integer pageNumber;
        public final String tableName;

        private TableInfo(Integer newPageNumber, String newTableName) {
            this.pageNumber = newPageNumber;
            this.tableName = newTableName;
        }
    }
}

