/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public abstract class JetFormat {
    public static final int MAX_RECORD_SIZE = 1900;
    public static final short TEXT_FIELD_UNIT_SIZE = 2;
    public static final short TEXT_FIELD_MAX_LENGTH = 510;
    private static final long OFFSET_VERSION = 20L;
    private static final byte CODE_VERSION_3 = 0;
    private static final byte CODE_VERSION_4 = 1;
    private final String _name;
    public final int PAGE_SIZE;
    public final long MAX_DATABASE_SIZE;
    public final int MAX_ROW_SIZE;
    public final int PAGE_INITIAL_FREE_SPACE;
    public final int OFFSET_NEXT_TABLE_DEF_PAGE;
    public final int OFFSET_NUM_ROWS;
    public final int OFFSET_NEXT_AUTO_NUMBER;
    public final int OFFSET_TABLE_TYPE;
    public final int OFFSET_MAX_COLS;
    public final int OFFSET_NUM_VAR_COLS;
    public final int OFFSET_NUM_COLS;
    public final int OFFSET_NUM_INDEX_SLOTS;
    public final int OFFSET_NUM_INDEXES;
    public final int OFFSET_OWNED_PAGES;
    public final int OFFSET_FREE_SPACE_PAGES;
    public final int OFFSET_INDEX_DEF_BLOCK;
    public final int OFFSET_INDEX_NUMBER_BLOCK;
    public final int OFFSET_COLUMN_TYPE;
    public final int OFFSET_COLUMN_NUMBER;
    public final int OFFSET_COLUMN_PRECISION;
    public final int OFFSET_COLUMN_SCALE;
    public final int OFFSET_COLUMN_FLAGS;
    public final int OFFSET_COLUMN_COMPRESSED_UNICODE;
    public final int OFFSET_COLUMN_LENGTH;
    public final int OFFSET_COLUMN_VARIABLE_TABLE_INDEX;
    public final int OFFSET_COLUMN_FIXED_DATA_OFFSET;
    public final int OFFSET_TABLE_DEF_LOCATION;
    public final int OFFSET_ROW_START;
    public final int OFFSET_USAGE_MAP_START;
    public final int OFFSET_USAGE_MAP_PAGE_DATA;
    public final int OFFSET_REFERENCE_MAP_PAGE_NUMBERS;
    public final int OFFSET_FREE_SPACE;
    public final int OFFSET_NUM_ROWS_ON_DATA_PAGE;
    public final int MAX_NUM_ROWS_ON_DATA_PAGE;
    public final int OFFSET_INDEX_COMPRESSED_BYTE_COUNT;
    public final int OFFSET_INDEX_ENTRY_MASK;
    public final int OFFSET_PREV_INDEX_PAGE;
    public final int OFFSET_NEXT_INDEX_PAGE;
    public final int OFFSET_CHILD_TAIL_INDEX_PAGE;
    public final int SIZE_INDEX_DEFINITION;
    public final int SIZE_COLUMN_HEADER;
    public final int SIZE_ROW_LOCATION;
    public final int SIZE_LONG_VALUE_DEF;
    public final int MAX_INLINE_LONG_VALUE_SIZE;
    public final int MAX_LONG_VALUE_ROW_SIZE;
    public final int SIZE_TDEF_HEADER;
    public final int SIZE_TDEF_TRAILER;
    public final int SIZE_COLUMN_DEF_BLOCK;
    public final int SIZE_INDEX_ENTRY_MASK;
    public final int USAGE_MAP_TABLE_BYTE_LENGTH;
    public final int MAX_COLUMNS_PER_TABLE;
    public final int MAX_TABLE_NAME_LENGTH;
    public final int MAX_COLUMN_NAME_LENGTH;
    public final int MAX_INDEX_NAME_LENGTH;
    public final Charset CHARSET;
    public static final JetFormat VERSION_4 = new Jet4Format();

    public static JetFormat getFormat(FileChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        int bytesRead = channel.read(buffer, 20L);
        if (bytesRead < 1) {
            throw new IOException("Empty database file");
        }
        buffer.flip();
        byte version = buffer.get();
        if (version == 1) {
            return VERSION_4;
        }
        throw new IOException("Unsupported version: " + version);
    }

    private JetFormat(String name) {
        this._name = name;
        this.PAGE_SIZE = this.definePageSize();
        this.MAX_DATABASE_SIZE = this.defineMaxDatabaseSize();
        this.MAX_ROW_SIZE = this.defineMaxRowSize();
        this.PAGE_INITIAL_FREE_SPACE = this.definePageInitialFreeSpace();
        this.OFFSET_NEXT_TABLE_DEF_PAGE = this.defineOffsetNextTableDefPage();
        this.OFFSET_NUM_ROWS = this.defineOffsetNumRows();
        this.OFFSET_NEXT_AUTO_NUMBER = this.defineOffsetNextAutoNumber();
        this.OFFSET_TABLE_TYPE = this.defineOffsetTableType();
        this.OFFSET_MAX_COLS = this.defineOffsetMaxCols();
        this.OFFSET_NUM_VAR_COLS = this.defineOffsetNumVarCols();
        this.OFFSET_NUM_COLS = this.defineOffsetNumCols();
        this.OFFSET_NUM_INDEX_SLOTS = this.defineOffsetNumIndexSlots();
        this.OFFSET_NUM_INDEXES = this.defineOffsetNumIndexes();
        this.OFFSET_OWNED_PAGES = this.defineOffsetOwnedPages();
        this.OFFSET_FREE_SPACE_PAGES = this.defineOffsetFreeSpacePages();
        this.OFFSET_INDEX_DEF_BLOCK = this.defineOffsetIndexDefBlock();
        this.OFFSET_INDEX_NUMBER_BLOCK = this.defineOffsetIndexNumberBlock();
        this.OFFSET_COLUMN_TYPE = this.defineOffsetColumnType();
        this.OFFSET_COLUMN_NUMBER = this.defineOffsetColumnNumber();
        this.OFFSET_COLUMN_PRECISION = this.defineOffsetColumnPrecision();
        this.OFFSET_COLUMN_SCALE = this.defineOffsetColumnScale();
        this.OFFSET_COLUMN_FLAGS = this.defineOffsetColumnFlags();
        this.OFFSET_COLUMN_COMPRESSED_UNICODE = this.defineOffsetColumnCompressedUnicode();
        this.OFFSET_COLUMN_LENGTH = this.defineOffsetColumnLength();
        this.OFFSET_COLUMN_VARIABLE_TABLE_INDEX = this.defineOffsetColumnVariableTableIndex();
        this.OFFSET_COLUMN_FIXED_DATA_OFFSET = this.defineOffsetColumnFixedDataOffset();
        this.OFFSET_TABLE_DEF_LOCATION = this.defineOffsetTableDefLocation();
        this.OFFSET_ROW_START = this.defineOffsetRowStart();
        this.OFFSET_USAGE_MAP_START = this.defineOffsetUsageMapStart();
        this.OFFSET_USAGE_MAP_PAGE_DATA = this.defineOffsetUsageMapPageData();
        this.OFFSET_REFERENCE_MAP_PAGE_NUMBERS = this.defineOffsetReferenceMapPageNumbers();
        this.OFFSET_FREE_SPACE = this.defineOffsetFreeSpace();
        this.OFFSET_NUM_ROWS_ON_DATA_PAGE = this.defineOffsetNumRowsOnDataPage();
        this.MAX_NUM_ROWS_ON_DATA_PAGE = this.defineMaxNumRowsOnDataPage();
        this.OFFSET_INDEX_COMPRESSED_BYTE_COUNT = this.defineOffsetIndexCompressedByteCount();
        this.OFFSET_INDEX_ENTRY_MASK = this.defineOffsetIndexEntryMask();
        this.OFFSET_PREV_INDEX_PAGE = this.defineOffsetPrevIndexPage();
        this.OFFSET_NEXT_INDEX_PAGE = this.defineOffsetNextIndexPage();
        this.OFFSET_CHILD_TAIL_INDEX_PAGE = this.defineOffsetChildTailIndexPage();
        this.SIZE_INDEX_DEFINITION = this.defineSizeIndexDefinition();
        this.SIZE_COLUMN_HEADER = this.defineSizeColumnHeader();
        this.SIZE_ROW_LOCATION = this.defineSizeRowLocation();
        this.SIZE_LONG_VALUE_DEF = this.defineSizeLongValueDef();
        this.MAX_INLINE_LONG_VALUE_SIZE = this.defineMaxInlineLongValueSize();
        this.MAX_LONG_VALUE_ROW_SIZE = this.defineMaxLongValueRowSize();
        this.SIZE_TDEF_HEADER = this.defineSizeTdefHeader();
        this.SIZE_TDEF_TRAILER = this.defineSizeTdefTrailer();
        this.SIZE_COLUMN_DEF_BLOCK = this.defineSizeColumnDefBlock();
        this.SIZE_INDEX_ENTRY_MASK = this.defineSizeIndexEntryMask();
        this.USAGE_MAP_TABLE_BYTE_LENGTH = this.defineUsageMapTableByteLength();
        this.MAX_COLUMNS_PER_TABLE = this.defineMaxColumnsPerTable();
        this.MAX_TABLE_NAME_LENGTH = this.defineMaxTableNameLength();
        this.MAX_COLUMN_NAME_LENGTH = this.defineMaxColumnNameLength();
        this.MAX_INDEX_NAME_LENGTH = this.defineMaxIndexNameLength();
        this.CHARSET = this.defineCharset();
    }

    protected abstract int definePageSize();

    protected abstract long defineMaxDatabaseSize();

    protected abstract int defineMaxRowSize();

    protected abstract int definePageInitialFreeSpace();

    protected abstract int defineOffsetNextTableDefPage();

    protected abstract int defineOffsetNumRows();

    protected abstract int defineOffsetNextAutoNumber();

    protected abstract int defineOffsetTableType();

    protected abstract int defineOffsetMaxCols();

    protected abstract int defineOffsetNumVarCols();

    protected abstract int defineOffsetNumCols();

    protected abstract int defineOffsetNumIndexSlots();

    protected abstract int defineOffsetNumIndexes();

    protected abstract int defineOffsetOwnedPages();

    protected abstract int defineOffsetFreeSpacePages();

    protected abstract int defineOffsetIndexDefBlock();

    protected abstract int defineOffsetIndexNumberBlock();

    protected abstract int defineOffsetColumnType();

    protected abstract int defineOffsetColumnNumber();

    protected abstract int defineOffsetColumnPrecision();

    protected abstract int defineOffsetColumnScale();

    protected abstract int defineOffsetColumnFlags();

    protected abstract int defineOffsetColumnCompressedUnicode();

    protected abstract int defineOffsetColumnLength();

    protected abstract int defineOffsetColumnVariableTableIndex();

    protected abstract int defineOffsetColumnFixedDataOffset();

    protected abstract int defineOffsetTableDefLocation();

    protected abstract int defineOffsetRowStart();

    protected abstract int defineOffsetUsageMapStart();

    protected abstract int defineOffsetUsageMapPageData();

    protected abstract int defineOffsetReferenceMapPageNumbers();

    protected abstract int defineOffsetFreeSpace();

    protected abstract int defineOffsetNumRowsOnDataPage();

    protected abstract int defineMaxNumRowsOnDataPage();

    protected abstract int defineOffsetIndexCompressedByteCount();

    protected abstract int defineOffsetIndexEntryMask();

    protected abstract int defineOffsetPrevIndexPage();

    protected abstract int defineOffsetNextIndexPage();

    protected abstract int defineOffsetChildTailIndexPage();

    protected abstract int defineSizeIndexDefinition();

    protected abstract int defineSizeColumnHeader();

    protected abstract int defineSizeRowLocation();

    protected abstract int defineSizeLongValueDef();

    protected abstract int defineMaxInlineLongValueSize();

    protected abstract int defineMaxLongValueRowSize();

    protected abstract int defineSizeTdefHeader();

    protected abstract int defineSizeTdefTrailer();

    protected abstract int defineSizeColumnDefBlock();

    protected abstract int defineSizeIndexEntryMask();

    protected abstract int defineUsageMapTableByteLength();

    protected abstract int defineMaxColumnsPerTable();

    protected abstract int defineMaxTableNameLength();

    protected abstract int defineMaxColumnNameLength();

    protected abstract int defineMaxIndexNameLength();

    protected abstract Charset defineCharset();

    public String toString() {
        return this._name;
    }

    private static final class Jet4Format
    extends JetFormat {
        private Jet4Format() {
            super("VERSION_4");
        }

        protected int definePageSize() {
            return 4096;
        }

        protected long defineMaxDatabaseSize() {
            return 0x80000000L;
        }

        protected int defineMaxRowSize() {
            return 4060;
        }

        protected int definePageInitialFreeSpace() {
            return this.PAGE_SIZE - 14;
        }

        protected int defineOffsetNextTableDefPage() {
            return 4;
        }

        protected int defineOffsetNumRows() {
            return 16;
        }

        protected int defineOffsetNextAutoNumber() {
            return 20;
        }

        protected int defineOffsetTableType() {
            return 40;
        }

        protected int defineOffsetMaxCols() {
            return 41;
        }

        protected int defineOffsetNumVarCols() {
            return 43;
        }

        protected int defineOffsetNumCols() {
            return 45;
        }

        protected int defineOffsetNumIndexSlots() {
            return 47;
        }

        protected int defineOffsetNumIndexes() {
            return 51;
        }

        protected int defineOffsetOwnedPages() {
            return 55;
        }

        protected int defineOffsetFreeSpacePages() {
            return 59;
        }

        protected int defineOffsetIndexDefBlock() {
            return 63;
        }

        protected int defineOffsetIndexNumberBlock() {
            return 52;
        }

        protected int defineOffsetColumnType() {
            return 0;
        }

        protected int defineOffsetColumnNumber() {
            return 5;
        }

        protected int defineOffsetColumnPrecision() {
            return 11;
        }

        protected int defineOffsetColumnScale() {
            return 12;
        }

        protected int defineOffsetColumnFlags() {
            return 15;
        }

        protected int defineOffsetColumnCompressedUnicode() {
            return 16;
        }

        protected int defineOffsetColumnLength() {
            return 23;
        }

        protected int defineOffsetColumnVariableTableIndex() {
            return 7;
        }

        protected int defineOffsetColumnFixedDataOffset() {
            return 21;
        }

        protected int defineOffsetTableDefLocation() {
            return 4;
        }

        protected int defineOffsetRowStart() {
            return 14;
        }

        protected int defineOffsetUsageMapStart() {
            return 5;
        }

        protected int defineOffsetUsageMapPageData() {
            return 4;
        }

        protected int defineOffsetReferenceMapPageNumbers() {
            return 1;
        }

        protected int defineOffsetFreeSpace() {
            return 2;
        }

        protected int defineOffsetNumRowsOnDataPage() {
            return 12;
        }

        protected int defineMaxNumRowsOnDataPage() {
            return 255;
        }

        protected int defineOffsetIndexCompressedByteCount() {
            return 24;
        }

        protected int defineOffsetIndexEntryMask() {
            return 27;
        }

        protected int defineOffsetPrevIndexPage() {
            return 12;
        }

        protected int defineOffsetNextIndexPage() {
            return 16;
        }

        protected int defineOffsetChildTailIndexPage() {
            return 20;
        }

        protected int defineSizeIndexDefinition() {
            return 12;
        }

        protected int defineSizeColumnHeader() {
            return 25;
        }

        protected int defineSizeRowLocation() {
            return 2;
        }

        protected int defineSizeLongValueDef() {
            return 12;
        }

        protected int defineMaxInlineLongValueSize() {
            return 64;
        }

        protected int defineMaxLongValueRowSize() {
            return 4076;
        }

        protected int defineSizeTdefHeader() {
            return 63;
        }

        protected int defineSizeTdefTrailer() {
            return 2;
        }

        protected int defineSizeColumnDefBlock() {
            return 25;
        }

        protected int defineSizeIndexEntryMask() {
            return 453;
        }

        protected int defineUsageMapTableByteLength() {
            return 64;
        }

        protected int defineMaxColumnsPerTable() {
            return 255;
        }

        protected int defineMaxTableNameLength() {
            return 64;
        }

        protected int defineMaxColumnNameLength() {
            return 64;
        }

        protected int defineMaxIndexNameLength() {
            return 64;
        }

        protected Charset defineCharset() {
            return Charset.forName("UTF-16LE");
        }
    }
}

