/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowFilter {
    public abstract boolean matches(Map<String, Object> var1);

    public Iterable<Map<String, Object>> apply(Iterable<Map<String, Object>> iterable) {
        return new FilterIterable(iterable);
    }

    public static RowFilter matchPattern(final Map<String, Object> rowPattern) {
        return new RowFilter(){

            @Override
            public boolean matches(Map<String, Object> row) {
                for (Map.Entry e : rowPattern.entrySet()) {
                    if (ObjectUtils.equals(e.getValue(), (Object)row.get(e.getKey()))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static RowFilter matchPattern(final Column columnPattern, final Object valuePattern) {
        return new RowFilter(){

            @Override
            public boolean matches(Map<String, Object> row) {
                return ObjectUtils.equals((Object)valuePattern, (Object)row.get(columnPattern.getName()));
            }
        };
    }

    public static RowFilter invert(final RowFilter filter) {
        return new RowFilter(){

            @Override
            public boolean matches(Map<String, Object> row) {
                return !filter.matches(row);
            }
        };
    }

    public static Iterable<Map<String, Object>> apply(RowFilter rowFilter, Iterable<Map<String, Object>> iterable) {
        return rowFilter != null ? rowFilter.apply(iterable) : iterable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterIterable
    implements Iterable<Map<String, Object>> {
        private final Iterable<Map<String, Object>> _iterable;

        private FilterIterable(Iterable<Map<String, Object>> iterable) {
            this._iterable = iterable;
        }

        @Override
        public Iterator<Map<String, Object>> iterator() {
            return new Iterator<Map<String, Object>>(){
                private final Iterator<Map<String, Object>> _iter;
                private Map<String, Object> _next;
                {
                    this._iter = FilterIterable.this._iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this._iter.hasNext()) {
                        this._next = this._iter.next();
                        if (!RowFilter.this.matches(this._next)) continue;
                        return true;
                    }
                    this._next = null;
                    return false;
                }

                @Override
                public Map<String, Object> next() {
                    return this._next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

