/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.IndexCodes;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.RowId;
import com.healthmarketscience.jackcess.SimpleIndex;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TempBufferHolder;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Index
implements Comparable<Index> {
    protected static final Log LOG = LogFactory.getLog(Index.class);
    public static final Entry FIRST_ENTRY = Index.createSpecialEntry(RowId.FIRST_ROW_ID);
    public static final Entry LAST_ENTRY = Index.createSpecialEntry(RowId.LAST_ROW_ID);
    protected static final int INVALID_INDEX_PAGE_NUMBER = 0;
    private static final int MAX_COLUMNS = 10;
    protected static final byte[] EMPTY_PREFIX = new byte[0];
    private static final short COLUMN_UNUSED = -1;
    private static final byte ASCENDING_COLUMN_FLAG = 1;
    private static final byte UNIQUE_INDEX_FLAG = 1;
    private static final byte IGNORE_NULLS_INDEX_FLAG = 2;
    private static final byte PRIMARY_KEY_INDEX_TYPE = 1;
    private static final byte FOREIGN_KEY_INDEX_TYPE = 2;
    private static final int MAX_TEXT_INDEX_CHAR_LENGTH = 255;
    static final Comparator<byte[]> BYTE_CODE_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] left, byte[] right) {
            int pos;
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int len = Math.min(left.length, right.length);
            for (pos = 0; pos < len && left[pos] == right[pos]; ++pos) {
            }
            if (pos < len) {
                return ByteUtil.asUnsignedByte(left[pos]) < ByteUtil.asUnsignedByte(right[pos]) ? -1 : 1;
            }
            return left.length < right.length ? -1 : (left.length > right.length ? 1 : 0);
        }
    };
    private final Table _table;
    private int _rootPageNumber;
    private final int _uniqueEntryCountOffset;
    private int _uniqueEntryCount;
    private final List<ColumnDescriptor> _columns = new ArrayList<ColumnDescriptor>();
    private int _indexNumber;
    private byte _indexFlags;
    private byte _indexType;
    private String _name;
    private UsageMap _ownedPages;
    private boolean _initialized;
    private int _modCount;
    private final TempBufferHolder _indexBufferH = TempBufferHolder.newHolder(TempBufferHolder.Type.SOFT, true);
    private ByteUtil.ByteStream _entryBuffer;
    private final int _maxPageEntrySize;
    private boolean _readOnly;

    protected Index(Table table, int uniqueEntryCount, int uniqueEntryCountOffset) {
        this._table = table;
        this._uniqueEntryCount = uniqueEntryCount;
        this._uniqueEntryCountOffset = uniqueEntryCountOffset;
        this._maxPageEntrySize = Index.calcMaxPageEntrySize(this._table.getFormat());
    }

    public Table getTable() {
        return this._table;
    }

    public JetFormat getFormat() {
        return this.getTable().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getTable().getPageChannel();
    }

    public void setIndexNumber(int indexNumber) {
        this._indexNumber = indexNumber;
    }

    public int getIndexNumber() {
        return this._indexNumber;
    }

    public void setIndexType(byte indexType) {
        this._indexType = indexType;
    }

    public byte getIndexFlags() {
        return this._indexFlags;
    }

    public int getUniqueEntryCount() {
        return this._uniqueEntryCount;
    }

    public int getUniqueEntryCountOffset() {
        return this._uniqueEntryCountOffset;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isPrimaryKey() {
        return this._indexType == 1;
    }

    public boolean isForeignKey() {
        return this._indexType == 2;
    }

    public boolean shouldIgnoreNulls() {
        return (this._indexFlags & 2) != 0;
    }

    public boolean isUnique() {
        return this.isPrimaryKey() || (this._indexFlags & 1) != 0;
    }

    public List<ColumnDescriptor> getColumns() {
        return Collections.unmodifiableList(this._columns);
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    protected int getRootPageNumber() {
        return this._rootPageNumber;
    }

    protected void setReadOnly() {
        this._readOnly = true;
    }

    protected int getMaxPageEntrySize() {
        return this._maxPageEntrySize;
    }

    void addOwnedPage(int pageNumber) throws IOException {
        this._ownedPages.addPageNumber(pageNumber);
    }

    protected int getEntryCount() throws IOException {
        this.initialize();
        EntryCursor cursor = this.cursor();
        Entry endEntry = cursor.getLastEntry();
        int count = 0;
        while (!endEntry.equals(cursor.getNextEntry())) {
            ++count;
        }
        return count;
    }

    public void initialize() throws IOException {
        if (!this._initialized) {
            this.readIndexEntries();
            this._initialized = true;
        }
    }

    public void update() throws IOException {
        this.initialize();
        if (this._readOnly) {
            throw new UnsupportedOperationException("FIXME cannot write indexes of this type yet, see Database javadoc for info on enabling large index support");
        }
        this.updateImpl();
    }

    public void read(ByteBuffer tableBuffer, List<Column> availableColumns) throws IOException {
        for (int i = 0; i < 10; ++i) {
            short columnNumber = tableBuffer.getShort();
            byte colFlags = tableBuffer.get();
            if (columnNumber == -1) continue;
            Column idxCol = null;
            for (Column col : availableColumns) {
                if (col.getColumnNumber() != columnNumber) continue;
                idxCol = col;
                break;
            }
            if (idxCol == null) {
                throw new IOException("Could not find column with number " + columnNumber + " for index " + this.getName());
            }
            this._columns.add(this.newColumnDescriptor(idxCol, colFlags));
        }
        byte umapRowNum = tableBuffer.get();
        int umapPageNum = ByteUtil.get3ByteInt(tableBuffer);
        this._ownedPages = UsageMap.read(this.getTable().getDatabase(), umapPageNum, umapRowNum, false);
        this._rootPageNumber = tableBuffer.getInt();
        ByteUtil.forward(tableBuffer, this.getFormat().SKIP_BEFORE_INDEX_FLAGS);
        this._indexFlags = tableBuffer.get();
        ByteUtil.forward(tableBuffer, this.getFormat().SKIP_AFTER_INDEX_FLAGS);
    }

    public void addRow(Object[] row, RowId rowId) throws IOException {
        boolean isNullEntry;
        int nullCount = this.countNullValues(row);
        boolean bl = isNullEntry = nullCount == this._columns.size();
        if (this.shouldIgnoreNulls() && isNullEntry) {
            return;
        }
        if (this.isPrimaryKey() && nullCount > 0) {
            throw new IOException("Null value found in row " + Arrays.asList(row) + " for primary key index " + this);
        }
        this.initialize();
        Entry newEntry = new Entry(this.createEntryBytes(row), rowId);
        if (this.addEntry(newEntry, isNullEntry, row)) {
            ++this._modCount;
        } else {
            LOG.warn((Object)("Added duplicate index entry " + newEntry + " for row: " + Arrays.asList(row)));
        }
    }

    private boolean addEntry(Entry newEntry, boolean isNullEntry, Object[] row) throws IOException {
        DataPage dataPage = this.findDataPage(newEntry);
        int idx = dataPage.findEntry(newEntry);
        if (idx < 0) {
            boolean isDupeEntry;
            idx = Index.missingIndexToInsertionPoint(idx);
            Position newPos = new Position(dataPage, idx, newEntry, true);
            Position nextPos = this.getNextPosition(newPos);
            Position prevPos = this.getPreviousPosition(newPos);
            boolean bl = isDupeEntry = nextPos != null && newEntry.equalsEntryBytes(nextPos.getEntry()) || prevPos != null && newEntry.equalsEntryBytes(prevPos.getEntry());
            if (this.isUnique() && !isNullEntry && isDupeEntry) {
                throw new IOException("New row " + Arrays.asList(row) + " violates uniqueness constraint for index " + this);
            }
            if (!isDupeEntry) {
                ++this._uniqueEntryCount;
            }
            dataPage.addEntry(idx, newEntry);
            return true;
        }
        return false;
    }

    public void deleteRow(Object[] row, RowId rowId) throws IOException {
        int nullCount = this.countNullValues(row);
        if (this.shouldIgnoreNulls() && nullCount == this._columns.size()) {
            return;
        }
        this.initialize();
        Entry oldEntry = new Entry(this.createEntryBytes(row), rowId);
        if (this.removeEntry(oldEntry)) {
            ++this._modCount;
        } else {
            LOG.warn((Object)("Failed removing index entry " + oldEntry + " for row: " + Arrays.asList(row)));
        }
    }

    private boolean removeEntry(Entry oldEntry) throws IOException {
        DataPage dataPage = this.findDataPage(oldEntry);
        int idx = dataPage.findEntry(oldEntry);
        boolean doRemove = false;
        if (idx < 0) {
            EntryCursor cursor = this.cursor();
            Position tmpPos = null;
            Position endPos = cursor._lastPos;
            while (!endPos.equals(tmpPos = cursor.getAnotherPosition(true))) {
                if (!tmpPos.getEntry().getRowId().equals(oldEntry.getRowId())) continue;
                dataPage = tmpPos.getDataPage();
                idx = tmpPos.getIndex();
                doRemove = true;
                break;
            }
        } else {
            doRemove = true;
        }
        if (doRemove) {
            dataPage.removeEntry(idx);
        }
        return doRemove;
    }

    public EntryCursor cursor() throws IOException {
        return this.cursor(null, true, null, true);
    }

    public EntryCursor cursor(Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        this.initialize();
        Entry startEntry = FIRST_ENTRY;
        byte[] startEntryBytes = null;
        if (startRow != null) {
            startEntryBytes = this.createEntryBytes(startRow);
            startEntry = new Entry(startEntryBytes, startInclusive ? RowId.FIRST_ROW_ID : RowId.LAST_ROW_ID);
        }
        Entry endEntry = LAST_ENTRY;
        if (endRow != null) {
            byte[] endEntryBytes = startRow == endRow ? startEntryBytes : this.createEntryBytes(endRow);
            endEntry = new Entry(endEntryBytes, endInclusive ? RowId.LAST_ROW_ID : RowId.FIRST_ROW_ID);
        }
        return new EntryCursor(this.findEntryPosition(startEntry), this.findEntryPosition(endEntry));
    }

    private Position findEntryPosition(Entry entry) throws IOException {
        DataPage dataPage = this.findDataPage(entry);
        int idx = dataPage.findEntry(entry);
        boolean between = false;
        if (idx < 0) {
            idx = Index.missingIndexToInsertionPoint(idx);
            between = true;
        }
        return new Position(dataPage, idx, entry, between);
    }

    private Position getNextPosition(Position curPos) throws IOException {
        int nextIdx = curPos.getNextIndex();
        Position nextPos = null;
        if (nextIdx < curPos.getDataPage().getEntries().size()) {
            nextPos = new Position(curPos.getDataPage(), nextIdx);
        } else {
            int nextPageNumber = curPos.getDataPage().getNextPageNumber();
            DataPage nextDataPage = null;
            while (nextPageNumber != 0) {
                DataPage dp = this.getDataPage(nextPageNumber);
                if (!dp.isEmpty()) {
                    nextDataPage = dp;
                    break;
                }
                nextPageNumber = dp.getNextPageNumber();
            }
            if (nextDataPage != null) {
                nextPos = new Position(nextDataPage, 0);
            }
        }
        return nextPos;
    }

    private Position getPreviousPosition(Position curPos) throws IOException {
        int prevIdx = curPos.getPrevIndex();
        Position prevPos = null;
        if (prevIdx >= 0) {
            prevPos = new Position(curPos.getDataPage(), prevIdx);
        } else {
            int prevPageNumber = curPos.getDataPage().getPrevPageNumber();
            DataPage prevDataPage = null;
            while (prevPageNumber != 0) {
                DataPage dp = this.getDataPage(prevPageNumber);
                if (!dp.isEmpty()) {
                    prevDataPage = dp;
                    break;
                }
                prevPageNumber = dp.getPrevPageNumber();
            }
            if (prevDataPage != null) {
                prevPos = new Position(prevDataPage, prevDataPage.getEntries().size() - 1);
            }
        }
        return prevPos;
    }

    protected static int missingIndexToInsertionPoint(int idx) {
        return -(idx + 1);
    }

    public Object[] constructIndexRowFromEntry(Object ... values) {
        if (values.length != this._columns.size()) {
            throw new IllegalArgumentException("Wrong number of column values given " + values.length + ", expected " + this._columns.size());
        }
        int valIdx = 0;
        Object[] idxRow = new Object[this.getTable().getColumnCount()];
        for (ColumnDescriptor col : this._columns) {
            idxRow[col.getColumnIndex()] = values[valIdx++];
        }
        return idxRow;
    }

    public Object[] constructIndexRow(String colName, Object value) {
        return this.constructIndexRow(Collections.singletonMap(colName, value));
    }

    public Object[] constructIndexRow(Map<String, Object> row) {
        for (ColumnDescriptor col : this._columns) {
            if (row.containsKey(col.getName())) continue;
            return null;
        }
        Object[] idxRow = new Object[this.getTable().getColumnCount()];
        for (ColumnDescriptor col : this._columns) {
            idxRow[col.getColumnIndex()] = row.get(col.getName());
        }
        return idxRow;
    }

    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("\tName: (" + this._table.getName() + ") " + this._name);
        rtn.append("\n\tNumber: " + this._indexNumber);
        rtn.append("\n\tPage number: " + this._rootPageNumber);
        rtn.append("\n\tIs Primary Key: " + this.isPrimaryKey());
        rtn.append("\n\tIs Foreign Key: " + this.isForeignKey());
        rtn.append("\n\tIs Unique: " + this.isUnique());
        rtn.append("\n\tIgnore Nulls: " + this.shouldIgnoreNulls());
        rtn.append("\n\tColumns: " + this._columns);
        rtn.append("\n\tInitialized: " + this._initialized);
        if (this._initialized) {
            try {
                rtn.append("\n\tEntryCount: " + this.getEntryCount());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        rtn.append("\n\n");
        return rtn.toString();
    }

    @Override
    public int compareTo(Index other) {
        if (this._indexNumber > other.getIndexNumber()) {
            return 1;
        }
        if (this._indexNumber < other.getIndexNumber()) {
            return -1;
        }
        return 0;
    }

    protected void writeDataPage(DataPage dataPage) throws IOException {
        if (dataPage.getCompressedEntrySize() > this._maxPageEntrySize) {
            if (this instanceof SimpleIndex) {
                throw new UnsupportedOperationException("FIXME cannot write large index yet, see Database javadoc for info on enabling large index support");
            }
            throw new IllegalStateException("data page is too large");
        }
        ByteBuffer buffer = this._indexBufferH.getPageBuffer(this.getPageChannel());
        buffer.put(dataPage.isLeaf() ? (byte)4 : 3);
        buffer.put((byte)1);
        buffer.putShort((short)0);
        buffer.putInt(this.getTable().getTableDefPageNumber());
        buffer.putInt(0);
        buffer.putInt(dataPage.getPrevPageNumber());
        buffer.putInt(dataPage.getNextPageNumber());
        buffer.putInt(dataPage.getChildTailPageNumber());
        byte[] entryPrefix = dataPage.getEntryPrefix();
        buffer.putShort((short)entryPrefix.length);
        buffer.put((byte)0);
        byte[] entryMask = new byte[this.getFormat().SIZE_INDEX_ENTRY_MASK];
        int totalSize = entryPrefix.length;
        for (Entry entry : dataPage.getEntries()) {
            int idx;
            int n = idx = (totalSize += entry.size() - entryPrefix.length) / 8;
            entryMask[n] = (byte)(entryMask[n] | 1 << totalSize % 8);
        }
        buffer.put(entryMask);
        buffer.put(entryPrefix);
        for (Entry entry : dataPage.getEntries()) {
            entry.write(buffer, entryPrefix);
        }
        buffer.putShort(2, (short)(this.getFormat().PAGE_SIZE - buffer.position()));
        this.getPageChannel().writePage(buffer, dataPage.getPageNumber());
    }

    protected void readDataPage(DataPage dataPage) throws IOException {
        ByteBuffer buffer = this._indexBufferH.getPageBuffer(this.getPageChannel());
        this.getPageChannel().readPage(buffer, dataPage.getPageNumber());
        boolean isLeaf = Index.isLeafPage(buffer);
        dataPage.setLeaf(isLeaf);
        int entryPrefixLength = ByteUtil.getUnsignedShort(buffer, this.getFormat().OFFSET_INDEX_COMPRESSED_BYTE_COUNT);
        int entryMaskLength = this.getFormat().SIZE_INDEX_ENTRY_MASK;
        int entryMaskPos = this.getFormat().OFFSET_INDEX_ENTRY_MASK;
        int entryPos = entryMaskPos + entryMaskLength;
        int lastStart = 0;
        int totalEntrySize = 0;
        byte[] entryPrefix = null;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        TempBufferHolder tmpEntryBufferH = TempBufferHolder.newHolder(TempBufferHolder.Type.HARD, true, ByteOrder.BIG_ENDIAN);
        Entry prevEntry = FIRST_ENTRY;
        for (int i = 0; i < entryMaskLength; ++i) {
            byte entryMask = buffer.get(entryMaskPos + i);
            for (int j = 0; j < 8; ++j) {
                if ((entryMask & 1 << j) == 0) continue;
                int length = i * 8 + j - lastStart;
                buffer.position(entryPos + lastStart);
                ByteBuffer curEntryBuffer = buffer;
                int curEntryLen = length;
                if (entryPrefix != null) {
                    curEntryBuffer = this.getTempEntryBuffer(buffer, length, entryPrefix, tmpEntryBufferH);
                    curEntryLen += entryPrefix.length;
                }
                totalEntrySize += curEntryLen;
                Entry entry = this.newEntry(curEntryBuffer, curEntryLen, isLeaf);
                if (prevEntry.compareTo(entry) >= 0) {
                    throw new IOException("Unexpected order in index entries, " + prevEntry + " >= " + entry);
                }
                entries.add(entry);
                if (entries.size() == 1 && entryPrefixLength > 0) {
                    entryPrefix = new byte[entryPrefixLength];
                    buffer.position(entryPos + lastStart);
                    buffer.get(entryPrefix);
                }
                lastStart += length;
                prevEntry = entry;
            }
        }
        dataPage.setEntryPrefix(entryPrefix != null ? entryPrefix : EMPTY_PREFIX);
        dataPage.setEntries(entries);
        dataPage.setTotalEntrySize(totalEntrySize);
        int prevPageNumber = buffer.getInt(this.getFormat().OFFSET_PREV_INDEX_PAGE);
        int nextPageNumber = buffer.getInt(this.getFormat().OFFSET_NEXT_INDEX_PAGE);
        int childTailPageNumber = buffer.getInt(this.getFormat().OFFSET_CHILD_TAIL_INDEX_PAGE);
        dataPage.setPrevPageNumber(prevPageNumber);
        dataPage.setNextPageNumber(nextPageNumber);
        dataPage.setChildTailPageNumber(childTailPageNumber);
    }

    private Entry newEntry(ByteBuffer buffer, int entryLength, boolean isLeaf) throws IOException {
        if (isLeaf) {
            return new Entry(buffer, entryLength);
        }
        return new NodeEntry(buffer, entryLength);
    }

    private ByteBuffer getTempEntryBuffer(ByteBuffer indexPage, int entryLen, byte[] valuePrefix, TempBufferHolder tmpEntryBufferH) {
        ByteBuffer tmpEntryBuffer = tmpEntryBufferH.getBuffer(this.getPageChannel(), valuePrefix.length + entryLen);
        tmpEntryBuffer.put(valuePrefix);
        tmpEntryBuffer.put(indexPage.array(), indexPage.position(), entryLen);
        tmpEntryBuffer.flip();
        return tmpEntryBuffer;
    }

    private static boolean isLeafPage(ByteBuffer buffer) throws IOException {
        byte pageType = buffer.get(0);
        if (pageType == 4) {
            return true;
        }
        if (pageType == 3) {
            return false;
        }
        throw new IOException("Unexpected page type " + pageType);
    }

    private int countNullValues(Object[] values) {
        if (values == null) {
            return this._columns.size();
        }
        int nullCount = 0;
        for (ColumnDescriptor col : this._columns) {
            Object value;
            if (!col.isNullValue(value = values[col.getColumnIndex()])) continue;
            ++nullCount;
        }
        return nullCount;
    }

    private byte[] createEntryBytes(Object[] values) throws IOException {
        if (values == null) {
            return null;
        }
        if (this._entryBuffer == null) {
            this._entryBuffer = new ByteUtil.ByteStream();
        }
        this._entryBuffer.reset();
        for (ColumnDescriptor col : this._columns) {
            Object value = values[col.getColumnIndex()];
            if (Column.isRawData(value)) continue;
            col.writeValue(value, this._entryBuffer);
        }
        return this._entryBuffer.toByteArray();
    }

    protected abstract void updateImpl() throws IOException;

    protected abstract void readIndexEntries() throws IOException;

    protected abstract DataPage findDataPage(Entry var1) throws IOException;

    protected abstract DataPage getDataPage(int var1) throws IOException;

    private static byte[] flipFirstBitInByte(byte[] value, int index) {
        value[index] = (byte)(value[index] ^ 0x80);
        return value;
    }

    private static byte[] flipBytes(byte[] value) {
        return Index.flipBytes(value, 0, value.length);
    }

    private static byte[] flipBytes(byte[] value, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            value[i] = ~value[i];
        }
        return value;
    }

    private static byte[] encodeNumberColumnValue(Object value, Column column) throws IOException {
        return column.write(value, 0, ByteOrder.BIG_ENDIAN).array();
    }

    private static void writeNonNullIndexTextValue(Object value, ByteUtil.ByteStream bout, boolean isAscending) throws IOException {
        boolean hasCrazyCodes;
        String str = ((Object)Column.toCharSequence(value)).toString();
        if (str.length() > 255) {
            str = str.substring(0, 255);
        }
        int prevLength = bout.getLength();
        ByteUtil.ByteStream extraCodes = null;
        ByteUtil.ByteStream unprintableCodes = null;
        ByteUtil.ByteStream crazyCodes = null;
        int charOffset = 0;
        for (int i = 0; i < str.length(); ++i) {
            byte crazyFlag;
            char c = str.charAt(i);
            IndexCodes.CharHandler ch = IndexCodes.getCharHandler(c);
            int curCharOffset = charOffset++;
            byte[] bytes = ch.getInlineBytes();
            if (bytes != null) {
                bout.write(bytes);
            }
            if (ch.getType() == IndexCodes.Type.SIMPLE) continue;
            bytes = ch.getExtraBytes();
            byte extraCodeModifier = ch.getExtraByteModifier();
            if (bytes != null || extraCodeModifier != 0) {
                if (extraCodes == null) {
                    extraCodes = new ExtraCodesStream(str.length());
                }
                Index.writeExtraCodes(curCharOffset, bytes, extraCodeModifier, (ExtraCodesStream)extraCodes);
            }
            if ((bytes = ch.getUnprintableBytes()) != null) {
                if (unprintableCodes == null) {
                    unprintableCodes = new ByteUtil.ByteStream();
                }
                Index.writeUnprintableCodes(curCharOffset, bytes, unprintableCodes, (ExtraCodesStream)extraCodes);
            }
            if ((crazyFlag = ch.getCrazyFlag()) == 0) continue;
            if (crazyCodes == null) {
                crazyCodes = new ByteUtil.ByteStream();
            }
            crazyCodes.write(crazyFlag);
        }
        bout.write(1);
        boolean hasExtraCodes = Index.trimExtraCodes(extraCodes, (byte)0, (byte)2);
        boolean hasUnprintableCodes = unprintableCodes != null;
        boolean bl = hasCrazyCodes = crazyCodes != null;
        if (hasExtraCodes || hasUnprintableCodes || hasCrazyCodes) {
            if (hasExtraCodes) {
                extraCodes.writeTo(bout);
            }
            if (hasCrazyCodes || hasUnprintableCodes) {
                bout.write(1);
                bout.write(1);
                if (hasCrazyCodes) {
                    Index.writeCrazyCodes(crazyCodes, bout);
                    if (hasUnprintableCodes) {
                        bout.write(-1);
                    }
                }
                if (hasUnprintableCodes) {
                    bout.write(1);
                    unprintableCodes.writeTo(bout);
                }
            }
        }
        if (!isAscending) {
            bout.write(0);
            Index.flipBytes(bout.getBytes(), prevLength, bout.getLength() - prevLength);
        }
        bout.write(0);
    }

    private static void writeExtraCodes(int charOffset, byte[] bytes, byte extraCodeModifier, ExtraCodesStream extraCodes) throws IOException {
        int numChars = extraCodes.getNumChars();
        if (numChars < charOffset) {
            int fillChars = charOffset - numChars;
            extraCodes.writeFill(fillChars, (byte)2);
            extraCodes.incrementNumChars(fillChars);
        }
        if (bytes != null) {
            extraCodes.write(bytes);
            extraCodes.incrementNumChars(1);
        } else {
            int lastIdx = extraCodes.getLength() - 1;
            if (lastIdx >= 0) {
                byte lastByte = extraCodes.get(lastIdx);
                lastByte = (byte)(lastByte + extraCodeModifier);
                extraCodes.set(lastIdx, lastByte);
            } else {
                extraCodes.write(extraCodeModifier);
                extraCodes.setUnprintablePrefixLen(1);
            }
        }
    }

    private static boolean trimExtraCodes(ByteUtil.ByteStream extraCodes, byte minTrimCode, byte maxTrimCode) throws IOException {
        if (extraCodes == null) {
            return false;
        }
        extraCodes.trimTrailing(minTrimCode, maxTrimCode);
        return extraCodes.getLength() > 0;
    }

    private static void writeUnprintableCodes(int charOffset, byte[] bytes, ByteUtil.ByteStream unprintableCodes, ExtraCodesStream extraCodes) throws IOException {
        int unprintCharOffset = charOffset;
        if (extraCodes != null) {
            unprintCharOffset = extraCodes.getLength() + (charOffset - extraCodes.getNumChars()) - extraCodes.getUnprintablePrefixLen();
        }
        int offset = 7 + 4 * unprintCharOffset | 0x8000;
        unprintableCodes.write(offset >> 8 & 0xFF);
        unprintableCodes.write(offset & 0xFF);
        unprintableCodes.write(6);
        unprintableCodes.write(bytes);
    }

    private static void writeCrazyCodes(ByteUtil.ByteStream crazyCodes, ByteUtil.ByteStream bout) throws IOException {
        Index.trimExtraCodes(crazyCodes, (byte)3, (byte)3);
        if (crazyCodes.getLength() > 0) {
            int curByte = -128;
            int idx = 0;
            for (int i = 0; i < crazyCodes.getLength(); ++i) {
                byte nextByte = crazyCodes.get(i);
                nextByte = (byte)(nextByte << (2 - idx) * 2);
                curByte = (byte)(curByte | nextByte);
                if (++idx != 3) continue;
                bout.write(curByte);
                curByte = -128;
                idx = 0;
            }
            if (idx > 0) {
                bout.write(curByte);
            }
        }
        bout.write(IndexCodes.CRAZY_CODES_SUFFIX);
    }

    private static Entry createSpecialEntry(RowId rowId) {
        return new Entry((byte[])null, rowId);
    }

    private ColumnDescriptor newColumnDescriptor(Column col, byte flags) throws IOException {
        switch (col.getType()) {
            case TEXT: 
            case MEMO: {
                return new TextColumnDescriptor(col, flags);
            }
            case INT: 
            case LONG: 
            case MONEY: {
                return new IntegerColumnDescriptor(col, flags);
            }
            case FLOAT: 
            case DOUBLE: 
            case SHORT_DATE_TIME: {
                return new FloatingPointColumnDescriptor(col, flags);
            }
            case NUMERIC: {
                return new FixedPointColumnDescriptor(col, flags);
            }
            case BYTE: {
                return new ByteColumnDescriptor(col, flags);
            }
            case BOOLEAN: {
                return new BooleanColumnDescriptor(col, flags);
            }
            case GUID: {
                return new GuidColumnDescriptor(col, flags);
            }
        }
        this.setReadOnly();
        return new ReadOnlyColumnDescriptor(col, flags);
    }

    private static EntryType determineEntryType(byte[] entryBytes, RowId rowId) {
        if (entryBytes != null) {
            return rowId.getType() == RowId.Type.NORMAL ? EntryType.NORMAL : (rowId.getType() == RowId.Type.ALWAYS_FIRST ? EntryType.FIRST_VALID : EntryType.LAST_VALID);
        }
        if (!rowId.isValid()) {
            return rowId.getType() == RowId.Type.ALWAYS_FIRST ? EntryType.ALWAYS_FIRST : EntryType.ALWAYS_LAST;
        }
        throw new IllegalArgumentException("Values was null for valid entry");
    }

    private static int calcMaxPageEntrySize(JetFormat format) {
        int pageDataSize = format.PAGE_SIZE - (format.OFFSET_INDEX_ENTRY_MASK + format.SIZE_INDEX_ENTRY_MASK);
        int entryMaskSize = format.SIZE_INDEX_ENTRY_MASK * 8;
        return Math.min(pageDataSize, entryMaskSize);
    }

    private static final class ExtraCodesStream
    extends ByteUtil.ByteStream {
        private int _numChars;
        private int _unprintablePrefixLen;

        private ExtraCodesStream(int length) {
            super(length);
        }

        public int getNumChars() {
            return this._numChars;
        }

        public void incrementNumChars(int inc) {
            this._numChars += inc;
        }

        public int getUnprintablePrefixLen() {
            return this._unprintablePrefixLen;
        }

        public void setUnprintablePrefixLen(int len) {
            this._unprintablePrefixLen = len;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class DataPage {
        protected DataPage() {
        }

        public abstract int getPageNumber();

        public abstract boolean isLeaf();

        public abstract void setLeaf(boolean var1);

        public abstract int getPrevPageNumber();

        public abstract void setPrevPageNumber(int var1);

        public abstract int getNextPageNumber();

        public abstract void setNextPageNumber(int var1);

        public abstract int getChildTailPageNumber();

        public abstract void setChildTailPageNumber(int var1);

        public abstract int getTotalEntrySize();

        public abstract void setTotalEntrySize(int var1);

        public abstract byte[] getEntryPrefix();

        public abstract void setEntryPrefix(byte[] var1);

        public abstract List<Entry> getEntries();

        public abstract void setEntries(List<Entry> var1);

        public abstract void addEntry(int var1, Entry var2) throws IOException;

        public abstract void removeEntry(int var1) throws IOException;

        public final boolean isEmpty() {
            return this.getEntries().isEmpty();
        }

        public final int getCompressedEntrySize() {
            return this.getTotalEntrySize() - this.getEntryPrefix().length * (this.getEntries().size() - 1);
        }

        public final int findEntry(Entry entry) {
            return Collections.binarySearch(this.getEntries(), entry);
        }

        public final int hashCode() {
            return this.getPageNumber();
        }

        public final boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.getPageNumber() == ((DataPage)o).getPageNumber();
        }

        public final String toString() {
            List<Entry> entries = this.getEntries();
            return (this.isLeaf() ? "Leaf" : "Node") + "DataPage[" + this.getPageNumber() + "] " + this.getPrevPageNumber() + ", " + this.getNextPageNumber() + ", (" + this.getChildTailPageNumber() + "), " + (this.isLeaf() && !entries.isEmpty() ? "[" + entries.get(0) + ", " + entries.get(entries.size() - 1) + "]" : entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Position
    implements Comparable<Position> {
        private final DataPage _dataPage;
        private final int _idx;
        private final Entry _entry;
        private final boolean _between;

        private Position(DataPage dataPage, int idx) {
            this(dataPage, idx, dataPage.getEntries().get(idx), false);
        }

        private Position(DataPage dataPage, int idx, Entry entry, boolean between) {
            this._dataPage = dataPage;
            this._idx = idx;
            this._entry = entry;
            this._between = between;
        }

        public DataPage getDataPage() {
            return this._dataPage;
        }

        public int getIndex() {
            return this._idx;
        }

        public int getNextIndex() {
            return this._between ? this._idx : this._idx + 1;
        }

        public int getPrevIndex() {
            return this._idx - 1;
        }

        public Entry getEntry() {
            return this._entry;
        }

        public boolean isBetween() {
            return this._between;
        }

        public boolean equalsEntry(Entry entry) {
            return this._entry.equals(entry);
        }

        @Override
        public int compareTo(Position other) {
            if (this == other) {
                return 0;
            }
            if (this._dataPage.equals(other._dataPage)) {
                int idxCmp;
                int n = this._idx < other._idx ? -1 : (this._idx > other._idx ? 1 : (this._between == other._between ? 0 : (idxCmp = this._between ? -1 : 1)));
                if (idxCmp != 0) {
                    return idxCmp;
                }
            }
            return this._entry.compareTo(other._entry);
        }

        public int hashCode() {
            return this._entry.hashCode();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.compareTo((Position)o) == 0;
        }

        public String toString() {
            return "Page = " + this._dataPage.getPageNumber() + ", Idx = " + this._idx + ", Entry = " + this._entry + ", Between = " + this._between;
        }
    }

    public final class EntryCursor {
        private final DirHandler _forwardDirHandler = new ForwardDirHandler();
        private final DirHandler _reverseDirHandler = new ReverseDirHandler();
        private Position _firstPos;
        private Position _lastPos;
        private Position _curPos;
        private Position _prevPos;
        private int _lastModCount;

        private EntryCursor(Position firstPos, Position lastPos) {
            this._firstPos = firstPos;
            this._lastPos = lastPos;
            this._lastModCount = this.getIndexModCount();
            this.reset();
        }

        private DirHandler getDirHandler(boolean moveForward) {
            return moveForward ? this._forwardDirHandler : this._reverseDirHandler;
        }

        public Index getIndex() {
            return Index.this;
        }

        private int getIndexModCount() {
            return Index.this._modCount;
        }

        public Entry getFirstEntry() {
            return this._firstPos.getEntry();
        }

        public Entry getLastEntry() {
            return this._lastPos.getEntry();
        }

        public boolean isUpToDate() {
            return this.getIndexModCount() == this._lastModCount;
        }

        public void reset() {
            this.beforeFirst();
        }

        public void beforeFirst() {
            this.reset(true);
        }

        public void afterLast() {
            this.reset(false);
        }

        protected void reset(boolean moveForward) {
            this._prevPos = this._curPos = this.getDirHandler(moveForward).getBeginningPosition();
        }

        public void beforeEntry(Object[] row) throws IOException {
            this.restorePosition(new Entry(Index.this.createEntryBytes(row), RowId.FIRST_ROW_ID));
        }

        public void afterEntry(Object[] row) throws IOException {
            this.restorePosition(new Entry(Index.this.createEntryBytes(row), RowId.LAST_ROW_ID));
        }

        public Entry getNextEntry() throws IOException {
            return this.getAnotherPosition(true).getEntry();
        }

        public Entry getPreviousEntry() throws IOException {
            return this.getAnotherPosition(false).getEntry();
        }

        protected void restorePosition(Entry curEntry) throws IOException {
            this.restorePosition(curEntry, this._curPos.getEntry());
        }

        protected void restorePosition(Entry curEntry, Entry prevEntry) throws IOException {
            if (!this._curPos.equalsEntry(curEntry) || !this._prevPos.equalsEntry(prevEntry)) {
                if (!this.isUpToDate()) {
                    this.updateBounds();
                    this._lastModCount = this.getIndexModCount();
                }
                this._prevPos = this.updatePosition(prevEntry);
                this._curPos = this.updatePosition(curEntry);
            } else {
                this.checkForModification();
            }
        }

        private Position getAnotherPosition(boolean moveForward) throws IOException {
            DirHandler handler = this.getDirHandler(moveForward);
            if (this._curPos.equals(handler.getEndPosition())) {
                if (!this.isUpToDate()) {
                    this.restorePosition(this._prevPos.getEntry());
                } else {
                    return this._curPos;
                }
            }
            this.checkForModification();
            this._prevPos = this._curPos;
            this._curPos = handler.getAnotherPosition(this._curPos);
            return this._curPos;
        }

        private void checkForModification() throws IOException {
            if (!this.isUpToDate()) {
                this.updateBounds();
                this._prevPos = this.updatePosition(this._prevPos.getEntry());
                this._curPos = this.updatePosition(this._curPos.getEntry());
                this._lastModCount = this.getIndexModCount();
            }
        }

        private Position updatePosition(Entry entry) throws IOException {
            if (!entry.isValid()) {
                if (this._firstPos.equalsEntry(entry)) {
                    return this._firstPos;
                }
                if (this._lastPos.equalsEntry(entry)) {
                    return this._lastPos;
                }
                throw new IllegalArgumentException("Invalid entry given " + entry);
            }
            Position pos = Index.this.findEntryPosition(entry);
            if (pos.compareTo(this._lastPos) >= 0) {
                return this._lastPos;
            }
            if (pos.compareTo(this._firstPos) <= 0) {
                return this._firstPos;
            }
            return pos;
        }

        private void updateBounds() throws IOException {
            this._firstPos = Index.this.findEntryPosition(this._firstPos.getEntry());
            this._lastPos = Index.this.findEntryPosition(this._lastPos.getEntry());
        }

        public String toString() {
            return this.getClass().getSimpleName() + " CurPosition " + this._curPos + ", PrevPosition " + this._prevPos;
        }

        private final class ReverseDirHandler
        extends DirHandler {
            private ReverseDirHandler() {
            }

            public Position getAnotherPosition(Position curPos) throws IOException {
                Position newPos = Index.this.getPreviousPosition(curPos);
                if (newPos == null || newPos.compareTo(EntryCursor.this._firstPos) <= 0) {
                    newPos = EntryCursor.this._firstPos;
                }
                return newPos;
            }

            public Position getBeginningPosition() {
                return EntryCursor.this._lastPos;
            }

            public Position getEndPosition() {
                return EntryCursor.this._firstPos;
            }
        }

        private final class ForwardDirHandler
        extends DirHandler {
            private ForwardDirHandler() {
            }

            public Position getAnotherPosition(Position curPos) throws IOException {
                Position newPos = Index.this.getNextPosition(curPos);
                if (newPos == null || newPos.compareTo(EntryCursor.this._lastPos) >= 0) {
                    newPos = EntryCursor.this._lastPos;
                }
                return newPos;
            }

            public Position getBeginningPosition() {
                return EntryCursor.this._firstPos;
            }

            public Position getEndPosition() {
                return EntryCursor.this._lastPos;
            }
        }

        private abstract class DirHandler {
            private DirHandler() {
            }

            public abstract Position getAnotherPosition(Position var1) throws IOException;

            public abstract Position getBeginningPosition();

            public abstract Position getEndPosition();
        }
    }

    private static final class NodeEntry
    extends Entry {
        private final Integer _subPageNumber;

        private NodeEntry(byte[] entryBytes, RowId rowId, EntryType type, Integer subPageNumber) {
            super(entryBytes, rowId, type);
            this._subPageNumber = subPageNumber;
        }

        private NodeEntry(ByteBuffer buffer, int entryLen) throws IOException {
            super(buffer, entryLen, 4);
            this._subPageNumber = ByteUtil.getInt(buffer, ByteOrder.BIG_ENDIAN);
        }

        public Integer getSubPageNumber() {
            return this._subPageNumber;
        }

        public boolean isLeafEntry() {
            return false;
        }

        protected int size() {
            return super.size() + 4;
        }

        protected void write(ByteBuffer buffer, byte[] prefix) throws IOException {
            super.write(buffer, prefix);
            ByteUtil.putInt(buffer, this._subPageNumber, ByteOrder.BIG_ENDIAN);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.compareTo((Entry)o) == 0 && this.getSubPageNumber().equals(((Entry)o).getSubPageNumber());
        }

        public String toString() {
            return "Node RowId = " + this.getRowId() + ", SubPage = " + this._subPageNumber + this.entryBytesToString() + "\n";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry
    implements Comparable<Entry> {
        private final RowId _rowId;
        private final byte[] _entryBytes;
        private final EntryType _type;

        private Entry(byte[] entryBytes, RowId rowId, EntryType type) {
            this._rowId = rowId;
            this._entryBytes = entryBytes;
            this._type = type;
        }

        private Entry(byte[] entryBytes, RowId rowId) {
            this(entryBytes, rowId, Index.determineEntryType(entryBytes, rowId));
        }

        private Entry(ByteBuffer buffer, int entryLen) throws IOException {
            this(buffer, entryLen, 0);
        }

        private Entry(ByteBuffer buffer, int entryLen, int extraTrailingLen) throws IOException {
            int colEntryLen = entryLen - (4 + extraTrailingLen);
            this._entryBytes = new byte[colEntryLen];
            buffer.get(this._entryBytes);
            int page = ByteUtil.get3ByteInt(buffer, ByteOrder.BIG_ENDIAN);
            int row = ByteUtil.getUnsignedByte(buffer);
            this._rowId = new RowId(page, row);
            this._type = EntryType.NORMAL;
        }

        public RowId getRowId() {
            return this._rowId;
        }

        public EntryType getType() {
            return this._type;
        }

        public Integer getSubPageNumber() {
            throw new UnsupportedOperationException();
        }

        public boolean isLeafEntry() {
            return true;
        }

        public boolean isValid() {
            return this._entryBytes != null;
        }

        protected final byte[] getEntryBytes() {
            return this._entryBytes;
        }

        protected int size() {
            return this._entryBytes.length + 4;
        }

        protected void write(ByteBuffer buffer, byte[] prefix) throws IOException {
            if (prefix.length <= this._entryBytes.length) {
                buffer.put(this._entryBytes, prefix.length, this._entryBytes.length - prefix.length);
                ByteUtil.put3ByteInt(buffer, this.getRowId().getPageNumber(), ByteOrder.BIG_ENDIAN);
            } else if (prefix.length <= this._entryBytes.length + 3) {
                ByteBuffer tmp = ByteBuffer.allocate(3);
                ByteUtil.put3ByteInt(tmp, this.getRowId().getPageNumber(), ByteOrder.BIG_ENDIAN);
                tmp.flip();
                tmp.position(prefix.length - this._entryBytes.length);
                buffer.put(tmp);
            } else {
                throw new IllegalStateException("prefix should never be this long");
            }
            buffer.put((byte)this.getRowId().getRowNumber());
        }

        protected final String entryBytesToString() {
            return this.isValid() ? ", Bytes = " + ByteUtil.toHexString(ByteBuffer.wrap(this._entryBytes), this._entryBytes.length) : "";
        }

        public String toString() {
            return "RowId = " + this._rowId + this.entryBytesToString() + "\n";
        }

        public int hashCode() {
            return this._rowId.hashCode();
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.compareTo((Entry)o) == 0;
        }

        public boolean equalsEntryBytes(Entry o) {
            return BYTE_CODE_COMPARATOR.compare(this._entryBytes, o._entryBytes) == 0;
        }

        @Override
        public int compareTo(Entry other) {
            if (this == other) {
                return 0;
            }
            if (this.isValid() && other.isValid()) {
                int entryCmp = BYTE_CODE_COMPARATOR.compare(this._entryBytes, other._entryBytes);
                if (entryCmp != 0) {
                    return entryCmp;
                }
            } else {
                int typeCmp = this._type.compareTo(other._type);
                if (typeCmp != 0) {
                    return typeCmp;
                }
            }
            return this._rowId.compareTo(other.getRowId());
        }

        protected Entry asNodeEntry(Integer subPageNumber) {
            return new NodeEntry(this._entryBytes, this._rowId, this._type, subPageNumber);
        }
    }

    private static final class ReadOnlyColumnDescriptor
    extends ColumnDescriptor {
        private ReadOnlyColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            throw new UnsupportedOperationException("should not be called");
        }
    }

    private static final class GuidColumnDescriptor
    extends ColumnDescriptor {
        private GuidColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            byte[] valueBytes = Index.encodeNumberColumnValue(value, this.getColumn());
            if (!this.isAscending()) {
                Index.flipBytes(valueBytes);
            }
            bout.write(valueBytes, 0, 8);
            bout.write(9);
            bout.write(valueBytes, 8, 8);
            bout.write(this.isAscending() ? 8 : -9);
        }
    }

    private static final class TextColumnDescriptor
    extends ColumnDescriptor {
        private TextColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            Index.writeNonNullIndexTextValue(value, bout, this.isAscending());
        }
    }

    private static final class BooleanColumnDescriptor
    extends ColumnDescriptor {
        private BooleanColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected boolean isNullValue(Object value) {
            return false;
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            bout.write(Column.toBooleanValue(value) ? (this.isAscending() ? 0 : -1) : (this.isAscending() ? -1 : 0));
        }
    }

    private static final class ByteColumnDescriptor
    extends ColumnDescriptor {
        private ByteColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            byte[] valueBytes = Index.encodeNumberColumnValue(value, this.getColumn());
            if (!this.isAscending()) {
                Index.flipBytes(valueBytes);
            }
            bout.write(valueBytes);
        }
    }

    private static final class FixedPointColumnDescriptor
    extends ColumnDescriptor {
        private FixedPointColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            byte[] valueBytes = Index.encodeNumberColumnValue(value, this.getColumn());
            boolean isNegative = (valueBytes[0] & 0x80) != 0;
            boolean alwaysRevFirstByte = this.getColumn().getFormat().REVERSE_FIRST_BYTE_IN_DESC_NUMERIC_INDEXES;
            if (alwaysRevFirstByte) {
                valueBytes[0] = -1;
            }
            if (isNegative == this.isAscending()) {
                Index.flipBytes(valueBytes);
            }
            if (!alwaysRevFirstByte) {
                valueBytes[0] = isNegative ? 0 : -1;
            }
            bout.write(valueBytes);
        }
    }

    private static final class FloatingPointColumnDescriptor
    extends ColumnDescriptor {
        private FloatingPointColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            boolean isNegative;
            byte[] valueBytes = Index.encodeNumberColumnValue(value, this.getColumn());
            boolean bl = isNegative = (valueBytes[0] & 0x80) != 0;
            if (!isNegative) {
                Index.flipFirstBitInByte(valueBytes, 0);
            }
            if (isNegative == this.isAscending()) {
                Index.flipBytes(valueBytes);
            }
            bout.write(valueBytes);
        }
    }

    private static final class IntegerColumnDescriptor
    extends ColumnDescriptor {
        private IntegerColumnDescriptor(Column column, byte flags) throws IOException {
            super(column, flags);
        }

        protected void writeNonNullValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            byte[] valueBytes = Index.encodeNumberColumnValue(value, this.getColumn());
            Index.flipFirstBitInByte(valueBytes, 0);
            if (!this.isAscending()) {
                Index.flipBytes(valueBytes);
            }
            bout.write(valueBytes);
        }
    }

    public static abstract class ColumnDescriptor {
        private final Column _column;
        private final byte _flags;

        private ColumnDescriptor(Column column, byte flags) throws IOException {
            this._column = column;
            this._flags = flags;
        }

        public Column getColumn() {
            return this._column;
        }

        public byte getFlags() {
            return this._flags;
        }

        public boolean isAscending() {
            return (this.getFlags() & 1) != 0;
        }

        public int getColumnIndex() {
            return this.getColumn().getColumnIndex();
        }

        public String getName() {
            return this.getColumn().getName();
        }

        protected boolean isNullValue(Object value) {
            return value == null;
        }

        protected final void writeValue(Object value, ByteUtil.ByteStream bout) throws IOException {
            if (this.isNullValue(value)) {
                bout.write(IndexCodes.getNullEntryFlag(this.isAscending()));
                return;
            }
            bout.write(IndexCodes.getStartEntryFlag(this.isAscending()));
            this.writeNonNullValue(value, bout);
        }

        protected abstract void writeNonNullValue(Object var1, ByteUtil.ByteStream var2) throws IOException;

        public String toString() {
            return "ColumnDescriptor " + this.getColumn() + "\nflags: " + this.getFlags();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntryType {
        ALWAYS_FIRST,
        FIRST_VALID,
        NORMAL,
        LAST_VALID,
        ALWAYS_LAST;

    }
}

