/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Database;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JetFormat {
    public static final int MAX_RECORD_SIZE = 1900;
    public static final short TEXT_FIELD_UNIT_SIZE = 2;
    public static final short TEXT_FIELD_MAX_LENGTH = 510;
    private static final long OFFSET_VERSION = 20L;
    private static final byte CODE_VERSION_3 = 0;
    private static final byte CODE_VERSION_4 = 1;
    private static final byte CODE_VERSION_5 = 2;
    private static final byte[] ACCESS_VERSION_2000 = new byte[]{48, 0, 56, 0, 46, 0, 53, 0, 48, 0};
    private static final byte[] ACCESS_VERSION_2003 = new byte[]{48, 0, 57, 0, 46, 0, 53, 0, 48, 0};
    private final String _name;
    public final boolean READ_ONLY;
    public final boolean INDEXES_SUPPORTED;
    public final int PAGE_SIZE;
    public final long MAX_DATABASE_SIZE;
    public final int MAX_ROW_SIZE;
    public final int PAGE_INITIAL_FREE_SPACE;
    public final int OFFSET_NEXT_TABLE_DEF_PAGE;
    public final int OFFSET_NUM_ROWS;
    public final int OFFSET_NEXT_AUTO_NUMBER;
    public final int OFFSET_TABLE_TYPE;
    public final int OFFSET_MAX_COLS;
    public final int OFFSET_NUM_VAR_COLS;
    public final int OFFSET_NUM_COLS;
    public final int OFFSET_NUM_INDEX_SLOTS;
    public final int OFFSET_NUM_INDEXES;
    public final int OFFSET_OWNED_PAGES;
    public final int OFFSET_FREE_SPACE_PAGES;
    public final int OFFSET_INDEX_DEF_BLOCK;
    public final int OFFSET_INDEX_NUMBER_BLOCK;
    public final int OFFSET_COLUMN_TYPE;
    public final int OFFSET_COLUMN_NUMBER;
    public final int OFFSET_COLUMN_PRECISION;
    public final int OFFSET_COLUMN_SCALE;
    public final int OFFSET_COLUMN_FLAGS;
    public final int OFFSET_COLUMN_COMPRESSED_UNICODE;
    public final int OFFSET_COLUMN_LENGTH;
    public final int OFFSET_COLUMN_VARIABLE_TABLE_INDEX;
    public final int OFFSET_COLUMN_FIXED_DATA_OFFSET;
    public final int OFFSET_COLUMN_FIXED_DATA_ROW_OFFSET;
    public final int OFFSET_TABLE_DEF_LOCATION;
    public final int OFFSET_ROW_START;
    public final int OFFSET_USAGE_MAP_START;
    public final int OFFSET_USAGE_MAP_PAGE_DATA;
    public final int OFFSET_REFERENCE_MAP_PAGE_NUMBERS;
    public final int OFFSET_FREE_SPACE;
    public final int OFFSET_NUM_ROWS_ON_DATA_PAGE;
    public final int MAX_NUM_ROWS_ON_DATA_PAGE;
    public final int OFFSET_INDEX_COMPRESSED_BYTE_COUNT;
    public final int OFFSET_INDEX_ENTRY_MASK;
    public final int OFFSET_PREV_INDEX_PAGE;
    public final int OFFSET_NEXT_INDEX_PAGE;
    public final int OFFSET_CHILD_TAIL_INDEX_PAGE;
    public final int SIZE_INDEX_DEFINITION;
    public final int SIZE_COLUMN_HEADER;
    public final int SIZE_ROW_LOCATION;
    public final int SIZE_LONG_VALUE_DEF;
    public final int MAX_INLINE_LONG_VALUE_SIZE;
    public final int MAX_LONG_VALUE_ROW_SIZE;
    public final int SIZE_TDEF_HEADER;
    public final int SIZE_TDEF_TRAILER;
    public final int SIZE_COLUMN_DEF_BLOCK;
    public final int SIZE_INDEX_ENTRY_MASK;
    public final int SKIP_BEFORE_INDEX_FLAGS;
    public final int SKIP_AFTER_INDEX_FLAGS;
    public final int SKIP_BEFORE_INDEX_SLOT;
    public final int SKIP_AFTER_INDEX_SLOT;
    public final int SKIP_BEFORE_INDEX;
    public final int SIZE_NAME_LENGTH;
    public final int SIZE_ROW_COLUMN_COUNT;
    public final int SIZE_ROW_VAR_COL_OFFSET;
    public final int USAGE_MAP_TABLE_BYTE_LENGTH;
    public final int MAX_COLUMNS_PER_TABLE;
    public final int MAX_TABLE_NAME_LENGTH;
    public final int MAX_COLUMN_NAME_LENGTH;
    public final int MAX_INDEX_NAME_LENGTH;
    public final boolean REVERSE_FIRST_BYTE_IN_DESC_NUMERIC_INDEXES;
    public final Charset CHARSET;
    public static final JetFormat VERSION_3 = new Jet3Format();
    public static final JetFormat VERSION_4 = new Jet4Format();
    public static final JetFormat VERSION_5 = new Jet5Format();

    public static JetFormat getFormat(FileChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        int bytesRead = channel.read(buffer, 20L);
        if (bytesRead < 1) {
            throw new IOException("Empty database file");
        }
        buffer.flip();
        byte version = buffer.get();
        if (version == 0) {
            return VERSION_3;
        }
        if (version == 1) {
            return VERSION_4;
        }
        if (version == 2) {
            return VERSION_5;
        }
        throw new IOException("Unsupported " + (version < 0 ? "older" : "newer") + " version: " + version);
    }

    private JetFormat(String name) {
        this._name = name;
        this.READ_ONLY = this.defineReadOnly();
        this.INDEXES_SUPPORTED = this.defineIndexesSupported();
        this.PAGE_SIZE = this.definePageSize();
        this.MAX_DATABASE_SIZE = this.defineMaxDatabaseSize();
        this.MAX_ROW_SIZE = this.defineMaxRowSize();
        this.PAGE_INITIAL_FREE_SPACE = this.definePageInitialFreeSpace();
        this.OFFSET_NEXT_TABLE_DEF_PAGE = this.defineOffsetNextTableDefPage();
        this.OFFSET_NUM_ROWS = this.defineOffsetNumRows();
        this.OFFSET_NEXT_AUTO_NUMBER = this.defineOffsetNextAutoNumber();
        this.OFFSET_TABLE_TYPE = this.defineOffsetTableType();
        this.OFFSET_MAX_COLS = this.defineOffsetMaxCols();
        this.OFFSET_NUM_VAR_COLS = this.defineOffsetNumVarCols();
        this.OFFSET_NUM_COLS = this.defineOffsetNumCols();
        this.OFFSET_NUM_INDEX_SLOTS = this.defineOffsetNumIndexSlots();
        this.OFFSET_NUM_INDEXES = this.defineOffsetNumIndexes();
        this.OFFSET_OWNED_PAGES = this.defineOffsetOwnedPages();
        this.OFFSET_FREE_SPACE_PAGES = this.defineOffsetFreeSpacePages();
        this.OFFSET_INDEX_DEF_BLOCK = this.defineOffsetIndexDefBlock();
        this.OFFSET_INDEX_NUMBER_BLOCK = this.defineOffsetIndexNumberBlock();
        this.OFFSET_COLUMN_TYPE = this.defineOffsetColumnType();
        this.OFFSET_COLUMN_NUMBER = this.defineOffsetColumnNumber();
        this.OFFSET_COLUMN_PRECISION = this.defineOffsetColumnPrecision();
        this.OFFSET_COLUMN_SCALE = this.defineOffsetColumnScale();
        this.OFFSET_COLUMN_FLAGS = this.defineOffsetColumnFlags();
        this.OFFSET_COLUMN_COMPRESSED_UNICODE = this.defineOffsetColumnCompressedUnicode();
        this.OFFSET_COLUMN_LENGTH = this.defineOffsetColumnLength();
        this.OFFSET_COLUMN_VARIABLE_TABLE_INDEX = this.defineOffsetColumnVariableTableIndex();
        this.OFFSET_COLUMN_FIXED_DATA_OFFSET = this.defineOffsetColumnFixedDataOffset();
        this.OFFSET_COLUMN_FIXED_DATA_ROW_OFFSET = this.defineOffsetColumnFixedDataRowOffset();
        this.OFFSET_TABLE_DEF_LOCATION = this.defineOffsetTableDefLocation();
        this.OFFSET_ROW_START = this.defineOffsetRowStart();
        this.OFFSET_USAGE_MAP_START = this.defineOffsetUsageMapStart();
        this.OFFSET_USAGE_MAP_PAGE_DATA = this.defineOffsetUsageMapPageData();
        this.OFFSET_REFERENCE_MAP_PAGE_NUMBERS = this.defineOffsetReferenceMapPageNumbers();
        this.OFFSET_FREE_SPACE = this.defineOffsetFreeSpace();
        this.OFFSET_NUM_ROWS_ON_DATA_PAGE = this.defineOffsetNumRowsOnDataPage();
        this.MAX_NUM_ROWS_ON_DATA_PAGE = this.defineMaxNumRowsOnDataPage();
        this.OFFSET_INDEX_COMPRESSED_BYTE_COUNT = this.defineOffsetIndexCompressedByteCount();
        this.OFFSET_INDEX_ENTRY_MASK = this.defineOffsetIndexEntryMask();
        this.OFFSET_PREV_INDEX_PAGE = this.defineOffsetPrevIndexPage();
        this.OFFSET_NEXT_INDEX_PAGE = this.defineOffsetNextIndexPage();
        this.OFFSET_CHILD_TAIL_INDEX_PAGE = this.defineOffsetChildTailIndexPage();
        this.SIZE_INDEX_DEFINITION = this.defineSizeIndexDefinition();
        this.SIZE_COLUMN_HEADER = this.defineSizeColumnHeader();
        this.SIZE_ROW_LOCATION = this.defineSizeRowLocation();
        this.SIZE_LONG_VALUE_DEF = this.defineSizeLongValueDef();
        this.MAX_INLINE_LONG_VALUE_SIZE = this.defineMaxInlineLongValueSize();
        this.MAX_LONG_VALUE_ROW_SIZE = this.defineMaxLongValueRowSize();
        this.SIZE_TDEF_HEADER = this.defineSizeTdefHeader();
        this.SIZE_TDEF_TRAILER = this.defineSizeTdefTrailer();
        this.SIZE_COLUMN_DEF_BLOCK = this.defineSizeColumnDefBlock();
        this.SIZE_INDEX_ENTRY_MASK = this.defineSizeIndexEntryMask();
        this.SKIP_BEFORE_INDEX_FLAGS = this.defineSkipBeforeIndexFlags();
        this.SKIP_AFTER_INDEX_FLAGS = this.defineSkipAfterIndexFlags();
        this.SKIP_BEFORE_INDEX_SLOT = this.defineSkipBeforeIndexSlot();
        this.SKIP_AFTER_INDEX_SLOT = this.defineSkipAfterIndexSlot();
        this.SKIP_BEFORE_INDEX = this.defineSkipBeforeIndex();
        this.SIZE_NAME_LENGTH = this.defineSizeNameLength();
        this.SIZE_ROW_COLUMN_COUNT = this.defineSizeRowColumnCount();
        this.SIZE_ROW_VAR_COL_OFFSET = this.defineSizeRowVarColOffset();
        this.USAGE_MAP_TABLE_BYTE_LENGTH = this.defineUsageMapTableByteLength();
        this.MAX_COLUMNS_PER_TABLE = this.defineMaxColumnsPerTable();
        this.MAX_TABLE_NAME_LENGTH = this.defineMaxTableNameLength();
        this.MAX_COLUMN_NAME_LENGTH = this.defineMaxColumnNameLength();
        this.MAX_INDEX_NAME_LENGTH = this.defineMaxIndexNameLength();
        this.REVERSE_FIRST_BYTE_IN_DESC_NUMERIC_INDEXES = this.defineReverseFirstByteInDescNumericIndexes();
        this.CHARSET = this.defineCharset();
    }

    protected abstract boolean defineReadOnly();

    protected abstract boolean defineIndexesSupported();

    protected abstract int definePageSize();

    protected abstract long defineMaxDatabaseSize();

    protected abstract int defineMaxRowSize();

    protected abstract int definePageInitialFreeSpace();

    protected abstract int defineOffsetNextTableDefPage();

    protected abstract int defineOffsetNumRows();

    protected abstract int defineOffsetNextAutoNumber();

    protected abstract int defineOffsetTableType();

    protected abstract int defineOffsetMaxCols();

    protected abstract int defineOffsetNumVarCols();

    protected abstract int defineOffsetNumCols();

    protected abstract int defineOffsetNumIndexSlots();

    protected abstract int defineOffsetNumIndexes();

    protected abstract int defineOffsetOwnedPages();

    protected abstract int defineOffsetFreeSpacePages();

    protected abstract int defineOffsetIndexDefBlock();

    protected abstract int defineOffsetIndexNumberBlock();

    protected abstract int defineOffsetColumnType();

    protected abstract int defineOffsetColumnNumber();

    protected abstract int defineOffsetColumnPrecision();

    protected abstract int defineOffsetColumnScale();

    protected abstract int defineOffsetColumnFlags();

    protected abstract int defineOffsetColumnCompressedUnicode();

    protected abstract int defineOffsetColumnLength();

    protected abstract int defineOffsetColumnVariableTableIndex();

    protected abstract int defineOffsetColumnFixedDataOffset();

    protected abstract int defineOffsetColumnFixedDataRowOffset();

    protected abstract int defineOffsetTableDefLocation();

    protected abstract int defineOffsetRowStart();

    protected abstract int defineOffsetUsageMapStart();

    protected abstract int defineOffsetUsageMapPageData();

    protected abstract int defineOffsetReferenceMapPageNumbers();

    protected abstract int defineOffsetFreeSpace();

    protected abstract int defineOffsetNumRowsOnDataPage();

    protected abstract int defineMaxNumRowsOnDataPage();

    protected abstract int defineOffsetIndexCompressedByteCount();

    protected abstract int defineOffsetIndexEntryMask();

    protected abstract int defineOffsetPrevIndexPage();

    protected abstract int defineOffsetNextIndexPage();

    protected abstract int defineOffsetChildTailIndexPage();

    protected abstract int defineSizeIndexDefinition();

    protected abstract int defineSizeColumnHeader();

    protected abstract int defineSizeRowLocation();

    protected abstract int defineSizeLongValueDef();

    protected abstract int defineMaxInlineLongValueSize();

    protected abstract int defineMaxLongValueRowSize();

    protected abstract int defineSizeTdefHeader();

    protected abstract int defineSizeTdefTrailer();

    protected abstract int defineSizeColumnDefBlock();

    protected abstract int defineSizeIndexEntryMask();

    protected abstract int defineSkipBeforeIndexFlags();

    protected abstract int defineSkipAfterIndexFlags();

    protected abstract int defineSkipBeforeIndexSlot();

    protected abstract int defineSkipAfterIndexSlot();

    protected abstract int defineSkipBeforeIndex();

    protected abstract int defineSizeNameLength();

    protected abstract int defineSizeRowColumnCount();

    protected abstract int defineSizeRowVarColOffset();

    protected abstract int defineUsageMapTableByteLength();

    protected abstract int defineMaxColumnsPerTable();

    protected abstract int defineMaxTableNameLength();

    protected abstract int defineMaxColumnNameLength();

    protected abstract int defineMaxIndexNameLength();

    protected abstract Charset defineCharset();

    protected abstract boolean defineReverseFirstByteInDescNumericIndexes();

    protected abstract Map<Database.FileFormat, byte[]> getPossibleFileFormats();

    public String toString() {
        return this._name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Jet5Format
    extends Jet4Format {
        private Jet5Format() {
            super("VERSION_5");
        }

        @Override
        protected boolean defineReverseFirstByteInDescNumericIndexes() {
            return true;
        }

        @Override
        protected Map<Database.FileFormat, byte[]> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jet4Format
    extends JetFormat {
        private Jet4Format() {
            this("VERSION_4");
        }

        private Jet4Format(String name) {
            super(name);
        }

        @Override
        protected boolean defineReadOnly() {
            return false;
        }

        @Override
        protected boolean defineIndexesSupported() {
            return true;
        }

        @Override
        protected int definePageSize() {
            return 4096;
        }

        @Override
        protected long defineMaxDatabaseSize() {
            return 0x80000000L;
        }

        @Override
        protected int defineMaxRowSize() {
            return 4060;
        }

        @Override
        protected int definePageInitialFreeSpace() {
            return this.PAGE_SIZE - 14;
        }

        @Override
        protected int defineOffsetNextTableDefPage() {
            return 4;
        }

        @Override
        protected int defineOffsetNumRows() {
            return 16;
        }

        @Override
        protected int defineOffsetNextAutoNumber() {
            return 20;
        }

        @Override
        protected int defineOffsetTableType() {
            return 40;
        }

        @Override
        protected int defineOffsetMaxCols() {
            return 41;
        }

        @Override
        protected int defineOffsetNumVarCols() {
            return 43;
        }

        @Override
        protected int defineOffsetNumCols() {
            return 45;
        }

        @Override
        protected int defineOffsetNumIndexSlots() {
            return 47;
        }

        @Override
        protected int defineOffsetNumIndexes() {
            return 51;
        }

        @Override
        protected int defineOffsetOwnedPages() {
            return 55;
        }

        @Override
        protected int defineOffsetFreeSpacePages() {
            return 59;
        }

        @Override
        protected int defineOffsetIndexDefBlock() {
            return 63;
        }

        @Override
        protected int defineOffsetIndexNumberBlock() {
            return 52;
        }

        @Override
        protected int defineOffsetColumnType() {
            return 0;
        }

        @Override
        protected int defineOffsetColumnNumber() {
            return 5;
        }

        @Override
        protected int defineOffsetColumnPrecision() {
            return 11;
        }

        @Override
        protected int defineOffsetColumnScale() {
            return 12;
        }

        @Override
        protected int defineOffsetColumnFlags() {
            return 15;
        }

        @Override
        protected int defineOffsetColumnCompressedUnicode() {
            return 16;
        }

        @Override
        protected int defineOffsetColumnLength() {
            return 23;
        }

        @Override
        protected int defineOffsetColumnVariableTableIndex() {
            return 7;
        }

        @Override
        protected int defineOffsetColumnFixedDataOffset() {
            return 21;
        }

        @Override
        protected int defineOffsetColumnFixedDataRowOffset() {
            return 2;
        }

        @Override
        protected int defineOffsetTableDefLocation() {
            return 4;
        }

        @Override
        protected int defineOffsetRowStart() {
            return 14;
        }

        @Override
        protected int defineOffsetUsageMapStart() {
            return 5;
        }

        @Override
        protected int defineOffsetUsageMapPageData() {
            return 4;
        }

        @Override
        protected int defineOffsetReferenceMapPageNumbers() {
            return 1;
        }

        @Override
        protected int defineOffsetFreeSpace() {
            return 2;
        }

        @Override
        protected int defineOffsetNumRowsOnDataPage() {
            return 12;
        }

        @Override
        protected int defineMaxNumRowsOnDataPage() {
            return 255;
        }

        @Override
        protected int defineOffsetIndexCompressedByteCount() {
            return 24;
        }

        @Override
        protected int defineOffsetIndexEntryMask() {
            return 27;
        }

        @Override
        protected int defineOffsetPrevIndexPage() {
            return 12;
        }

        @Override
        protected int defineOffsetNextIndexPage() {
            return 16;
        }

        @Override
        protected int defineOffsetChildTailIndexPage() {
            return 20;
        }

        @Override
        protected int defineSizeIndexDefinition() {
            return 12;
        }

        @Override
        protected int defineSizeColumnHeader() {
            return 25;
        }

        @Override
        protected int defineSizeRowLocation() {
            return 2;
        }

        @Override
        protected int defineSizeLongValueDef() {
            return 12;
        }

        @Override
        protected int defineMaxInlineLongValueSize() {
            return 64;
        }

        @Override
        protected int defineMaxLongValueRowSize() {
            return 4076;
        }

        @Override
        protected int defineSizeTdefHeader() {
            return 63;
        }

        @Override
        protected int defineSizeTdefTrailer() {
            return 2;
        }

        @Override
        protected int defineSizeColumnDefBlock() {
            return 25;
        }

        @Override
        protected int defineSizeIndexEntryMask() {
            return 453;
        }

        @Override
        protected int defineSkipBeforeIndexFlags() {
            return 4;
        }

        @Override
        protected int defineSkipAfterIndexFlags() {
            return 5;
        }

        @Override
        protected int defineSkipBeforeIndexSlot() {
            return 4;
        }

        @Override
        protected int defineSkipAfterIndexSlot() {
            return 4;
        }

        @Override
        protected int defineSkipBeforeIndex() {
            return 4;
        }

        @Override
        protected int defineSizeNameLength() {
            return 2;
        }

        @Override
        protected int defineSizeRowColumnCount() {
            return 2;
        }

        @Override
        protected int defineSizeRowVarColOffset() {
            return 2;
        }

        @Override
        protected int defineUsageMapTableByteLength() {
            return 64;
        }

        @Override
        protected int defineMaxColumnsPerTable() {
            return 255;
        }

        @Override
        protected int defineMaxTableNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxColumnNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxIndexNameLength() {
            return 64;
        }

        @Override
        protected boolean defineReverseFirstByteInDescNumericIndexes() {
            return false;
        }

        @Override
        protected Charset defineCharset() {
            return Charset.forName("UTF-16LE");
        }

        @Override
        protected Map<Database.FileFormat, byte[]> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Jet3Format
    extends JetFormat {
        private Jet3Format() {
            super("VERSION_3");
        }

        @Override
        protected boolean defineReadOnly() {
            return true;
        }

        @Override
        protected boolean defineIndexesSupported() {
            return false;
        }

        @Override
        protected int definePageSize() {
            return 2048;
        }

        @Override
        protected long defineMaxDatabaseSize() {
            return 0x40000000L;
        }

        @Override
        protected int defineMaxRowSize() {
            return 2012;
        }

        @Override
        protected int definePageInitialFreeSpace() {
            return this.PAGE_SIZE - 14;
        }

        @Override
        protected int defineOffsetNextTableDefPage() {
            return 4;
        }

        @Override
        protected int defineOffsetNumRows() {
            return 12;
        }

        @Override
        protected int defineOffsetNextAutoNumber() {
            return 20;
        }

        @Override
        protected int defineOffsetTableType() {
            return 20;
        }

        @Override
        protected int defineOffsetMaxCols() {
            return 21;
        }

        @Override
        protected int defineOffsetNumVarCols() {
            return 23;
        }

        @Override
        protected int defineOffsetNumCols() {
            return 25;
        }

        @Override
        protected int defineOffsetNumIndexSlots() {
            return 27;
        }

        @Override
        protected int defineOffsetNumIndexes() {
            return 31;
        }

        @Override
        protected int defineOffsetOwnedPages() {
            return 35;
        }

        @Override
        protected int defineOffsetFreeSpacePages() {
            return 39;
        }

        @Override
        protected int defineOffsetIndexDefBlock() {
            return 43;
        }

        @Override
        protected int defineOffsetIndexNumberBlock() {
            return 39;
        }

        @Override
        protected int defineOffsetColumnType() {
            return 0;
        }

        @Override
        protected int defineOffsetColumnNumber() {
            return 1;
        }

        @Override
        protected int defineOffsetColumnPrecision() {
            return 11;
        }

        @Override
        protected int defineOffsetColumnScale() {
            return 12;
        }

        @Override
        protected int defineOffsetColumnFlags() {
            return 13;
        }

        @Override
        protected int defineOffsetColumnCompressedUnicode() {
            return 16;
        }

        @Override
        protected int defineOffsetColumnLength() {
            return 16;
        }

        @Override
        protected int defineOffsetColumnVariableTableIndex() {
            return 3;
        }

        @Override
        protected int defineOffsetColumnFixedDataOffset() {
            return 14;
        }

        @Override
        protected int defineOffsetColumnFixedDataRowOffset() {
            return 1;
        }

        @Override
        protected int defineOffsetTableDefLocation() {
            return 4;
        }

        @Override
        protected int defineOffsetRowStart() {
            return 10;
        }

        @Override
        protected int defineOffsetUsageMapStart() {
            return 5;
        }

        @Override
        protected int defineOffsetUsageMapPageData() {
            return 4;
        }

        @Override
        protected int defineOffsetReferenceMapPageNumbers() {
            return 1;
        }

        @Override
        protected int defineOffsetFreeSpace() {
            return 2;
        }

        @Override
        protected int defineOffsetNumRowsOnDataPage() {
            return 8;
        }

        @Override
        protected int defineMaxNumRowsOnDataPage() {
            return 255;
        }

        @Override
        protected int defineOffsetIndexCompressedByteCount() {
            return 20;
        }

        @Override
        protected int defineOffsetIndexEntryMask() {
            return 22;
        }

        @Override
        protected int defineOffsetPrevIndexPage() {
            return 8;
        }

        @Override
        protected int defineOffsetNextIndexPage() {
            return 12;
        }

        @Override
        protected int defineOffsetChildTailIndexPage() {
            return 16;
        }

        @Override
        protected int defineSizeIndexDefinition() {
            return 8;
        }

        @Override
        protected int defineSizeColumnHeader() {
            return 18;
        }

        @Override
        protected int defineSizeRowLocation() {
            return 2;
        }

        @Override
        protected int defineSizeLongValueDef() {
            return 12;
        }

        @Override
        protected int defineMaxInlineLongValueSize() {
            return 64;
        }

        @Override
        protected int defineMaxLongValueRowSize() {
            return 2032;
        }

        @Override
        protected int defineSizeTdefHeader() {
            return 63;
        }

        @Override
        protected int defineSizeTdefTrailer() {
            return 2;
        }

        @Override
        protected int defineSizeColumnDefBlock() {
            return 25;
        }

        @Override
        protected int defineSizeIndexEntryMask() {
            return 226;
        }

        @Override
        protected int defineSkipBeforeIndexFlags() {
            return 0;
        }

        @Override
        protected int defineSkipAfterIndexFlags() {
            return 0;
        }

        @Override
        protected int defineSkipBeforeIndexSlot() {
            return 0;
        }

        @Override
        protected int defineSkipAfterIndexSlot() {
            return 0;
        }

        @Override
        protected int defineSkipBeforeIndex() {
            return 0;
        }

        @Override
        protected int defineSizeNameLength() {
            return 1;
        }

        @Override
        protected int defineSizeRowColumnCount() {
            return 1;
        }

        @Override
        protected int defineSizeRowVarColOffset() {
            return 1;
        }

        @Override
        protected int defineUsageMapTableByteLength() {
            return 128;
        }

        @Override
        protected int defineMaxColumnsPerTable() {
            return 255;
        }

        @Override
        protected int defineMaxTableNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxColumnNameLength() {
            return 64;
        }

        @Override
        protected int defineMaxIndexNameLength() {
            return 64;
        }

        @Override
        protected boolean defineReverseFirstByteInDescNumericIndexes() {
            return false;
        }

        @Override
        protected Charset defineCharset() {
            return Charset.defaultCharset();
        }

        @Override
        protected Map<Database.FileFormat, byte[]> getPossibleFileFormats() {
            return PossibleFileFormats.POSSIBLE_VERSION_3;
        }
    }

    private static final class PossibleFileFormats {
        private static final Map<Database.FileFormat, byte[]> POSSIBLE_VERSION_3 = Collections.singletonMap(Database.FileFormat.V1997, null);
        private static final Map<Database.FileFormat, byte[]> POSSIBLE_VERSION_4 = new EnumMap<Database.FileFormat, byte[]>(Database.FileFormat.class);
        private static final Map<Database.FileFormat, byte[]> POSSIBLE_VERSION_5 = Collections.singletonMap(Database.FileFormat.V2007, null);

        private PossibleFileFormats() {
        }

        static {
            POSSIBLE_VERSION_4.put(Database.FileFormat.V2000, ACCESS_VERSION_2000);
            POSSIBLE_VERSION_4.put(Database.FileFormat.V2003, ACCESS_VERSION_2003);
        }
    }
}

