/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import java.nio.ByteBuffer;

public class NullMask {
    private byte[] _mask;

    public NullMask(int columnCount) {
        this._mask = new byte[(columnCount + 7) / 8];
    }

    public void read(ByteBuffer buffer) {
        buffer.get(this._mask);
    }

    public void write(ByteBuffer buffer) {
        buffer.put(this._mask);
    }

    public boolean isNull(Column column) {
        short columnNumber = column.getColumnNumber();
        int maskIndex = columnNumber / 8;
        if (maskIndex >= this._mask.length) {
            return true;
        }
        return (this._mask[maskIndex] & (byte)(1 << columnNumber % 8)) == 0;
    }

    public void markNotNull(Column column) {
        short columnNumber = column.getColumnNumber();
        int maskIndex = columnNumber / 8;
        this._mask[maskIndex] = (byte)(this._mask[maskIndex] | (byte)(1 << columnNumber % 8));
    }

    public int byteSize() {
        return this._mask.length;
    }
}

