/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.complex;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.complex.SingleValue;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueColumnInfo
extends ComplexColumnInfo<SingleValue> {
    private static final Set<DataType> VALUE_TYPES = EnumSet.of(DataType.BYTE, new DataType[]{DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.GUID, DataType.NUMERIC, DataType.TEXT});
    private final Column _valueCol = this.getTypeColumns().get(0);

    public MultiValueColumnInfo(Column column, int complexId, Table typeObjTable, Table flatTable) throws IOException {
        super(column, complexId, typeObjTable, flatTable);
    }

    @Override
    public ComplexDataType getType() {
        return ComplexDataType.MULTI_VALUE;
    }

    public Column getValueColumn() {
        return this._valueCol;
    }

    @Override
    protected SingleValueImpl toValue(ComplexValueForeignKey complexValueFk, Map<String, Object> rawValue) {
        int id = (Integer)this.getPrimaryKeyColumn().getRowValue(rawValue);
        Object value = this.getValueColumn().getRowValue(rawValue);
        return new SingleValueImpl(id, complexValueFk, value);
    }

    @Override
    protected Object[] asRow(Object[] row, SingleValue value) {
        super.asRow(row, value);
        this.getValueColumn().setRowValue(row, value.get());
        return row;
    }

    public static SingleValue newSingleValue(Object value) {
        return MultiValueColumnInfo.newSingleValue(INVALID_COMPLEX_VALUE_ID, value);
    }

    public static SingleValue newSingleValue(ComplexValueForeignKey complexValueFk, Object value) {
        return new SingleValueImpl(-1, complexValueFk, value);
    }

    public static boolean isMultiValueColumn(Table typeObjTable) {
        List<Column> typeCols = typeObjTable.getColumns();
        return typeCols.size() == 1 && VALUE_TYPES.contains((Object)typeCols.get(0).getType());
    }

    private static class SingleValueImpl
    extends ComplexColumnInfo.ComplexValueImpl
    implements SingleValue {
        private Object _value;

        private SingleValueImpl(int id, ComplexValueForeignKey complexValueFk, Object value) {
            super(id, complexValueFk);
            this._value = value;
        }

        public Object get() {
            return this._value;
        }

        public void set(Object value) {
            this._value = value;
        }

        public void update() throws IOException {
            this.getComplexValueForeignKey().updateMultiValue(this);
        }

        public void delete() throws IOException {
            this.getComplexValueForeignKey().deleteMultiValue(this);
        }

        public String toString() {
            return "SingleValue(" + this.getComplexValueForeignKey() + "," + this.getId() + ") " + this.get();
        }
    }
}

