/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableBuilder {
    private static final String ESCAPE_PREFIX = "x";
    private String _name;
    private List<ColumnBuilder> _columns = new ArrayList<ColumnBuilder>();
    private List<IndexBuilder> _indexes = new ArrayList<IndexBuilder>();
    private boolean _escapeIdentifiers;

    public TableBuilder(String name) {
        this(name, false);
    }

    public TableBuilder(String name, boolean escapeIdentifiers) {
        this._name = name;
        this._escapeIdentifiers = escapeIdentifiers;
        if (this._escapeIdentifiers) {
            this._name = TableBuilder.escapeIdentifier(this._name);
        }
    }

    public TableBuilder addColumn(ColumnBuilder column) {
        if (this._escapeIdentifiers) {
            column.escapeName();
        }
        this._columns.add(column);
        return this;
    }

    public TableBuilder addColumns(Collection<? extends ColumnBuilder> columns) {
        if (columns != null) {
            for (ColumnBuilder columnBuilder : columns) {
                this.addColumn(columnBuilder);
            }
        }
        return this;
    }

    public TableBuilder addIndex(IndexBuilder index) {
        if (this._escapeIdentifiers) {
            index.setName(TableBuilder.escapeIdentifier(index.getName()));
            for (IndexBuilder.Column col : index.getColumns()) {
                col.setName(TableBuilder.escapeIdentifier(col.getName()));
            }
        }
        this._indexes.add(index);
        return this;
    }

    public TableBuilder setEscapeIdentifiers(boolean escapeIdentifiers) {
        this._escapeIdentifiers = escapeIdentifiers;
        return this;
    }

    public TableBuilder setPrimaryKey(String ... colNames) {
        this.addIndex(new IndexBuilder("PrimaryKey").addColumns(colNames).setPrimaryKey());
        return this;
    }

    public TableBuilder escapeName() {
        this._name = TableBuilder.escapeIdentifier(this._name);
        return this;
    }

    public Table toTable(Database db) throws IOException {
        ((DatabaseImpl)db).createTable(this._name, this._columns, this._indexes);
        return db.getTable(this._name);
    }

    public static String escapeIdentifier(String s) {
        if (TableBuilder.isReservedWord(s)) {
            return ESCAPE_PREFIX + s;
        }
        return s;
    }

    public static boolean isReservedWord(String s) {
        return ReservedWords.VALUES.contains(s.toLowerCase());
    }

    private static final class ReservedWords {
        private static final Set<String> VALUES = new HashSet<String>(Arrays.asList("add", "all", "alphanumeric", "alter", "and", "any", "application", "as", "asc", "assistant", "autoincrement", "avg", "between", "binary", "bit", "boolean", "by", "byte", "char", "character", "column", "compactdatabase", "constraint", "container", "count", "counter", "create", "createdatabase", "createfield", "creategroup", "createindex", "createobject", "createproperty", "createrelation", "createtabledef", "createuser", "createworkspace", "currency", "currentuser", "database", "date", "datetime", "delete", "desc", "description", "disallow", "distinct", "distinctrow", "document", "double", "drop", "echo", "else", "end", "eqv", "error", "exists", "exit", "false", "field", "fields", "fillcache", "float", "float4", "float8", "foreign", "form", "forms", "from", "full", "function", "general", "getobject", "getoption", "gotopage", "group", "group by", "guid", "having", "idle", "ieeedouble", "ieeesingle", "if", "ignore", "imp", "in", "index", "indexes", "inner", "insert", "inserttext", "int", "integer", "integer1", "integer2", "integer4", "into", "is", "join", "key", "lastmodified", "left", "level", "like", "logical", "logical1", "long", "longbinary", "longtext", "macro", "match", "max", "min", "mod", "memo", "module", "money", "move", "name", "newpassword", "no", "not", "null", "number", "numeric", "object", "oleobject", "off", "on", "openrecordset", "option", "or", "order", "outer", "owneraccess", "parameter", "parameters", "partial", "percent", "pivot", "primary", "procedure", "property", "queries", "query", "quit", "real", "recalc", "recordset", "references", "refresh", "refreshlink", "registerdatabase", "relation", "repaint", "repairdatabase", "report", "reports", "requery", "right", "screen", "section", "select", "set", "setfocus", "setoption", "short", "single", "smallint", "some", "sql", "stdev", "stdevp", "string", "sum", "table", "tabledef", "tabledefs", "tableid", "text", "time", "timestamp", "top", "transform", "true", "type", "union", "unique", "update", "user", "value", "values", "var", "varp", "varbinary", "varchar", "where", "with", "workspace", "xor", "year", "yes", "yesno"));

        private ReservedWords() {
        }
    }
}

