/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.complex.ComplexColumnInfo;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.ComplexColumnSupport;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.OleUtil;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.TableCreator;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TempBufferHolder;
import com.healthmarketscience.jackcess.impl.TempPageHolder;
import com.healthmarketscience.jackcess.impl.UsageMap;
import com.healthmarketscience.jackcess.impl.complex.ComplexColumnInfoImpl;
import com.healthmarketscience.jackcess.impl.complex.ComplexValueForeignKeyImpl;
import com.healthmarketscience.jackcess.impl.scsu.Compress;
import com.healthmarketscience.jackcess.impl.scsu.EndOfInputException;
import com.healthmarketscience.jackcess.impl.scsu.Expand;
import com.healthmarketscience.jackcess.impl.scsu.IllegalInputException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnImpl
implements Column,
Comparable<ColumnImpl> {
    private static final Log LOG = LogFactory.getLog(ColumnImpl.class);
    public static final Object RETURN_ROW_ID = "<RETURN_ROW_ID>";
    private static final double MILLISECONDS_PER_DAY = 8.64E7;
    private static final long MILLIS_BETWEEN_EPOCH_AND_1900 = 2209161600000L;
    private static final byte LONG_VALUE_TYPE_THIS_PAGE = -128;
    private static final byte LONG_VALUE_TYPE_OTHER_PAGE = 64;
    private static final byte LONG_VALUE_TYPE_OTHER_PAGES = 0;
    private static final int LONG_VALUE_TYPE_MASK = -1073741824;
    public static final byte FIXED_LEN_FLAG_MASK = 1;
    public static final byte AUTO_NUMBER_FLAG_MASK = 4;
    public static final byte AUTO_NUMBER_GUID_FLAG_MASK = 64;
    public static final byte HYPERLINK_FLAG_MASK = -128;
    public static final byte UNKNOWN_FLAG_MASK = 2;
    private static final short GENERAL_SORT_ORDER_VALUE = 1033;
    public static final SortOrder GENERAL_LEGACY_SORT_ORDER = new SortOrder(1033, 0);
    public static final SortOrder GENERAL_SORT_ORDER = new SortOrder(1033, 1);
    private static final Pattern GUID_PATTERN = Pattern.compile("\\s*[{]?([\\p{XDigit}]{8})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{12})[}]?\\s*");
    private static final byte[] TEXT_COMPRESSION_HEADER = new byte[]{-1, -2};
    private static final NumericInfo DEFAULT_NUMERIC_INFO = new NumericInfo();
    private static final TextInfo DEFAULT_TEXT_INFO = new TextInfo();
    private final TableImpl _table;
    private final boolean _variableLength;
    private final boolean _autoNumber;
    private final DataType _type;
    private final short _columnLength;
    private final short _columnNumber;
    private int _columnIndex;
    private final int _displayIndex;
    private String _name;
    private final int _fixedDataOffset;
    private final int _varLenTableIndex;
    private NumericInfo _numericInfo = DEFAULT_NUMERIC_INFO;
    private TextInfo _textInfo = DEFAULT_TEXT_INFO;
    private final AutoNumberGenerator _autoNumberGenerator;
    private final ComplexColumnInfo<? extends ComplexValue> _complexInfo;
    private PropertyMap _props;
    private LongValueBufferHolder _lvalBufferH;

    protected ColumnImpl(TableImpl table, DataType type, int colNumber, int fixedOffset, int varLenIndex) {
        this._table = table;
        this._type = type;
        this._columnLength = !this._type.isVariableLength() ? (short)type.getFixedSize() : (short)type.getMaxSize();
        this._variableLength = type.isVariableLength();
        if (type.getHasScalePrecision()) {
            this.modifyNumericInfo();
            this._numericInfo._scale = (byte)type.getDefaultScale();
            this._numericInfo._precision = (byte)type.getDefaultPrecision();
        }
        this._autoNumber = false;
        this._autoNumberGenerator = null;
        this._columnNumber = (short)colNumber;
        this._columnIndex = colNumber;
        this._displayIndex = colNumber;
        this._fixedDataOffset = fixedOffset;
        this._varLenTableIndex = varLenIndex;
        this._complexInfo = null;
    }

    public ColumnImpl(TableImpl table, ByteBuffer buffer, int offset, int displayIndex) throws IOException {
        this._table = table;
        this._displayIndex = displayIndex;
        byte colType = buffer.get(offset + this.getFormat().OFFSET_COLUMN_TYPE);
        this._columnNumber = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_NUMBER);
        this._columnLength = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_LENGTH);
        byte flags = buffer.get(offset + this.getFormat().OFFSET_COLUMN_FLAGS);
        this._variableLength = (flags & 1) == 0;
        this._autoNumber = (flags & 0x44) != 0;
        DataType type = null;
        try {
            type = DataType.fromByte(colType);
        }
        catch (IOException e) {
            LOG.warn((Object)("Unsupported column type " + colType));
            type = this._variableLength ? DataType.UNSUPPORTED_VARLEN : DataType.UNSUPPORTED_FIXEDLEN;
            this.setUnknownDataType(colType);
        }
        this._type = type;
        if (this._type.getHasScalePrecision()) {
            this.modifyNumericInfo();
            this._numericInfo._precision = buffer.get(offset + this.getFormat().OFFSET_COLUMN_PRECISION);
            this._numericInfo._scale = buffer.get(offset + this.getFormat().OFFSET_COLUMN_SCALE);
        } else if (this._type.isTextual()) {
            this.modifyTextInfo();
            this._textInfo._sortOrder = ColumnImpl.readSortOrder(buffer, offset + this.getFormat().OFFSET_COLUMN_SORT_ORDER, this.getFormat());
            int cpOffset = this.getFormat().OFFSET_COLUMN_CODE_PAGE;
            if (cpOffset >= 0) {
                this._textInfo._codePage = buffer.getShort(offset + cpOffset);
            }
            this._textInfo._compressedUnicode = (buffer.get(offset + this.getFormat().OFFSET_COLUMN_COMPRESSED_UNICODE) & 1) == 1;
            if (this._type == DataType.MEMO) {
                this._textInfo._hyperlink = (flags & 0xFFFFFF80) != 0;
            }
        }
        this._autoNumberGenerator = this.createAutoNumberGenerator();
        if (this._variableLength) {
            this._varLenTableIndex = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_VARIABLE_TABLE_INDEX);
            this._fixedDataOffset = 0;
        } else {
            this._fixedDataOffset = buffer.getShort(offset + this.getFormat().OFFSET_COLUMN_FIXED_DATA_OFFSET);
            this._varLenTableIndex = 0;
        }
        this._complexInfo = this._type == DataType.COMPLEX_TYPE ? ComplexColumnSupport.create(this, buffer, offset) : null;
    }

    void setUsageMaps(UsageMap ownedPages, UsageMap freeSpacePages) {
        this._lvalBufferH = new UmapLongValueBufferHolder(ownedPages, freeSpacePages);
    }

    void postTableLoadInit() throws IOException {
        if (this.getType().isLongValue() && this._lvalBufferH == null) {
            this._lvalBufferH = new LegacyLongValueBufferHolder();
        }
        if (this._complexInfo != null) {
            ((ComplexColumnInfoImpl)this._complexInfo).postTableLoadInit();
        }
    }

    @Override
    public TableImpl getTable() {
        return this._table;
    }

    @Override
    public DatabaseImpl getDatabase() {
        return this.getTable().getDatabase();
    }

    public JetFormat getFormat() {
        return this.getDatabase().getFormat();
    }

    public PageChannel getPageChannel() {
        return this.getDatabase().getPageChannel();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public boolean isVariableLength() {
        return this._variableLength;
    }

    @Override
    public boolean isAutoNumber() {
        return this._autoNumber;
    }

    public short getColumnNumber() {
        return this._columnNumber;
    }

    @Override
    public int getColumnIndex() {
        return this._columnIndex;
    }

    public void setColumnIndex(int newColumnIndex) {
        this._columnIndex = newColumnIndex;
    }

    public int getDisplayIndex() {
        return this._displayIndex;
    }

    @Override
    public DataType getType() {
        return this._type;
    }

    @Override
    public int getSQLType() throws SQLException {
        return this._type.getSQLType();
    }

    @Override
    public boolean isCompressedUnicode() {
        return this._textInfo._compressedUnicode;
    }

    @Override
    public byte getPrecision() {
        return this._numericInfo._precision;
    }

    @Override
    public byte getScale() {
        return this._numericInfo._scale;
    }

    public SortOrder getTextSortOrder() {
        return this._textInfo._sortOrder;
    }

    public short getTextCodePage() {
        return this._textInfo._codePage;
    }

    @Override
    public short getLength() {
        return this._columnLength;
    }

    @Override
    public short getLengthInUnits() {
        return (short)this.getType().toUnitSize(this.getLength());
    }

    public int getVarLenTableIndex() {
        return this._varLenTableIndex;
    }

    public int getFixedDataOffset() {
        return this._fixedDataOffset;
    }

    protected Charset getCharset() {
        return this.getDatabase().getCharset();
    }

    protected Calendar getCalendar() {
        return this.getDatabase().getCalendar();
    }

    @Override
    public boolean isAppendOnly() {
        return this.getVersionHistoryColumn() != null;
    }

    @Override
    public ColumnImpl getVersionHistoryColumn() {
        return this._textInfo._versionHistoryCol;
    }

    public int getOwnedPageCount() {
        return this._lvalBufferH == null ? 0 : this._lvalBufferH.getOwnedPageCount();
    }

    public void setVersionHistoryColumn(ColumnImpl versionHistoryCol) {
        this.modifyTextInfo();
        this._textInfo._versionHistoryCol = versionHistoryCol;
    }

    @Override
    public boolean isHyperlink() {
        return this._textInfo._hyperlink;
    }

    @Override
    public ComplexColumnInfo<? extends ComplexValue> getComplexInfo() {
        return this._complexInfo;
    }

    private void setUnknownDataType(byte type) {
        this.modifyNumericInfo();
        this._numericInfo._scale = type;
    }

    private byte getUnknownDataType() {
        return this._numericInfo._scale;
    }

    private AutoNumberGenerator createAutoNumberGenerator() {
        if (!this._autoNumber || this._type == null) {
            return null;
        }
        switch (this._type) {
            case LONG: {
                return new LongAutoNumberGenerator();
            }
            case GUID: {
                return new GuidAutoNumberGenerator();
            }
            case COMPLEX_TYPE: {
                return new ComplexTypeAutoNumberGenerator();
            }
        }
        LOG.warn((Object)("Unknown auto number column type " + (Object)((Object)this._type)));
        return new UnsupportedAutoNumberGenerator(this._type);
    }

    public AutoNumberGenerator getAutoNumberGenerator() {
        return this._autoNumberGenerator;
    }

    @Override
    public PropertyMap getProperties() throws IOException {
        if (this._props == null) {
            this._props = this.getTable().getPropertyMaps().get(this.getName());
        }
        return this._props;
    }

    private void modifyNumericInfo() {
        if (this._numericInfo == DEFAULT_NUMERIC_INFO) {
            this._numericInfo = new NumericInfo();
        }
    }

    private void modifyTextInfo() {
        if (this._textInfo == DEFAULT_TEXT_INFO) {
            this._textInfo = new TextInfo();
        }
    }

    @Override
    public Object setRowValue(Object[] rowArray, Object value) {
        rowArray[this._columnIndex] = value;
        return value;
    }

    @Override
    public Object setRowValue(Map<String, Object> rowMap, Object value) {
        rowMap.put(this._name, value);
        return value;
    }

    @Override
    public Object getRowValue(Object[] rowArray) {
        return rowArray[this._columnIndex];
    }

    @Override
    public Object getRowValue(Map<String, ?> rowMap) {
        return rowMap.get(this._name);
    }

    public Object read(byte[] data) throws IOException {
        return this.read(data, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public Object read(byte[] data, ByteOrder order) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.order(order);
        if (this._type == DataType.BOOLEAN) {
            throw new IOException("Tried to read a boolean from data instead of null mask.");
        }
        if (this._type == DataType.BYTE) {
            return buffer.get();
        }
        if (this._type == DataType.INT) {
            return buffer.getShort();
        }
        if (this._type == DataType.LONG) {
            return buffer.getInt();
        }
        if (this._type == DataType.DOUBLE) {
            return buffer.getDouble();
        }
        if (this._type == DataType.FLOAT) {
            return Float.valueOf(buffer.getFloat());
        }
        if (this._type == DataType.SHORT_DATE_TIME) {
            return this.readDateValue(buffer);
        }
        if (this._type == DataType.BINARY) {
            return data;
        }
        if (this._type == DataType.TEXT) {
            return this.decodeTextValue(data);
        }
        if (this._type == DataType.MONEY) {
            return ColumnImpl.readCurrencyValue(buffer);
        }
        if (this._type == DataType.OLE) {
            if (data.length > 0) {
                return this.readLongValue(data);
            }
            return null;
        }
        if (this._type == DataType.MEMO) {
            if (data.length > 0) {
                return this.readLongStringValue(data);
            }
            return null;
        }
        if (this._type == DataType.NUMERIC) {
            return this.readNumericValue(buffer);
        }
        if (this._type == DataType.GUID) {
            return ColumnImpl.readGUIDValue(buffer, order);
        }
        if (this._type == DataType.UNKNOWN_0D || this._type == DataType.UNKNOWN_11) {
            return data;
        }
        if (this._type == DataType.COMPLEX_TYPE) {
            return new ComplexValueForeignKeyImpl(this, buffer.getInt());
        }
        if (this._type.isUnsupported()) {
            return ColumnImpl.rawDataWrapper(data);
        }
        throw new IOException("Unrecognized data type: " + (Object)((Object)this._type));
    }

    private byte[] readLongValue(byte[] lvalDefinition) throws IOException {
        ByteBuffer def = PageChannel.wrap(lvalDefinition);
        int lengthWithFlags = def.getInt();
        int length = lengthWithFlags & 0x3FFFFFFF;
        byte[] rtn = new byte[length];
        byte type = (byte)((lengthWithFlags & 0xC0000000) >>> 24);
        if (type == -128) {
            def.getInt();
            def.getInt();
            int rowLen = def.remaining();
            if (rowLen < length) {
                LOG.warn((Object)(this.getName() + " value may be truncated: expected length " + length + " found " + rowLen));
                rtn = new byte[rowLen];
            }
            def.get(rtn);
        } else {
            if (lvalDefinition.length != this.getFormat().SIZE_LONG_VALUE_DEF) {
                throw new IOException("Expected " + this.getFormat().SIZE_LONG_VALUE_DEF + " bytes in long value definition, but found " + lvalDefinition.length);
            }
            int rowNum = ByteUtil.getUnsignedByte(def);
            int pageNum = ByteUtil.get3ByteInt(def, def.position());
            ByteBuffer lvalPage = this.getPageChannel().createPageBuffer();
            switch (type) {
                case 64: {
                    this.getPageChannel().readPage(lvalPage, pageNum);
                    short rowStart = TableImpl.findRowStart(lvalPage, rowNum, this.getFormat());
                    short rowEnd = TableImpl.findRowEnd(lvalPage, rowNum, this.getFormat());
                    int rowLen = rowEnd - rowStart;
                    if (rowLen < length) {
                        LOG.warn((Object)(this.getName() + " value may be truncated: expected length " + length + " found " + rowLen));
                        rtn = new byte[rowLen];
                    }
                    lvalPage.position(rowStart);
                    lvalPage.get(rtn);
                    break;
                }
                case 0: {
                    int chunkLength;
                    ByteBuffer rtnBuf = ByteBuffer.wrap(rtn);
                    for (int remainingLen = length; remainingLen > 0; remainingLen -= chunkLength) {
                        lvalPage.clear();
                        this.getPageChannel().readPage(lvalPage, pageNum);
                        short rowStart = TableImpl.findRowStart(lvalPage, rowNum, this.getFormat());
                        short rowEnd = TableImpl.findRowEnd(lvalPage, rowNum, this.getFormat());
                        lvalPage.position(rowStart);
                        rowNum = ByteUtil.getUnsignedByte(lvalPage);
                        pageNum = ByteUtil.get3ByteInt(lvalPage);
                        chunkLength = rowEnd - rowStart - 4;
                        if (chunkLength > remainingLen) {
                            rowEnd = (short)(rowEnd - (chunkLength - remainingLen));
                            chunkLength = remainingLen;
                        }
                        lvalPage.limit(rowEnd);
                        rtnBuf.put(lvalPage);
                    }
                    break;
                }
                default: {
                    throw new IOException("Unrecognized long value type: " + type);
                }
            }
        }
        return rtn;
    }

    private String readLongStringValue(byte[] lvalDefinition) throws IOException {
        byte[] binData = this.readLongValue(lvalDefinition);
        if (binData == null) {
            return null;
        }
        return this.decodeTextValue(binData);
    }

    private static BigDecimal readCurrencyValue(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() != 8) {
            throw new IOException("Invalid money value.");
        }
        return new BigDecimal(BigInteger.valueOf(buffer.getLong(0)), 4);
    }

    private static void writeCurrencyValue(ByteBuffer buffer, Object value) throws IOException {
        Object inValue = value;
        try {
            BigDecimal decVal = ColumnImpl.toBigDecimal(value);
            inValue = decVal;
            decVal = decVal.setScale(4);
            buffer.putLong(decVal.movePointRight(4).longValueExact());
        }
        catch (ArithmeticException e) {
            throw (IOException)new IOException("Currency value '" + inValue + "' out of range").initCause(e);
        }
    }

    private BigDecimal readNumericValue(ByteBuffer buffer) {
        boolean negate = buffer.get() != 0;
        byte[] tmpArr = ByteUtil.getBytes(buffer, 16);
        if (buffer.order() != ByteOrder.BIG_ENDIAN) {
            ColumnImpl.fixNumericByteOrder(tmpArr);
        }
        BigInteger intVal = new BigInteger(tmpArr);
        if (negate) {
            intVal = intVal.negate();
        }
        return new BigDecimal(intVal, this.getScale());
    }

    private void writeNumericValue(ByteBuffer buffer, Object value) throws IOException {
        Object inValue = value;
        try {
            int maxByteLen;
            boolean negative;
            BigDecimal decVal = ColumnImpl.toBigDecimal(value);
            inValue = decVal;
            boolean bl = negative = decVal.compareTo(BigDecimal.ZERO) < 0;
            if (negative) {
                decVal = decVal.negate();
            }
            buffer.put(negative ? (byte)-128 : 0);
            decVal = decVal.setScale(this.getScale());
            if (decVal.precision() > this.getPrecision()) {
                throw new IOException("Numeric value is too big for specified precision " + this.getPrecision() + ": " + decVal);
            }
            byte[] intValBytes = decVal.unscaledValue().toByteArray();
            if (intValBytes.length > (maxByteLen = this.getType().getFixedSize() - 1)) {
                throw new IOException("Too many bytes for valid BigInteger?");
            }
            if (intValBytes.length < maxByteLen) {
                byte[] tmpBytes = new byte[maxByteLen];
                System.arraycopy(intValBytes, 0, tmpBytes, maxByteLen - intValBytes.length, intValBytes.length);
                intValBytes = tmpBytes;
            }
            if (buffer.order() != ByteOrder.BIG_ENDIAN) {
                ColumnImpl.fixNumericByteOrder(intValBytes);
            }
            buffer.put(intValBytes);
        }
        catch (ArithmeticException e) {
            throw (IOException)new IOException("Numeric value '" + inValue + "' out of range").initCause(e);
        }
    }

    private Date readDateValue(ByteBuffer buffer) {
        long dateBits = buffer.getLong();
        long time = this.fromDateDouble(Double.longBitsToDouble(dateBits));
        return new DateExt(time, dateBits);
    }

    public long fromDateDouble(double value) {
        long time = Math.round(value * 8.64E7);
        time -= 2209161600000L;
        time -= this.getFromLocalTimeZoneOffset(time);
        return time;
    }

    private void writeDateValue(ByteBuffer buffer, Object value) {
        if (value == null) {
            buffer.putDouble(0.0);
        } else if (value instanceof DateExt) {
            buffer.putLong(((DateExt)value).getDateBits());
        } else {
            buffer.putDouble(this.toDateDouble(value));
        }
    }

    public double toDateDouble(Object value) {
        long time = value instanceof Date ? ((Date)value).getTime() : (value instanceof Calendar ? ((Calendar)value).getTimeInMillis() : ((Number)value).longValue());
        time += this.getToLocalTimeZoneOffset(time);
        return (double)(time += 2209161600000L) / 8.64E7;
    }

    private long getToLocalTimeZoneOffset(long time) {
        Calendar c = this.getCalendar();
        c.setTimeInMillis(time);
        return (long)c.get(15) + (long)c.get(16);
    }

    private long getFromLocalTimeZoneOffset(long time) {
        Calendar c = this.getCalendar();
        c.setTimeInMillis(time);
        c.setTimeInMillis(time - (long)c.get(15));
        return (long)c.get(15) + (long)c.get(16);
    }

    private static String readGUIDValue(ByteBuffer buffer, ByteOrder order) {
        if (order != ByteOrder.BIG_ENDIAN) {
            byte[] tmpArr = ByteUtil.getBytes(buffer, 16);
            ByteUtil.swap4Bytes(tmpArr, 0);
            ByteUtil.swap2Bytes(tmpArr, 4);
            ByteUtil.swap2Bytes(tmpArr, 6);
            buffer = ByteBuffer.wrap(tmpArr);
        }
        StringBuilder sb = new StringBuilder(22);
        sb.append("{");
        sb.append(ByteUtil.toHexString(buffer, 0, 4, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 4, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 6, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 8, 2, false));
        sb.append("-");
        sb.append(ByteUtil.toHexString(buffer, 10, 6, false));
        sb.append("}");
        return sb.toString();
    }

    private static void writeGUIDValue(ByteBuffer buffer, Object value, ByteOrder order) throws IOException {
        Matcher m = GUID_PATTERN.matcher(ColumnImpl.toCharSequence(value));
        if (!m.matches()) {
            throw new IOException("Invalid GUID: " + value);
        }
        ByteBuffer origBuffer = null;
        byte[] tmpBuf = null;
        if (order != ByteOrder.BIG_ENDIAN) {
            origBuffer = buffer;
            tmpBuf = new byte[16];
            buffer = ByteBuffer.wrap(tmpBuf);
        }
        ByteUtil.writeHexString(buffer, m.group(1));
        ByteUtil.writeHexString(buffer, m.group(2));
        ByteUtil.writeHexString(buffer, m.group(3));
        ByteUtil.writeHexString(buffer, m.group(4));
        ByteUtil.writeHexString(buffer, m.group(5));
        if (tmpBuf != null) {
            ByteUtil.swap4Bytes(tmpBuf, 0);
            ByteUtil.swap2Bytes(tmpBuf, 4);
            ByteUtil.swap2Bytes(tmpBuf, 6);
            origBuffer.put(tmpBuf);
        }
    }

    static boolean isGUIDValue(Object value) throws IOException {
        return GUID_PATTERN.matcher(ColumnImpl.toCharSequence(value)).matches();
    }

    public ByteBuffer writeLongValue(byte[] value, int remainingRowLength) throws IOException {
        if (value.length > this.getType().getMaxSize()) {
            throw new IOException("value too big for column, max " + this.getType().getMaxSize() + ", got " + value.length);
        }
        int type = 0;
        int lvalDefLen = this.getFormat().SIZE_LONG_VALUE_DEF;
        if (this.getFormat().SIZE_LONG_VALUE_DEF + value.length <= remainingRowLength && value.length <= this.getFormat().MAX_INLINE_LONG_VALUE_SIZE) {
            type = -128;
            lvalDefLen += value.length;
        } else {
            type = value.length <= this.getFormat().MAX_LONG_VALUE_ROW_SIZE ? 64 : 0;
        }
        ByteBuffer def = this.getPageChannel().createBuffer(lvalDefLen);
        int lengthWithFlags = value.length | type << 24;
        def.putInt(lengthWithFlags);
        if (type == -128) {
            def.putInt(0);
            def.putInt(0);
            def.put(value);
        } else {
            ByteBuffer lvalPage = null;
            int firstLvalPageNum = -1;
            byte firstLvalRow = 0;
            switch (type) {
                case 64: {
                    lvalPage = this._lvalBufferH.getLongValuePage(value.length);
                    firstLvalPageNum = this._lvalBufferH.getPageNumber();
                    firstLvalRow = (byte)TableImpl.addDataPageRow(lvalPage, value.length, this.getFormat(), 0);
                    lvalPage.put(value);
                    this.getPageChannel().writePage(lvalPage, firstLvalPageNum);
                    break;
                }
                case 0: {
                    int chunkLength;
                    int remainingLen;
                    ByteBuffer buffer = ByteBuffer.wrap(value);
                    buffer.limit(0);
                    lvalPage = this._lvalBufferH.getLongValuePage(remainingLen);
                    firstLvalPageNum = this._lvalBufferH.getPageNumber();
                    firstLvalRow = (byte)TableImpl.getRowsOnDataPage(lvalPage, this.getFormat());
                    int lvalPageNum = firstLvalPageNum;
                    ByteBuffer nextLvalPage = null;
                    int nextLvalPageNum = 0;
                    int nextLvalRowNum = 0;
                    for (remainingLen = buffer.remaining(); remainingLen > 0; remainingLen -= chunkLength) {
                        lvalPage.clear();
                        chunkLength = Math.min(this.getFormat().MAX_LONG_VALUE_ROW_SIZE - 4, remainingLen);
                        if (chunkLength < remainingLen) {
                            this._lvalBufferH.clear();
                            nextLvalPage = this._lvalBufferH.getLongValuePage(remainingLen - chunkLength + 4);
                            nextLvalPageNum = this._lvalBufferH.getPageNumber();
                            nextLvalRowNum = TableImpl.getRowsOnDataPage(nextLvalPage, this.getFormat());
                        } else {
                            nextLvalPage = null;
                            nextLvalPageNum = 0;
                            nextLvalRowNum = 0;
                        }
                        byte lvalRow = (byte)TableImpl.addDataPageRow(lvalPage, chunkLength + 4, this.getFormat(), 0);
                        lvalPage.put((byte)nextLvalRowNum);
                        ByteUtil.put3ByteInt(lvalPage, nextLvalPageNum);
                        buffer.limit(buffer.limit() + chunkLength);
                        lvalPage.put(buffer);
                        this.getPageChannel().writePage(lvalPage, lvalPageNum);
                        lvalPage = nextLvalPage;
                        lvalPageNum = nextLvalPageNum;
                    }
                    break;
                }
                default: {
                    throw new IOException("Unrecognized long value type: " + type);
                }
            }
            def.put(firstLvalRow);
            ByteUtil.put3ByteInt(def, firstLvalPageNum);
            def.putInt(0);
        }
        def.flip();
        return def;
    }

    private void writeLongValueHeader(ByteBuffer lvalPage) {
        lvalPage.put((byte)1);
        lvalPage.put((byte)1);
        lvalPage.putShort((short)this.getFormat().DATA_PAGE_INITIAL_FREE_SPACE);
        lvalPage.put((byte)76);
        lvalPage.put((byte)86);
        lvalPage.put((byte)65);
        lvalPage.put((byte)76);
        lvalPage.putInt(0);
        lvalPage.putShort((short)0);
    }

    public ByteBuffer write(Object obj, int remainingRowLength) throws IOException {
        return this.write(obj, remainingRowLength, PageChannel.DEFAULT_BYTE_ORDER);
    }

    public ByteBuffer write(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
        if (ColumnImpl.isRawData(obj)) {
            return ByteBuffer.wrap(((RawData)obj).getBytes());
        }
        if (!this.isVariableLength() || !this.getType().isVariableLength()) {
            return this.writeFixedLengthField(obj, order);
        }
        if (!this.getType().isLongValue()) {
            switch (this.getType()) {
                case NUMERIC: {
                    ByteBuffer buffer = this.getPageChannel().createBuffer(this.getType().getFixedSize(), order);
                    this.writeNumericValue(buffer, obj);
                    buffer.flip();
                    return buffer;
                }
                case TEXT: {
                    byte[] encodedData = this.encodeTextValue(obj, 0, this.getLengthInUnits(), false).array();
                    obj = encodedData;
                    break;
                }
                case BINARY: 
                case UNKNOWN_0D: 
                case UNSUPPORTED_VARLEN: {
                    break;
                }
                default: {
                    throw new RuntimeException("unexpected inline var length type: " + (Object)((Object)this.getType()));
                }
            }
            ByteBuffer buffer = ByteBuffer.wrap(ColumnImpl.toByteArray(obj));
            buffer.order(order);
            return buffer;
        }
        switch (this.getType()) {
            case OLE: {
                break;
            }
            case MEMO: {
                int maxMemoChars = DataType.MEMO.toUnitSize(DataType.MEMO.getMaxSize());
                obj = this.encodeTextValue(obj, 0, maxMemoChars, false).array();
                break;
            }
            default: {
                throw new RuntimeException("unexpected var length, long value type: " + (Object)((Object)this.getType()));
            }
        }
        return this.writeLongValue(ColumnImpl.toByteArray(obj), remainingRowLength);
    }

    public ByteBuffer writeFixedLengthField(Object obj, ByteOrder order) throws IOException {
        int size = this.getType().getFixedSize(this._columnLength);
        ByteBuffer buffer = this.getPageChannel().createBuffer(size, order);
        obj = ColumnImpl.booleanToInteger(obj);
        switch (this.getType()) {
            case BOOLEAN: {
                break;
            }
            case BYTE: {
                buffer.put(ColumnImpl.toNumber(obj).byteValue());
                break;
            }
            case INT: {
                buffer.putShort(ColumnImpl.toNumber(obj).shortValue());
                break;
            }
            case LONG: {
                buffer.putInt(ColumnImpl.toNumber(obj).intValue());
                break;
            }
            case MONEY: {
                ColumnImpl.writeCurrencyValue(buffer, obj);
                break;
            }
            case FLOAT: {
                buffer.putFloat(ColumnImpl.toNumber(obj).floatValue());
                break;
            }
            case DOUBLE: {
                buffer.putDouble(ColumnImpl.toNumber(obj).doubleValue());
                break;
            }
            case SHORT_DATE_TIME: {
                this.writeDateValue(buffer, obj);
                break;
            }
            case TEXT: {
                short numChars = this.getLengthInUnits();
                buffer.put(this.encodeTextValue(obj, numChars, numChars, true));
                break;
            }
            case GUID: {
                ColumnImpl.writeGUIDValue(buffer, obj, order);
                break;
            }
            case NUMERIC: {
                this.writeNumericValue(buffer, obj);
                break;
            }
            case COMPLEX_TYPE: 
            case BINARY: 
            case UNKNOWN_0D: 
            case UNKNOWN_11: {
                buffer.putInt(ColumnImpl.toNumber(obj).intValue());
                break;
            }
            case UNSUPPORTED_FIXEDLEN: {
                byte[] bytes = ColumnImpl.toByteArray(obj);
                if (bytes.length != this.getLength()) {
                    throw new IOException("Invalid fixed size binary data, size " + this.getLength() + ", got " + bytes.length);
                }
                buffer.put(bytes);
                break;
            }
            default: {
                throw new IOException("Unsupported data type: " + (Object)((Object)this.getType()));
            }
        }
        buffer.flip();
        return buffer;
    }

    private String decodeTextValue(byte[] data) throws IOException {
        try {
            boolean isCompressed;
            boolean bl = isCompressed = data.length > 1 && data[0] == TEXT_COMPRESSION_HEADER[0] && data[1] == TEXT_COMPRESSION_HEADER[1];
            if (isCompressed) {
                int dataStart;
                Expand expander = new Expand();
                StringBuilder textBuf = new StringBuilder(data.length);
                int dataEnd = dataStart = TEXT_COMPRESSION_HEADER.length;
                boolean inCompressedMode = true;
                while (dataEnd < data.length) {
                    if (data[dataEnd] == 0) {
                        this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, expander, textBuf);
                        inCompressedMode = !inCompressedMode;
                        dataStart = ++dataEnd;
                        continue;
                    }
                    ++dataEnd;
                }
                this.decodeTextSegment(data, dataStart, dataEnd, inCompressedMode, expander, textBuf);
                return textBuf.toString();
            }
            return ColumnImpl.decodeUncompressedText(data, this.getCharset());
        }
        catch (IllegalInputException e) {
            throw (IOException)new IOException("Can't expand text column").initCause(e);
        }
        catch (EndOfInputException e) {
            throw (IOException)new IOException("Can't expand text column").initCause(e);
        }
    }

    private void decodeTextSegment(byte[] data, int dataStart, int dataEnd, boolean inCompressedMode, Expand expander, StringBuilder textBuf) throws IllegalInputException, EndOfInputException {
        if (dataEnd <= dataStart) {
            return;
        }
        int dataLength = dataEnd - dataStart;
        if (inCompressedMode) {
            byte[] tmpData = ByteUtil.copyOf(data, dataStart, dataLength);
            expander.reset();
            textBuf.append(expander.expand(tmpData));
        } else {
            textBuf.append(ColumnImpl.decodeUncompressedText(data, dataStart, dataLength, this.getCharset()));
        }
    }

    private static CharBuffer decodeUncompressedText(byte[] textBytes, int startPos, int length, Charset charset) {
        return charset.decode(ByteBuffer.wrap(textBytes, startPos, length));
    }

    private ByteBuffer encodeTextValue(Object obj, int minChars, int maxChars, boolean forceUncompressed) throws IOException {
        CharSequence text = ColumnImpl.toCharSequence(obj);
        if (text.length() > maxChars || text.length() < minChars) {
            throw new IOException("Text is wrong length for " + (Object)((Object)this.getType()) + " column, max " + maxChars + ", min " + minChars + ", got " + text.length());
        }
        if (!forceUncompressed && this.isCompressedUnicode() && text.length() <= this.getFormat().MAX_COMPRESSED_UNICODE_SIZE && ColumnImpl.isAsciiCompressible(text)) {
            byte[] encodedChars = new byte[TEXT_COMPRESSION_HEADER.length + text.length()];
            encodedChars[0] = TEXT_COMPRESSION_HEADER[0];
            encodedChars[1] = TEXT_COMPRESSION_HEADER[1];
            for (int i = 0; i < text.length(); ++i) {
                encodedChars[i + ColumnImpl.TEXT_COMPRESSION_HEADER.length] = (byte)text.charAt(i);
            }
            return ByteBuffer.wrap(encodedChars);
        }
        return ColumnImpl.encodeUncompressedText(text, this.getCharset());
    }

    private static boolean isAsciiCompressible(CharSequence text) {
        if (text.length() <= TEXT_COMPRESSION_HEADER.length) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Compress.isAsciiCrLfOrTab(c)) continue;
            return false;
        }
        return true;
    }

    private static byte getColumnBitFlags(ColumnBuilder col) {
        byte flags = 2;
        if (!col.getType().isVariableLength()) {
            flags = (byte)(flags | 1);
        }
        if (col.isAutoNumber()) {
            int autoNumFlags = 0;
            switch (col.getType()) {
                case LONG: 
                case COMPLEX_TYPE: {
                    autoNumFlags = 4;
                    break;
                }
                case GUID: {
                    autoNumFlags = 64;
                    break;
                }
            }
            flags = (byte)(flags | autoNumFlags);
        }
        if (col.isHyperlink()) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        return flags;
    }

    public String toString() {
        ToStringBuilder sb = CustomToStringStyle.builder(this).append("name", (Object)("(" + this._table.getName() + ") " + this._name));
        byte typeValue = this._type.getValue();
        if (this._type.isUnsupported()) {
            typeValue = this.getUnknownDataType();
        }
        sb.append("type", (Object)("0x" + Integer.toHexString(typeValue) + " (" + (Object)((Object)this._type) + ")")).append("number", this._columnNumber).append("length", this._columnLength).append("variableLength", this._variableLength);
        if (this._type.isTextual()) {
            sb.append("compressedUnicode", this._textInfo._compressedUnicode).append("textSortOrder", (Object)this._textInfo._sortOrder);
            if (this._textInfo._codePage > 0) {
                sb.append("textCodePage", this._textInfo._codePage);
            }
            if (this.isAppendOnly()) {
                sb.append("appendOnly", this.isAppendOnly());
            }
            if (this.isHyperlink()) {
                sb.append("hyperlink", this.isHyperlink());
            }
        }
        if (this._autoNumber) {
            sb.append("lastAutoNumber", this._autoNumberGenerator.getLast());
        }
        if (this._complexInfo != null) {
            sb.append("complexInfo", this._complexInfo);
        }
        return sb.toString();
    }

    public static String decodeUncompressedText(byte[] textBytes, Charset charset) {
        return ColumnImpl.decodeUncompressedText(textBytes, 0, textBytes.length, charset).toString();
    }

    public static ByteBuffer encodeUncompressedText(CharSequence text, Charset charset) {
        CharBuffer cb = text instanceof CharBuffer ? (CharBuffer)text : CharBuffer.wrap(text);
        return charset.encode(cb);
    }

    @Override
    public int compareTo(ColumnImpl other) {
        if (this._columnNumber > other.getColumnNumber()) {
            return 1;
        }
        if (this._columnNumber < other.getColumnNumber()) {
            return -1;
        }
        return 0;
    }

    public static short countVariableLength(List<ColumnBuilder> columns) {
        short rtn = 0;
        for (ColumnBuilder col : columns) {
            if (!col.getType().isVariableLength()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    public static short countNonLongVariableLength(List<ColumnBuilder> columns) {
        short rtn = 0;
        for (ColumnBuilder col : columns) {
            if (!col.getType().isVariableLength() || col.getType().isLongValue()) continue;
            rtn = (short)(rtn + 1);
        }
        return rtn;
    }

    private static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        return new BigDecimal(value.toString());
    }

    private static Number toNumber(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        return Double.valueOf(value.toString());
    }

    public static CharSequence toCharSequence(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        if (value instanceof Clob) {
            try {
                Clob c = (Clob)value;
                return c.getSubString(1L, (int)c.length());
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        if (value instanceof Reader) {
            char[] buf = new char[8192];
            StringBuilder sout = new StringBuilder();
            Reader in = (Reader)value;
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                sout.append(buf, 0, read);
            }
            return sout;
        }
        return value.toString();
    }

    public static byte[] toByteArray(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof OleUtil.OleBlobImpl) {
            return ((OleUtil.OleBlobImpl)value).getBytes();
        }
        if (value instanceof Blob) {
            try {
                Blob b = (Blob)value;
                return b.getBytes(1L, (int)b.length());
            }
            catch (SQLException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (value instanceof InputStream) {
            ByteUtil.copy((InputStream)value, bout);
        } else {
            ObjectOutputStream oos = new ObjectOutputStream(bout);
            oos.writeObject(value);
            oos.close();
        }
        return bout.toByteArray();
    }

    public static boolean toBooleanValue(Object obj) {
        return obj != null && (Boolean)obj != false;
    }

    private static void fixNumericByteOrder(byte[] bytes) {
        for (int i = 0; i < 4; ++i) {
            ByteUtil.swap4Bytes(bytes, i * 4);
        }
    }

    protected static Object booleanToInteger(Object obj) {
        if (obj instanceof Boolean) {
            obj = (Boolean)obj != false ? 1 : 0;
        }
        return obj;
    }

    static RawData rawDataWrapper(byte[] bytes) {
        return new RawData(bytes);
    }

    public static boolean isRawData(Object value) {
        return value instanceof RawData;
    }

    protected static void writeDefinitions(TableCreator creator, ByteBuffer buffer) throws IOException {
        List<ColumnBuilder> columns = creator.getColumns();
        short fixedOffset = 0;
        short variableOffset = 0;
        short longVariableOffset = ColumnImpl.countNonLongVariableLength(columns);
        for (ColumnBuilder col : columns) {
            buffer.put(col.getType().getValue());
            buffer.putInt(1625);
            buffer.putShort(col.getColumnNumber());
            if (col.getType().isVariableLength()) {
                if (!col.getType().isLongValue()) {
                    short s = variableOffset;
                    variableOffset = (short)(variableOffset + 1);
                    buffer.putShort(s);
                } else {
                    short s = longVariableOffset;
                    longVariableOffset = (short)(longVariableOffset + 1);
                    buffer.putShort(s);
                }
            } else {
                buffer.putShort((short)0);
            }
            buffer.putShort(col.getColumnNumber());
            if (col.getType().isTextual()) {
                ColumnImpl.writeSortOrder(buffer, col.getTextSortOrder(), creator.getFormat());
            } else {
                if (col.getType().getHasScalePrecision()) {
                    buffer.put(col.getPrecision());
                    buffer.put(col.getScale());
                } else {
                    buffer.put((byte)0);
                    buffer.put((byte)0);
                }
                buffer.putShort((short)0);
            }
            buffer.put(ColumnImpl.getColumnBitFlags(col));
            if (col.isCompressedUnicode()) {
                buffer.put((byte)1);
            } else {
                buffer.put((byte)0);
            }
            buffer.putInt(0);
            if (col.getType().isVariableLength()) {
                buffer.putShort((short)0);
            } else {
                buffer.putShort(fixedOffset);
                fixedOffset = (short)(fixedOffset + col.getType().getFixedSize(col.getLength()));
            }
            if (!col.getType().isLongValue()) {
                buffer.putShort(col.getLength());
                continue;
            }
            buffer.putShort((short)0);
        }
        for (ColumnBuilder col : columns) {
            TableImpl.writeName(buffer, col.getName(), creator.getCharset());
        }
    }

    static SortOrder readSortOrder(ByteBuffer buffer, int position, JetFormat format) {
        short value = buffer.getShort(position);
        byte version = 0;
        if (format.SIZE_SORT_ORDER == 4) {
            version = buffer.get(position + 3);
        }
        if (value == 0) {
            return format.DEFAULT_SORT_ORDER;
        }
        if (value == 1033) {
            if (version == GENERAL_LEGACY_SORT_ORDER.getVersion()) {
                return GENERAL_LEGACY_SORT_ORDER;
            }
            if (version == GENERAL_SORT_ORDER.getVersion()) {
                return GENERAL_SORT_ORDER;
            }
        }
        return new SortOrder(value, version);
    }

    private static void writeSortOrder(ByteBuffer buffer, SortOrder sortOrder, JetFormat format) {
        if (sortOrder == null) {
            sortOrder = format.DEFAULT_SORT_ORDER;
        }
        buffer.putShort(sortOrder.getValue());
        if (format.SIZE_SORT_ORDER == 4) {
            buffer.put((byte)0);
            buffer.put(sortOrder.getVersion());
        }
    }

    private final class UmapLongValueBufferHolder
    extends LongValueBufferHolder {
        private final UsageMap _ownedPages;
        private final UsageMap _freeSpacePages;
        private final TempPageHolder _longValueBufferH;

        private UmapLongValueBufferHolder(UsageMap ownedPages, UsageMap freeSpacePages) {
            this._longValueBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
            this._ownedPages = ownedPages;
            this._freeSpacePages = freeSpacePages;
        }

        protected TempPageHolder getBufferHolder() {
            return this._longValueBufferH;
        }

        public int getOwnedPageCount() {
            return this._ownedPages.getPageCount();
        }

        protected ByteBuffer findNewPage(int dataLength) throws IOException {
            ByteBuffer newPage = TableImpl.findFreeRowSpace(this._ownedPages, this._freeSpacePages, this._longValueBufferH);
            if (newPage != null) {
                if (TableImpl.rowFitsOnDataPage(dataLength, newPage, ColumnImpl.this.getFormat())) {
                    return newPage;
                }
                this.clear();
            }
            newPage = super.findNewPage(dataLength);
            int pageNumber = this.getPageNumber();
            this._ownedPages.addPageNumber(pageNumber);
            this._freeSpacePages.addPageNumber(pageNumber);
            return newPage;
        }

        public void clear() throws IOException {
            int pageNumber = this.getPageNumber();
            if (pageNumber != -1) {
                this._freeSpacePages.removePageNumber(pageNumber, true);
            }
            super.clear();
        }
    }

    private final class LegacyLongValueBufferHolder
    extends LongValueBufferHolder {
        private LegacyLongValueBufferHolder() {
        }

        protected TempPageHolder getBufferHolder() {
            return ColumnImpl.this.getTable().getLongValueBuffer();
        }
    }

    private abstract class LongValueBufferHolder {
        private LongValueBufferHolder() {
        }

        public ByteBuffer getLongValuePage(int dataLength) throws IOException {
            TempPageHolder lvalBufferH = this.getBufferHolder();
            dataLength = Math.min(dataLength, ColumnImpl.this.getFormat().MAX_LONG_VALUE_ROW_SIZE);
            ByteBuffer lvalPage = null;
            if (lvalBufferH.getPageNumber() != -1 && TableImpl.rowFitsOnDataPage(dataLength, lvalPage = lvalBufferH.getPage(ColumnImpl.this.getPageChannel()), ColumnImpl.this.getFormat())) {
                return lvalPage;
            }
            return this.findNewPage(dataLength);
        }

        protected ByteBuffer findNewPage(int dataLength) throws IOException {
            ByteBuffer lvalPage = this.getBufferHolder().setNewPage(ColumnImpl.this.getPageChannel());
            ColumnImpl.this.writeLongValueHeader(lvalPage);
            return lvalPage;
        }

        public int getOwnedPageCount() {
            return 0;
        }

        public int getPageNumber() {
            return this.getBufferHolder().getPageNumber();
        }

        public void clear() throws IOException {
            this.getBufferHolder().clear();
        }

        protected abstract TempPageHolder getBufferHolder();
    }

    private static final class TextInfo {
        private boolean _compressedUnicode;
        private SortOrder _sortOrder;
        private short _codePage;
        private ColumnImpl _versionHistoryCol;
        private boolean _hyperlink;

        private TextInfo() {
        }
    }

    private static final class NumericInfo {
        private byte _precision;
        private byte _scale;

        private NumericInfo() {
        }
    }

    public static final class SortOrder {
        private final short _value;
        private final byte _version;

        public SortOrder(short value, byte version) {
            this._value = value;
            this._version = version;
        }

        public short getValue() {
            return this._value;
        }

        public byte getVersion() {
            return this._version;
        }

        public int hashCode() {
            return this._value;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this._value == ((SortOrder)o)._value && this._version == ((SortOrder)o)._version;
        }

        public String toString() {
            return CustomToStringStyle.valueBuilder(this).append(null, (Object)(this._value + "(" + this._version + ")")).toString();
        }
    }

    private final class UnsupportedAutoNumberGenerator
    extends AutoNumberGenerator {
        private final DataType _genType;

        private UnsupportedAutoNumberGenerator(DataType genType) {
            this._genType = genType;
        }

        public Object getLast() {
            return null;
        }

        public Object getNext(Object prevRowValue) {
            throw new UnsupportedOperationException();
        }

        public void restoreLast(Object last) {
            throw new UnsupportedOperationException();
        }

        public DataType getType() {
            return this._genType;
        }
    }

    private final class ComplexTypeAutoNumberGenerator
    extends AutoNumberGenerator {
        private ComplexTypeAutoNumberGenerator() {
        }

        public Object getLast() {
            return ColumnImpl.this.getTable().getLastComplexTypeAutoNumber();
        }

        public Object getNext(Object prevRowValue) {
            int nextComplexAutoNum = prevRowValue == null ? ColumnImpl.this.getTable().getNextComplexTypeAutoNumber() : ((ComplexValueForeignKey)prevRowValue).get();
            return new ComplexValueForeignKeyImpl(ColumnImpl.this, nextComplexAutoNum);
        }

        public void restoreLast(Object last) {
            if (last instanceof ComplexValueForeignKey) {
                ColumnImpl.this.getTable().restoreLastComplexTypeAutoNumber(((ComplexValueForeignKey)last).get());
            }
        }

        public DataType getType() {
            return DataType.COMPLEX_TYPE;
        }
    }

    private final class GuidAutoNumberGenerator
    extends AutoNumberGenerator {
        private Object _lastAutoNumber;

        private GuidAutoNumberGenerator() {
        }

        public Object getLast() {
            return this._lastAutoNumber;
        }

        public Object getNext(Object prevRowValue) {
            this._lastAutoNumber = "{" + UUID.randomUUID() + "}";
            return this._lastAutoNumber;
        }

        public void restoreLast(Object last) {
            this._lastAutoNumber = null;
        }

        public DataType getType() {
            return DataType.GUID;
        }
    }

    private final class LongAutoNumberGenerator
    extends AutoNumberGenerator {
        private LongAutoNumberGenerator() {
        }

        public Object getLast() {
            return ColumnImpl.this.getTable().getLastLongAutoNumber();
        }

        public Object getNext(Object prevRowValue) {
            return ColumnImpl.this.getTable().getNextLongAutoNumber();
        }

        public void restoreLast(Object last) {
            if (last instanceof Integer) {
                ColumnImpl.this.getTable().restoreLastLongAutoNumber((Integer)last);
            }
        }

        public DataType getType() {
            return DataType.LONG;
        }
    }

    public abstract class AutoNumberGenerator {
        protected AutoNumberGenerator() {
        }

        public abstract Object getLast();

        public abstract Object getNext(Object var1);

        public abstract void restoreLast(Object var1);

        public abstract DataType getType();
    }

    private static class RawData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final byte[] _bytes;

        private RawData(byte[] bytes) {
            this._bytes = bytes;
        }

        private byte[] getBytes() {
            return this._bytes;
        }

        public String toString() {
            return CustomToStringStyle.valueBuilder(this).append(null, this.getBytes()).toString();
        }

        private Object writeReplace() throws ObjectStreamException {
            return this.getBytes();
        }
    }

    private static final class DateExt
    extends Date {
        private static final long serialVersionUID = 0L;
        private final transient long _dateBits;

        private DateExt(long time, long dateBits) {
            super(time);
            this._dateBits = dateBits;
        }

        public long getDateBits() {
            return this._dateBits;
        }

        private Object writeReplace() throws ObjectStreamException {
            return new Date(super.getTime());
        }
    }
}

