/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.impl.CodecHandler;
import com.healthmarketscience.jackcess.impl.CodecProvider;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.DefaultCodecProvider;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.TempBufferHolder;
import com.healthmarketscience.jackcess.impl.TempPageHolder;
import com.healthmarketscience.jackcess.impl.UsageMap;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PageChannel
implements Channel,
Flushable {
    private static final Log LOG = LogFactory.getLog(PageChannel.class);
    static final int INVALID_PAGE_NUMBER = -1;
    static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final byte[] INVALID_PAGE_BYTE_HEADER = new byte[]{0, 0, 0, 0};
    static final int PAGE_GLOBAL_USAGE_MAP = 1;
    static final int ROW_GLOBAL_USAGE_MAP = 0;
    private final FileChannel _channel;
    private final boolean _closeChannel;
    private final JetFormat _format;
    private final boolean _autoSync;
    private final ByteBuffer _invalidPageBytes = ByteBuffer.wrap(INVALID_PAGE_BYTE_HEADER);
    private final ByteBuffer _forceBytes = ByteBuffer.allocate(1);
    private UsageMap _globalUsageMap;
    private CodecHandler _codecHandler = DefaultCodecProvider.DUMMY_HANDLER;
    private TempPageHolder _fullPageEncodeBufferH;
    private TempBufferHolder _tempDecodeBufferH;
    private int _writeCount;

    protected PageChannel(boolean testing) {
        if (!testing) {
            throw new IllegalArgumentException();
        }
        this._channel = null;
        this._closeChannel = false;
        this._format = JetFormat.VERSION_4;
        this._autoSync = false;
    }

    public PageChannel(FileChannel channel, boolean closeChannel, JetFormat format, boolean autoSync) throws IOException {
        this._channel = channel;
        this._closeChannel = closeChannel;
        this._format = format;
        this._autoSync = autoSync;
    }

    public void initialize(DatabaseImpl database, CodecProvider codecProvider) throws IOException {
        this._codecHandler = codecProvider.createHandler(this, database.getCharset());
        if (!this._codecHandler.canEncodePartialPage()) {
            this._fullPageEncodeBufferH = TempPageHolder.newHolder(TempBufferHolder.Type.SOFT);
        }
        if (!this._codecHandler.canDecodeInline()) {
            this._tempDecodeBufferH = TempBufferHolder.newHolder(TempBufferHolder.Type.SOFT, true);
        }
        this._globalUsageMap = UsageMap.read(database, 1, 0, true);
    }

    public JetFormat getFormat() {
        return this._format;
    }

    public boolean isAutoSync() {
        return this._autoSync;
    }

    public void startWrite() {
        ++this._writeCount;
    }

    public void finishWrite() throws IOException {
        this.assertWriting();
        if (--this._writeCount == 0 && this._autoSync) {
            this.flush();
        }
    }

    public boolean isWriting() {
        return this._writeCount > 0;
    }

    private void assertWriting() {
        if (!this.isWriting()) {
            throw new IllegalStateException("No write operation in progress");
        }
    }

    private int getNextPageNumber(long size) {
        return (int)(size / (long)this.getFormat().PAGE_SIZE);
    }

    private long getPageOffset(int pageNumber) {
        return (long)pageNumber * (long)this.getFormat().PAGE_SIZE;
    }

    private void validatePageNumber(int pageNumber) throws IOException {
        int nextPageNumber = this.getNextPageNumber(this._channel.size());
        if (pageNumber <= -1 || pageNumber >= nextPageNumber) {
            throw new IllegalStateException("invalid page number " + pageNumber);
        }
    }

    public void readPage(ByteBuffer buffer, int pageNumber) throws IOException {
        this.validatePageNumber(pageNumber);
        ByteBuffer inPage = buffer;
        ByteBuffer outPage = buffer;
        if (pageNumber != 0 && !this._codecHandler.canDecodeInline()) {
            inPage = this._tempDecodeBufferH.getPageBuffer(this);
            outPage.clear();
        }
        inPage.clear();
        int bytesRead = this._channel.read(inPage, (long)pageNumber * (long)this.getFormat().PAGE_SIZE);
        inPage.flip();
        if (bytesRead != this.getFormat().PAGE_SIZE) {
            throw new IOException("Failed attempting to read " + this.getFormat().PAGE_SIZE + " bytes from page " + pageNumber + ", only read " + bytesRead);
        }
        if (pageNumber == 0) {
            this.applyHeaderMask(buffer);
        } else {
            this._codecHandler.decodePage(inPage, outPage, pageNumber);
        }
    }

    public void writePage(ByteBuffer page, int pageNumber) throws IOException {
        this.writePage(page, pageNumber, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePage(ByteBuffer page, int pageNumber, int pageOffset) throws IOException {
        this.assertWriting();
        this.validatePageNumber(pageNumber);
        page.rewind().position(pageOffset);
        int writeLen = page.remaining();
        if (writeLen + pageOffset > this.getFormat().PAGE_SIZE) {
            throw new IllegalArgumentException("Page buffer is too large, size " + (writeLen + pageOffset));
        }
        ByteBuffer encodedPage = page;
        if (pageNumber == 0) {
            this.applyHeaderMask(page);
        } else {
            if (!this._codecHandler.canEncodePartialPage()) {
                if (pageOffset > 0 && writeLen < this.getFormat().PAGE_SIZE) {
                    ByteBuffer fullPage = this._fullPageEncodeBufferH.setPage(this, pageNumber);
                    fullPage.position(pageOffset);
                    fullPage.put(page);
                    fullPage.rewind();
                    page = fullPage;
                    pageOffset = 0;
                    writeLen = this.getFormat().PAGE_SIZE;
                } else {
                    this._fullPageEncodeBufferH.possiblyInvalidate(pageNumber, null);
                }
            }
            encodedPage = this._codecHandler.encodePage(page, pageNumber, pageOffset);
            encodedPage.position(pageOffset).limit(pageOffset + writeLen);
        }
        try {
            this._channel.write(encodedPage, this.getPageOffset(pageNumber) + (long)pageOffset);
        }
        finally {
            if (pageNumber == 0) {
                this.applyHeaderMask(page);
            }
        }
    }

    public int allocateNewPage() throws IOException {
        this.assertWriting();
        long size = this._channel.size();
        if (size >= this.getFormat().MAX_DATABASE_SIZE) {
            throw new IOException("Database is at maximum size " + this.getFormat().MAX_DATABASE_SIZE);
        }
        if (size % (long)this.getFormat().PAGE_SIZE != 0L) {
            throw new IOException("Database corrupted, file size " + size + " is not multiple of page size " + this.getFormat().PAGE_SIZE);
        }
        this._forceBytes.rewind();
        int pageOffset = this.getFormat().PAGE_SIZE - this._forceBytes.remaining();
        long offset = size + (long)pageOffset;
        int pageNumber = this.getNextPageNumber(size);
        this._channel.write(this._forceBytes, offset);
        this._globalUsageMap.removePageNumber(pageNumber, true);
        return pageNumber;
    }

    public void deallocatePage(int pageNumber) throws IOException {
        this.assertWriting();
        this.validatePageNumber(pageNumber);
        this._invalidPageBytes.rewind();
        this._channel.write(this._invalidPageBytes, this.getPageOffset(pageNumber));
        this._globalUsageMap.addPageNumber(pageNumber);
    }

    public ByteBuffer createPageBuffer() {
        return this.createBuffer(this.getFormat().PAGE_SIZE);
    }

    public ByteBuffer createBuffer(int size) {
        return this.createBuffer(size, DEFAULT_BYTE_ORDER);
    }

    public ByteBuffer createBuffer(int size, ByteOrder order) {
        return ByteBuffer.allocate(size).order(order);
    }

    public void flush() throws IOException {
        this._channel.force(true);
    }

    public void close() throws IOException {
        this.flush();
        if (this._closeChannel) {
            this._channel.close();
        }
    }

    public boolean isOpen() {
        return this._channel.isOpen();
    }

    private void applyHeaderMask(ByteBuffer buffer) {
        byte[] headerMask = this._format.HEADER_MASK;
        for (int idx = 0; idx < headerMask.length; ++idx) {
            int pos = idx + this._format.OFFSET_MASKED_HEADER;
            byte b = (byte)(buffer.get(pos) ^ headerMask[idx]);
            buffer.put(pos, b);
        }
    }

    public static ByteBuffer narrowBuffer(ByteBuffer buffer, int position, int limit) {
        return (ByteBuffer)buffer.duplicate().order(buffer.order()).clear().limit(limit).position(position).mark();
    }

    public static ByteBuffer wrap(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(DEFAULT_BYTE_ORDER);
    }
}

