/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.scsu;

import com.healthmarketscience.jackcess.impl.scsu.Debug;
import com.healthmarketscience.jackcess.impl.scsu.EndOfInputException;
import com.healthmarketscience.jackcess.impl.scsu.EndOfOutputException;
import com.healthmarketscience.jackcess.impl.scsu.IllegalInputException;
import com.healthmarketscience.jackcess.impl.scsu.SCSU;

public class Compress
extends SCSU {
    private int iIn;
    private int iOut;
    private int iSCU = -1;
    private boolean fUnicodeMode = false;
    static int iNextWindow = 3;

    private boolean locateWindow(int ch, int[] offsetTable) {
        int iWin = this.getCurrentWindow();
        if (iWin != -1 && ch >= offsetTable[iWin] && ch < offsetTable[iWin] + 128) {
            return true;
        }
        for (iWin = 0; iWin < offsetTable.length; ++iWin) {
            if (ch < offsetTable[iWin] || ch >= offsetTable[iWin] + 128) continue;
            this.selectWindow(iWin);
            return true;
        }
        return false;
    }

    public static boolean isAsciiCrLfOrTab(int ch) {
        return ch >= 32 && ch <= 127 || ch == 9 || ch == 10 || ch == 13;
    }

    public int outputSingleByteRun(char[] in, byte[] out) throws EndOfOutputException, EndOfInputException, IllegalInputException {
        int iWin = this.getCurrentWindow();
        while (this.iIn < in.length) {
            int outlen = 0;
            byte byte1 = 0;
            byte byte2 = 0;
            int ch = in[this.iIn];
            int inlen = 1;
            if ((ch & 0xF800) == 55296) {
                if ((ch & 0xFC00) == 56320) {
                    throw new IllegalInputException("Unpaired low surrogate: " + this.iIn);
                }
                if (this.iIn >= in.length - 1) {
                    throw new EndOfInputException();
                }
                char ch2 = in[this.iIn + 1];
                if ((ch2 & 0xFC00) != 56320) {
                    throw new IllegalInputException("Unpaired high surrogate: " + (this.iIn + 1));
                }
                ch = (ch - 55296 << 10 | ch2 - 56320) + 65536;
                inlen = 2;
            }
            if (Compress.isAsciiCrLfOrTab(ch) || ch == 0) {
                byte2 = (byte)(ch & 0x7F);
                outlen = 1;
            } else if (ch < 32) {
                byte1 = 1;
                byte2 = (byte)ch;
                outlen = 2;
            } else if (ch >= this.dynamicOffset[iWin] && ch < this.dynamicOffset[iWin] + 128) {
                byte2 = (byte)((ch -= this.dynamicOffset[iWin]) | 0x80);
                outlen = 1;
            }
            if (this.iOut + outlen >= out.length) {
                throw new EndOfOutputException();
            }
            switch (outlen) {
                default: {
                    return ch;
                }
                case 2: {
                    out[this.iOut++] = byte1;
                }
                case 1: 
            }
            out[this.iOut++] = byte2;
            this.iIn += inlen;
        }
        return 0;
    }

    private void quoteSingleByte(int ch, byte[] out) throws EndOfOutputException {
        Debug.out("Quoting SingleByte ", ch);
        int iWin = this.getCurrentWindow();
        if (this.iOut >= out.length - 2) {
            throw new EndOfOutputException();
        }
        out[this.iOut++] = (byte)(1 + iWin);
        if (ch >= this.dynamicOffset[iWin] && ch < this.dynamicOffset[iWin] + 128) {
            out[this.iOut++] = (byte)((ch -= this.dynamicOffset[iWin]) | 0x80);
        } else if (ch >= staticOffset[iWin] && ch < staticOffset[iWin] + 128) {
            out[this.iOut++] = (byte)(ch -= staticOffset[iWin]);
        } else {
            throw new IllegalStateException("ch = " + ch + " not valid in quoteSingleByte. Internal Compressor Error");
        }
        ++this.iIn;
        Debug.out("New input: ", this.iIn);
    }

    public char outputUnicodeRun(char[] in, byte[] out) throws EndOfOutputException {
        char ch = '\u0000';
        while (this.iIn < in.length) {
            ch = in[this.iIn];
            int outlen = 2;
            if (Compress.isCompressible(ch)) {
                if (this.iIn < in.length - 1) {
                    Debug.out("is-comp: ", ch);
                    char ch2 = in[this.iIn + 1];
                    if (Compress.isCompressible(ch2)) break;
                    Debug.out("no-comp: ", ch2);
                }
                if (ch >= '\ue000' && ch <= '\uf2ff') {
                    outlen = 3;
                }
            }
            if (this.iOut >= out.length - outlen) {
                Debug.out("End of Output @", this.iOut);
                throw new EndOfOutputException();
            }
            if (outlen == 3) {
                out[this.iOut++] = -16;
            }
            out[this.iOut++] = (byte)(ch >>> 8);
            out[this.iOut++] = (byte)(ch & 0xFF);
            ++this.iIn;
        }
        return ch;
    }

    private boolean positionWindow(int ch, byte[] out, boolean fCurUnicodeMode) throws IllegalInputException, EndOfOutputException {
        int iWin = iNextWindow % 8;
        int iPosition = 0;
        if (ch < 128) {
            throw new IllegalStateException("ch < 0x80");
        }
        for (int i = 0; i < fixedOffset.length; ++i) {
            if (ch < fixedOffset[i] || ch >= fixedOffset[i] + 128) continue;
            iPosition = i;
            break;
        }
        if (iPosition != 0) {
            Debug.out("FIXED position is ", iPosition + 249);
            this.dynamicOffset[iWin] = fixedOffset[iPosition];
            iPosition += 249;
        } else if (ch < 13312) {
            iPosition = ch >>> 7;
            this.dynamicOffset[iWin] = ch & 0xFF80;
            Debug.out("Offset=" + this.dynamicOffset[iWin] + ", iPosition=" + iPosition + " for char", ch);
        } else {
            if (ch < 57344) {
                return false;
            }
            if (ch <= 65535) {
                iPosition = ch - 44032 >>> 7;
                this.dynamicOffset[iWin] = ch & 0xFF80;
                Debug.out("Offset=" + this.dynamicOffset[iWin] + ", iPosition=" + iPosition + " for char", ch);
            } else {
                iPosition = ch - 65536 >>> 7;
                Debug.out("Try position Window at ", iPosition);
                iPosition |= iWin << 13;
                this.dynamicOffset[iWin] = ch & 0x1FFF80;
            }
        }
        if (iPosition < 256 && this.iOut < out.length - 1) {
            out[this.iOut++] = (byte)((fCurUnicodeMode ? -24 : 24) + iWin);
            out[this.iOut++] = (byte)(iPosition & 0xFF);
        } else if (iPosition >= 256 && this.iOut < out.length - 2) {
            Debug.out("Setting extended window at ", iPosition);
            out[this.iOut++] = fCurUnicodeMode ? -15 : 11;
            out[this.iOut++] = (byte)(iPosition >>> 8 & 0xFF);
            out[this.iOut++] = (byte)(iPosition & 0xFF);
        } else {
            throw new EndOfOutputException();
        }
        this.selectWindow(iWin);
        ++iNextWindow;
        return true;
    }

    public int simpleCompress(char[] in, int iStartIn, byte[] out, int iStartOut) throws IllegalInputException, EndOfInputException, EndOfOutputException {
        this.iIn = iStartIn;
        this.iOut = iStartOut;
        while (this.iIn < in.length) {
            int ch;
            if (this.iSCU != -1) {
                Debug.out("Remaining", in, this.iIn);
                Debug.out("Output until [" + this.iOut + "]: ", out);
                ch = this.outputUnicodeRun(in, out);
                if (this.iOut - this.iSCU == 3) {
                    out[this.iSCU] = 14;
                    this.iSCU = -1;
                    continue;
                }
                this.iSCU = -1;
                this.fUnicodeMode = true;
            } else {
                ch = this.outputSingleByteRun(in, out);
            }
            if (this.iIn == in.length) break;
            Debug.out("Output so far: ", out);
            Debug.out("Routing ch=" + ch + " for Input", in, this.iIn);
            if (this.iOut >= out.length - 1) {
                throw new EndOfOutputException();
            }
            int ich = this.iIn;
            while (ch < 128) {
                if (ich == in.length || !Compress.isCompressible(in[ich])) {
                    ch = in[this.iIn];
                    break;
                }
                ch = in[ich];
                ++ich;
            }
            int iprevWindow = this.getCurrentWindow();
            if (ch < 128 || this.locateWindow(ch, this.dynamicOffset)) {
                char ch2;
                Debug.out("located dynamic window " + this.getCurrentWindow() + " at ", this.iOut + 1);
                if (!this.fUnicodeMode && this.iIn < in.length - 1 && (ch2 = in[this.iIn + 1]) >= this.dynamicOffset[iprevWindow] && ch2 < this.dynamicOffset[iprevWindow] + 128) {
                    this.quoteSingleByte(ch, out);
                    this.selectWindow(iprevWindow);
                    continue;
                }
                out[this.iOut++] = (byte)((this.fUnicodeMode ? -32 : 16) + this.getCurrentWindow());
                this.fUnicodeMode = false;
                continue;
            }
            if (!this.fUnicodeMode && this.locateWindow(ch, staticOffset)) {
                Debug.out("located a static window", this.getCurrentWindow());
                this.quoteSingleByte(ch, out);
                this.selectWindow(iprevWindow);
                continue;
            }
            if (this.positionWindow(ch, out, this.fUnicodeMode)) {
                this.fUnicodeMode = false;
                continue;
            }
            this.iSCU = this.iOut;
            out[this.iOut++] = 15;
        }
        return this.iOut - iStartOut;
    }

    public byte[] compress(String inStr) throws IllegalInputException, EndOfInputException {
        byte[] out = new byte[inStr.length() * 2];
        char[] in = inStr.toCharArray();
        Debug.out("compress input: ", in);
        this.reset();
        while (true) {
            try {
                this.simpleCompress(in, this.charsRead(), out, this.bytesWritten());
            }
            catch (EndOfOutputException e) {
                byte[] largerOut = new byte[out.length * 2];
                System.arraycopy(out, 0, largerOut, 0, out.length);
                out = largerOut;
                continue;
            }
            break;
        }
        byte[] trimmedOut = new byte[this.bytesWritten()];
        System.arraycopy(out, 0, trimmedOut, 0, trimmedOut.length);
        out = trimmedOut;
        Debug.out("compress output: ", out);
        return out;
    }

    public void reset() {
        super.reset();
        this.fUnicodeMode = false;
        this.iSCU = -1;
    }

    public int bytesWritten() {
        return this.iOut;
    }

    public int charsRead() {
        return this.iIn;
    }
}

