/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.datamodel;

import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.datamodel.AbstractListListener;
import com.higherfrequencytrading.chronicle.datamodel.CollectionListener;
import com.higherfrequencytrading.chronicle.datamodel.DataStore;
import com.higherfrequencytrading.chronicle.datamodel.ListListener;
import com.higherfrequencytrading.chronicle.datamodel.ObservableList;
import com.higherfrequencytrading.chronicle.datamodel.WrapperEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListWrapper<E>
implements ObservableList<E> {
    private final DataStore dataStore;
    private final String name;
    private final Class<E> eClass;
    private final List<E> underlying;
    private final int maxMessageSize;
    private final int offset;
    private final List<ListListener<E>> listeners = new ArrayList<ListListener<E>>();
    private boolean notifyOff = false;
    private final boolean enumClass;
    private Annotation[] annotations = new Annotation[0];

    public ListWrapper(DataStore dataStore, String name, Class<E> eClass, List<E> underlying, int maxMessageSize) {
        this(dataStore, name, eClass, underlying, maxMessageSize, 0);
    }

    public ListWrapper(DataStore dataStore, String name, Class<E> eClass, List<E> underlying, int maxMessageSize, int offset) {
        this.dataStore = dataStore;
        this.name = name;
        this.eClass = eClass;
        this.underlying = underlying;
        this.maxMessageSize = maxMessageSize;
        this.offset = offset;
        this.enumClass = dataStore.enumeratedClass(eClass);
        dataStore.add(name, this);
    }

    @Override
    public void addListener(CollectionListener<E> listener) {
        this.listeners.add(new ListCollectionListener<E>(listener));
    }

    @Override
    public void removeListener(CollectionListener<E> listener) {
        Iterator<ListListener<E>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListListener<E> listListener = iterator.next();
            if (!(listListener instanceof ListCollectionListener) || ((ListCollectionListener)listListener).listener != listener) continue;
            iterator.remove();
        }
    }

    @Override
    public void inSync() {
        for (ListListener<E> listener : this.listeners) {
            listener.inSync();
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = Arrays.copyOf(annotations, annotations.length);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public void addListener(ListListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ListListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean add(E e) {
        this.checkWritable();
        if (!this.underlying.add(e)) {
            return false;
        }
        this.writeAdd(e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.checkWritable();
        this.underlying.add(index, element);
        this.writeAdd(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkWritable();
        this.underlying.addAll(c);
        if (c.isEmpty()) {
            return false;
        }
        if (c.size() == 1) {
            this.writeAdd(c instanceof List ? ((List)c).get(0) : c.iterator().next());
        } else {
            this.writeAddAll(c);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkWritable();
        ArrayList<E> added = new ArrayList<E>();
        for (E e : c) {
            if (!this.underlying.add(e)) continue;
            added.add(e);
        }
        if (added.isEmpty()) {
            return false;
        }
        if (added.size() == 1) {
            this.writeAdd(added.get(0));
        } else {
            this.writeAddAll(added);
        }
        return true;
    }

    void checkWritable() {
        this.dataStore.checkWritable();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlying.containsAll(c);
    }

    @Override
    public void clear() {
        this.checkWritable();
        this.writeClear();
        this.underlying.clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.underlying).equals(o);
    }

    @Override
    public E get(int index) {
        return this.underlying.get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this.underlying).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.underlying.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.underlying.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            final ListIterator<E> iter;
            E last;
            {
                this.iter = ListWrapper.this.underlying.listIterator(index);
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                this.last = this.iter.next();
                return this.last;
            }

            @Override
            public void remove() {
                ListWrapper.this.checkWritable();
                this.iter.remove();
                int maxSize = ListWrapper.this.maxMessageSize;
                Excerpt excerpt = ListWrapper.this.getExcerpt(maxSize, WrapperEvent.remove);
                ListWrapper.this.writeElement(excerpt, this.last);
                excerpt.finish();
            }

            @Override
            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            @Override
            public E previous() {
                return this.iter.previous();
            }

            @Override
            public int nextIndex() {
                return this.iter.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.iter.previousIndex();
            }

            @Override
            public void set(E e) {
                ListWrapper.this.set(this.iter.previousIndex() + 1, e);
            }

            @Override
            public void add(E e) {
                ListWrapper.this.add(this.iter.previousIndex() + 1, e);
            }
        };
    }

    @Override
    public void notifyOff(boolean notifyOff) {
        this.notifyOff = notifyOff;
    }

    @Override
    public void onExcerpt(Excerpt excerpt) {
        WrapperEvent event = excerpt.readEnum(WrapperEvent.class);
        if (!this.notifyOff) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).eventStart(excerpt.index(), this.name);
            }
        }
        try {
            switch (event) {
                case add: {
                    E e = this.readElement(excerpt);
                    this.underlying.add(e);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).add(e);
                    }
                    break;
                }
                case addIndex: {
                    int index = excerpt.readInt();
                    E e = this.readElement(excerpt);
                    this.underlying.add(index, e);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).add(index, e);
                    }
                    break;
                }
                case addAll: {
                    List<E> eList = this.readList(excerpt);
                    this.underlying.addAll(eList);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        CollectionListener listener = this.listeners.get(i);
                        for (int j = 0; j < eList.size(); ++j) {
                            listener.add(eList.get(j));
                        }
                    }
                    break;
                }
                case addAllIndex: {
                    int index = excerpt.readInt();
                    List<E> eList = this.readList(excerpt);
                    this.underlying.addAll(index, eList);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        ListListener<E> listener = this.listeners.get(i);
                        for (int j = 0; j < eList.size(); ++j) {
                            listener.add(index + j, eList.get(j));
                        }
                    }
                    break;
                }
                case set: {
                    int index = excerpt.readInt();
                    E e = this.readElement(excerpt);
                    E oldElement = this.underlying.set(index, e);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).set(index, oldElement, e);
                    }
                    break;
                }
                case remove: {
                    E e = this.readElement(excerpt);
                    this.underlying.remove(e);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).remove(e);
                    }
                    break;
                }
                case removeIndex: {
                    int index = excerpt.readInt();
                    E oldElement = this.underlying.remove(index);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).remove(index, oldElement);
                    }
                    break;
                }
                case removeAll: {
                    List<E> eList = this.readList(excerpt);
                    this.underlying.removeAll(eList);
                    if (this.notifyOff) break;
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        CollectionListener listener = this.listeners.get(i);
                        for (int j = 0; j < eList.size(); ++j) {
                            listener.remove(eList.get(j));
                        }
                    }
                    break;
                }
                case clear: {
                    int offset = excerpt.readInt();
                    int size = excerpt.readInt();
                    int endToRemove = Math.min(size + offset, this.underlying.size());
                    if (!this.notifyOff) {
                        for (int i = 0; i < this.listeners.size(); ++i) {
                            ListListener<E> listener = this.listeners.get(i);
                            for (int j = offset; j < endToRemove; ++j) {
                                listener.remove(this.underlying.get(j));
                            }
                        }
                    }
                    if (offset != 0 || endToRemove != this.underlying.size()) {
                        this.underlying.subList(offset, offset + size).clear();
                        break;
                    }
                    this.underlying.clear();
                    break;
                }
                case event: {
                    if (this.notifyOff) break;
                    Object object = excerpt.readObject();
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).onEvent(object);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (!this.notifyOff) {
            boolean lastEvent = !excerpt.hasNextIndex();
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).eventEnd(lastEvent);
            }
        }
    }

    @Override
    public E remove(int index) {
        this.checkWritable();
        if (index < this.size()) {
            E e = this.underlying.get(index);
            this.underlying.remove(index);
            this.writeRemove(index, e);
            return e;
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        this.checkWritable();
        if (!this.underlying.remove(o)) {
            return false;
        }
        this.writeRemove(o);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkWritable();
        ArrayList removed = new ArrayList();
        for (Object o : c) {
            if (!this.underlying.remove(o)) continue;
            removed.add(o);
        }
        if (removed.isEmpty()) {
            return false;
        }
        if (removed.size() == 0) {
            this.writeRemove(removed.get(0));
        } else {
            this.writeRemoveAll(removed);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkWritable();
        ArrayList<E> toremove = new ArrayList<E>(this.size());
        for (E e : this) {
            if (c.contains(e)) continue;
            toremove.add(e);
        }
        return !toremove.isEmpty() && this.removeAll(toremove);
    }

    @Override
    public E set(int index, E element) {
        this.checkWritable();
        E e = this.underlying.set(index, element);
        if (element.equals(e)) {
            return e;
        }
        this.writeSet(index, e, element);
        return e;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex >= this.size() || toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new ListWrapper<E>(this.dataStore, this.name, this.eClass, this.underlying.subList(fromIndex, toIndex), this.maxMessageSize);
    }

    @Override
    public E[] toArray() {
        return this.underlying.toArray((Object[])Array.newInstance(this.eClass, this.underlying.size()));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.underlying.toArray(a);
    }

    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public void publishEvent(Object object) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize + 128, WrapperEvent.event);
        long eventId = excerpt.index();
        excerpt.writeObject((Object)WrapperEvent.event);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.onEvent(object);
                listener.eventEnd(true);
            }
        }
    }

    private Excerpt getExcerpt(int maxSize, WrapperEvent event) {
        Excerpt excerpt = this.dataStore.startExcerpt(maxSize + 2 + event.name().length(), this.name);
        excerpt.writeEnum(event);
        return excerpt;
    }

    private void writeAdd(E element) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.add);
        long eventId = excerpt.index();
        this.writeElement(excerpt, element);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.add(element);
                listener.eventEnd(true);
            }
        }
    }

    private void writeAdd(int index, E element) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.addIndex);
        long eventId = excerpt.index();
        excerpt.writeInt(this.offset + index);
        this.writeElement(excerpt, element);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.add(index, element);
                listener.eventEnd(true);
            }
        }
    }

    private void writeAddAll(Collection<E> added) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize * added.size(), WrapperEvent.addAll);
        long eventId = excerpt.index();
        this.writeList(excerpt, added);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (E e : added) {
                    listener.add(e);
                }
                listener.eventEnd(true);
            }
        }
    }

    private void writeClear() {
        Excerpt excerpt = this.getExcerpt(16, WrapperEvent.clear);
        long eventId = excerpt.index();
        excerpt.writeInt(this.offset);
        excerpt.writeInt(this.size());
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (int j = 0; j < this.underlying.size(); ++j) {
                    listener.remove(this.underlying.get(j));
                }
                listener.eventEnd(true);
            }
        }
    }

    private void writeRemove(Object o) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.remove);
        long eventId = excerpt.index();
        this.writeElement(excerpt, o);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.remove(o);
                listener.eventEnd(true);
            }
        }
    }

    private void writeRemove(int index, Object o) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.removeIndex);
        long eventId = excerpt.index();
        excerpt.writeInt(index);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListListener<Object> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.remove(index, o);
                listener.eventEnd(true);
            }
        }
    }

    private void writeRemoveAll(List<E> removed) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize * removed.size(), WrapperEvent.removeAll);
        long eventId = excerpt.index();
        this.writeList(excerpt, removed);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (int j = 0; j < removed.size(); ++j) {
                    listener.remove(removed.get(j));
                }
                listener.eventEnd(true);
            }
        }
    }

    private void writeSet(int index, E oldElement, E element) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.set);
        long eventId = excerpt.index();
        excerpt.writeEnum(WrapperEvent.add);
        excerpt.writeInt(this.offset + index);
        this.writeElement(excerpt, element);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.set(index, oldElement, element);
                listener.eventEnd(true);
            }
        }
    }

    private E readElement(Excerpt excerpt) {
        if (this.enumClass) {
            return excerpt.readEnum(this.eClass);
        }
        return (E)excerpt.readObject();
    }

    private void writeElement(Excerpt excerpt, E element) {
        if (this.enumClass) {
            excerpt.writeEnum(element);
        } else {
            excerpt.writeObject(element);
        }
    }

    private List<E> readList(Excerpt excerpt) {
        ArrayList eList = new ArrayList();
        if (this.enumClass) {
            excerpt.readEnums(this.eClass, eList);
        } else {
            excerpt.readList(eList);
        }
        return eList;
    }

    private void writeList(Excerpt excerpt, Collection<E> list) {
        if (this.enumClass) {
            excerpt.writeEnums(list);
        } else {
            excerpt.writeList(list);
        }
    }

    static class ListCollectionListener<E>
    extends AbstractListListener<E> {
        final CollectionListener<E> listener;

        public ListCollectionListener(CollectionListener<E> listener) {
            this.listener = listener;
        }

        @Override
        public void add(E element) {
            this.listener.add(element);
        }

        @Override
        public void remove(E e) {
            this.listener.remove(e);
        }
    }
}

