/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.datamodel;

import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.datamodel.CollectionListener;
import com.higherfrequencytrading.chronicle.datamodel.DataStore;
import com.higherfrequencytrading.chronicle.datamodel.ObservableSet;
import com.higherfrequencytrading.chronicle.datamodel.WrapperEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SetWrapper<E>
implements ObservableSet<E> {
    private final DataStore dataStore;
    private final String name;
    private final Class<E> eClass;
    private final Set<E> underlying;
    private final int maxMessageSize;
    private final List<CollectionListener<E>> listeners = new ArrayList<CollectionListener<E>>();
    private boolean notifyOff = false;
    private final boolean enumClass;
    private Annotation[] annotations = new Annotation[0];

    public SetWrapper(DataStore dataStore, String name, Class<E> eClass, Set<E> underlying, int maxMessageSize) {
        this.dataStore = dataStore;
        this.name = name;
        this.eClass = eClass;
        this.underlying = underlying;
        this.maxMessageSize = maxMessageSize;
        this.enumClass = dataStore.enumeratedClass(eClass);
        dataStore.add(name, this);
    }

    @Override
    public void addListener(CollectionListener<E> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void inSync() {
        for (CollectionListener<E> listener : this.listeners) {
            listener.inSync();
        }
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = Arrays.copyOf(annotations, annotations.length);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public boolean add(E e) {
        this.checkWritable();
        if (!this.underlying.add(e)) {
            return false;
        }
        this.writeAdd(e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkWritable();
        ArrayList<E> added = new ArrayList<E>();
        for (E e : c) {
            if (!this.underlying.add(e)) continue;
            added.add(e);
        }
        if (added.isEmpty()) {
            return false;
        }
        if (added.size() == 1) {
            this.writeAdd(added.get(0));
        } else {
            this.writeAddAll(added);
        }
        return true;
    }

    void checkWritable() {
        this.dataStore.checkWritable();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlying.containsAll(c);
    }

    @Override
    public void clear() {
        this.writeClear();
        this.underlying.clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.underlying).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.underlying).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            final Iterator<E> iter;
            E last;
            {
                this.iter = SetWrapper.this.underlying.iterator();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                this.last = this.iter.next();
                return this.last;
            }

            @Override
            public void remove() {
                SetWrapper.this.checkWritable();
                this.iter.remove();
                int maxSize = SetWrapper.this.maxMessageSize;
                Excerpt excerpt = SetWrapper.this.getExcerpt(maxSize, WrapperEvent.remove);
                SetWrapper.this.writeElement(excerpt, this.last);
                excerpt.finish();
            }
        };
    }

    @Override
    public void notifyOff(boolean notifyOff) {
        this.notifyOff = notifyOff;
    }

    @Override
    public void onExcerpt(Excerpt excerpt) {
        int i;
        WrapperEvent event = excerpt.readEnum(WrapperEvent.class);
        if (!this.notifyOff) {
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                this.listeners.get(i2).eventStart(excerpt.index(), this.name);
            }
        }
        try {
            switch (event) {
                case add: {
                    E e = this.readElement(excerpt);
                    this.underlying.add(e);
                    if (this.notifyOff) break;
                    for (i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).add(e);
                    }
                    break;
                }
                case addAll: {
                    int j;
                    CollectionListener<Object> listener;
                    List<E> eList = this.readList(excerpt);
                    this.underlying.addAll(eList);
                    if (this.notifyOff) break;
                    for (i = 0; i < this.listeners.size(); ++i) {
                        listener = this.listeners.get(i);
                        for (j = 0; j < eList.size(); ++j) {
                            listener.add(eList.get(j));
                        }
                    }
                    break;
                }
                case remove: {
                    E e = this.readElement(excerpt);
                    this.underlying.remove(e);
                    if (this.notifyOff) break;
                    for (i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).remove(e);
                    }
                    break;
                }
                case removeAll: {
                    int j;
                    CollectionListener<Object> listener;
                    List<E> eList = this.readList(excerpt);
                    this.underlying.removeAll(eList);
                    if (this.notifyOff) break;
                    for (i = 0; i < this.listeners.size(); ++i) {
                        listener = this.listeners.get(i);
                        for (j = 0; j < eList.size(); ++j) {
                            listener.remove(eList.get(j));
                        }
                    }
                    break;
                }
                case clear: {
                    int j;
                    CollectionListener<Object> listener;
                    if (!this.notifyOff && !this.listeners.isEmpty()) {
                        Object[] elements = this.underlying.toArray(new Object[this.underlying.size()]);
                        for (i = 0; i < this.listeners.size(); ++i) {
                            listener = this.listeners.get(i);
                            for (j = 0; j < elements.length; ++j) {
                                listener.remove(elements[j]);
                            }
                        }
                    }
                    this.underlying.clear();
                    break;
                }
                case event: {
                    if (this.notifyOff) break;
                    Object object = excerpt.readObject();
                    for (i = 0; i < this.listeners.size(); ++i) {
                        this.listeners.get(i).onEvent(object);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.notifyOff) {
            boolean lastEvent = !excerpt.hasNextIndex();
            for (i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).eventEnd(lastEvent);
            }
        }
    }

    @Override
    public boolean remove(Object o) {
        this.checkWritable();
        if (!this.underlying.remove(o)) {
            return false;
        }
        this.writeRemove(o);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkWritable();
        ArrayList removed = new ArrayList();
        for (Object o : c) {
            if (!this.underlying.remove(o)) continue;
            removed.add(o);
        }
        if (removed.isEmpty()) {
            return false;
        }
        if (removed.size() == 0) {
            this.writeRemove(removed.get(0));
        } else {
            this.writeRemoveAll(removed);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkWritable();
        ArrayList<E> toremove = new ArrayList<E>(this.size());
        for (E e : this) {
            if (c.contains(e)) continue;
            toremove.add(e);
        }
        return !toremove.isEmpty() && this.removeAll(toremove);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public E[] toArray() {
        return this.underlying.toArray((Object[])Array.newInstance(this.eClass, this.underlying.size()));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.underlying.toArray(a);
    }

    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public void publishEvent(Object object) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize + 128, WrapperEvent.event);
        long eventId = excerpt.index();
        excerpt.writeObject((Object)WrapperEvent.event);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.onEvent(object);
                listener.eventEnd(true);
            }
        }
    }

    private Excerpt getExcerpt(int maxSize, WrapperEvent event) {
        Excerpt excerpt = this.dataStore.startExcerpt(maxSize + 2 + event.name().length(), this.name);
        excerpt.writeEnum(event);
        return excerpt;
    }

    private void writeAdd(E element) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.add);
        long eventId = excerpt.index();
        this.writeElement(excerpt, element);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.add(element);
                listener.eventEnd(true);
            }
        }
    }

    private void writeAddAll(Collection<E> added) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize * added.size(), WrapperEvent.addAll);
        long eventId = excerpt.index();
        this.writeList(excerpt, added);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (E e : added) {
                    listener.add(e);
                }
                listener.eventEnd(true);
            }
        }
    }

    private void writeClear() {
        Excerpt excerpt = this.getExcerpt(10, WrapperEvent.clear);
        long eventId = excerpt.index();
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            Object[] elements = this.underlying.toArray(new Object[this.underlying.size()]);
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener<Object> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (int j = 0; j < elements.length; ++j) {
                    listener.remove(elements[j]);
                }
                listener.eventEnd(true);
            }
        }
    }

    private void writeRemove(Object o) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.remove);
        long eventId = excerpt.index();
        this.writeElement(excerpt, o);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener<Object> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.remove(o);
                listener.eventEnd(true);
            }
        }
    }

    private void writeRemoveAll(List<E> removed) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize * removed.size(), WrapperEvent.removeAll);
        long eventId = excerpt.index();
        this.writeList(excerpt, removed);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CollectionListener<E> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (int j = 0; j < removed.size(); ++j) {
                    listener.remove(removed.get(j));
                }
                listener.eventEnd(true);
            }
        }
    }

    private E readElement(Excerpt excerpt) {
        if (this.enumClass) {
            return excerpt.readEnum(this.eClass);
        }
        return (E)excerpt.readObject();
    }

    private void writeElement(Excerpt excerpt, E element) {
        if (this.enumClass) {
            excerpt.writeEnum(element);
        } else {
            excerpt.writeObject(element);
        }
    }

    private List<E> readList(Excerpt excerpt) {
        ArrayList eList = new ArrayList();
        if (this.enumClass) {
            excerpt.readEnums(this.eClass, eList);
        } else {
            excerpt.readList(eList);
        }
        return eList;
    }

    private void writeList(Excerpt excerpt, Collection<E> list) {
        if (this.enumClass) {
            excerpt.writeEnums(list);
        } else {
            excerpt.writeList(list);
        }
    }
}

