/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.ExcerptMarshallable;
import com.higherfrequencytrading.chronicle.impl.ClassEnumMarshaller;
import com.higherfrequencytrading.chronicle.impl.DateMarshaller;
import com.higherfrequencytrading.chronicle.impl.DirectChronicle;
import com.higherfrequencytrading.chronicle.impl.ExcerptMarshaller;
import com.higherfrequencytrading.chronicle.impl.ExternalizableMarshaller;
import com.higherfrequencytrading.chronicle.impl.GenericEnumMarshaller;
import com.higherfrequencytrading.chronicle.impl.StringMarshaller;
import com.higherfrequencytrading.chronicle.impl.VanillaEnumMarshaller;
import java.io.Externalizable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractChronicle
implements DirectChronicle {
    private final String name;
    private final Map<Class, EnumeratedMarshaller> marshallerMap = new LinkedHashMap<Class, EnumeratedMarshaller>();
    protected long size = 0L;
    private boolean multiThreaded = false;

    protected AbstractChronicle(String name) {
        this.name = name;
        StringMarshaller stringMarshaller = new StringMarshaller(16384);
        this.marshallerMap.put(String.class, stringMarshaller);
        this.marshallerMap.put(CharSequence.class, stringMarshaller);
        this.marshallerMap.put(Class.class, new ClassEnumMarshaller(Thread.currentThread().getContextClassLoader()));
        this.marshallerMap.put(Date.class, new DateMarshaller(10191));
    }

    @Override
    public boolean multiThreaded() {
        return this.multiThreaded;
    }

    @Override
    public void multiThreaded(boolean multiThreaded) {
        this.multiThreaded = multiThreaded;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public <E> void setEnumeratedMarshaller(EnumeratedMarshaller<E> marshaller) {
        this.marshallerMap.put(marshaller.classMarshaled(), marshaller);
    }

    @Override
    public <E> EnumeratedMarshaller<E> acquireMarshaller(Class<E> aClass) {
        EnumeratedMarshaller<Object> em = this.marshallerMap.get(aClass);
        if (em == null) {
            if (aClass.isEnum()) {
                em = new VanillaEnumMarshaller<Object>(aClass, null);
                this.marshallerMap.put(aClass, em);
            } else if (ExcerptMarshallable.class.isAssignableFrom(aClass)) {
                em = new ExcerptMarshaller<E>(aClass);
                this.marshallerMap.put(aClass, em);
            } else if (Externalizable.class.isAssignableFrom(aClass)) {
                em = new ExternalizableMarshaller<E>(aClass);
                this.marshallerMap.put(aClass, em);
            } else {
                em = new GenericEnumMarshaller<E>(aClass, 1000);
                this.marshallerMap.put(aClass, em);
            }
        }
        return em;
    }

    @Override
    public <E> EnumeratedMarshaller<E> getMarshaller(Class<E> aClass) {
        return this.marshallerMap.get(aClass);
    }
}

