/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.ByteStringAppender;
import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import com.higherfrequencytrading.chronicle.impl.DirectChronicle;
import com.higherfrequencytrading.chronicle.math.MutableDecimal;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractExcerpt
implements Excerpt {
    private static final int MIN_SIZE = 8;
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    protected final DirectChronicle chronicle;
    protected long index = -1L;
    protected long start = 0L;
    protected long position = 0L;
    private int capacity = 0;
    protected long limit = 0L;
    protected long startPosition;
    protected long size = 0L;
    protected MappedByteBuffer buffer;
    private boolean forWrite = false;
    private static final byte[] MIN_VALUE_TEXT = "-9223372036854775808".getBytes();
    private static final byte[] Infinity = "Infinity".getBytes();
    private static final byte[] NaN = "NaN".getBytes();
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    static final int MAX_NUMBER_LENGTH = 1 + (int)Math.ceil(Math.log10(9.223372036854776E18));
    private final byte[] numberBuffer = new byte[MAX_NUMBER_LENGTH];
    private ExcerptInputStream inputStream = null;
    private ExcerptOutputStream outputStream = null;
    private Thread lastThread = null;
    private final AtomicBoolean barrier = new AtomicBoolean();
    private StringBuilder utfReader = null;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final byte BYTE_EXTENDED = -127;
    private static final byte BYTE_MAX_VALUE = -126;
    private static final short UBYTE_EXTENDED = 255;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final short SHORT_EXTENDED = -32767;
    private static final short SHORT_MAX_VALUE = -32766;
    private static final int USHORT_EXTENDED = 65535;
    private static final int INT_MIN_VALUE = Integer.MIN_VALUE;
    private static final int INT_EXTENDED = -2147483647;
    private static final int INT_MAX_VALUE = -2147483646;
    private SimpleDateFormat dateFormat = null;
    private long lastDay = Long.MIN_VALUE;
    private byte[] lastDateStr = null;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final long[] TENS = new long[19];
    private static final byte NULL = 78;
    private static final byte ENUMED = 69;
    private static final byte SERIALIZED = 83;

    protected AbstractExcerpt(DirectChronicle chronicle) {
        this.chronicle = chronicle;
    }

    @Override
    public DirectChronicle chronicle() {
        return this.chronicle;
    }

    @Override
    public boolean nextIndex() {
        return this.index(this.index() + 1L);
    }

    @Override
    public boolean hasNextIndex() {
        this.readMemoryBarrier();
        long nextIndex = this.index + 1L;
        long endPosition = this.chronicle.getIndexData(nextIndex + 1L);
        return endPosition != 0L;
    }

    @Override
    public boolean index(long index) throws IndexOutOfBoundsException {
        this.forWrite = false;
        this.readMemoryBarrier();
        long endPosition = this.chronicle.getIndexData(index + 1L);
        if (endPosition == 0L) {
            this.capacity = 0;
            this.buffer = null;
            if (index == -1L) {
                this.index = -1L;
                this.capacity = 0;
                this.startPosition = this.position = (long)0;
                this.limit = this.position;
                return true;
            }
            return false;
        }
        long startPosition = this.chronicle.getIndexData(index);
        this.capacity = (int)(endPosition - startPosition);
        assert (this.capacity >= 8) : "end=" + endPosition + ", start=" + startPosition;
        this.index0(index, startPosition, endPosition);
        long l = this.readLong(0);
        return l != 0L;
    }

    @Override
    public long size() {
        this.readMemoryBarrier();
        long size = this.size - 1L;
        while (this.chronicle.getIndexData(++size + 1L) != 0L) {
        }
        this.size = size;
        return this.size;
    }

    private void readMemoryBarrier() {
        this.barrier.get();
    }

    @Override
    public void startExcerpt(int capacity) {
        this.capacity = capacity < 8 ? 8 : capacity;
        long startPosition = this.chronicle.startExcerpt(capacity);
        long endPosition = startPosition + (long)capacity;
        this.index0(this.chronicle.size(), startPosition, endPosition);
        this.forWrite = true;
    }

    private boolean checkThread() {
        Thread thread = Thread.currentThread();
        if (this.lastThread == null) {
            this.lastThread = thread;
        } else if (this.lastThread != thread) {
            throw new AssertionError((Object)("Excerpt used by two threads " + thread + " and " + this.lastThread));
        }
        return true;
    }

    @Override
    public void finish() {
        assert (this.chronicle.multiThreaded() || this.checkThread());
        long length = this.checkEndOfBuffer();
        if (this.forWrite) {
            if (this.chronicle.synchronousMode()) {
                this.buffer.force();
            }
            long endPosition = this.startPosition + length;
            this.chronicle.setIndexData(this.index + 1L, endPosition);
            this.chronicle.incrementSize();
            this.capacity = (int)length;
            assert (this.capacity >= 8) : "len=" + length;
            this.writeMemoryBarrier();
        }
        this.buffer = null;
    }

    private long checkEndOfBuffer() {
        long length = this.position - this.start;
        if (length < 8L) {
            length = 8L;
        }
        if (this.position > this.limit) {
            throw new IllegalStateException("Capacity allowed: " + this.capacity + " data read/written: " + length);
        }
        if (this.readLong(0) == 0L) {
            throw new IllegalStateException("The first 8 bytes cannot be all zero");
        }
        return length;
    }

    protected abstract void index0(long var1, long var3, long var5);

    private void writeMemoryBarrier() {
        this.barrier.lazySet(true);
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public Excerpt position(int position) {
        if (position < 0 || position > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.position = this.start + (long)position;
        return this;
    }

    @Override
    public int position() {
        return (int)(this.position - this.start);
    }

    @Override
    public int capacity() {
        return (int)(this.limit - this.start);
    }

    @Override
    public int remaining() {
        return (int)(this.limit - this.position);
    }

    @Override
    public void readFully(byte[] b) {
        this.readFully(b, 0, b.length);
    }

    @Override
    public int skipBytes(int n) {
        int position = this.position();
        int n2 = Math.min(n, this.capacity - position);
        this.position(position + n2);
        return n2;
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        if (len-- <= 0) {
            return;
        }
        do {
            b[off++] = this.readByte();
        } while (len-- > 0);
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public boolean readBoolean(int offset) {
        return this.readByte(offset) != 0;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedByte(int offset) {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShort(int offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    @Override
    public String readLine() {
        StringBuilder input = new StringBuilder();
        block4: while (this.position() < this.capacity()) {
            int c = this.readUnsignedByte();
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    int cur = this.position();
                    if (cur >= this.capacity() || this.readByte(cur) != 10) break block4;
                    this.position(cur + 1);
                    break block4;
                }
                default: {
                    input.append((char)c);
                    continue block4;
                }
            }
        }
        return input.toString();
    }

    @Override
    public String readUTF() {
        if (this.readUTF(this.acquireUtfReader())) {
            return this.utfReader.toString();
        }
        return null;
    }

    private StringBuilder acquireUtfReader() {
        if (this.utfReader == null) {
            this.utfReader = new StringBuilder();
        }
        this.utfReader.setLength(0);
        return this.utfReader;
    }

    @Override
    public boolean readUTF(Appendable appendable) {
        return this.appendUTF(appendable);
    }

    @Override
    public boolean readUTF(StringBuilder stringBuilder) {
        try {
            stringBuilder.setLength(0);
            return this.appendUTF0(stringBuilder);
        }
        catch (IOException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    @Override
    public boolean appendUTF(Appendable appendable) {
        try {
            return this.appendUTF0(appendable);
        }
        catch (IOException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    private boolean appendUTF0(Appendable appendable) throws IOException {
        long len = this.readStopBit();
        if (len < -1L || len > Integer.MAX_VALUE) {
            throw new StreamCorruptedException("UTF length invalid " + len);
        }
        if (len == -1L) {
            return false;
        }
        int count = 0;
        int utflen = (int)len;
        if (count < utflen) {
            do {
                byte c;
                if ((c = this.readByte()) < 0) {
                    this.position(this.position() - 1);
                    break;
                }
                appendable.append((char)c);
            } while (++count < utflen);
        }
        if (count < utflen) {
            this.append1(appendable, utflen, count);
        }
        return true;
    }

    private void append1(Appendable appendable, int utflen, int count) throws IOException {
        do {
            int c = this.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
        } while (count < utflen);
    }

    @Override
    public String parseUTF(StopCharTester tester) {
        this.parseUTF(this.acquireUtfReader(), tester);
        return this.utfReader.toString();
    }

    @Override
    public void parseUTF(Appendable builder, StopCharTester tester) {
        try {
            this.readUTF0(builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void readUTF0(Appendable appendable, StopCharTester tester) throws IOException {
        while (this.remaining() > 0) {
            byte c = this.readByte();
            if (c < 0) {
                this.position(this.position() - 1);
                break;
            }
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        if (this.remaining() > 0) {
            this.readUTF1(appendable, tester);
        }
    }

    private void readUTF1(Appendable appendable, StopCharTester tester) throws IOException {
        do {
            int c = this.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    break;
                }
                case 14: {
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte ");
                }
            }
        } while (this.remaining() > 0);
    }

    @Override
    public boolean stepBackAndSkipTo(StopCharTester tester) {
        if (this.position() > 0) {
            this.position(this.position() - 1);
        }
        return this.skipTo(tester);
    }

    @Override
    public boolean skipTo(StopCharTester tester) {
        if (this.remaining() <= 0) {
            return false;
        }
        do {
            byte ch;
            if (!tester.isStopChar(ch = this.readByte())) continue;
            return true;
        } while (this.remaining() > 0);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readUTF(int offset) {
        long oldPosition = this.position;
        this.position = offset;
        try {
            String string = this.readUTF();
            return string;
        }
        finally {
            this.position = oldPosition;
        }
    }

    @Override
    public short readCompactShort() {
        byte b = this.readByte();
        switch (b) {
            case -128: {
                return Short.MIN_VALUE;
            }
            case -126: {
                return Short.MAX_VALUE;
            }
            case -127: {
                return this.readShort();
            }
        }
        return b;
    }

    @Override
    public int readCompactUnsignedShort() {
        int b = this.readUnsignedByte();
        if (b == 255) {
            return this.readUnsignedShort();
        }
        return b;
    }

    @Override
    public int readInt24() {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return this.readUnsignedByte() << 24 + this.readUnsignedShort() << 8 >> 8;
        }
        return this.readUnsignedByte() << 8 + this.readUnsignedShort() << 16 >> 8;
    }

    @Override
    public int readInt24(int offset) {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return this.readUnsignedByte(offset) << 24 + this.readUnsignedShort(offset + 1) << 8 >> 8;
        }
        return this.readUnsignedByte(offset) << 8 + this.readUnsignedShort(offset + 1) << 16 >> 8;
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedInt(int offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public int readCompactInt() {
        short b = this.readShort();
        switch (b) {
            case -32768: {
                return Integer.MIN_VALUE;
            }
            case -32766: {
                return Integer.MAX_VALUE;
            }
            case -32767: {
                return this.readInt();
            }
        }
        return b;
    }

    @Override
    public long readCompactUnsignedInt() {
        int b = this.readUnsignedByte();
        if (b == 65535) {
            return this.readUnsignedInt();
        }
        return b;
    }

    @Override
    public long readInt48() {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (long)this.readUnsignedShort() << (int)(48L + this.readUnsignedInt()) << 16 >> 16;
        }
        return this.readUnsignedShort() << (int)(16L + this.readUnsignedInt()) << 32 >> 8;
    }

    @Override
    public long readInt48(int offset) {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (long)this.readUnsignedShort(offset) << (int)(48L + this.readUnsignedInt(offset + 2)) << 16 >> 16;
        }
        return this.readUnsignedShort(offset) << (int)(16L + this.readUnsignedInt(offset + 2)) << 32 >> 16;
    }

    @Override
    public long readCompactLong() {
        int b = this.readInt();
        switch (b) {
            case -2147483648: {
                return Long.MIN_VALUE;
            }
            case -2147483646: {
                return Long.MAX_VALUE;
            }
            case -2147483647: {
                return this.readLong();
            }
        }
        return b;
    }

    @Override
    public long readStopBit() {
        long b = this.readByte();
        if (b >= 0L) {
            return b;
        }
        return this.readStopBit0(b);
    }

    private long readStopBit0(long b) {
        long l = 0L;
        int count = 0;
        do {
            l |= (b & 0x7FL) << count;
            count += 7;
        } while ((b = (long)this.readByte()) < 0L);
        if (b == 0L && count > 0) {
            return l ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return l | b << count;
    }

    @Override
    public double readCompactDouble() {
        float f = this.readFloat();
        if (Float.isNaN(f)) {
            return this.readDouble();
        }
        return f;
    }

    @Override
    public void readByteString(StringBuilder sb) {
        sb.setLength(0);
        int len = this.readByte() & 0xFF;
        for (int i = 0; i < len; ++i) {
            sb.append(this.readByte());
        }
    }

    @Override
    public int readByteString(int offset, StringBuilder sb) {
        sb.setLength(0);
        int len = this.readByte(offset) & 0xFF;
        for (int i = 1; i <= len; ++i) {
            sb.append(this.readByte(offset + i));
        }
        return offset + len + 1;
    }

    @Override
    public String readByteString() {
        int len = this.readByte() & 0xFF;
        if (len == 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte();
        }
        return new String(bytes, 0);
    }

    @Override
    public void readChars(StringBuilder sb) {
        int len = this.readChar();
        sb.setLength(0);
        for (int i = 0; i < len; ++i) {
            sb.append(this.readChar());
        }
    }

    @Override
    public String readChars() {
        int len = this.readChar();
        if (len == 0) {
            return "";
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public void read(ByteBuffer bb) {
        int len;
        if (bb.order() == this.order()) {
            for (len = Math.min(bb.remaining(), this.remaining()); len >= 8; len -= 8) {
                bb.putLong(this.readLong());
            }
        }
        while (len > 0) {
            bb.put(this.readByte());
            --len;
        }
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? -1 : 0);
    }

    @Override
    public void writeBoolean(int offset, boolean v) {
        this.write(offset, v ? -1 : 0);
    }

    @Override
    public void writeBytes(String s) {
        this.writeBytes((CharSequence)s);
    }

    @Override
    public void writeBytes(CharSequence s) {
        int len = s.length();
        if (len > 255) {
            throw new IllegalArgumentException("Len cannot be " + len + " > 255");
        }
        this.write(len);
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void writeBytes(int offset, CharSequence s) {
        int i;
        int len = s.length();
        if (len > 255) {
            throw new IllegalArgumentException("Len cannot be " + len + " > 255");
        }
        this.write(offset, len);
        for (i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
        for (i = 0; i < len; ++i) {
            this.write(offset + 1 + i, s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        this.writeChars((CharSequence)s);
    }

    @Override
    public void writeChars(CharSequence s) {
        int len = s.length();
        if (len > 65535) {
            throw new IllegalArgumentException("Len cannot be " + len + " > 65535");
        }
        this.writeChar(len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeChars(int offset, CharSequence s) {
        int len = s.length();
        if (len > 65535) {
            throw new IllegalArgumentException("Len cannot be " + len + " > 65535");
        }
        this.writeChar(offset + len);
        for (int i = 0; i < len; ++i) {
            this.writeChar(offset + 2 + i, s.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s) {
        this.writeUTF((CharSequence)s);
    }

    @Override
    public void writeUTF(CharSequence str) {
        char c;
        if (str == null) {
            this.writeStopBit(-1L);
            return;
        }
        long strlen = str.length();
        int utflen = 0;
        int i = 0;
        while ((long)i < strlen) {
            c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > this.remaining()) {
            throw new IllegalArgumentException("encoded string too long: " + utflen + " bytes, remaining=" + this.remaining());
        }
        this.writeStopBit(utflen);
        i = 0;
        while ((long)i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f') {
            this.write(c);
            ++i;
        }
        while ((long)i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write((byte)(0xE0 | c >> 12 & 0xF));
                this.write((byte)(0x80 | c >> 6 & 0x3F));
                this.write((byte)(0x80 | c & 0x3F));
            } else {
                this.write((byte)(0xC0 | c >> 6 & 0x1F));
                this.write((byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeUnsignedByte(int v) {
        this.writeByte(v);
    }

    @Override
    public void writeUnsignedByte(int offset, int v) {
        this.write(offset, v);
    }

    @Override
    public void write(int offset, byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.write(offset + i, b[i]);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void writeUnsignedShort(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeUnsignedShort(int offset, int v) {
        this.writeShort(offset, v);
    }

    @Override
    public void writeCompactShort(int v) {
        if (v > -126 && v <= 127) {
            this.writeByte(v);
        } else {
            switch (v) {
                case -32768: {
                    this.writeByte(-128);
                    break;
                }
                case 32767: {
                    this.writeByte(-126);
                    break;
                }
                default: {
                    this.writeByte(-127);
                    this.writeShort(v);
                }
            }
        }
    }

    @Override
    public void writeCompactUnsignedShort(int v) {
        if (v >= 0 && v < 65535) {
            this.writeByte(v);
        } else {
            this.writeUnsignedShort(65535);
            this.writeUnsignedShort(v);
        }
    }

    @Override
    public void writeInt24(int v) {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedByte(v >>> 16);
            this.writeUnsignedShort(v);
        } else {
            this.writeUnsignedByte(v);
            this.writeUnsignedShort(v >>> 8);
        }
    }

    @Override
    public void writeInt24(int offset, int v) {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedByte(offset, v >>> 16);
            this.writeUnsignedShort(offset + 1, v);
        } else {
            this.writeUnsignedByte(offset, v);
            this.writeUnsignedShort(offset + 1, v >>> 8);
        }
    }

    @Override
    public void writeUnsignedInt(long v) {
        this.writeInt((int)v);
    }

    @Override
    public void writeUnsignedInt(int offset, long v) {
        this.writeInt(offset, (int)v);
    }

    @Override
    public void writeCompactInt(int v) {
        if (v > -32766 && v <= Short.MAX_VALUE) {
            this.writeShort(v);
        } else {
            switch (v) {
                case -2147483648: {
                    this.writeShort(Short.MIN_VALUE);
                    break;
                }
                case 0x7FFFFFFF: {
                    this.writeShort(-32766);
                    break;
                }
                default: {
                    this.writeShort(-127);
                    this.writeInt(v);
                }
            }
        }
    }

    @Override
    public void writeCompactUnsignedInt(long v) {
        if (v >= 0L && v < 65535L) {
            this.writeShort((int)v);
        } else {
            this.writeShort(65535);
            this.writeUnsignedInt(v);
        }
    }

    @Override
    public void writeInt48(long v) {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedShort((int)(v >>> 32));
            this.writeUnsignedInt(v);
        } else {
            this.writeUnsignedShort((int)v);
            this.writeUnsignedInt(v >>> 16);
        }
    }

    @Override
    public void writeInt48(int offset, long v) {
        if (this.chronicle.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedShort(offset, (int)(v >>> 32));
            this.writeUnsignedInt(offset + 2, v);
        } else {
            this.writeUnsignedShort(offset, (int)v);
            this.writeUnsignedInt(offset + 2, v >>> 16);
        }
    }

    @Override
    public void writeCompactLong(long v) {
        if (v > -2147483646L && v <= Integer.MAX_VALUE) {
            this.writeInt((int)v);
        } else if (v == Long.MIN_VALUE) {
            this.writeInt(-128);
        } else if (v == Long.MAX_VALUE) {
            this.writeInt(-126);
        } else {
            this.writeInt(-127);
            this.writeLong(v);
        }
    }

    @Override
    public void writeStopBit(long n) {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            this.writeByte((byte)(0x80L | n & 0x7FL));
            n = n2;
        }
        if (neg) {
            this.writeByte((byte)(0x80L | n & 0x7FL));
            this.writeByte(0);
        } else {
            this.writeByte((byte)(n & 0x7FL));
        }
    }

    @Override
    public void writeCompactDouble(double v) {
        float f = (float)v;
        if ((double)f == v) {
            this.writeFloat(f);
        } else {
            this.writeFloat(Float.NaN);
            this.writeDouble(v);
        }
    }

    @Override
    public void write(ByteBuffer bb) {
        if (bb.order() == this.order()) {
            while (bb.remaining() >= 8) {
                this.writeLong(bb.getLong());
            }
        }
        while (bb.remaining() >= 1) {
            this.writeByte(bb.get());
        }
    }

    @Override
    public int length() {
        return this.position();
    }

    @Override
    public ByteStringAppender append(CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
        return this;
    }

    @Override
    public ByteStringAppender append(CharSequence s, int start, int end) {
        int len = Math.min(end, s.length());
        for (int i = start; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
        return this;
    }

    @Override
    public ByteStringAppender append(Enum value) {
        return this.append(value.toString());
    }

    @Override
    public ByteStringAppender append(byte[] str) {
        this.write(str);
        return this;
    }

    @Override
    public ByteStringAppender append(byte[] str, int offset, int len) {
        this.write(str, offset, len);
        return this;
    }

    @Override
    public ByteStringAppender append(boolean b) {
        this.append(b ? "true" : "false");
        return this;
    }

    @Override
    public ByteStringAppender append(char c) {
        this.writeByte(c);
        return this;
    }

    @Override
    public ByteStringAppender append(int num) {
        return this.append((long)num);
    }

    @Override
    public ByteStringAppender append(long num) {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                this.append(MIN_VALUE_TEXT);
                return this;
            }
            this.writeByte(45);
            num = -num;
        }
        if (num == 0L) {
            this.writeByte(48);
        } else {
            this.appendLong0(num);
        }
        return this;
    }

    @Override
    public ByteStringAppender appendDate(long timeInMS) {
        long date;
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        if (this.lastDay != (date = timeInMS / 86400000L)) {
            this.lastDateStr = this.dateFormat.format(new Date(timeInMS)).getBytes(ISO_8859_1);
            this.lastDay = date;
        }
        this.append(this.lastDateStr);
        return this;
    }

    @Override
    public ByteStringAppender appendDateTime(long timeInMS) {
        this.appendDate(timeInMS);
        this.writeByte(84);
        this.appendTime(timeInMS);
        return this;
    }

    @Override
    public ByteStringAppender appendTime(long timeInMS) {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            this.appendLong0(hours);
        } else {
            this.writeByte((char)(hours / 10 + 48));
            this.writeByte((char)(hours % 10 + 48));
        }
        this.writeByte(58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        this.writeByte((char)(minutes / 10 + 48));
        this.writeByte((char)(minutes % 10 + 48));
        this.writeByte(58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        this.writeByte((char)(seconds / 10 + 48));
        this.writeByte((char)(seconds % 10 + 48));
        this.writeByte(46);
        int millis = (int)(timeInMS % 1000L);
        this.writeByte((char)(millis / 100 + 48));
        this.writeByte((char)(millis / 10 % 10 + 48));
        this.writeByte((char)(millis % 10 + 48));
        return this;
    }

    @Override
    public ByteStringAppender append(double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            this.writeByte(45);
        }
        if (exp == 0 && mantissa == 0L) {
            this.writeByte(48);
            return this;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                this.buffer.put(Infinity);
            } else {
                this.buffer.put(NaN);
            }
            return this;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                this.appendLong0(intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    this.writeByte(46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        this.writeByte((char)(48L + num));
                        double parsedValue = AbstractExcerpt.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                }
                return this;
            }
            this.writeByte(48);
            this.writeByte(46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    this.writeByte(48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                this.writeByte(c);
                mantissa -= num << precision;
                double parsedValue = AbstractExcerpt.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return this;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        this.appendLong0(val2);
        for (int i = 0; i < digits; ++i) {
            this.writeByte(48);
        }
        return this;
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value += (long)modDiv * mod / 5L;
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    @Override
    public double parseDouble() {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        while (true) {
            byte ch;
            if ((ch = this.readByte()) >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
                continue;
            }
            if (ch == 45) {
                negative = true;
                continue;
            }
            if (ch != 46) break;
            decimalPlaces = 0;
        }
        return AbstractExcerpt.asDouble(value, exp, negative, decimalPlaces);
    }

    @Override
    public MutableDecimal parseDecimal(MutableDecimal decimal) {
        long num = 0L;
        long scale = Long.MIN_VALUE;
        boolean negative = false;
        while (true) {
            byte b;
            if ((b = this.readByte()) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                ++scale;
                continue;
            }
            if (b == 46) {
                scale = 0L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        if (negative) {
            num = -num;
        }
        decimal.set(num, scale > 0L ? (int)scale : 0);
        return decimal;
    }

    @Override
    public long parseLong() {
        long num = 0L;
        boolean negative = false;
        while (true) {
            byte b;
            if ((b = this.readByte()) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    private void appendLong0(long num) {
        int endIndex = this.appendLong1(num);
        this.write(this.numberBuffer, endIndex, MAX_NUMBER_LENGTH - endIndex);
    }

    private int appendLong1(long num) {
        this.numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        this.numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        this.numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        this.numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        this.numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        this.numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        this.numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        this.numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        this.numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        this.numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        this.numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        this.numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        this.numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        this.numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        this.numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        this.numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        this.numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        this.numberBuffer[2] = (byte)(num % 10L + 48L);
        num /= 10L;
        return 2;
    }

    @Override
    public ByteStringAppender append(double d, int precision) {
        double d2;
        if (precision < 0) {
            precision = 0;
        }
        if (precision >= TENS.length) {
            precision = TENS.length - 1;
        }
        long power10 = TENS[precision];
        if (d < 0.0) {
            d = -d;
            this.writeByte(45);
        }
        if ((d2 = d * (double)power10) > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
            return this.append(d);
        }
        long val = (long)(d2 + 0.5);
        while (precision > 0 && val % 10L == 0L) {
            val /= 10L;
            --precision;
        }
        if (precision > 0) {
            this.appendDouble0(val, precision);
        } else {
            this.appendLong0(val);
        }
        return this;
    }

    private void appendDouble0(long num, int precision) {
        int endIndex = this.appendDouble1(num, precision);
        this.write(this.numberBuffer, endIndex, MAX_NUMBER_LENGTH - endIndex);
    }

    private int appendDouble1(long num, int precision) {
        int endIndex = MAX_NUMBER_LENGTH;
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 1) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 2) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 3) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 4) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 5) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 6) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 7) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 8) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 9) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 10) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 11) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 12) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 13) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 14) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 15) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 16) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 17) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return endIndex;
        }
        if (precision == 18) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        return endIndex;
    }

    private static long power10(long l) {
        int idx = Arrays.binarySearch(TENS, l);
        return idx >= 0 ? TENS[idx] : TENS[~idx - 1];
    }

    @Override
    public ByteStringAppender append(MutableDecimal md) {
        StringBuilder sb = this.acquireUtfReader();
        md.toString(sb);
        this.append(sb);
        return this;
    }

    @Override
    public InputStream inputStream() {
        if (this.inputStream == null) {
            this.inputStream = new ExcerptInputStream();
        }
        return this.inputStream;
    }

    @Override
    public OutputStream outputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ExcerptOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public <E> void writeEnum(E e) {
        Class aClass = e == null || e instanceof CharSequence ? String.class : e.getClass();
        EnumeratedMarshaller<String> em = this.chronicle().acquireMarshaller(aClass);
        em.write(this, (String)e);
    }

    @Override
    public <E> E readEnum(Class<E> eClass) {
        EnumeratedMarshaller<E> em = this.chronicle().acquireMarshaller(eClass);
        return em.read(this);
    }

    @Override
    public <E> E parseEnum(Class<E> eClass, StopCharTester tester) {
        EnumeratedMarshaller<E> em = this.chronicle().acquireMarshaller(eClass);
        return em.parse(this, tester);
    }

    @Override
    public <E> void writeEnums(Collection<E> eList) {
        this.writeInt(eList.size());
        for (E e : eList) {
            this.writeEnum(e);
        }
    }

    @Override
    public <E> void writeList(Collection<E> list) {
        this.writeInt(list.size());
        for (E e : list) {
            this.writeObject(e);
        }
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map) {
        this.writeInt(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.writeEnum(entry.getKey());
            this.writeEnum(entry.getValue());
        }
    }

    @Override
    public <E> void readEnums(Class<E> eClass, List<E> eList) {
        eList.clear();
        int len = this.readInt();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            eList.add(this.readEnum(eClass));
        }
    }

    @Override
    public <E> void readList(Collection<E> list) {
        int len = this.readInt();
        list.clear();
        for (int i = 0; i < len; ++i) {
            Object e = this.readObject();
            list.add(e);
        }
    }

    @Override
    public <K, V> Map<K, V> readMap(Class<K> kClass, Class<V> vClass) {
        int len = this.readInt();
        if (len == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(len * 10 / 7);
        for (int i = 0; i < len; ++i) {
            map.put(this.readEnum(kClass), this.readEnum(vClass));
        }
        return map;
    }

    @Override
    public int available() {
        return this.remaining();
    }

    @Override
    public int read() {
        return this.remaining() > 0 ? (int)this.readByte() : -1;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public abstract int read(byte[] var1, int var2, int var3);

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Skip bytes out of range, was " + n);
        }
        if (n > (long)this.remaining()) {
            n = this.remaining();
        }
        this.skipBytes((int)n);
        return n;
    }

    @Override
    public void close() {
        if (!this.isFinished()) {
            this.finish();
        }
    }

    @Override
    public void flush() {
        this.checkEndOfBuffer();
    }

    @Override
    public Object readObject() {
        byte type = this.readByte();
        switch (type) {
            case 78: {
                return null;
            }
            case 69: {
                Class clazz = this.readEnum(Class.class);
                return this.readEnum(clazz);
            }
            case 83: {
                try {
                    return new ObjectInputStream(this.inputStream()).readObject();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalStateException("Unknown type " + (char)type);
    }

    @Override
    public void writeObject(Object obj) {
        EnumeratedMarshaller<?> em;
        if (obj == null) {
            this.writeByte(78);
            return;
        }
        Class<?> clazz = obj.getClass();
        EnumeratedMarshaller<?> enumeratedMarshaller = em = obj instanceof Comparable || obj instanceof Externalizable ? this.chronicle.acquireMarshaller(clazz) : this.chronicle.getMarshaller(clazz);
        if (em != null) {
            this.writeByte(69);
            this.writeEnum(clazz);
            em.write(this, obj);
            return;
        }
        this.writeByte(83);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(this.outputStream());
            oos.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.checkEndOfBuffer();
    }

    @Override
    public Excerpt toStart() {
        this.index(-1L);
        return this;
    }

    @Override
    public Excerpt toEnd() {
        this.index(this.size() - 1L);
        return this;
    }

    @Override
    public boolean isFinished() {
        return this.buffer == null;
    }

    static {
        AbstractExcerpt.TENS[0] = 1L;
        for (int i = 1; i < TENS.length; ++i) {
            AbstractExcerpt.TENS[i] = TENS[i - 1] * 10L;
        }
    }

    protected class ExcerptOutputStream
    extends OutputStream {
        protected ExcerptOutputStream() {
        }

        @Override
        public void close() throws IOException {
            AbstractExcerpt.this.finish();
        }

        @Override
        public void write(byte[] b) throws IOException {
            AbstractExcerpt.this.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AbstractExcerpt.this.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            AbstractExcerpt.this.writeUnsignedByte(b);
        }
    }

    protected class ExcerptInputStream
    extends InputStream {
        private int mark = 0;

        protected ExcerptInputStream() {
        }

        @Override
        public int available() throws IOException {
            return AbstractExcerpt.this.remaining();
        }

        @Override
        public void close() throws IOException {
            AbstractExcerpt.this.finish();
        }

        @Override
        public void mark(int readlimit) {
            this.mark = AbstractExcerpt.this.position();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            AbstractExcerpt.this.readFully(b, off, len);
            return len;
        }

        @Override
        public void reset() throws IOException {
            AbstractExcerpt.this.position(this.mark);
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                throw new IOException("Skip too large");
            }
            return AbstractExcerpt.this.skipBytes((int)n);
        }

        @Override
        public int read() throws IOException {
            if (AbstractExcerpt.this.remaining() > 0) {
                return AbstractExcerpt.this.readUnsignedByte();
            }
            return -1;
        }
    }
}

