/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.impl.AbstractExcerpt;
import com.higherfrequencytrading.chronicle.impl.DirectChronicle;

public class ByteBufferExcerpt
extends AbstractExcerpt {
    protected ByteBufferExcerpt(DirectChronicle chronicle) {
        super(chronicle);
    }

    @Override
    protected void index0(long index, long startPosition, long endPosition) {
        this.index = index;
        this.startPosition = startPosition;
        this.buffer = this.chronicle.acquireDataBuffer(startPosition);
        this.start = this.position = (long)this.chronicle.positionInBuffer(startPosition);
        this.limit = this.chronicle.positionInBuffer(endPosition - 1L) + 1;
        assert (this.limit > this.start && this.position < this.limit && endPosition > startPosition);
    }

    @Override
    public byte readByte() {
        return this.buffer.get((int)this.position++);
    }

    @Override
    public byte readByte(int offset) {
        return this.buffer.get((int)(this.start + (long)offset));
    }

    @Override
    public short readShort() {
        short s = this.buffer.getShort((int)this.position);
        this.position += 2L;
        return s;
    }

    @Override
    public short readShort(int offset) {
        return this.buffer.getShort((int)(this.start + (long)offset));
    }

    @Override
    public char readChar() {
        char ch = this.buffer.getChar((int)this.position);
        this.position += 2L;
        return ch;
    }

    @Override
    public char readChar(int offset) {
        return this.buffer.getChar((int)(this.start + (long)offset));
    }

    @Override
    public int readInt() {
        int i = this.buffer.getInt((int)this.position);
        this.position += 4L;
        return i;
    }

    @Override
    public int readInt(int offset) {
        return this.buffer.getInt((int)(this.start + (long)offset));
    }

    @Override
    public long readLong() {
        long l = this.buffer.getLong((int)this.position);
        this.position += 8L;
        return l;
    }

    @Override
    public long readLong(int offset) {
        return this.buffer.getLong((int)(this.start + (long)offset));
    }

    @Override
    public float readFloat() {
        float f = this.buffer.getFloat((int)this.position);
        this.position += 4L;
        return f;
    }

    @Override
    public float readFloat(int offset) {
        return this.buffer.getFloat((int)(this.start + (long)offset));
    }

    @Override
    public double readDouble() {
        double d = this.buffer.getDouble((int)this.position);
        this.position += 8L;
        return d;
    }

    @Override
    public double readDouble(int offset) {
        return this.buffer.getDouble((int)(this.start + (long)offset));
    }

    @Override
    public void write(int b) {
        this.buffer.put((int)this.position++, (byte)b);
    }

    @Override
    public void write(int offset, int b) {
        this.buffer.put((int)(this.start + (long)offset), (byte)b);
    }

    @Override
    public void writeShort(int v) {
        this.buffer.putShort((int)this.position, (short)v);
        this.position += 2L;
    }

    @Override
    public void writeShort(int offset, int v) {
        this.buffer.putShort((int)(this.start + (long)offset), (short)v);
    }

    @Override
    public void writeChar(int v) {
        this.buffer.putChar((int)this.position, (char)v);
        this.position += 2L;
    }

    @Override
    public void writeChar(int offset, int v) {
        this.buffer.putChar((int)(this.start + (long)offset), (char)v);
    }

    @Override
    public void writeInt(int v) {
        this.buffer.putInt((int)this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeInt(int offset, int v) {
        this.buffer.putInt((int)(this.start + (long)offset), v);
    }

    @Override
    public void writeLong(long v) {
        this.buffer.putLong((int)this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeLong(int offset, long v) {
        this.buffer.putLong((int)(this.start + (long)offset), v);
    }

    @Override
    public void writeFloat(float v) {
        this.buffer.putFloat((int)this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeFloat(int offset, float v) {
        this.buffer.putFloat((int)(this.start + (long)offset), v);
    }

    @Override
    public void writeDouble(double v) {
        this.buffer.putDouble((int)this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeDouble(int offset, double v) {
        this.buffer.putDouble((int)(this.start + (long)offset), v);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (len > this.remaining()) {
            len = this.remaining();
        }
        for (int i = 0; i < len; ++i) {
            b[i + off] = this.buffer.get((int)((long)i + this.position));
        }
        return len;
    }
}

