/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassEnumMarshaller
implements EnumeratedMarshaller<Class> {
    private static final int CACHE_SIZE = 1019;
    private static final Map<String, Class> SC_SHORT_NAME;
    private static final Map<Class, String> CS_SHORT_NAME;
    private WeakReference<Class>[] classWeakReference = null;
    private final ClassLoader classLoader;

    public ClassEnumMarshaller(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<Class> classMarshaled() {
        return Class.class;
    }

    @Override
    public void write(Excerpt excerpt, Class aClass) {
        String s = CS_SHORT_NAME.get(aClass);
        if (s == null) {
            s = aClass.getName();
        }
        excerpt.writeUTF(s);
    }

    @Override
    public Class read(Excerpt excerpt) {
        String name = excerpt.readUTF();
        return this.load(name);
    }

    private Class load(String name) {
        Class<?> clazz;
        WeakReference<Class> ref;
        int hash = (name.hashCode() & Integer.MAX_VALUE) % 1019;
        if (this.classWeakReference == null) {
            this.classWeakReference = new WeakReference[1019];
        }
        if ((ref = this.classWeakReference[hash]) != null && (clazz = (Class<?>)ref.get()) != null && clazz.getName().equals(name)) {
            return clazz;
        }
        try {
            clazz = SC_SHORT_NAME.get(name);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.classLoader.loadClass(name);
            this.classWeakReference[hash] = new WeakReference(clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Class parse(Excerpt excerpt, StopCharTester tester) {
        String name = excerpt.parseUTF(tester);
        return this.load(name);
    }

    static {
        Class[] classes;
        SC_SHORT_NAME = new LinkedHashMap<String, Class>();
        CS_SHORT_NAME = new LinkedHashMap<Class, String>();
        for (Class clazz : classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Class.class, BigInteger.class, BigDecimal.class, Date.class}) {
            String simpleName = clazz.getSimpleName();
            SC_SHORT_NAME.put(simpleName, clazz);
            CS_SHORT_NAME.put(clazz, simpleName);
        }
    }
}

