/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class ExternalizableMarshaller<E extends Externalizable>
implements EnumeratedMarshaller<E> {
    private final Class<E> classMarshaled;
    private final Constructor<E> constructor;

    public ExternalizableMarshaller(Class<E> classMarshaled) {
        this.classMarshaled = classMarshaled;
        try {
            this.constructor = classMarshaled.getConstructor(new Class[0]);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Class<E> classMarshaled() {
        return this.classMarshaled;
    }

    @Override
    public void write(Excerpt excerpt, E e) {
        try {
            e.writeExternal(excerpt);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E read(Excerpt excerpt) {
        try {
            Externalizable e = (Externalizable)this.constructor.newInstance(new Object[0]);
            e.readExternal(excerpt);
            return (E)e;
        }
        catch (Exception e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public E parse(Excerpt excerpt, StopCharTester tester) {
        return (E)this.read(excerpt);
    }
}

