/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.impl.AbstractChronicle;
import com.higherfrequencytrading.chronicle.impl.ByteBufferExcerpt;
import com.higherfrequencytrading.chronicle.impl.UnsafeExcerpt;
import com.higherfrequencytrading.chronicle.tools.ChronicleTools;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import sun.nio.ch.DirectBuffer;

public class IndexedChronicle
extends AbstractChronicle {
    public static final long MAX_VIRTUAL_ADDRESS = 0x1000000000000L;
    public static final int DEFAULT_DATA_BITS_SIZE = 27;
    public static final int DEFAULT_DATA_BITS_SIZE32 = 22;
    private static final Logger logger = Logger.getLogger(IndexedChronicle.class.getName());
    private final List<MappedByteBuffer> indexBuffers = new ArrayList<MappedByteBuffer>();
    private final List<MappedByteBuffer> dataBuffers = new ArrayList<MappedByteBuffer>();
    private int lastIndexId = -1;
    private MappedByteBuffer lastIndexBuffer = null;
    private int lastDataId = -1;
    private MappedByteBuffer lastDataBuffer = null;
    private final int indexBitSize;
    protected final int indexLowMask;
    private final int dataBitSize;
    private final int dataLowMask;
    private final FileChannel indexChannel;
    private final FileChannel dataChannel;
    private boolean useUnsafe = false;
    private final ByteOrder byteOrder;
    private final boolean minimiseByteBuffers;
    private final boolean synchronousMode;

    public IndexedChronicle(String basePath) throws IOException {
        this(basePath, ChronicleTools.is64Bit() ? 27 : 22);
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint) throws IOException {
        this(basePath, dataBitSizeHint, ByteOrder.nativeOrder());
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder) throws IOException {
        this(basePath, dataBitSizeHint, byteOrder, !ChronicleTools.is64Bit());
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder, boolean minimiseByteBuffers) throws IOException {
        this(basePath, dataBitSizeHint, byteOrder, minimiseByteBuffers, false);
    }

    public IndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder, boolean minimiseByteBuffers, boolean synchronousMode) throws IOException {
        super(IndexedChronicle.extractName(basePath));
        this.byteOrder = byteOrder;
        this.minimiseByteBuffers = minimiseByteBuffers;
        this.synchronousMode = synchronousMode;
        this.indexBitSize = Math.min(30, Math.max(12, dataBitSizeHint - 3));
        this.dataBitSize = Math.min(30, Math.max(12, dataBitSizeHint));
        this.indexLowMask = (1 << this.indexBitSize) - 1;
        this.dataLowMask = (1 << this.dataBitSize) - 1;
        File parentFile = new File(basePath).getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        this.indexChannel = new RandomAccessFile(basePath + ".index", synchronousMode ? "rwd" : "rw").getChannel();
        this.dataChannel = new RandomAccessFile(basePath + ".data", synchronousMode ? "rwd" : "rw").getChannel();
        long indexSize = this.indexChannel.size() >>> this.indexBitSize();
        if (indexSize > 0L) {
            --indexSize;
            while (indexSize > 0L && this.getIndexData(indexSize) == 0L) {
                --indexSize;
            }
            logger.info(basePath + ", size=" + indexSize);
            this.size = indexSize;
        } else {
            logger.info(basePath + " created.");
        }
    }

    private static String extractName(String basePath) {
        File file = new File(basePath);
        String name = file.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        if ((file = file.getParentFile()) == null) {
            return "chronicle";
        }
        name = file.getName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return "chronicle";
    }

    @Override
    public long sizeInBytes() {
        try {
            return this.indexChannel.size() + this.dataChannel.size();
        }
        catch (IOException ignored) {
            return -1L;
        }
    }

    protected int indexBitSize() {
        return 3;
    }

    public void useUnsafe(boolean useUnsafe) {
        this.useUnsafe = useUnsafe && this.byteOrder == ByteOrder.nativeOrder();
    }

    public boolean useUnsafe() {
        return this.useUnsafe;
    }

    @Override
    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    @Override
    public boolean synchronousMode() {
        return this.synchronousMode;
    }

    @Override
    public Excerpt createExcerpt() {
        return this.useUnsafe ? new UnsafeExcerpt(this) : new ByteBufferExcerpt(this);
    }

    @Override
    public long getIndexData(long indexId) {
        long indexOffset = indexId << this.indexBitSize();
        MappedByteBuffer indexBuffer = this.acquireIndexBuffer(indexOffset);
        return indexBuffer.getLong((int)(indexOffset & (long)this.indexLowMask));
    }

    protected MappedByteBuffer acquireIndexBuffer(long startPosition) {
        if (startPosition >= 0x1000000000000L) {
            this.throwByteOrderIsIncorrect();
        }
        int indexBufferId = (int)(startPosition >> this.indexBitSize);
        if (this.minimiseByteBuffers) {
            if (this.lastIndexId == indexBufferId) {
                return this.lastIndexBuffer;
            }
        } else {
            MappedByteBuffer buffer;
            if (this.indexBuffers.size() <= indexBufferId) {
                this.fillIndexBufferWithNulls(indexBufferId);
            }
            if ((buffer = this.indexBuffers.get(indexBufferId)) != null) {
                return buffer;
            }
        }
        return this.createIndexBuffer(startPosition, indexBufferId);
    }

    private void fillIndexBufferWithNulls(int indexBufferId) {
        while (this.indexBuffers.size() <= indexBufferId) {
            this.indexBuffers.add(null);
        }
    }

    private MappedByteBuffer createIndexBuffer(long startPosition, int indexBufferId) {
        try {
            MappedByteBuffer mbb;
            try {
                mbb = this.indexChannel.map(FileChannel.MapMode.READ_WRITE, startPosition & (long)(~this.indexLowMask), 1 << this.indexBitSize);
            }
            catch (OutOfMemoryError e) {
                System.gc();
                mbb = this.indexChannel.map(FileChannel.MapMode.READ_WRITE, startPosition & (long)(~this.indexLowMask), 1 << this.indexBitSize);
            }
            mbb.order(this.byteOrder);
            if (this.minimiseByteBuffers) {
                this.lastIndexBuffer = mbb;
                this.lastIndexId = indexBufferId;
            } else {
                this.indexBuffers.set(indexBufferId, mbb);
            }
            return mbb;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public MappedByteBuffer acquireDataBuffer(long startPosition) {
        if (startPosition >= 0x1000000000000L) {
            return this.throwByteOrderIsIncorrect();
        }
        int dataBufferId = (int)(startPosition >> this.dataBitSize);
        if (this.minimiseByteBuffers) {
            if (this.lastDataId == dataBufferId) {
                return this.lastDataBuffer;
            }
        } else {
            MappedByteBuffer buffer;
            if (this.dataBuffers.size() <= dataBufferId) {
                this.fillDataBuffersWithNulls(dataBufferId);
            }
            if ((buffer = this.dataBuffers.get(dataBufferId)) != null) {
                return buffer;
            }
        }
        return this.createDataBuffer(startPosition, dataBufferId);
    }

    private void fillDataBuffersWithNulls(int dataBufferId) {
        while (this.dataBuffers.size() <= dataBufferId) {
            this.dataBuffers.add(null);
        }
    }

    private MappedByteBuffer createDataBuffer(long startPosition, int dataBufferId) {
        try {
            MappedByteBuffer mbb;
            try {
                mbb = this.dataChannel.map(FileChannel.MapMode.READ_WRITE, startPosition & (long)(~this.dataLowMask), 1 << this.dataBitSize);
            }
            catch (OutOfMemoryError e) {
                System.gc();
                mbb = this.dataChannel.map(FileChannel.MapMode.READ_WRITE, startPosition & (long)(~this.dataLowMask), 1 << this.dataBitSize);
            }
            mbb.order(ByteOrder.nativeOrder());
            if (this.minimiseByteBuffers) {
                this.lastDataBuffer = mbb;
                this.lastDataId = dataBufferId;
            } else {
                this.dataBuffers.set(dataBufferId, mbb);
            }
            return mbb;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private MappedByteBuffer throwByteOrderIsIncorrect() {
        throw new IllegalStateException("ByteOrder is incorrect.");
    }

    @Override
    public int positionInBuffer(long startPosition) {
        return (int)(startPosition & (long)this.dataLowMask);
    }

    @Override
    public void setIndexData(long indexId, long indexData) {
        long indexOffset = indexId << this.indexBitSize();
        MappedByteBuffer indexBuffer = this.acquireIndexBuffer(indexOffset);
        indexBuffer.putLong((int)(indexOffset & (long)this.indexLowMask), indexData);
        if (this.synchronousMode()) {
            indexBuffer.force();
        }
    }

    @Override
    public long startExcerpt(int capacity) {
        long startPosition = this.getIndexData(this.size);
        assert (this.size == 0L || startPosition != 0L);
        if ((startPosition & (long)(~this.dataLowMask)) != (startPosition + (long)capacity & (long)(~this.dataLowMask))) {
            startPosition = startPosition + (long)this.dataLowMask & (long)(~this.dataLowMask);
            this.setIndexData(this.size, startPosition);
        }
        return startPosition;
    }

    @Override
    public void incrementSize() {
        ++this.size;
    }

    public void clear() {
        this.size = 0L;
        this.setIndexData(1L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.clearAll(this.indexChannel, this.indexBuffers);
        }
        finally {
            this.clearAll(this.dataChannel, this.dataBuffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll(FileChannel channel, List<MappedByteBuffer> buffers) {
        try {
            for (MappedByteBuffer buffer : buffers) {
                if (buffer == null) continue;
                buffer.force();
            }
        }
        finally {
            try {
                channel.close();
            }
            catch (IOException ignored) {}
            for (MappedByteBuffer buffer : buffers) {
                if (!(buffer instanceof DirectBuffer)) continue;
                ((DirectBuffer)((Object)buffer)).cleaner().clean();
            }
        }
        buffers.clear();
    }
}

