/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.impl.IndexedChronicle;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;

public class IntIndexedChronicle
extends IndexedChronicle {
    private static final long LONG_MASK = 0xFFFFFFFFL;

    public IntIndexedChronicle(String basePath) throws IOException {
        super(basePath);
    }

    public IntIndexedChronicle(String basePath, int dataBitSizeHint) throws IOException {
        super(basePath, dataBitSizeHint);
    }

    public IntIndexedChronicle(String basePath, int dataBitSizeHint, ByteOrder byteOrder) throws IOException {
        super(basePath, dataBitSizeHint, byteOrder);
    }

    @Override
    protected int indexBitSize() {
        return 2;
    }

    @Override
    public long getIndexData(long indexId) {
        long indexOffset = indexId << this.indexBitSize();
        MappedByteBuffer indexBuffer = this.acquireIndexBuffer(indexOffset);
        return (long)indexBuffer.getInt((int)(indexOffset & (long)this.indexLowMask)) & 0xFFFFFFFFL;
    }

    @Override
    public void setIndexData(long indexId, long indexData) {
        if (indexData >= 0x100000000L) {
            throw new IllegalStateException("Size of Chronicle too large > 4 GB");
        }
        long indexOffset = indexId << this.indexBitSize();
        MappedByteBuffer indexBuffer = this.acquireIndexBuffer(indexOffset);
        assert (indexData <= 0xFFFFFFFFL);
        indexBuffer.putInt((int)(indexOffset & (long)this.indexLowMask), (int)indexData);
    }
}

