/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tcp;

import com.higherfrequencytrading.chronicle.Chronicle;
import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.impl.WrappedExcerpt;
import com.higherfrequencytrading.chronicle.tcp.TcpUtil;
import com.higherfrequencytrading.chronicle.tools.IOTools;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InProcessChronicleSink
implements Chronicle {
    private final Chronicle chronicle;
    private final SocketAddress address;
    private final Excerpt excerpt;
    private final Logger logger;
    private volatile boolean closed = false;
    private SocketChannel sc = null;
    private boolean scFirst = true;
    private final ByteBuffer readBuffer;

    public InProcessChronicleSink(Chronicle chronicle, String hostname, int port) {
        this.chronicle = chronicle;
        this.address = new InetSocketAddress(hostname, port);
        this.logger = Logger.getLogger(this.getClass().getName() + '.' + chronicle);
        this.excerpt = chronicle.createExcerpt();
        this.readBuffer = TcpUtil.createBuffer(262144, chronicle);
    }

    @Override
    public void multiThreaded(boolean multiThreaded) {
        this.chronicle.multiThreaded(multiThreaded);
    }

    @Override
    public String name() {
        return this.chronicle.name();
    }

    @Override
    public Excerpt createExcerpt() {
        return new SinkExcerpt();
    }

    @Override
    public long size() {
        return this.chronicle.size();
    }

    @Override
    public long sizeInBytes() {
        return this.chronicle.sizeInBytes();
    }

    @Override
    public ByteOrder byteOrder() {
        return this.chronicle.byteOrder();
    }

    @Override
    public <E> void setEnumeratedMarshaller(EnumeratedMarshaller<E> marshaller) {
        this.chronicle.setEnumeratedMarshaller(marshaller);
    }

    boolean readNext() {
        if (this.sc == null || !this.sc.isOpen()) {
            this.sc = this.createConnection();
            this.scFirst = true;
        }
        return this.sc != null && this.readNextExcerpt(this.sc);
    }

    private SocketChannel createConnection() {
        while (!this.closed) {
            try {
                this.readBuffer.clear();
                this.readBuffer.limit(0);
                SocketChannel sc = SocketChannel.open(this.address);
                sc.socket().setReceiveBufferSize(262144);
                this.logger.info("Connected to " + this.address);
                ByteBuffer bb = ByteBuffer.allocate(8);
                bb.putLong(0, this.chronicle.size());
                IOTools.writeAllOrEOF(sc, bb);
                return sc;
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Failed to connect to " + this.address + " retrying", e);
                } else if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Failed to connect to " + this.address + " retrying " + e);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        }
        return null;
    }

    private boolean readNextExcerpt(SocketChannel sc) {
        try {
            long size;
            if (this.closed) {
                return false;
            }
            if (this.readBuffer.remaining() < (this.scFirst ? 12 : 4)) {
                int minSize;
                if (this.readBuffer.remaining() == 0) {
                    this.readBuffer.clear();
                } else {
                    this.readBuffer.compact();
                }
                int n = minSize = this.scFirst ? 20 : 12;
                while (this.readBuffer.position() < minSize) {
                    if (sc.read(this.readBuffer) >= 0) continue;
                    sc.close();
                    return false;
                }
                this.readBuffer.flip();
            }
            if (this.scFirst) {
                long scIndex = this.readBuffer.getLong();
                if (scIndex != this.chronicle.size()) {
                    throw new StreamCorruptedException("Expected index " + this.chronicle.size() + " but got " + scIndex);
                }
                this.scFirst = false;
            }
            if ((size = (long)this.readBuffer.getInt()) == -128L) {
                return false;
            }
            if (size > 0x8000000L || size < 0L) {
                throw new StreamCorruptedException("size was " + size);
            }
            this.excerpt.startExcerpt((int)size);
            long remaining = size;
            int limit = this.readBuffer.limit();
            int size2 = (int)Math.min((long)this.readBuffer.remaining(), remaining);
            remaining -= (long)size2;
            this.readBuffer.limit(this.readBuffer.position() + size2);
            this.excerpt.write(this.readBuffer);
            this.readBuffer.limit(limit);
            while (remaining > 0L) {
                this.readBuffer.clear();
                int size3 = (int)Math.min((long)this.readBuffer.capacity(), remaining);
                this.readBuffer.limit(size3);
                if (sc.read(this.readBuffer) < 0) {
                    throw new EOFException();
                }
                this.readBuffer.flip();
                remaining -= (long)this.readBuffer.remaining();
                this.excerpt.write(this.readBuffer);
            }
            this.excerpt.finish();
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Lost connection to " + this.address + " retrying", e);
            } else if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Lost connection to " + this.address + " retrying " + e);
            }
            try {
                sc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    void closeSocket(SocketChannel sc) {
        if (sc != null) {
            try {
                sc.close();
            }
            catch (IOException e) {
                this.logger.warning("Error closing socket " + e);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.closeSocket(this.sc);
    }

    @Override
    public <E> EnumeratedMarshaller<E> getMarshaller(Class<E> eClass) {
        return this.chronicle.getMarshaller(eClass);
    }

    private class SinkExcerpt
    extends WrappedExcerpt {
        public SinkExcerpt() {
            super(InProcessChronicleSink.this.chronicle.createExcerpt());
        }

        @Override
        public boolean nextIndex() {
            return super.nextIndex() || InProcessChronicleSink.this.readNext() && super.nextIndex();
        }

        @Override
        public boolean index(long index) throws IndexOutOfBoundsException {
            if (super.index(index)) {
                return true;
            }
            return index >= 0L && InProcessChronicleSink.this.readNext() && super.index(index);
        }
    }
}

