/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tools;

import com.higherfrequencytrading.chronicle.Excerpt;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Arrays;

public enum ChronicleTools {

    private static final boolean IS64BIT = ChronicleTools.is64Bit0();

    public static void deleteOnExit(String basePath) {
        for (String name : new String[]{basePath + ".data", basePath + ".index"}) {
            File file = new File(name);
            file.delete();
            file.deleteOnExit();
        }
    }

    public static String asString(Excerpt excerpt) {
        return ChronicleTools.asString(excerpt, excerpt.position());
    }

    public static String asString(Excerpt excerpt, int position) {
        return ChronicleTools.asString(excerpt, position, 1024);
    }

    public static String asString(Excerpt excerpt, int position, int length) {
        int limit = Math.min(position + length, excerpt.capacity());
        StringBuilder sb = new StringBuilder(limit - position);
        for (int i = position; i < limit; ++i) {
            char ch = (char)excerpt.readUnsignedByte(i);
            if (ch < ' ' || ch > '\u007f') {
                ch = '.';
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String asString(ByteBuffer bb) {
        StringBuilder sb = new StringBuilder();
        for (int i = bb.position(); i < bb.limit(); ++i) {
            byte b = bb.get(i);
            if (b < 32) {
                int h = b & 0xFF;
                if (h < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(h));
                continue;
            }
            sb.append(' ').append((char)b);
        }
        return sb.toString();
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return systemProp.equals("64");
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return systemProp.equals("64");
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static Class[] getGenericTypes(Type type, int count) {
        Object[] types = new Class[count];
        Arrays.fill(types, Object.class);
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] arguments = pt.getActualTypeArguments();
            for (int i = 0; i < arguments.length && i < count; ++i) {
                if (arguments[i] instanceof Class) {
                    types[i] = (Class)arguments[i];
                    continue;
                }
                if (!(arguments[i] instanceof ParameterizedType)) continue;
                types[i] = (Class)((ParameterizedType)arguments[i]).getRawType();
            }
        }
        return types;
    }
}

