/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tools;

import com.higherfrequencytrading.chronicle.tools.IOTools;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigProperties
extends AbstractMap<String, String> {
    private static final String[] NO_STRINGS = new String[0];
    private final Properties properties;
    private final String scope;
    private final String[] scopeArray;

    public ConfigProperties(Properties properties, String scope) {
        this.properties = properties;
        this.scope = scope;
        this.scopeArray = this.decompose(scope);
    }

    private String[] decompose(String scope) {
        if (scope.length() == 0) {
            return NO_STRINGS;
        }
        String[] parts = scope.split("\\.");
        ArrayList<String> ret = new ArrayList<String>();
        for (int len = parts.length; len >= 1; --len) {
            int max = 1 << parts.length;
            for (int i = 1; i < max; ++i) {
                if (Integer.bitCount(i) != len) continue;
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < parts.length; ++j) {
                    if ((i >> j & 1) == 0) continue;
                    sb.append(parts[j]).append('.');
                }
                ret.add(sb.toString());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public ConfigProperties(String path, String scopeArray) throws IOException {
        this(IOTools.loadProperties(path), scopeArray);
    }

    @Override
    public String get(Object key) {
        for (String s : this.scopeArray) {
            String key2 = s + key;
            Object obj = this.properties.get(key2);
            if (obj == null) continue;
            return String.valueOf(obj);
        }
        return (String)super.get(String.valueOf(key));
    }

    public String get(String name, String defaultValue) {
        String value = this.get(name);
        return value == null ? defaultValue : value;
    }

    public int getInt(String name, int defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public long getLong(String name, long defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(name);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public double getDouble(String name, double defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(name);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(name);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.properties.entrySet();
    }

    public ConfigProperties addToScope(String name) {
        if (!this.scope.isEmpty() && Arrays.asList(this.scope.split("\\.")).contains(name)) {
            return this;
        }
        String scope2 = this.scope.length() == 0 ? name : this.scope + "." + name;
        return new ConfigProperties(this.properties, scope2);
    }
}

