/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import sun.reflect.Reflection;

public enum IOTools {

    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String normalisePath(String pathName) {
        if (pathName.startsWith("'") || pathName.endsWith("'")) {
            return new SimpleDateFormat(pathName).format(new Date());
        }
        return pathName;
    }

    public static InputStream asStream(String name) throws IOException {
        ClassLoader classLoader = Reflection.getCallerClass((int)3).getClassLoader();
        return IOTools.asStream(name, classLoader);
    }

    public static InputStream asStream(String name, ClassLoader classLoader) throws IOException {
        InputStream in;
        String name2;
        block4: {
            name2 = IOTools.normalisePath(name);
            if (name2.startsWith("=")) {
                return new ByteArrayInputStream(name2.getBytes(UTF_8));
            }
            try {
                in = new FileInputStream(name2);
            }
            catch (FileNotFoundException e) {
                in = classLoader.getResourceAsStream(name2);
                if (in != null) break block4;
                throw e;
            }
        }
        if (name2.endsWith(".gz") || name2.endsWith(".GZ")) {
            in = new GZIPInputStream(in);
        }
        in = new BufferedInputStream(in);
        return in;
    }

    public static BufferedReader asReader(String name) throws IOException {
        ClassLoader classLoader = Reflection.getCallerClass((int)3).getClassLoader();
        return new BufferedReader(new InputStreamReader(IOTools.asStream(name, classLoader), UTF_8));
    }

    public static Properties loadProperties(String path) throws IOException {
        BufferedReader br = IOTools.asReader(path);
        Properties prop = new Properties();
        prop.load(br);
        br.close();
        return prop;
    }

    public static void writeAllOrEOF(SocketChannel sc, ByteBuffer bb) throws IOException {
        IOTools.writeAll(sc, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void writeAll(SocketChannel sc, ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && sc.write(bb) >= 0) {
        }
    }

    public static void readFullyOrEOF(SocketChannel socket, ByteBuffer bb) throws IOException {
        IOTools.readAvailable(socket, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void readAvailable(SocketChannel socket, ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && socket.read(bb) >= 0) {
        }
    }
}

