/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.tools;

import com.higherfrequencytrading.chronicle.tools.WaitingRunnable;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaitingThread
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(WaitingThread.class.getName());
    private final int delayMS;
    private final Set<WaitingRunnable> runnables = new LinkedHashSet<WaitingRunnable>();
    private volatile WaitingRunnable[] runnableArray = new WaitingRunnable[0];
    private final ExecutorService service;
    private volatile boolean closed = false;

    public WaitingThread(int delayMS, final String name, final boolean daemon) {
        this.delayMS = delayMS;
        this.service = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name);
                t.setDaemon(daemon);
                return t;
            }
        });
        this.service.submit(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        WaitingRunnable[] ra = WaitingThread.this.runnableArray;
                        boolean busy = false;
                        for (WaitingRunnable waitingRunnable : ra) {
                            try {
                                busy |= waitingRunnable.run();
                            }
                            catch (IllegalStateException e) {
                                WaitingThread.this.remove(waitingRunnable);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.WARNING, "Task " + waitingRunnable + " failed, removing", ex);
                            }
                        }
                        if (!busy) {
                            WaitingThread.this.pause();
                        }
                    }
                    catch (Throwable t) {
                        if (WaitingThread.this.closed) break block7;
                        LOGGER.log(Level.SEVERE, "WaitingThread died unexpectedly", t);
                    }
                }
            }
        });
    }

    protected void pause() throws InterruptedException {
        if (this.delayMS < 0) {
            return;
        }
        if (this.delayMS == 0) {
            Thread.yield();
        } else {
            Thread.sleep(this.delayMS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WaitingRunnable waitingRunnable) {
        Set<WaitingRunnable> set = this.runnables;
        synchronized (set) {
            if (this.runnables.add(waitingRunnable)) {
                this.runnableArray = this.runnables.toArray(new WaitingRunnable[this.runnables.size()]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(WaitingRunnable waitingRunnable) {
        Set<WaitingRunnable> set = this.runnables;
        synchronized (set) {
            if (this.runnables.remove(waitingRunnable)) {
                this.runnableArray = this.runnables.toArray(new WaitingRunnable[this.runnables.size()]);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.service.shutdown();
    }
}

