/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle;

import com.higherfrequencytrading.chronicle.StopCharTester;
import org.jetbrains.annotations.NotNull;

public enum StopCharTesters implements StopCharTester
{
    CONTROL_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32;
        }
    }
    ,
    FIX_TEXT{

        @Override
        public boolean isStopChar(int ch) {
            return ch <= 1;
        }
    };


    @NotNull
    public static StopCharTester forChars(@NotNull CharSequence sequence) {
        if (sequence.length() == 1) {
            return StopCharTesters.forChar(sequence.charAt(0));
        }
        return new CSCSTester(sequence);
    }

    @NotNull
    public static StopCharTester forChar(char ch) {
        return new CharCSTester(ch);
    }

    static class CharCSTester
    implements StopCharTester {
        private final char ch;

        public CharCSTester(char ch) {
            this.ch = ch;
        }

        @Override
        public boolean isStopChar(int ch) {
            return this.ch == ch;
        }
    }

    static class CSCSTester
    implements StopCharTester {
        @NotNull
        private final String seperators;

        public CSCSTester(@NotNull CharSequence cs) {
            this.seperators = cs.toString();
        }

        @Override
        public boolean isStopChar(int ch) {
            return this.seperators.indexOf(ch) >= 0;
        }
    }
}

