/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.datamodel;

import com.higherfrequencytrading.chronicle.Chronicle;
import com.higherfrequencytrading.chronicle.datamodel.DataStore;
import com.higherfrequencytrading.chronicle.datamodel.MasterContext;
import com.higherfrequencytrading.chronicle.datamodel.ModelMode;
import com.higherfrequencytrading.chronicle.impl.IndexedChronicle;
import com.higherfrequencytrading.chronicle.tcp.InProcessChronicleSink;
import com.higherfrequencytrading.chronicle.tcp.InProcessChronicleSource;
import com.higherfrequencytrading.chronicle.tools.ConfigProperties;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DataStoreSet {
    @NotNull
    private final ConfigProperties configProperties;
    private final String nodeName;
    private final Map<String, DataStore> dataStoreMap = new LinkedHashMap<String, DataStore>();

    public DataStoreSet(String nodeName, @NotNull ConfigProperties configProperties) {
        this.nodeName = nodeName;
        this.configProperties = configProperties.addToScope(nodeName);
    }

    public <Model> void inject(@NotNull Model model) {
        try {
            for (Class<?> type = model.getClass(); type != null && type != Object.class && type != Enum.class; type = type.getSuperclass()) {
                MasterContext defaultContext = type.getAnnotation(MasterContext.class);
                for (Field field : type.getDeclaredFields()) {
                    MasterContext fieldContext = field.getAnnotation(MasterContext.class);
                    String contextName = fieldContext != null ? fieldContext.value() : (defaultContext != null ? defaultContext.value() : "local");
                    ConfigProperties configProperties2 = this.configProperties.addToScope(contextName);
                    String uri = configProperties2.get("uri");
                    DataStore dataStore = this.acquireDataStore(contextName, uri, contextName.equals(this.nodeName) ? ModelMode.MASTER : ModelMode.READ_ONLY);
                    dataStore.injectField(model, field);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private DataStore acquireDataStore(String contextName, String uriText, @NotNull ModelMode mode) throws IOException {
        DataStore ds = this.dataStoreMap.get(contextName);
        if (ds == null) {
            Chronicle chronicle;
            URI uri = URI.create(uriText);
            String path = uri.getPath();
            if (path == null) {
                throw new AssertionError((Object)("uri.path not set for " + contextName));
            }
            if (path.startsWith("/.")) {
                path = path.substring(1);
            }
            switch (mode) {
                case MASTER: {
                    chronicle = new InProcessChronicleSource(new IndexedChronicle(path), uri.getPort());
                    break;
                }
                case READ_ONLY: {
                    chronicle = new InProcessChronicleSink(new IndexedChronicle(path + "/" + this.nodeName), uri.getHost(), uri.getPort());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown ModelMode " + (Object)((Object)mode)));
                }
            }
            ds = new DataStore(chronicle, mode);
            this.dataStoreMap.put(contextName, ds);
        }
        return ds;
    }

    public void start() {
        for (DataStore dataStore : this.dataStoreMap.values()) {
            dataStore.start();
        }
    }

    public void startAtEnd() {
        for (DataStore dataStore : this.dataStoreMap.values()) {
            dataStore.startAtEnd();
        }
    }

    public void close() {
        for (DataStore dataStore : this.dataStoreMap.values()) {
            dataStore.close();
        }
    }
}

