/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.datamodel;

import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.datamodel.DataStore;
import com.higherfrequencytrading.chronicle.datamodel.MapListener;
import com.higherfrequencytrading.chronicle.datamodel.ObservableMap;
import com.higherfrequencytrading.chronicle.datamodel.WrapperEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapWrapper<K, V>
implements ObservableMap<K, V> {
    @NotNull
    private final DataStore dataStore;
    private final String name;
    @NotNull
    private final Class<K> kClass;
    @NotNull
    private final Class<V> vClass;
    @NotNull
    private final Map<K, V> underlying;
    private final int maxMessageSize;
    private final List<MapListener<K, V>> listeners = new ArrayList<MapListener<K, V>>();
    private final Set<K> keySet;
    private final Collection<V> values;
    private final Set<Map.Entry<K, V>> entrySet;
    private final boolean kEnumClass;
    private final boolean vEnumClass;
    private boolean notifyOff = false;
    @NotNull
    private Annotation[] annotations = new Annotation[0];

    public MapWrapper(@NotNull DataStore dataStore, String name, @NotNull Class<K> kClass, @NotNull Class<V> vClass, @NotNull Map<K, V> underlying, int maxMessageSize) {
        this.dataStore = dataStore;
        this.name = name;
        this.kClass = kClass;
        this.vClass = vClass;
        this.underlying = underlying;
        this.maxMessageSize = maxMessageSize;
        this.kEnumClass = dataStore.enumeratedClass(kClass);
        this.vEnumClass = dataStore.enumeratedClass(vClass);
        this.keySet = Collections.unmodifiableSet(underlying.keySet());
        this.values = Collections.unmodifiableCollection(underlying.values());
        this.entrySet = Collections.unmodifiableSet(underlying.entrySet());
        dataStore.add(name, this);
    }

    @NotNull
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(@NotNull Annotation[] annotations) {
        this.annotations = Arrays.copyOf(annotations, annotations.length);
    }

    @Override
    @Nullable
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public void addListener(MapListener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(MapListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void inSync() {
        for (MapListener<K, V> listener : this.listeners) {
            listener.inSync();
        }
    }

    @Override
    public void onExcerpt(@NotNull Excerpt excerpt) {
        int i;
        int position = excerpt.position();
        WrapperEvent event = excerpt.readEnum(WrapperEvent.class);
        if (event == null) {
            excerpt.position(position);
            System.err.println("Unknown event type " + excerpt.readUTF());
            return;
        }
        if (!this.notifyOff) {
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                this.listeners.get(i2).eventStart(excerpt.index(), this.name);
            }
        }
        try {
            switch (event) {
                case put: {
                    this.onExcerptPut(excerpt);
                    break;
                }
                case putAll: {
                    int count = excerpt.readInt();
                    for (i = 0; i < count; ++i) {
                        this.onExcerptPut(excerpt);
                    }
                    break;
                }
                case remove: {
                    K key = this.readKey(excerpt);
                    V value = this.underlying.remove(key);
                    if (this.notifyOff) break;
                    for (int i3 = 0; i3 < this.listeners.size(); ++i3) {
                        this.listeners.get(i3).remove(key, value);
                    }
                    break;
                }
                case clear: {
                    if (!this.notifyOff) {
                        Map.Entry[] entrySet = this.underlying.entrySet().toArray(new Map.Entry[this.underlying.size()]);
                        for (int i4 = 0; i4 < this.listeners.size(); ++i4) {
                            MapListener listener = this.listeners.get(i4);
                            for (int j = 0; j < entrySet.length; ++j) {
                                listener.remove(entrySet[j].getKey(), entrySet[j].getValue());
                            }
                        }
                    }
                    this.underlying.clear();
                    break;
                }
                case event: {
                    if (this.notifyOff) break;
                    Object object = excerpt.readObject();
                    for (int i5 = 0; i5 < this.listeners.size(); ++i5) {
                        this.listeners.get(i5).onEvent(object);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.notifyOff) {
            boolean lastEvent = !excerpt.hasNextIndex();
            for (i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).eventEnd(lastEvent);
            }
        }
    }

    private void onExcerptPut(@NotNull Excerpt excerpt) {
        K key = this.readKey(excerpt);
        V value = this.readValue(excerpt);
        V previous = this.underlying.put(key, value);
        if (!this.notifyOff) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                MapListener<K, V> listener = this.listeners.get(i);
                if (previous == null) {
                    listener.add(key, value);
                    continue;
                }
                listener.update(key, previous, value);
            }
        }
    }

    private V readValue(@NotNull Excerpt excerpt) {
        if (this.vEnumClass) {
            return excerpt.readEnum(this.vClass);
        }
        return (V)excerpt.readObject();
    }

    private K readKey(@NotNull Excerpt excerpt) {
        if (this.kEnumClass) {
            return excerpt.readEnum(this.kClass);
        }
        return (K)excerpt.readObject();
    }

    @Override
    public void notifyOff(boolean notifyOff) {
        this.notifyOff = notifyOff;
    }

    @Override
    public void clear() {
        this.checkWritable();
        this.writeClear();
    }

    private void writeClear() {
        Excerpt excerpt = this.getExcerpt(16, WrapperEvent.clear);
        long eventId = excerpt.index();
        excerpt.writeEnum(WrapperEvent.clear);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            Map.Entry[] entrySet = this.underlying.entrySet().toArray(new Map.Entry[this.underlying.size()]);
            for (int i = 0; i < this.listeners.size(); ++i) {
                MapListener listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                for (int j = 0; j < entrySet.length; ++j) {
                    listener.remove(entrySet[j].getKey(), entrySet[j].getValue());
                }
                listener.eventEnd(true);
            }
        }
    }

    @NotNull
    private Excerpt getExcerpt(int maxSize, @NotNull WrapperEvent event) {
        Excerpt excerpt = this.dataStore.startExcerpt(maxSize + 2 + event.name().length(), this.name);
        excerpt.writeEnum(event);
        return excerpt;
    }

    void checkWritable() {
        this.dataStore.checkWritable();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.underlying.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.underlying.containsValue(value);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        return this.underlying.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.underlying.get(key);
    }

    @Override
    public int hashCode() {
        return this.underlying.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        this.checkWritable();
        V previous = this.underlying.put(key, value);
        if (this.sameOrNotEqual(previous, value)) {
            this.writePut(key, previous, value);
        }
        return previous;
    }

    private void writePut(K key, @Nullable V previous, V value) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.put);
        long eventId = excerpt.index();
        this.writeKey(excerpt, key);
        this.writeValue(excerpt, value);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                MapListener<K, V> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                if (previous == null) {
                    listener.add(key, value);
                } else {
                    listener.update(key, previous, value);
                }
                listener.eventEnd(true);
            }
        }
    }

    private void writeValue(@NotNull Excerpt excerpt, V value) {
        if (this.vEnumClass) {
            excerpt.writeEnum(value);
        } else {
            excerpt.writeObject(value);
        }
    }

    private void writeKey(@NotNull Excerpt excerpt, K key) {
        if (this.kEnumClass) {
            excerpt.writeEnum(key);
        } else {
            excerpt.writeObject(key);
        }
    }

    protected boolean sameOrNotEqual(@Nullable V previous, V value) {
        return previous == value || previous == null || !previous.equals(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.checkWritable();
        this.performAndWritePutAll(m);
    }

    private void performAndWritePutAll(@NotNull Map<? extends K, ? extends V> m) {
        Excerpt excerpt = this.getExcerpt(m.size() * this.maxMessageSize, WrapperEvent.putAll);
        long eventId = excerpt.index();
        int pos = excerpt.position();
        excerpt.writeInt(0);
        int count = 0;
        for (int i = 0; i < this.listeners.size(); ++i) {
            MapListener<K, V> listener = this.listeners.get(i);
            listener.eventStart(eventId, this.name);
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            MapListener<K, V> listener;
            int i;
            V value;
            K key = entry.getKey();
            V previous = this.underlying.put(key, value = entry.getValue());
            if (this.sameOrNotEqual(previous, value)) {
                this.writeKey(excerpt, key);
                this.writeValue(excerpt, value);
                for (i = 0; i < this.listeners.size(); ++i) {
                    listener = this.listeners.get(i);
                    if (previous == null) {
                        listener.add(key, value);
                        continue;
                    }
                    listener.update(key, previous, value);
                }
                ++count;
            }
            for (i = 0; i < this.listeners.size(); ++i) {
                listener = this.listeners.get(i);
                listener.eventEnd(true);
            }
        }
        excerpt.writeInt(pos, count);
        excerpt.finish();
    }

    @Override
    public V remove(Object key) {
        this.checkWritable();
        V value = this.underlying.remove(key);
        if (value != null) {
            this.writeRemove(key, value);
        }
        return value;
    }

    private void writeRemove(Object key, V value) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize, WrapperEvent.remove);
        long eventId = excerpt.index();
        this.writeKey(excerpt, key);
        this.writeValue(excerpt, value);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                MapListener<Object, V> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.remove(key, value);
                listener.eventEnd(true);
            }
        }
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    public String toString() {
        return this.underlying.toString();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public void publishEvent(Object object) {
        Excerpt excerpt = this.getExcerpt(this.maxMessageSize + 128, WrapperEvent.event);
        long eventId = excerpt.index();
        excerpt.writeObject((Object)WrapperEvent.event);
        excerpt.finish();
        if (!this.notifyOff && !this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                MapListener<K, V> listener = this.listeners.get(i);
                listener.eventStart(eventId, this.name);
                listener.onEvent(object);
                listener.eventEnd(true);
            }
        }
    }
}

