/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.impl.AbstractExcerpt;
import com.higherfrequencytrading.chronicle.impl.DirectChronicle;
import com.higherfrequencytrading.chronicle.impl.MappedMemory;
import org.jetbrains.annotations.NotNull;

public class ByteBufferExcerpt
extends AbstractExcerpt {
    private MappedMemory mappedMemory;

    protected ByteBufferExcerpt(DirectChronicle chronicle) {
        super(chronicle);
    }

    @Override
    protected void index0(long index, long startPosition, long endPosition) {
        this.index = index;
        this.startPosition = startPosition;
        MappedMemory.release(this.mappedMemory);
        this.mappedMemory = this.chronicle.acquireDataBuffer(startPosition);
        this.buffer = this.mappedMemory.buffer();
        this.start = this.position = (long)this.chronicle.positionInBuffer(startPosition);
        this.limit = this.chronicle.positionInBuffer(endPosition - 1L) + 1;
        assert (this.limit > this.start && this.position < this.limit && endPosition > startPosition);
    }

    @Override
    public byte readByte() {
        assert (this.buffer != null);
        return this.buffer.get((int)this.position++);
    }

    @Override
    public byte readByte(int offset) {
        assert (this.buffer != null);
        return this.buffer.get((int)(this.start + (long)offset));
    }

    @Override
    public short readShort() {
        assert (this.buffer != null);
        short s = this.buffer.getShort((int)this.position);
        this.position += 2L;
        return s;
    }

    @Override
    public short readShort(int offset) {
        assert (this.buffer != null);
        return this.buffer.getShort((int)(this.start + (long)offset));
    }

    @Override
    public char readChar() {
        assert (this.buffer != null);
        char ch = this.buffer.getChar((int)this.position);
        this.position += 2L;
        return ch;
    }

    @Override
    public char readChar(int offset) {
        assert (this.buffer != null);
        return this.buffer.getChar((int)(this.start + (long)offset));
    }

    @Override
    public int readInt() {
        assert (this.buffer != null);
        int i = this.buffer.getInt((int)this.position);
        this.position += 4L;
        return i;
    }

    @Override
    public int readInt(int offset) {
        assert (this.buffer != null);
        return this.buffer.getInt((int)(this.start + (long)offset));
    }

    @Override
    public long readLong() {
        assert (this.buffer != null);
        long l = this.buffer.getLong((int)this.position);
        this.position += 8L;
        return l;
    }

    @Override
    public long readLong(int offset) {
        assert (this.buffer != null);
        return this.buffer.getLong((int)(this.start + (long)offset));
    }

    @Override
    public float readFloat() {
        assert (this.buffer != null);
        float f = this.buffer.getFloat((int)this.position);
        this.position += 4L;
        return f;
    }

    @Override
    public float readFloat(int offset) {
        assert (this.buffer != null);
        return this.buffer.getFloat((int)(this.start + (long)offset));
    }

    @Override
    public double readDouble() {
        assert (this.buffer != null);
        double d = this.buffer.getDouble((int)this.position);
        this.position += 8L;
        return d;
    }

    @Override
    public double readDouble(int offset) {
        assert (this.buffer != null);
        return this.buffer.getDouble((int)(this.start + (long)offset));
    }

    @Override
    public void write(int b) {
        assert (this.buffer != null);
        this.buffer.put((int)this.position++, (byte)b);
    }

    @Override
    public void write(int offset, int b) {
        assert (this.buffer != null);
        this.buffer.put((int)(this.start + (long)offset), (byte)b);
    }

    @Override
    public void writeShort(int v) {
        assert (this.buffer != null);
        this.buffer.putShort((int)this.position, (short)v);
        this.position += 2L;
    }

    @Override
    public void writeShort(int offset, int v) {
        assert (this.buffer != null);
        this.buffer.putShort((int)(this.start + (long)offset), (short)v);
    }

    @Override
    public void writeChar(int v) {
        assert (this.buffer != null);
        this.buffer.putChar((int)this.position, (char)v);
        this.position += 2L;
    }

    @Override
    public void writeChar(int offset, int v) {
        assert (this.buffer != null);
        this.buffer.putChar((int)(this.start + (long)offset), (char)v);
    }

    @Override
    public void writeInt(int v) {
        assert (this.buffer != null);
        this.buffer.putInt((int)this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeInt(int offset, int v) {
        assert (this.buffer != null);
        this.buffer.putInt((int)(this.start + (long)offset), v);
    }

    @Override
    public void writeLong(long v) {
        assert (this.buffer != null);
        this.buffer.putLong((int)this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeLong(int offset, long v) {
        assert (this.buffer != null);
        this.buffer.putLong((int)(this.start + (long)offset), v);
    }

    @Override
    public void writeFloat(float v) {
        assert (this.buffer != null);
        this.buffer.putFloat((int)this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeFloat(int offset, float v) {
        assert (this.buffer != null);
        this.buffer.putFloat((int)(this.start + (long)offset), v);
    }

    @Override
    public void writeDouble(double v) {
        assert (this.buffer != null);
        this.buffer.putDouble((int)this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeDouble(int offset, double v) {
        assert (this.buffer != null);
        this.buffer.putDouble((int)(this.start + (long)offset), v);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        if (len > this.remaining()) {
            len = this.remaining();
        }
        for (int i = 0; i < len; ++i) {
            assert (this.buffer != null);
            b[i + off] = this.buffer.get((int)((long)i + this.position));
        }
        this.position += (long)len;
        return len;
    }
}

