/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.impl.IndexedChronicle;
import com.higherfrequencytrading.chronicle.impl.IntIndexedChronicle;
import com.higherfrequencytrading.chronicle.tools.ChronicleTools;
import java.io.IOException;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;

public class ChronicleBuilder {
    @NotNull
    public static IndexedChronicleBuilder newIndexedChronicleBuilder(String basePath) {
        return new IndexedChronicleBuilder(basePath);
    }

    @NotNull
    public static IntIndexedChronicleBuilder newIntIndexedChronicleBuilder(String basePath) {
        return new IntIndexedChronicleBuilder(basePath);
    }

    public static class IntIndexedChronicleBuilder
    extends IndexedChronicleBuilder {
        public IntIndexedChronicleBuilder(String basePath) {
            super(basePath);
        }

        @Override
        @NotNull
        public IntIndexedChronicle build() throws IOException {
            IntIndexedChronicle intIndexedChronicle = new IntIndexedChronicle(this.basePath, this.dataBitSizeHint, this.byteOrder);
            intIndexedChronicle.useUnsafe(this.useUnsafe);
            return intIndexedChronicle;
        }
    }

    public static class IndexedChronicleBuilder {
        protected String basePath;
        protected int dataBitSizeHint = ChronicleTools.is64Bit() ? 27 : 22;
        protected ByteOrder byteOrder = ByteOrder.nativeOrder();
        protected boolean minimiseByteBuffers = !ChronicleTools.is64Bit();
        protected boolean synchronousMode = false;
        protected boolean useUnsafe = false;

        public IndexedChronicleBuilder(String basePath) {
            this.basePath = basePath;
        }

        @NotNull
        public IndexedChronicleBuilder dataBitSizeHint(int dataBitSizeHint) {
            this.dataBitSizeHint = dataBitSizeHint;
            return this;
        }

        @NotNull
        public IndexedChronicleBuilder byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        @NotNull
        public IndexedChronicleBuilder minimiseByteBuffers(boolean minimiseByteBuffers) {
            this.minimiseByteBuffers = minimiseByteBuffers;
            return this;
        }

        @NotNull
        public IndexedChronicleBuilder useSynchronousMode(boolean synchronousMode) {
            this.synchronousMode = synchronousMode;
            return this;
        }

        @NotNull
        public IndexedChronicleBuilder useUnsafe(boolean useUnsafe) {
            this.useUnsafe = useUnsafe;
            return this;
        }

        @NotNull
        public IndexedChronicle build() throws IOException {
            IndexedChronicle indexedChronicle = new IndexedChronicle(this.basePath, this.dataBitSizeHint, this.byteOrder, this.minimiseByteBuffers, this.synchronousMode);
            indexedChronicle.useUnsafe(this.useUnsafe);
            return indexedChronicle;
        }
    }
}

