/*
 * Decompiled with CFR 0.152.
 */
package com.higherfrequencytrading.chronicle.impl;

import com.higherfrequencytrading.chronicle.EnumeratedMarshaller;
import com.higherfrequencytrading.chronicle.Excerpt;
import com.higherfrequencytrading.chronicle.StopCharTester;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DateMarshaller
implements EnumeratedMarshaller<Date> {
    final int size1;
    private final StringBuilder sb = new StringBuilder();
    @Nullable
    private Date[] interner = null;

    public DateMarshaller(int size) {
        int size2;
        for (size2 = 128; size2 < size && size2 < 0x100000; size2 <<= 1) {
        }
        this.size1 = size2 - 1;
    }

    @Override
    @NotNull
    public Class<Date> classMarshaled() {
        return Date.class;
    }

    @Override
    public void write(@NotNull Excerpt excerpt, @NotNull Date date) {
        int pos = excerpt.position();
        excerpt.writeUnsignedByte(0);
        excerpt.append(date.getTime());
        excerpt.writeUnsignedByte(pos, excerpt.position() - 1 - pos);
    }

    @Override
    @Nullable
    public Date read(@NotNull Excerpt excerpt) {
        excerpt.readUTF(this.sb);
        long time = DateMarshaller.parseLong(this.sb);
        return this.lookupDate(time);
    }

    @Nullable
    private Date lookupDate(long time) {
        Date date;
        int idx = this.hashFor(time);
        if (this.interner == null) {
            this.interner = new Date[this.size1 + 1];
        }
        if ((date = this.interner[idx]) != null && date.getTime() == time) {
            return date;
        }
        this.interner[idx] = new Date(time);
        return this.interner[idx];
    }

    private int hashFor(long time) {
        long h = time;
        h ^= h >>> 41 ^ h >>> 20;
        h ^= h >>> 14 ^ h >>> 7;
        return (int)(h & (long)this.size1);
    }

    private static long parseLong(@NotNull CharSequence sb) {
        long num = 0L;
        boolean negative = false;
        for (int i = 0; i < sb.length(); ++i) {
            char b = sb.charAt(i);
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != '-') break;
            negative = true;
        }
        return negative ? -num : num;
    }

    @Override
    @Nullable
    public Date parse(@NotNull Excerpt excerpt, @NotNull StopCharTester tester) {
        return this.lookupDate(excerpt.readLong());
    }
}

